/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.query;

import com.cloudant.client.api.query.Field;
import com.cloudant.client.api.query.Selector;
import com.cloudant.client.internal.query.Definition;
import com.cloudant.client.internal.query.Helpers;
import com.cloudant.client.internal.query.InternalIndex;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public abstract class Builder<I extends InternalIndex<D, F>, D extends Definition<F>, B extends Builder, F extends Field> {
    protected I instance = this.newInstance();

    public B name(String indexName) {
        ((InternalIndex)this.instance).name = indexName;
        return this.returnThis();
    }

    public B designDocument(String designDocumentId) {
        ((InternalIndex)this.instance).ddoc = designDocumentId;
        return this.returnThis();
    }

    public B partialFilterSelector(Selector selector) {
        ((Definition)((InternalIndex)this.instance).def).selector = Helpers.getJsonObjectFromSelector(selector);
        return this.returnThis();
    }

    protected B fields(List<F> fields) {
        if (((Definition)((InternalIndex)this.instance).def).fields == null) {
            ((Definition)((InternalIndex)this.instance).def).fields = new ArrayList(fields.size());
        }
        ((Definition)((InternalIndex)this.instance).def).fields.addAll(fields);
        return this.returnThis();
    }

    public String definition() {
        JsonObject indexAsJson = new Gson().toJsonTree(this.instance).getAsJsonObject();
        JsonObject definition = indexAsJson.getAsJsonObject("def");
        indexAsJson.remove("def");
        indexAsJson.add("index", (JsonElement)definition);
        return indexAsJson.toString();
    }

    protected abstract B returnThis();

    protected abstract I newInstance();
}

