/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.api.ClickHouseException;
import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.ClientFaultCause;
import com.clickhouse.client.api.ClientMisconfigurationException;
import com.clickhouse.client.api.ConnectionInitiationException;
import com.clickhouse.client.api.ConnectionReuseStrategy;
import com.clickhouse.client.api.DataTransferException;
import com.clickhouse.client.api.ServerException;
import com.clickhouse.client.api.enums.ProxyType;
import com.clickhouse.client.api.internal.ClickHouseLZ4InputStream;
import com.clickhouse.client.api.internal.LZ4Entity;
import com.clickhouse.client.api.transport.Endpoint;
import com.clickhouse.data.ClickHouseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import net.jpountz.lz4.LZ4Factory;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityTemplate;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.IOCallback;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAPIClientHelper {
    public static final String KEY_STATEMENT_PARAMS = "statement_params";
    private static final Logger LOG = LoggerFactory.getLogger(HttpAPIClientHelper.class);
    private static final int ERROR_BODY_BUFFER_SIZE = 1024;
    private static final Pattern PATTERN_HEADER_VALUE_ASCII = Pattern.compile("\\p{Graph}+(?:[ ]\\p{Graph}+)*");
    private final CloseableHttpClient httpClient;
    private String proxyAuthHeaderValue;
    private final Set<ClientFaultCause> defaultRetryCauses;
    private final String defaultUserAgent;
    private final Object metricsRegistry;
    ConnPoolControl<?> poolControl;
    private static final long CONNECTION_INACTIVITY_CHECK = 5000L;
    private static final String ERROR_CODE_PREFIX_PATTERN = "%d. DB::Exception:";
    private static final long POOL_VENT_TIMEOUT = 10000L;
    private final AtomicLong timeToPoolVent = new AtomicLong(0L);
    private static final ContentType CONTENT_TYPE = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (String)"UTF-8");

    public HttpAPIClientHelper(Map<String, Object> configuration, Object metricsRegistry, boolean initSslContext) {
        this.metricsRegistry = metricsRegistry;
        this.httpClient = this.createHttpClient(initSslContext, configuration);
        boolean usingClientCompression = (Boolean)ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getOrDefault(configuration);
        boolean usingServerCompression = (Boolean)ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getOrDefault(configuration);
        boolean useHttpCompression = (Boolean)ClientConfigProperties.USE_HTTP_COMPRESSION.getOrDefault(configuration);
        LOG.debug("client compression: {}, server compression: {}, http compression: {}", new Object[]{usingClientCompression, usingServerCompression, useHttpCompression});
        this.defaultRetryCauses = new HashSet<ClientFaultCause>((Collection)ClientConfigProperties.CLIENT_RETRY_ON_FAILURE.getOrDefault(configuration));
        if (this.defaultRetryCauses.contains((Object)ClientFaultCause.None)) {
            this.defaultRetryCauses.removeIf(c -> c != ClientFaultCause.None);
        }
        this.defaultUserAgent = this.buildDefaultUserAgent();
    }

    public SSLContext createSSLContext(Map<String, Object> configuration) {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("Failed to create default SSL context", e);
        }
        ClickHouseSslContextProvider sslContextProvider = ClickHouseSslContextProvider.getProvider();
        String trustStorePath = (String)configuration.get(ClientConfigProperties.SSL_TRUST_STORE.getKey());
        if (trustStorePath != null) {
            try {
                sslContext = sslContextProvider.getSslContextFromKeyStore(trustStorePath, (String)configuration.get(ClientConfigProperties.SSL_KEY_STORE_PASSWORD.getKey()), (String)configuration.get(ClientConfigProperties.SSL_KEYSTORE_TYPE.getKey()));
            }
            catch (SSLException e) {
                throw new ClientMisconfigurationException("Failed to create SSL context from a keystore", e);
            }
        }
        if (configuration.get(ClientConfigProperties.CA_CERTIFICATE.getKey()) != null || configuration.get(ClientConfigProperties.SSL_CERTIFICATE.getKey()) != null || configuration.get(ClientConfigProperties.SSL_KEY.getKey()) != null) {
            try {
                sslContext = sslContextProvider.getSslContextFromCerts((String)configuration.get(ClientConfigProperties.SSL_CERTIFICATE.getKey()), (String)configuration.get(ClientConfigProperties.SSL_KEY.getKey()), (String)configuration.get(ClientConfigProperties.CA_CERTIFICATE.getKey()));
            }
            catch (SSLException e) {
                throw new ClientMisconfigurationException("Failed to create SSL context from certificates", e);
            }
        }
        return sslContext;
    }

    private ConnectionConfig createConnectionConfig(Map<String, Object> configuration) {
        ConnectionConfig.Builder connConfig = ConnectionConfig.custom();
        ClientConfigProperties.CONNECTION_TTL.applyIfSet(configuration, t -> connConfig.setTimeToLive(t.longValue(), TimeUnit.MILLISECONDS));
        ClientConfigProperties.CONNECTION_TIMEOUT.applyIfSet(configuration, t -> connConfig.setConnectTimeout(t.longValue(), TimeUnit.MILLISECONDS));
        connConfig.setValidateAfterInactivity(5000L, TimeUnit.MILLISECONDS);
        return connConfig.build();
    }

    private HttpClientConnectionManager basicConnectionManager(LayeredConnectionSocketFactory sslConnectionSocketFactory, SocketConfig socketConfig, Map<String, Object> configuration) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        registryBuilder.register("https", (Object)sslConnectionSocketFactory);
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)registryBuilder.build());
        connManager.setConnectionConfig(this.createConnectionConfig(configuration));
        connManager.setSocketConfig(socketConfig);
        return connManager;
    }

    private HttpClientConnectionManager poolConnectionManager(LayeredConnectionSocketFactory sslConnectionSocketFactory, SocketConfig socketConfig, Map<String, Object> configuration) {
        PoolingHttpClientConnectionManager phccm;
        PoolingHttpClientConnectionManagerBuilder connMgrBuilder = PoolingHttpClientConnectionManagerBuilder.create().setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX);
        ConnectionReuseStrategy connectionReuseStrategy = (ConnectionReuseStrategy)((Object)ClientConfigProperties.CONNECTION_REUSE_STRATEGY.getOrDefault(configuration));
        switch (connectionReuseStrategy) {
            case LIFO: {
                connMgrBuilder.setConnPoolPolicy(PoolReusePolicy.LIFO);
                break;
            }
            case FIFO: {
                connMgrBuilder.setConnPoolPolicy(PoolReusePolicy.FIFO);
                break;
            }
            default: {
                throw new ClientMisconfigurationException("Unknown connection reuse strategy: " + (Object)((Object)connectionReuseStrategy));
            }
        }
        LOG.debug("Connection reuse strategy: {}", (Object)connectionReuseStrategy);
        connMgrBuilder.setDefaultConnectionConfig(this.createConnectionConfig(configuration));
        connMgrBuilder.setMaxConnTotal(Integer.MAX_VALUE);
        ClientConfigProperties.HTTP_MAX_OPEN_CONNECTIONS.applyIfSet(configuration, arg_0 -> ((PoolingHttpClientConnectionManagerBuilder)connMgrBuilder).setMaxConnPerRoute(arg_0));
        int networkBufferSize = (Integer)ClientConfigProperties.CLIENT_NETWORK_BUFFER_SIZE.getOrDefault(configuration);
        MeteredManagedHttpClientConnectionFactory connectionFactory = new MeteredManagedHttpClientConnectionFactory(Http1Config.custom().setBufferSize(networkBufferSize).build(), CharCodingConfig.DEFAULT, DefaultHttpResponseParserFactory.INSTANCE);
        connMgrBuilder.setConnectionFactory((HttpConnectionFactory)connectionFactory);
        connMgrBuilder.setSSLSocketFactory(sslConnectionSocketFactory);
        connMgrBuilder.setDefaultSocketConfig(socketConfig);
        this.poolControl = phccm = connMgrBuilder.build();
        if (this.metricsRegistry != null) {
            try {
                String mGroupName = (String)ClientConfigProperties.METRICS_GROUP_NAME.getOrDefault(configuration);
                Class<?> micrometerLoader = this.getClass().getClassLoader().loadClass("com.clickhouse.client.api.metrics.MicrometerLoader");
                Method applyMethod = micrometerLoader.getDeclaredMethod("applyPoolingMetricsBinder", Object.class, String.class, PoolingHttpClientConnectionManager.class);
                applyMethod.invoke(micrometerLoader, this.metricsRegistry, mGroupName, phccm);
                applyMethod = micrometerLoader.getDeclaredMethod("applyConnectionMetricsBinder", Object.class, String.class, MeteredManagedHttpClientConnectionFactory.class);
                applyMethod.invoke(micrometerLoader, new Object[]{this.metricsRegistry, mGroupName, connectionFactory});
            }
            catch (Exception e) {
                LOG.error("Failed to register metrics", (Throwable)e);
            }
        }
        return phccm;
    }

    public CloseableHttpClient createHttpClient(boolean initSslContext, Map<String, Object> configuration) {
        boolean disableCookies;
        String proxyTypeVal;
        ProxyType proxyType;
        String socketSNI;
        SSLContext sslContext;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLContext sSLContext = sslContext = initSslContext ? this.createSSLContext(configuration) : null;
        Object sslConnectionSocketFactory = sslContext != null ? ((socketSNI = (String)configuration.get(ClientConfigProperties.SSL_SOCKET_SNI.getKey())) != null && !socketSNI.trim().isEmpty() ? new CustomSSLConnectionFactory(socketSNI, sslContext, (hostname, session) -> true) : new SSLConnectionSocketFactory(sslContext)) : new DummySSLConnectionSocketFactory();
        SocketConfig.Builder soCfgBuilder = SocketConfig.custom();
        ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.applyIfSet(configuration, t -> soCfgBuilder.setSoTimeout(t.intValue(), TimeUnit.MILLISECONDS));
        ClientConfigProperties.SOCKET_RCVBUF_OPT.applyIfSet(configuration, arg_0 -> ((SocketConfig.Builder)soCfgBuilder).setRcvBufSize(arg_0));
        ClientConfigProperties.SOCKET_SNDBUF_OPT.applyIfSet(configuration, arg_0 -> ((SocketConfig.Builder)soCfgBuilder).setSndBufSize(arg_0));
        ClientConfigProperties.SOCKET_LINGER_OPT.applyIfSet(configuration, v -> soCfgBuilder.setSoLinger(v.intValue(), TimeUnit.SECONDS));
        ClientConfigProperties.SOCKET_TCP_NO_DELAY_OPT.applyIfSet(configuration, arg_0 -> ((SocketConfig.Builder)soCfgBuilder).setTcpNoDelay(arg_0));
        String proxyHost = (String)configuration.get(ClientConfigProperties.PROXY_HOST.getKey());
        Integer proxyPort = (Integer)configuration.get(ClientConfigProperties.PROXY_PORT.getKey());
        HttpHost proxy = null;
        if (proxyHost != null && proxyPort != null) {
            proxy = new HttpHost(proxyHost, proxyPort.intValue());
        }
        ProxyType proxyType2 = proxyType = (proxyTypeVal = (String)configuration.get(ClientConfigProperties.PROXY_TYPE.getKey())) == null ? null : ProxyType.valueOf(proxyTypeVal);
        if (proxyType == ProxyType.HTTP) {
            clientBuilder.setProxy(proxy);
            String proxyUser = (String)configuration.get(ClientConfigProperties.PROXY_USER.getKey());
            String proxyPassword = (String)configuration.get(ClientConfigProperties.PROXY_PASSWORD.getKey());
            if (proxyUser != null && proxyPassword != null) {
                this.proxyAuthHeaderValue = "Basic " + Base64.getEncoder().encodeToString((proxyUser + ":" + proxyPassword).getBytes(StandardCharsets.UTF_8));
            }
        } else if (proxyType == ProxyType.SOCKS) {
            soCfgBuilder.setSocksProxyAddress((SocketAddress)new InetSocketAddress(proxyHost, (int)proxyPort));
        }
        boolean bl = disableCookies = (Boolean)ClientConfigProperties.HTTP_SAVE_COOKIES.getOrDefault(configuration) == false;
        if (disableCookies) {
            clientBuilder.disableCookieManagement();
        }
        SocketConfig socketConfig = soCfgBuilder.build();
        if (((Boolean)ClientConfigProperties.CONNECTION_POOL_ENABLED.getOrDefault(configuration)).booleanValue()) {
            clientBuilder.setConnectionManager(this.poolConnectionManager((LayeredConnectionSocketFactory)sslConnectionSocketFactory, socketConfig, configuration));
        } else {
            clientBuilder.setConnectionManager(this.basicConnectionManager((LayeredConnectionSocketFactory)sslConnectionSocketFactory, socketConfig, configuration));
        }
        Long keepAliveTimeout = (Long)ClientConfigProperties.HTTP_KEEP_ALIVE_TIMEOUT.getOrDefault(configuration);
        if (keepAliveTimeout != null && keepAliveTimeout > 0L) {
            clientBuilder.setKeepAliveStrategy((response, context) -> TimeValue.ofMilliseconds((long)keepAliveTimeout));
        }
        return clientBuilder.build();
    }

    public Exception readError(ClassicHttpResponse httpResponse) {
        int serverCode = HttpAPIClientHelper.getHeaderInt(httpResponse.getFirstHeader("X-ClickHouse-Exception-Code"), 0);
        InputStream body = null;
        try {
            int rBytes;
            body = httpResponse.getEntity().getContent();
            byte[] buffer = new byte[1024];
            byte[] lookUpStr = String.format(ERROR_CODE_PREFIX_PATTERN, serverCode).getBytes(StandardCharsets.UTF_8);
            StringBuilder msgBuilder = new StringBuilder();
            boolean found = false;
            block4: do {
                block9: {
                    rBytes = -1;
                    try {
                        rBytes = body.read(buffer);
                    }
                    catch (ClientException e) {
                        if (!(body instanceof ClickHouseLZ4InputStream)) break block9;
                        ClickHouseLZ4InputStream stream = (ClickHouseLZ4InputStream)body;
                        body = stream.getInputStream();
                        byte[] headerBuffer = stream.getHeaderBuffer();
                        System.arraycopy(headerBuffer, 0, buffer, 0, headerBuffer.length);
                        rBytes = headerBuffer.length;
                    }
                }
                if (rBytes == -1) break;
                for (int i = 0; i < rBytes; ++i) {
                    if (buffer[i] != lookUpStr[0]) continue;
                    found = true;
                    for (int j = 1; j < Math.min(rBytes - i, lookUpStr.length); ++j) {
                        if (buffer[i + j] == lookUpStr[j]) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    msgBuilder.append(new String(buffer, i, rBytes - i, StandardCharsets.UTF_8));
                    continue block4;
                }
            } while (!found);
            while ((rBytes = body.read(buffer)) != -1) {
                msgBuilder.append(new String(buffer, 0, rBytes, StandardCharsets.UTF_8));
            }
            String msg = msgBuilder.toString().replaceAll("\\s+", " ").replaceAll("\\\\n", " ").replaceAll("\\\\/", "/");
            if (msg.trim().isEmpty()) {
                msg = String.format(ERROR_CODE_PREFIX_PATTERN, serverCode) + " <Unreadable error message> (transport error: " + httpResponse.getCode() + ")";
            }
            return new ServerException(serverCode, "Code: " + msg, httpResponse.getCode());
        }
        catch (Exception e) {
            LOG.error("Failed to read error message", (Throwable)e);
            return new ServerException(serverCode, String.format(ERROR_CODE_PREFIX_PATTERN, serverCode) + " <Unreadable error message> (transport error: " + httpResponse.getCode() + ")", httpResponse.getCode());
        }
    }

    public ClassicHttpResponse executeRequest(Endpoint server, Map<String, Object> requestConfig, LZ4Factory lz4Factory, IOCallback<OutputStream> writeCallback) throws Exception {
        URI uri;
        if (this.poolControl != null && this.timeToPoolVent.get() < System.currentTimeMillis()) {
            this.timeToPoolVent.set(System.currentTimeMillis() + 10000L);
            this.poolControl.closeExpired();
        }
        if (requestConfig == null) {
            requestConfig = Collections.emptyMap();
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(server.getBaseURL());
            this.addQueryParams(uriBuilder, requestConfig);
            uri = uriBuilder.normalizeSyntax().build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpPost req = new HttpPost(uri);
        this.addHeaders(req, requestConfig);
        boolean clientCompression = (Boolean)ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getOrDefault(requestConfig);
        boolean useHttpCompression = (Boolean)ClientConfigProperties.USE_HTTP_COMPRESSION.getOrDefault(requestConfig);
        boolean appCompressedData = (Boolean)ClientConfigProperties.APP_COMPRESSED_DATA.getOrDefault(requestConfig);
        req.setEntity(this.wrapRequestEntity((HttpEntity)new EntityTemplate(-1L, CONTENT_TYPE, null, writeCallback), clientCompression, useHttpCompression, appCompressedData, lz4Factory, requestConfig));
        HttpClientContext context = HttpClientContext.create();
        Number responseTimeout = (Number)ClientConfigProperties.SOCKET_OPERATION_TIMEOUT.getOrDefault(requestConfig);
        Number connectionReqTimeout = (Number)ClientConfigProperties.CONNECTION_REQUEST_TIMEOUT.getOrDefault(requestConfig);
        RequestConfig reqHttpConf = RequestConfig.custom().setResponseTimeout(responseTimeout.longValue(), TimeUnit.MILLISECONDS).setConnectionRequestTimeout(connectionReqTimeout.longValue(), TimeUnit.MILLISECONDS).build();
        context.setRequestConfig(reqHttpConf);
        ClassicHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.executeOpen(null, (ClassicHttpRequest)req, (HttpContext)context);
            boolean serverCompression = (Boolean)ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getOrDefault(requestConfig);
            httpResponse.setEntity(this.wrapResponseEntity(httpResponse.getEntity(), httpResponse.getCode(), serverCompression, useHttpCompression, lz4Factory, requestConfig));
            if (httpResponse.getCode() == 407) {
                throw new ClientMisconfigurationException("Proxy authentication required. Please check your proxy settings.");
            }
            if (httpResponse.getCode() == 502) {
                httpResponse.close();
                throw new ClientException("Server returned '502 Bad gateway'. Check network and proxy settings.");
            }
            if (httpResponse.getCode() >= 400 || httpResponse.containsHeader("X-ClickHouse-Exception-Code")) {
                try {
                    throw this.readError(httpResponse);
                }
                catch (Throwable throwable) {
                    httpResponse.close();
                    throw throwable;
                }
            }
            return httpResponse;
        }
        catch (UnknownHostException e) {
            HttpAPIClientHelper.closeQuietly(httpResponse);
            LOG.warn("Host '{}' unknown", (Object)server.getBaseURL());
            throw e;
        }
        catch (ConnectException | NoRouteToHostException e) {
            HttpAPIClientHelper.closeQuietly(httpResponse);
            LOG.warn("Failed to connect to '{}': {}", (Object)server.getBaseURL(), (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            HttpAPIClientHelper.closeQuietly(httpResponse);
            LOG.debug("Failed to execute request to '{}': {}", new Object[]{server.getBaseURL(), e.getMessage(), e});
            throw e;
        }
    }

    public static void closeQuietly(ClassicHttpResponse httpResponse) {
        if (httpResponse != null) {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close response");
            }
        }
    }

    private void addHeaders(HttpPost req, Map<String, Object> requestConfig) {
        HttpAPIClientHelper.addHeader((HttpRequest)req, "Content-Type", CONTENT_TYPE.getMimeType());
        if (requestConfig.containsKey(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey())) {
            HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-Format", ((ClickHouseFormat)requestConfig.get(ClientConfigProperties.INPUT_OUTPUT_FORMAT.getKey())).name());
        }
        if (requestConfig.containsKey(ClientConfigProperties.QUERY_ID.getKey())) {
            HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-Query-Id", (String)requestConfig.get(ClientConfigProperties.QUERY_ID.getKey()));
        }
        HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-Database", (String)ClientConfigProperties.DATABASE.getOrDefault(requestConfig));
        if (((Boolean)ClientConfigProperties.SSL_AUTH.getOrDefault(requestConfig)).booleanValue()) {
            HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-User", (String)ClientConfigProperties.USER.getOrDefault(requestConfig));
            HttpAPIClientHelper.addHeader((HttpRequest)req, "x-clickhouse-ssl-certificate-auth", "on");
        } else if (((Boolean)ClientConfigProperties.HTTP_USE_BASIC_AUTH.getOrDefault(requestConfig)).booleanValue()) {
            String user = (String)ClientConfigProperties.USER.getOrDefault(requestConfig);
            String password = (String)ClientConfigProperties.PASSWORD.getOrDefault(requestConfig);
            req.addHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8))));
        } else {
            HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-User", (String)ClientConfigProperties.USER.getOrDefault(requestConfig));
            HttpAPIClientHelper.addHeader((HttpRequest)req, "X-ClickHouse-Key", (String)ClientConfigProperties.PASSWORD.getOrDefault(requestConfig));
        }
        if (this.proxyAuthHeaderValue != null) {
            req.addHeader("Proxy-Authorization", (Object)this.proxyAuthHeaderValue);
        }
        boolean clientCompression = (Boolean)ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getOrDefault(requestConfig);
        boolean serverCompression = (Boolean)ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getOrDefault(requestConfig);
        boolean useHttpCompression = (Boolean)ClientConfigProperties.USE_HTTP_COMPRESSION.getOrDefault(requestConfig);
        boolean appCompressedData = (Boolean)ClientConfigProperties.APP_COMPRESSED_DATA.getOrDefault(requestConfig);
        if (useHttpCompression) {
            if (serverCompression) {
                HttpAPIClientHelper.addHeader((HttpRequest)req, "Accept-Encoding", "lz4");
            }
            if (clientCompression && !appCompressedData) {
                HttpAPIClientHelper.addHeader((HttpRequest)req, "Content-Encoding", "lz4");
            }
        }
        for (String key : requestConfig.keySet()) {
            Object val;
            if (!key.startsWith("http_header_") || (val = requestConfig.get(key)) == null) continue;
            HttpAPIClientHelper.addHeader((HttpRequest)req, key.substring("http_header_".length()), String.valueOf(val));
        }
        if (req.containsHeader("Authorization") && (req.containsHeader("X-ClickHouse-User") || req.containsHeader("X-ClickHouse-Key"))) {
            req.removeHeaders("X-ClickHouse-User");
            req.removeHeaders("X-ClickHouse-Key");
        }
        this.correctUserAgentHeader((HttpRequest)req, requestConfig);
    }

    private void addQueryParams(URIBuilder req, Map<String, Object> requestConfig) {
        if (requestConfig.containsKey(ClientConfigProperties.QUERY_ID.getKey())) {
            req.addParameter("query_id", requestConfig.get(ClientConfigProperties.QUERY_ID.getKey()).toString());
        }
        if (requestConfig.containsKey(KEY_STATEMENT_PARAMS)) {
            Map params = (Map)requestConfig.get(KEY_STATEMENT_PARAMS);
            params.forEach((k, v) -> req.addParameter("param_" + k, String.valueOf(v)));
        }
        boolean clientCompression = (Boolean)ClientConfigProperties.COMPRESS_CLIENT_REQUEST.getOrDefault(requestConfig);
        boolean serverCompression = (Boolean)ClientConfigProperties.COMPRESS_SERVER_RESPONSE.getOrDefault(requestConfig);
        boolean useHttpCompression = (Boolean)ClientConfigProperties.USE_HTTP_COMPRESSION.getOrDefault(requestConfig);
        if (useHttpCompression) {
            req.addParameter("enable_http_compression", "1");
        } else {
            if (serverCompression) {
                req.addParameter("compress", "1");
            }
            if (clientCompression) {
                req.addParameter("decompress", "1");
            }
        }
        Collection sessionRoles = (Collection)ClientConfigProperties.SESSION_DB_ROLES.getOrDefault(requestConfig);
        if (sessionRoles != null && !sessionRoles.isEmpty()) {
            sessionRoles.forEach(r -> req.addParameter("role", r));
        }
        for (String key : requestConfig.keySet()) {
            Object val;
            if (!key.startsWith("clickhouse_setting_") || (val = requestConfig.get(key)) == null) continue;
            req.addParameter(key.substring("clickhouse_setting_".length()), String.valueOf(requestConfig.get(key)));
        }
    }

    private HttpEntity wrapRequestEntity(HttpEntity httpEntity, boolean clientCompression, boolean useHttpCompression, boolean appControlledCompression, LZ4Factory lz4Factory, Map<String, Object> requestConfig) {
        LOG.debug("wrapRequestEntity: client compression: {}, http compression: {}", (Object)clientCompression, (Object)useHttpCompression);
        if (clientCompression && !appControlledCompression) {
            int buffSize = (Integer)ClientConfigProperties.COMPRESSION_LZ4_UNCOMPRESSED_BUF_SIZE.getOrDefault(requestConfig);
            return new LZ4Entity(httpEntity, useHttpCompression, false, true, buffSize, false, lz4Factory);
        }
        return httpEntity;
    }

    private HttpEntity wrapResponseEntity(HttpEntity httpEntity, int httpStatus, boolean serverCompression, boolean useHttpCompression, LZ4Factory lz4Factory, Map<String, Object> requestConfig) {
        LOG.debug("wrapResponseEntity: server compression: {}, http compression: {}", (Object)serverCompression, (Object)useHttpCompression);
        if (serverCompression) {
            switch (httpStatus) {
                case 200: 
                case 201: 
                case 202: 
                case 204: 
                case 205: 
                case 206: 
                case 304: 
                case 400: 
                case 404: 
                case 500: {
                    int buffSize = (Integer)ClientConfigProperties.COMPRESSION_LZ4_UNCOMPRESSED_BUF_SIZE.getOrDefault(requestConfig);
                    return new LZ4Entity(httpEntity, useHttpCompression, true, false, buffSize, true, lz4Factory);
                }
            }
        }
        return httpEntity;
    }

    public static int getHeaderInt(Header header, int defaultValue) {
        return HttpAPIClientHelper.getHeaderVal(header, defaultValue, Integer::parseInt);
    }

    public static String getHeaderVal(Header header, String defaultValue) {
        return HttpAPIClientHelper.getHeaderVal(header, defaultValue, Function.identity());
    }

    public static <T> T getHeaderVal(Header header, T defaultValue, Function<String, T> converter) {
        if (header == null) {
            return defaultValue;
        }
        return converter.apply(header.getValue());
    }

    public boolean shouldRetry(Throwable ex, Map<String, Object> requestSettings) {
        List retryCauses = (List)ClientConfigProperties.CLIENT_RETRY_ON_FAILURE.getOrDefault(requestSettings);
        if (retryCauses.contains((Object)ClientFaultCause.None)) {
            return false;
        }
        if (ex instanceof NoHttpResponseException || ex.getCause() instanceof NoHttpResponseException) {
            return retryCauses.contains((Object)ClientFaultCause.NoHttpResponse);
        }
        if (ex instanceof ConnectException || ex instanceof ConnectTimeoutException || ex.getCause() instanceof ConnectException || ex.getCause() instanceof ConnectTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.ConnectTimeout);
        }
        if (ex instanceof ConnectionRequestTimeoutException || ex.getCause() instanceof ConnectionRequestTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.ConnectionRequestTimeout);
        }
        if (ex instanceof SocketTimeoutException || ex.getCause() instanceof SocketTimeoutException) {
            return retryCauses.contains((Object)ClientFaultCause.SocketTimeout);
        }
        if (ex instanceof ServerException || ex.getCause() instanceof ServerException) {
            ServerException se = (ServerException)ex;
            return se.isRetryable() && retryCauses.contains((Object)ClientFaultCause.ServerRetryable);
        }
        return false;
    }

    public RuntimeException wrapException(String message, Exception cause) {
        if (cause instanceof ClientException || cause instanceof ServerException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof ConnectionRequestTimeoutException || cause instanceof NoHttpResponseException || cause instanceof ConnectTimeoutException || cause instanceof ConnectException || cause instanceof UnknownHostException || cause instanceof NoRouteToHostException) {
            return new ConnectionInitiationException(message, cause);
        }
        if (cause instanceof SocketTimeoutException || cause instanceof IOException) {
            return new DataTransferException(message, cause);
        }
        return new ClickHouseException(message, cause);
    }

    private void correctUserAgentHeader(HttpRequest request, Map<String, Object> requestConfig) {
        Header userAgentHeader = request.getLastHeader("User-Agent");
        request.removeHeaders("User-Agent");
        String clientName = (String)ClientConfigProperties.CLIENT_NAME.getOrDefault(requestConfig);
        String userAgentValue = this.defaultUserAgent;
        if (userAgentHeader == null && clientName != null && !clientName.isEmpty()) {
            userAgentValue = clientName + " " + this.defaultUserAgent;
        } else if (userAgentHeader != null) {
            userAgentValue = userAgentHeader.getValue() + " " + this.defaultUserAgent;
        }
        request.setHeader("User-Agent", (Object)userAgentValue);
    }

    private String buildDefaultUserAgent() {
        StringBuilder userAgent = new StringBuilder();
        userAgent.append("clickhouse-java-v2/");
        String clientVersion = Client.clientVersion;
        userAgent.append(clientVersion);
        userAgent.append(" (");
        userAgent.append(System.getProperty("os.name"));
        userAgent.append("; ");
        userAgent.append("jvm:").append(System.getProperty("java.version"));
        userAgent.append("; ");
        userAgent.setLength(userAgent.length() - 2);
        userAgent.append(')');
        try {
            String httpClientVersion = this.httpClient.getClass().getPackage().getImplementationVersion();
            if (Objects.equals(this.httpClient.getClass().getPackage().getImplementationTitle(), this.getClass().getPackage().getImplementationTitle())) {
                httpClientVersion = "unknown";
                try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("client-v2-version.properties");){
                    Properties p = new Properties();
                    p.load(in);
                    String tmp = p.getProperty("apache.http.client.version");
                    if (tmp != null && !tmp.isEmpty() && !tmp.equals("${apache.httpclient.version}")) {
                        httpClientVersion = tmp;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            userAgent.append(" ").append("Apache-HttpClient").append('/').append(httpClientVersion);
        }
        catch (Exception e) {
            LOG.info("failed to construct http client version string");
        }
        return userAgent.toString();
    }

    public void close() {
        this.httpClient.close(CloseMode.IMMEDIATE);
    }

    private static <T> void addHeader(HttpRequest req, String headerName, String value) {
        if (value == null) {
            return;
        }
        if (value.trim().isEmpty()) {
            return;
        }
        if (PATTERN_HEADER_VALUE_ASCII.matcher(value).matches()) {
            req.addHeader(headerName, (Object)value);
        } else {
            try {
                req.addHeader(headerName + "*", (Object)("UTF-8''" + URLEncoder.encode(value, StandardCharsets.UTF_8.name())));
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Failed to convert string to UTF8", e);
            }
        }
    }

    public static class MeteredManagedHttpClientConnectionFactory
    extends ManagedHttpClientConnectionFactory {
        ConcurrentLinkedQueue<Long> times = new ConcurrentLinkedQueue();

        public MeteredManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, DefaultHttpResponseParserFactory defaultHttpResponseParserFactory) {
            super(http1Config, charCodingConfig, (HttpMessageParserFactory)defaultHttpResponseParserFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedHttpClientConnection createConnection(Socket socket) throws IOException {
            long startT = System.currentTimeMillis();
            try {
                ManagedHttpClientConnection managedHttpClientConnection = super.createConnection(socket);
                return managedHttpClientConnection;
            }
            finally {
                long endT = System.currentTimeMillis();
                this.times.add(endT - startT);
            }
        }

        public long getTime() {
            int count = this.times.size();
            long runningAverage = 0L;
            for (int i = 0; i < count; ++i) {
                Long t = this.times.poll();
                if (t == null) continue;
                runningAverage += t.longValue();
            }
            return count > 0 ? runningAverage / (long)count : 0L;
        }
    }

    public static class CustomSSLConnectionFactory
    extends SSLConnectionSocketFactory {
        private final SNIHostName defaultSNI;

        public CustomSSLConnectionFactory(String defaultSNI, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
            super(sslContext, hostnameVerifier);
            this.defaultSNI = defaultSNI == null || defaultSNI.trim().isEmpty() ? null : new SNIHostName(defaultSNI);
        }

        protected void prepareSocket(SSLSocket socket, HttpContext context) throws IOException {
            super.prepareSocket(socket, context);
            if (this.defaultSNI != null) {
                SSLParameters sslParams = socket.getSSLParameters();
                sslParams.setServerNames(Collections.singletonList(this.defaultSNI));
                socket.setSSLParameters(sslParams);
            }
        }
    }

    private static class DummySSLConnectionSocketFactory
    implements LayeredConnectionSocketFactory {
        private DummySSLConnectionSocketFactory() {
        }

        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
            return null;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return null;
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            return null;
        }
    }
}

