/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.value.ClickHouseBitmap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class BinaryStreamReader {
    private final InputStream input;
    private final Logger log;
    private final TimeZone timeZone;
    private final ByteBufferAllocator bufferAllocator;
    public static final int INT16_SIZE = 2;
    public static final int INT32_SIZE = 4;
    public static final int INT64_SIZE = 8;
    public static final int INT128_SIZE = 16;
    public static final int INT256_SIZE = 32;
    public static final int[] BASES = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    BinaryStreamReader(InputStream input, TimeZone timeZone, Logger log) {
        this(input, timeZone, log, new DefaultByteBufferAllocator());
    }

    BinaryStreamReader(InputStream input, TimeZone timeZone, Logger log, ByteBufferAllocator bufferAllocator) {
        this.log = log == null ? NOPLogger.NOP_LOGGER : log;
        this.timeZone = timeZone;
        this.input = input;
        this.bufferAllocator = bufferAllocator;
    }

    public <T> T readValue(ClickHouseColumn column) throws IOException {
        return this.readValue(column, null);
    }

    public <T> T readValue(ClickHouseColumn column, Class<?> typeHint) throws IOException {
        int isNull;
        if (column.isNullable() && (isNull = BinaryStreamReader.readByteOrEOF(this.input)) == 1) {
            return null;
        }
        try {
            switch (column.getDataType()) {
                case FixedString: {
                    byte[] bytes = BinaryStreamReader.readNBytes(this.input, column.getEstimatedLength());
                    return (T)new String(bytes, 0, column.getEstimatedLength(), StandardCharsets.UTF_8);
                }
                case String: {
                    int len = BinaryStreamReader.readVarInt(this.input);
                    if (len == 0) {
                        return (T)"";
                    }
                    return (T)new String(BinaryStreamReader.readNBytes(this.input, len), StandardCharsets.UTF_8);
                }
                case Int8: {
                    return (T)Byte.valueOf(this.readByte());
                }
                case UInt8: {
                    return (T)Short.valueOf(this.readUnsignedByte());
                }
                case Int16: {
                    return (T)Short.valueOf(this.readShortLE());
                }
                case UInt16: {
                    return (T)Integer.valueOf(this.readUnsignedShortLE());
                }
                case Int32: {
                    return (T)Integer.valueOf(this.readIntLE());
                }
                case UInt32: {
                    return (T)Long.valueOf(this.readUnsignedIntLE());
                }
                case Int64: {
                    return (T)Long.valueOf(this.readLongLE());
                }
                case UInt64: {
                    return (T)this.readBigIntegerLE(8, true);
                }
                case Int128: {
                    return (T)this.readBigIntegerLE(16, false);
                }
                case UInt128: {
                    return (T)this.readBigIntegerLE(16, true);
                }
                case Int256: {
                    return (T)this.readBigIntegerLE(32, false);
                }
                case UInt256: {
                    return (T)this.readBigIntegerLE(32, true);
                }
                case Decimal: {
                    return (T)this.readDecimal(column.getPrecision(), column.getScale());
                }
                case Decimal32: {
                    return (T)this.readDecimal(ClickHouseDataType.Decimal32.getMaxPrecision(), column.getScale());
                }
                case Decimal64: {
                    return (T)this.readDecimal(ClickHouseDataType.Decimal64.getMaxPrecision(), column.getScale());
                }
                case Decimal128: {
                    return (T)this.readDecimal(ClickHouseDataType.Decimal128.getMaxPrecision(), column.getScale());
                }
                case Decimal256: {
                    return (T)this.readDecimal(ClickHouseDataType.Decimal256.getMaxPrecision(), column.getScale());
                }
                case Float32: {
                    return (T)Float.valueOf(this.readFloatLE());
                }
                case Float64: {
                    return (T)Double.valueOf(this.readDoubleLE());
                }
                case Bool: {
                    return (T)Boolean.valueOf(BinaryStreamReader.readByteOrEOF(this.input) == 1);
                }
                case Enum8: {
                    return (T)Byte.valueOf((byte)this.readUnsignedByte());
                }
                case Enum16: {
                    return (T)Short.valueOf((short)this.readUnsignedShortLE());
                }
                case Date: {
                    return BinaryStreamReader.convertDateTime(this.readDate(column.getTimeZone() == null ? this.timeZone : column.getTimeZone()), typeHint);
                }
                case Date32: {
                    return BinaryStreamReader.convertDateTime(this.readDate32(column.getTimeZone() == null ? this.timeZone : column.getTimeZone()), typeHint);
                }
                case DateTime: {
                    return BinaryStreamReader.convertDateTime(this.readDateTime32(column.getTimeZone() == null ? this.timeZone : column.getTimeZone()), typeHint);
                }
                case DateTime32: {
                    return BinaryStreamReader.convertDateTime(this.readDateTime32(column.getTimeZone() == null ? this.timeZone : column.getTimeZone()), typeHint);
                }
                case DateTime64: {
                    return BinaryStreamReader.convertDateTime(this.readDateTime64(column.getScale(), column.getTimeZone() == null ? this.timeZone : column.getTimeZone()), typeHint);
                }
                case IntervalYear: 
                case IntervalQuarter: 
                case IntervalMonth: 
                case IntervalWeek: 
                case IntervalDay: 
                case IntervalHour: 
                case IntervalMinute: 
                case IntervalSecond: 
                case IntervalMicrosecond: 
                case IntervalMillisecond: 
                case IntervalNanosecond: {
                    return (T)this.readBigIntegerLE(8, true);
                }
                case IPv4: {
                    return (T)Inet4Address.getByAddress(this.readNBytesLE(this.input, 4));
                }
                case IPv6: {
                    return (T)Inet6Address.getByAddress(BinaryStreamReader.readNBytes(this.input, 16));
                }
                case UUID: {
                    return (T)new UUID(this.readLongLE(), this.readLongLE());
                }
                case Point: {
                    return (T)this.readGeoPoint();
                }
                case Polygon: {
                    return (T)this.readGeoPolygon();
                }
                case MultiPolygon: {
                    return (T)this.readGeoMultiPolygon();
                }
                case Ring: {
                    return (T)this.readGeoRing();
                }
                case Array: {
                    return BinaryStreamReader.convertArray(this.readArray(column), typeHint);
                }
                case Map: {
                    return (T)this.readMap(column);
                }
                case Tuple: {
                    return (T)this.readTuple(column);
                }
                case Nothing: {
                    return null;
                }
                case AggregateFunction: {
                    return (T)this.readBitmap(column);
                }
            }
            throw new IllegalArgumentException("Unsupported data type: " + column.getDataType());
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to read value for column " + column.getColumnName(), e);
        }
    }

    private static <T> T convertDateTime(ZonedDateTime value, Class<?> typeHint) {
        if (typeHint == null) {
            return (T)value;
        }
        if (typeHint.isAssignableFrom(LocalDateTime.class)) {
            return (T)value.toLocalDateTime();
        }
        if (typeHint.isAssignableFrom(LocalDate.class)) {
            return (T)value.toLocalDate();
        }
        return (T)value;
    }

    private static <T> T convertArray(ArrayValue value, Class<?> typeHint) {
        if (typeHint == null) {
            return (T)value;
        }
        if (typeHint.isAssignableFrom(List.class)) {
            return (T)value.asList();
        }
        return (T)value;
    }

    public short readShortLE() throws IOException {
        return BinaryStreamReader.readShortLE(this.input, this.bufferAllocator.allocate(2));
    }

    public static short readShortLE(InputStream input, byte[] buff) throws IOException {
        BinaryStreamReader.readNBytes(input, buff, 0, 2);
        return (short)(buff[0] & 0xFF | (buff[1] & 0xFF) << 8);
    }

    public int readIntLE() throws IOException {
        return BinaryStreamReader.readIntLE(this.input, this.bufferAllocator.allocate(4));
    }

    public static int readIntLE(InputStream input, byte[] buff) throws IOException {
        BinaryStreamReader.readNBytes(input, buff, 0, 4);
        return buff[0] & 0xFF | (buff[1] & 0xFF) << 8 | (buff[2] & 0xFF) << 16 | (buff[3] & 0xFF) << 24;
    }

    public long readLongLE() throws IOException {
        return BinaryStreamReader.readLongLE(this.input, this.bufferAllocator.allocate(8));
    }

    public static long readLongLE(InputStream input, byte[] buff) throws IOException {
        BinaryStreamReader.readNBytes(input, buff, 0, 8);
        return (long)(buff[0] & 0xFF) | (long)(buff[1] & 0xFF) << 8 | (long)(buff[2] & 0xFF) << 16 | (long)(buff[3] & 0xFF) << 24 | (long)(buff[4] & 0xFF) << 32 | (long)(buff[5] & 0xFF) << 40 | (long)(buff[6] & 0xFF) << 48 | (long)(buff[7] & 0xFF) << 56;
    }

    public byte readByte() throws IOException {
        return (byte)BinaryStreamReader.readByteOrEOF(this.input);
    }

    public short readUnsignedByte() throws IOException {
        return (short)(BinaryStreamReader.readByteOrEOF(this.input) & 0xFF);
    }

    public int readUnsignedShortLE() throws IOException {
        return BinaryStreamReader.readUnsignedShortLE(this.input, this.bufferAllocator.allocate(2));
    }

    public static int readUnsignedShortLE(InputStream input, byte[] buff) throws IOException {
        return BinaryStreamReader.readShortLE(input, buff) & 0xFFFF;
    }

    public long readUnsignedIntLE() throws IOException {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    public static long readUnsignedIntLE(InputStream input, byte[] buff) throws IOException {
        return (long)BinaryStreamReader.readIntLE(input, buff) & 0xFFFFFFFFL;
    }

    public BigInteger readBigIntegerLE(int len, boolean unsigned) throws IOException {
        return BinaryStreamReader.readBigIntegerLE(this.input, this.bufferAllocator.allocate(len), len, unsigned);
    }

    public static BigInteger readBigIntegerLE(InputStream input, byte[] buff, int len, boolean unsigned) throws IOException {
        byte[] bytes = BinaryStreamReader.readNBytesLE(input, buff, 0, len);
        return unsigned ? new BigInteger(1, bytes) : new BigInteger(bytes);
    }

    public float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public BigDecimal readDecimal(int precision, int scale) throws IOException {
        if (precision <= ClickHouseDataType.Decimal32.getMaxScale()) {
            return BigDecimal.valueOf(this.readIntLE(), scale);
        }
        BigDecimal v = precision <= ClickHouseDataType.Decimal64.getMaxScale() ? BigDecimal.valueOf(this.readLongLE(), scale) : (precision <= ClickHouseDataType.Decimal128.getMaxScale() ? new BigDecimal(this.readBigIntegerLE(16, false), scale) : new BigDecimal(this.readBigIntegerLE(32, false), scale));
        return v;
    }

    public static byte[] readNBytes(InputStream inputStream, int len) throws IOException {
        byte[] bytes = new byte[len];
        return BinaryStreamReader.readNBytes(inputStream, bytes, 0, len);
    }

    public static byte[] readNBytes(InputStream inputStream, byte[] buffer, int offset, int len) throws IOException {
        int r;
        for (int total = 0; total < len; total += r) {
            r = inputStream.read(buffer, offset + total, len - total);
            if (r != -1) continue;
            throw new EOFException("End of stream reached before reading all data");
        }
        return buffer;
    }

    private byte[] readNBytesLE(InputStream input, int len) throws IOException {
        return BinaryStreamReader.readNBytesLE(input, this.bufferAllocator.allocate(len), 0, len);
    }

    public static byte[] readNBytesLE(InputStream input, byte[] buffer, int offset, int len) throws IOException {
        byte[] bytes = BinaryStreamReader.readNBytes(input, buffer, 0, len);
        int s = 0;
        for (int i = len - 1; s < i; ++s, --i) {
            byte b = bytes[s];
            bytes[s] = bytes[i];
            bytes[i] = b;
        }
        return bytes;
    }

    public ArrayValue readArray(ClickHouseColumn column) throws IOException {
        Class itemType = column.getArrayBaseColumn().getDataType().getWiderPrimitiveClass();
        if (column.getArrayBaseColumn().isNullable()) {
            itemType = ClickHouseDataType.toObjectType((Class)itemType);
        }
        int len = BinaryStreamReader.readVarInt(this.input);
        ArrayValue array = new ArrayValue(column.getArrayNestedLevel() > 1 ? ArrayValue.class : itemType, len);
        if (len == 0) {
            return array;
        }
        for (int i = 0; i < len; ++i) {
            array.set(i, this.readValue((ClickHouseColumn)column.getNestedColumns().get(0)));
        }
        return array;
    }

    public void skipValue(ClickHouseColumn column) throws IOException {
        this.readValue(column, null);
    }

    public Map<?, ?> readMap(ClickHouseColumn column) throws IOException {
        int len = BinaryStreamReader.readVarInt(this.input);
        if (len == 0) {
            return Collections.emptyMap();
        }
        ClickHouseColumn keyType = column.getKeyInfo();
        ClickHouseColumn valueType = column.getValueInfo();
        LinkedHashMap map = new LinkedHashMap(len);
        for (int i = 0; i < len; ++i) {
            Object key = this.readValue(keyType);
            Object value = this.readValue(valueType);
            map.put(key, value);
        }
        return map;
    }

    public Object[] readTuple(ClickHouseColumn column) throws IOException {
        int len = column.getNestedColumns().size();
        Object[] tuple = new Object[len];
        for (int i = 0; i < len; ++i) {
            tuple[i] = this.readValue((ClickHouseColumn)column.getNestedColumns().get(i));
        }
        return tuple;
    }

    public double[] readGeoPoint() throws IOException {
        return new double[]{this.readDoubleLE(), this.readDoubleLE()};
    }

    public double[][] readGeoRing() throws IOException {
        int count = BinaryStreamReader.readVarInt(this.input);
        double[][] value = new double[count][2];
        for (int i = 0; i < count; ++i) {
            value[i] = this.readGeoPoint();
        }
        return value;
    }

    public double[][][] readGeoPolygon() throws IOException {
        int count = BinaryStreamReader.readVarInt(this.input);
        double[][][] value = new double[count][][];
        for (int i = 0; i < count; ++i) {
            value[i] = this.readGeoRing();
        }
        return value;
    }

    private double[][][][] readGeoMultiPolygon() throws IOException {
        int count = BinaryStreamReader.readVarInt(this.input);
        double[][][][] value = new double[count][][][];
        for (int i = 0; i < count; ++i) {
            value[i] = this.readGeoPolygon();
        }
        return value;
    }

    public static int readVarInt(InputStream input) throws IOException {
        int value = 0;
        for (int i = 0; i < 10; ++i) {
            byte b = (byte)BinaryStreamReader.readByteOrEOF(input);
            value |= (b & 0x7F) << 7 * i;
            if ((b & 0x80) == 0) break;
        }
        return value;
    }

    private ZonedDateTime readDate(TimeZone tz) throws IOException {
        return BinaryStreamReader.readDate(this.input, this.bufferAllocator.allocate(2), tz);
    }

    public static ZonedDateTime readDate(InputStream input, byte[] buff, TimeZone tz) throws IOException {
        LocalDate d = LocalDate.ofEpochDay(BinaryStreamReader.readUnsignedShortLE(input, buff));
        return d.atStartOfDay(tz.toZoneId()).withZoneSameInstant(tz.toZoneId());
    }

    public ZonedDateTime readDate32(TimeZone tz) throws IOException {
        return BinaryStreamReader.readDate32(this.input, this.bufferAllocator.allocate(4), tz);
    }

    public static ZonedDateTime readDate32(InputStream input, byte[] buff, TimeZone tz) throws IOException {
        LocalDate d = LocalDate.ofEpochDay(BinaryStreamReader.readIntLE(input, buff));
        return d.atStartOfDay(tz.toZoneId()).withZoneSameInstant(tz.toZoneId());
    }

    private ZonedDateTime readDateTime32(TimeZone tz) throws IOException {
        return BinaryStreamReader.readDateTime32(this.input, this.bufferAllocator.allocate(4), tz);
    }

    public static ZonedDateTime readDateTime32(InputStream input, byte[] buff, TimeZone tz) throws IOException {
        long time = BinaryStreamReader.readUnsignedIntLE(input, buff);
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Math.max(time, 0L)), tz.toZoneId()).atZone(tz.toZoneId());
    }

    public ZonedDateTime readDateTime64(int scale, TimeZone tz) throws IOException {
        return BinaryStreamReader.readDateTime64(this.input, this.bufferAllocator.allocate(8), scale, tz);
    }

    public static ZonedDateTime readDateTime64(InputStream input, byte[] buff, int scale, TimeZone tz) throws IOException {
        long value = BinaryStreamReader.readLongLE(input, buff);
        int nanoSeconds = 0;
        if (scale > 0) {
            int factor = BASES[scale];
            nanoSeconds = (int)(value % (long)factor);
            value /= (long)factor;
            if (nanoSeconds < 0) {
                nanoSeconds += factor;
                --value;
            }
            if ((long)nanoSeconds > 0L) {
                nanoSeconds *= BASES[9 - scale];
            }
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(value, nanoSeconds), tz.toZoneId()).atZone(tz.toZoneId());
    }

    public static String readString(InputStream input) throws IOException {
        int len = BinaryStreamReader.readVarInt(input);
        if (len == 0) {
            return "";
        }
        return new String(BinaryStreamReader.readNBytes(input, len), StandardCharsets.UTF_8);
    }

    public static int readByteOrEOF(InputStream input) throws IOException {
        int b = input.read();
        if (b < 0) {
            throw new EOFException("End of stream reached before reading all data");
        }
        return b;
    }

    public static boolean isReadToPrimitive(ClickHouseDataType dataType) {
        switch (dataType) {
            case Int8: 
            case UInt8: 
            case Int16: 
            case UInt16: 
            case Int32: 
            case UInt32: 
            case Int64: 
            case Float32: 
            case Float64: 
            case Bool: 
            case Enum8: 
            case Enum16: {
                return true;
            }
        }
        return false;
    }

    private ClickHouseBitmap readBitmap(ClickHouseColumn column) throws IOException {
        return ClickHouseBitmap.deserialize((InputStream)this.input, (ClickHouseDataType)((ClickHouseColumn)column.getNestedColumns().get(0)).getDataType());
    }

    public static class DefaultByteBufferAllocator
    implements ByteBufferAllocator {
        @Override
        public byte[] allocate(int size) {
            return new byte[size];
        }
    }

    public static interface ByteBufferAllocator {
        public byte[] allocate(int var1);
    }

    public static class ArrayValue {
        final int length;
        final Class<?> itemType;
        final Object array;
        private List<?> list = null;

        ArrayValue(Class<?> itemType, int length) {
            this.itemType = itemType;
            this.length = length;
            try {
                this.array = itemType.isArray() ? Array.newInstance(ArrayValue.class, length) : (itemType == List.class ? Array.newInstance(Object[].class, length) : Array.newInstance(itemType, length));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to create array of type: " + itemType, e);
            }
        }

        public int length() {
            return this.length;
        }

        public Object get(int index) {
            return Array.get(this.array, index);
        }

        public void set(int index, Object value) {
            try {
                Array.set(this.array, index, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to set value at index: " + index + " value " + value + " of class " + value.getClass().getName(), e);
            }
        }

        public synchronized <T> List<T> asList() {
            if (this.list == null) {
                ArrayList list = new ArrayList(this.length);
                for (int i = 0; i < this.length; ++i) {
                    Object item = this.get(i);
                    if (item instanceof ArrayValue) {
                        list.add(((ArrayValue)item).asList());
                        continue;
                    }
                    list.add(item);
                }
                this.list = list;
            }
            return this.list;
        }
    }

    public static class CachingByteBufferAllocator
    implements ByteBufferAllocator {
        private static final int MAX_PREALLOCATED_SIZE = 32;
        private final byte[][] preallocated = new byte[33][];

        public CachingByteBufferAllocator() {
            for (int i = 0; i < this.preallocated.length; ++i) {
                this.preallocated[i] = new byte[i];
            }
        }

        @Override
        public byte[] allocate(int size) {
            if (size < this.preallocated.length) {
                return this.preallocated[size];
            }
            return new byte[size];
        }
    }
}

