/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metadata;

import com.clickhouse.data.ClickHouseColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSchema {
    private String tableName = "";
    private String databaseName = "";
    private List<ClickHouseColumn> columns;
    private Map<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();
    private Map<String, Integer> colIndex;
    private boolean hasDefaults = false;

    public TableSchema() {
        this.columns = new ArrayList<ClickHouseColumn>();
        this.colIndex = new HashMap<String, Integer>();
    }

    public List<ClickHouseColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean hasDefaults() {
        return this.hasDefaults;
    }

    public void addColumn(String name, String type) {
        this.columns.add(ClickHouseColumn.of((String)name, (String)type));
        if (type.toUpperCase().contains("DEFAULT")) {
            this.hasDefaults = true;
        }
        Map columnMetadata = this.metadata.computeIfAbsent(name, k -> new HashMap());
        columnMetadata.put("type", type);
        this.colIndex.put(name, this.columns.size() - 1);
    }

    public ClickHouseColumn getColumnByName(String name) {
        for (ClickHouseColumn column : this.columns) {
            if (!column.getColumnName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    public String indexToName(int index) {
        return this.columns.get(index).getColumnName();
    }

    public int nameToIndex(String name) {
        return this.colIndex.get(name);
    }
}

