/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseLocalDateParser
extends ClickHouseDateValueParser<LocalDate> {
    private static ClickHouseLocalDateParser instance;

    static ClickHouseLocalDateParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseLocalDateParser();
        }
        return instance;
    }

    private ClickHouseLocalDateParser() {
        super(LocalDate.class);
    }

    @Override
    LocalDate parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateToLocalDate(value, columnInfo, timeZone).toLocalDate();
    }

    @Override
    LocalDate parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateTimeToLocalDateTime(value, columnInfo, timeZone).toLocalDate();
    }

    @Override
    LocalDate parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.parseAsInstant(value).atZone(timeZone.toZoneId()).toLocalDate();
    }

    @Override
    LocalDate parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return this.parseAsLocalDate(value);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return this.parseAsLocalDateTime(value).toLocalDate();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                Instant i = this.parseAsInstant(value);
                return i.atZone(timeZone.toZoneId()).toLocalDate();
            }
        }
    }
}

