/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseBitmap;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseRowBinaryStream {
    private static final int U_INT8_MAX = 255;
    private static final int U_INT16_MAX = 65535;
    private static final long U_INT32_MAX = 0xFFFFFFFFL;
    protected static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private final DataOutputStream out;
    private final TimeZone timeZone;

    public ClickHouseRowBinaryStream(OutputStream outputStream, TimeZone timeZone, ClickHouseProperties properties) {
        this.out = new DataOutputStream(outputStream);
        this.timeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
    }

    public void writeUnsignedLeb128(int value) throws IOException {
        Utils.checkArgument(value, 0);
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            this.out.write((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        this.out.write((byte)(value & 0x7F));
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void writeByteBuffer(ByteBuffer buffer) throws IOException {
        Channels.newChannel(this.out).write(buffer);
    }

    public void writeBytes(byte[] bytes, int offset, int len) throws IOException {
        this.out.write(bytes, offset, len);
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void writeString(String string) throws IOException {
        byte[] bytes = Objects.requireNonNull(string).getBytes(StandardCharsets.UTF_8);
        this.writeUnsignedLeb128(bytes.length);
        this.out.write(bytes);
    }

    public void writeFixedString(String string) throws IOException {
        byte[] bytes = Objects.requireNonNull(string).getBytes(StandardCharsets.UTF_8);
        this.out.write(bytes);
    }

    public void writeFixedString(String string, Integer len) throws IOException {
        byte[] bytes = Objects.requireNonNull(string).getBytes(StandardCharsets.UTF_8);
        Integer bl = bytes.length;
        this.out.write(bytes, 0, Math.min(len, bl));
        for (int i = 0; i < len - bl; ++i) {
            this.out.write(0);
        }
    }

    public void writeUInt8(boolean value) throws IOException {
        this.out.writeByte(value ? 1 : 0);
    }

    public void writeUInt8(int value) throws IOException {
        Utils.checkArgument(value, 0, 255);
        byte unsigned = (byte)((long)value & 0xFFL);
        this.out.writeByte(unsigned);
    }

    public void writeInt8(int value) throws IOException {
        Utils.checkArgument(value, -128, 127);
        this.out.writeByte(value);
    }

    public void writeInt8(byte value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeInt16(int value) throws IOException {
        Utils.checkArgument(value, Short.MIN_VALUE, Short.MAX_VALUE);
        Utils.writeShort(this.out, value);
    }

    public void writeInt16(short value) throws IOException {
        Utils.writeShort(this.out, value);
    }

    public void writeUInt16(int value) throws IOException {
        Utils.checkArgument(value, 0, 65535);
        short unsigned = (short)((long)value & 0xFFFFL);
        Utils.writeShort(this.out, unsigned);
    }

    public void writeInt32(int value) throws IOException {
        Utils.writeInt(this.out, value);
    }

    public void writeUInt32(long value) throws IOException {
        Utils.checkArgument(value, 0L, 0xFFFFFFFFL);
        int unsigned = (int)(value & 0xFFFFFFFFL);
        Utils.writeInt(this.out, unsigned);
    }

    public void writeInt64(long value) throws IOException {
        Utils.writeLong(this.out, value);
    }

    public void writeUInt64(long value) throws IOException {
        Utils.writeLong(this.out, value);
    }

    public void writeUInt64(BigInteger value) throws IOException {
        Utils.checkArgument(value, BigInteger.ZERO);
        Utils.writeLong(this.out, value.longValue());
    }

    public void writeInt128(BigInteger value) throws IOException {
        Utils.writeBigInteger(this.out, value, 16);
    }

    public void writeUInt128(BigInteger value) throws IOException {
        Utils.checkArgument(value, BigInteger.ZERO);
        Utils.writeBigInteger(this.out, value, 16);
    }

    public void writeInt256(BigInteger value) throws IOException {
        Utils.writeBigInteger(this.out, value, 32);
    }

    public void writeUInt256(BigInteger value) throws IOException {
        Utils.checkArgument(value, BigInteger.ZERO);
        Utils.writeBigInteger(this.out, value, 32);
    }

    public void writeDateTime(Date date) throws IOException {
        Objects.requireNonNull(date);
        this.writeUInt32(TimeUnit.MILLISECONDS.toSeconds(date.getTime()));
    }

    public void writeDate(Date date) throws IOException {
        Objects.requireNonNull(date);
        long localMillis = date.getTime() + (long)this.timeZone.getOffset(date.getTime());
        int daysSinceEpoch = (int)(localMillis / MILLIS_IN_DAY);
        this.writeUInt16(daysSinceEpoch);
    }

    public void writeFloat32(float value) throws IOException {
        Utils.writeInt(this.out, Float.floatToIntBits(value));
    }

    public void writeFloat64(double value) throws IOException {
        Utils.writeLong(this.out, Double.doubleToLongBits(value));
    }

    public void writeBigInteger(BigInteger value, int byteLength) throws IOException {
        int i;
        int empty = value.signum() == -1 ? -1 : 0;
        byte[] bytes = value.toByteArray();
        for (i = bytes.length - 1; i >= 0; --i) {
            this.out.write(bytes[i]);
        }
        for (i = byteLength - bytes.length; i > 0; --i) {
            this.out.write(empty);
        }
    }

    public void writeDecimal128(BigDecimal num, int scale) throws IOException {
        this.writeBigInteger(Utils.toBigInteger(num, scale), 16);
    }

    public void writeDecimal256(BigDecimal num, int scale) throws IOException {
        this.writeBigInteger(Utils.toBigInteger(num, scale), 32);
    }

    public void writeDecimal64(BigDecimal num, int scale) throws IOException {
        Utils.writeLong(this.out, Utils.toBigInteger(num, scale).longValue());
    }

    public void writeDecimal32(BigDecimal num, int scale) throws IOException {
        Utils.writeInt(this.out, Utils.toBigInteger(num, scale).intValue());
    }

    public void writeDateArray(Date[] dates) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(dates).length);
        for (Date date : dates) {
            this.writeDate(date);
        }
    }

    public void writeDateTimeArray(Date[] dates) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(dates).length);
        for (Date date : dates) {
            this.writeDateTime(date);
        }
    }

    public void writeStringArray(String[] strings) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(strings).length);
        for (String el : strings) {
            this.writeString(el);
        }
    }

    public void writeInt8Array(byte[] bytes) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(bytes).length);
        for (byte b : bytes) {
            this.writeInt8(b);
        }
    }

    public void writeInt8Array(int[] ints) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(ints).length);
        for (int i : ints) {
            this.writeInt8(i);
        }
    }

    public void writeUInt8Array(int[] ints) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(ints).length);
        for (int i : ints) {
            this.writeUInt8(i);
        }
    }

    public void writeInt16Array(short[] shorts) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(shorts).length);
        for (short s : shorts) {
            this.writeInt16(s);
        }
    }

    public void writeUInt16Array(int[] ints) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(ints).length);
        for (int i : ints) {
            this.writeUInt16(i);
        }
    }

    public void writeInt32Array(int[] ints) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(ints).length);
        for (int i : ints) {
            this.writeInt32(i);
        }
    }

    public void writeUInt32Array(long[] longs) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(longs).length);
        for (long l : longs) {
            this.writeUInt32(l);
        }
    }

    public void writeInt64Array(long[] longs) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(longs).length);
        for (long l : longs) {
            this.writeInt64(l);
        }
    }

    public void writeUInt64Array(long[] longs) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(longs).length);
        for (long l : longs) {
            this.writeUInt64(l);
        }
    }

    public void writeUInt64Array(BigInteger[] longs) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(longs).length);
        for (BigInteger l : longs) {
            this.writeUInt64(l);
        }
    }

    public void writeFloat32Array(float[] floats) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(floats).length);
        for (float f : floats) {
            this.writeFloat32(f);
        }
    }

    public void writeFloat64Array(double[] doubles) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(doubles).length);
        for (double d : doubles) {
            this.writeFloat64(d);
        }
    }

    public void markNextNullable(boolean isNullable) throws IOException {
        this.writeByte(isNullable ? (byte)1 : 0);
    }

    public void writeUUID(UUID uuid) throws IOException {
        Objects.requireNonNull(uuid);
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        byte[] array = bb.array();
        this.writeBytes(array);
    }

    public void writeUUIDArray(UUID[] uuids) throws IOException {
        this.writeUnsignedLeb128(Objects.requireNonNull(uuids).length);
        for (UUID uuid : uuids) {
            this.writeUUID(uuid);
        }
    }

    public void writeBitmap(ClickHouseBitmap rb) throws IOException {
        this.writeByteBuffer(Objects.requireNonNull(rb).toByteBuffer());
    }
}

