/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseAggregateFunction;
import com.clickhouse.data.ClickHouseArraySequence;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseEnum;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.value.ClickHouseArrayValue;
import com.clickhouse.data.value.ClickHouseBigDecimalValue;
import com.clickhouse.data.value.ClickHouseBigIntegerValue;
import com.clickhouse.data.value.ClickHouseBitmapValue;
import com.clickhouse.data.value.ClickHouseBoolValue;
import com.clickhouse.data.value.ClickHouseByteValue;
import com.clickhouse.data.value.ClickHouseDateTimeValue;
import com.clickhouse.data.value.ClickHouseDateValue;
import com.clickhouse.data.value.ClickHouseDoubleValue;
import com.clickhouse.data.value.ClickHouseEmptyValue;
import com.clickhouse.data.value.ClickHouseEnumValue;
import com.clickhouse.data.value.ClickHouseFloatValue;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import com.clickhouse.data.value.ClickHouseIntegerValue;
import com.clickhouse.data.value.ClickHouseIpv4Value;
import com.clickhouse.data.value.ClickHouseIpv6Value;
import com.clickhouse.data.value.ClickHouseLongValue;
import com.clickhouse.data.value.ClickHouseMapValue;
import com.clickhouse.data.value.ClickHouseNestedValue;
import com.clickhouse.data.value.ClickHouseObjectValue;
import com.clickhouse.data.value.ClickHouseOffsetDateTimeValue;
import com.clickhouse.data.value.ClickHouseShortValue;
import com.clickhouse.data.value.ClickHouseStringValue;
import com.clickhouse.data.value.ClickHouseTupleValue;
import com.clickhouse.data.value.ClickHouseUuidValue;
import com.clickhouse.data.value.array.ClickHouseBoolArrayValue;
import com.clickhouse.data.value.array.ClickHouseByteArrayValue;
import com.clickhouse.data.value.array.ClickHouseDoubleArrayValue;
import com.clickhouse.data.value.array.ClickHouseFloatArrayValue;
import com.clickhouse.data.value.array.ClickHouseIntArrayValue;
import com.clickhouse.data.value.array.ClickHouseLongArrayValue;
import com.clickhouse.data.value.array.ClickHouseShortArrayValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public final class ClickHouseColumn
implements Serializable {
    public static final String TYPE_NAME = "Column";
    public static final ClickHouseColumn[] EMPTY_ARRAY = new ClickHouseColumn[0];
    private static final long serialVersionUID = 8228660689532259640L;
    private static final String ERROR_MISSING_NESTED_TYPE = "Missing nested data type";
    private static final String KEYWORD_NULLABLE = "Nullable";
    private static final String KEYWORD_LOW_CARDINALITY = "LowCardinality";
    private static final String KEYWORD_AGGREGATE_FUNCTION = ClickHouseDataType.AggregateFunction.name();
    private static final String KEYWORD_SIMPLE_AGGREGATE_FUNCTION = ClickHouseDataType.SimpleAggregateFunction.name();
    private static final String KEYWORD_ARRAY = ClickHouseDataType.Array.name();
    private static final String KEYWORD_TUPLE = ClickHouseDataType.Tuple.name();
    private static final String KEYWORD_OBJECT = ClickHouseDataType.Object.name();
    private static final String KEYWORD_MAP = ClickHouseDataType.Map.name();
    private static final String KEYWORD_NESTED = ClickHouseDataType.Nested.name();
    private int columnCount;
    private int columnIndex;
    private String columnName;
    private String originalTypeName;
    private ClickHouseAggregateFunction aggFuncType = null;
    private ClickHouseDataType dataType;
    private boolean nullable;
    private boolean hasDefault;
    private boolean lowCardinality;
    private boolean lowCardinalityDisabled;
    private TimeZone timeZone;
    private int precision;
    private int scale;
    private List<ClickHouseColumn> nested;
    private List<String> parameters;
    private ClickHouseEnum enumConstants;
    private int arrayLevel;
    private ClickHouseColumn arrayBaseColumn;
    private boolean fixedByteLength;
    private int estimatedByteLength;
    private ClickHouseValue template;

    private static ClickHouseColumn update(ClickHouseColumn column) {
        column.enumConstants = ClickHouseEnum.EMPTY;
        int size = column.parameters.size();
        column.precision = column.dataType.getMaxPrecision();
        switch (column.dataType) {
            case Array: {
                if (column.nested.isEmpty()) break;
                column.arrayLevel = 1;
                column.arrayBaseColumn = column.nested.get(0);
                while (column.arrayLevel < 255 && column.arrayBaseColumn.dataType == ClickHouseDataType.Array) {
                    ++column.arrayLevel;
                    column.arrayBaseColumn = column.arrayBaseColumn.nested.get(0);
                }
                break;
            }
            case Bool: {
                column.template = ClickHouseBoolValue.ofNull();
                break;
            }
            case Enum8: 
            case Enum16: {
                column.enumConstants = new ClickHouseEnum(column.parameters);
                column.template = ClickHouseEnumValue.ofNull(column.enumConstants);
                break;
            }
            case Int8: {
                column.template = ClickHouseByteValue.ofNull();
                break;
            }
            case Int16: {
                column.template = ClickHouseShortValue.ofNull();
                break;
            }
            case Int32: {
                column.template = ClickHouseIntegerValue.ofNull();
                break;
            }
            case IntervalYear: 
            case IntervalQuarter: 
            case IntervalMonth: 
            case IntervalWeek: 
            case IntervalDay: 
            case IntervalHour: 
            case IntervalMinute: 
            case IntervalSecond: 
            case IntervalMicrosecond: 
            case IntervalMillisecond: 
            case IntervalNanosecond: 
            case Int64: {
                column.template = ClickHouseLongValue.ofNull(false);
                break;
            }
            case UInt64: {
                column.template = ClickHouseLongValue.ofUnsignedNull();
                break;
            }
            case Int128: 
            case UInt128: 
            case Int256: 
            case UInt256: {
                column.template = ClickHouseBigIntegerValue.ofNull();
                break;
            }
            case Float32: {
                column.template = ClickHouseFloatValue.ofNull();
                break;
            }
            case Float64: {
                column.template = ClickHouseDoubleValue.ofNull();
                break;
            }
            case Date: 
            case Date32: {
                column.template = ClickHouseDateValue.ofNull();
                break;
            }
            case DateTime: {
                if (size >= 2) {
                    if (!column.nullable) {
                        column.estimatedByteLength += ClickHouseDataType.DateTime64.getByteLength();
                    }
                    column.scale = Integer.parseInt(column.parameters.get(0));
                    column.timeZone = TimeZone.getTimeZone(column.parameters.get(1).replace("'", ""));
                    column.template = ClickHouseOffsetDateTimeValue.ofNull(column.scale, column.timeZone);
                    break;
                }
                if (size != 1) break;
                if (!column.nullable) {
                    column.estimatedByteLength += ClickHouseDataType.DateTime32.getByteLength();
                }
                column.timeZone = TimeZone.getTimeZone(column.parameters.get(0).replace("'", ""));
                column.template = ClickHouseOffsetDateTimeValue.ofNull(column.scale, column.timeZone);
                break;
            }
            case DateTime32: {
                if (size <= 0) break;
                column.timeZone = TimeZone.getTimeZone(column.parameters.get(0).replace("'", ""));
                column.template = ClickHouseOffsetDateTimeValue.ofNull(column.scale, column.timeZone);
                break;
            }
            case DateTime64: {
                if (size > 0) {
                    column.scale = Integer.parseInt(column.parameters.get(0));
                }
                if (size <= 1) break;
                column.timeZone = TimeZone.getTimeZone(column.parameters.get(1).replace("'", ""));
                column.template = ClickHouseOffsetDateTimeValue.ofNull(column.scale, column.timeZone);
                break;
            }
            case Decimal: {
                if (size >= 2) {
                    column.precision = Integer.parseInt(column.parameters.get(0));
                    column.scale = Integer.parseInt(column.parameters.get(1));
                    if (!column.nullable) {
                        column.estimatedByteLength = column.precision > ClickHouseDataType.Decimal128.getMaxScale() ? (column.estimatedByteLength += ClickHouseDataType.Decimal256.getByteLength()) : (column.precision > ClickHouseDataType.Decimal64.getMaxScale() ? (column.estimatedByteLength += ClickHouseDataType.Decimal128.getByteLength()) : (column.precision > ClickHouseDataType.Decimal32.getMaxScale() ? (column.estimatedByteLength += ClickHouseDataType.Decimal64.getByteLength()) : (column.estimatedByteLength += ClickHouseDataType.Decimal32.getByteLength())));
                    }
                }
                column.template = ClickHouseBigDecimalValue.ofNull();
                break;
            }
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                if (size > 0) {
                    column.scale = Integer.parseInt(column.parameters.get(0));
                }
                column.template = ClickHouseBigDecimalValue.ofNull();
                break;
            }
            case IPv4: {
                column.template = ClickHouseIpv4Value.ofNull();
                break;
            }
            case IPv6: {
                column.template = ClickHouseIpv6Value.ofNull();
                break;
            }
            case FixedString: {
                if (size > 0) {
                    column.precision = Integer.parseInt(column.parameters.get(0));
                    if (!column.nullable) {
                        column.estimatedByteLength += column.precision;
                    }
                }
                column.template = ClickHouseStringValue.ofNull();
                break;
            }
            case Object: 
            case JSON: 
            case String: {
                column.fixedByteLength = false;
                if (!column.nullable) {
                    ++column.estimatedByteLength;
                }
                column.template = ClickHouseStringValue.ofNull();
                break;
            }
            case UUID: {
                column.template = ClickHouseUuidValue.ofNull();
                break;
            }
            case Point: {
                column.template = ClickHouseGeoPointValue.ofOrigin();
                break;
            }
            case Ring: {
                column.template = ClickHouseGeoRingValue.ofEmpty();
                break;
            }
            case Polygon: {
                column.template = ClickHouseGeoPolygonValue.ofEmpty();
                break;
            }
            case MultiPolygon: {
                column.template = ClickHouseGeoMultiPolygonValue.ofEmpty();
                break;
            }
            case Nested: {
                column.template = ClickHouseNestedValue.ofEmpty(column.nested);
                break;
            }
            case Tuple: {
                column.template = ClickHouseTupleValue.of(new Object[0]);
                break;
            }
            case Nothing: {
                column.template = ClickHouseEmptyValue.INSTANCE;
                break;
            }
        }
        return column;
    }

    protected static int readColumn(String args, int startIndex, int len, String name, List<ClickHouseColumn> list) {
        List<ClickHouseColumn> nestedColumns;
        int index;
        String matchedKeyword;
        int index2;
        ClickHouseColumn column = null;
        StringBuilder builder = new StringBuilder();
        int brackets = 0;
        boolean nullable = false;
        boolean lowCardinality = false;
        int i = startIndex;
        boolean fixedLength = true;
        int estimatedLength = 0;
        if (args.startsWith(KEYWORD_LOW_CARDINALITY, i)) {
            lowCardinality = true;
            index2 = args.indexOf(40, i + KEYWORD_LOW_CARDINALITY.length());
            if (index2 < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = index2 + 1;
            ++brackets;
        }
        if (args.startsWith(KEYWORD_NULLABLE, i)) {
            nullable = true;
            index2 = args.indexOf(40, i + KEYWORD_NULLABLE.length());
            if (index2 < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = index2 + 1;
            ++brackets;
        }
        if (args.startsWith(matchedKeyword = KEYWORD_AGGREGATE_FUNCTION, i) || args.startsWith(matchedKeyword = KEYWORD_SIMPLE_AGGREGATE_FUNCTION, i)) {
            index = args.indexOf(40, i + matchedKeyword.length());
            if (index < i) {
                throw new IllegalArgumentException("Missing function parameters");
            }
            LinkedList<String> params = new LinkedList<String>();
            i = ClickHouseUtils.readParameters(args, index, len, params);
            ClickHouseAggregateFunction aggFunc = null;
            boolean isFirst = true;
            LinkedList<ClickHouseColumn> nestedColumns2 = new LinkedList<ClickHouseColumn>();
            for (String p : params) {
                if (isFirst) {
                    if (matchedKeyword == KEYWORD_AGGREGATE_FUNCTION) {
                        int pIndex = p.indexOf(40);
                        aggFunc = ClickHouseAggregateFunction.of(pIndex > 0 ? p.substring(0, pIndex) : p);
                    }
                    isFirst = false;
                    continue;
                }
                nestedColumns2.add(ClickHouseColumn.of("", p));
            }
            column = new ClickHouseColumn(ClickHouseDataType.valueOf(matchedKeyword), name, args.substring(startIndex, i), nullable, lowCardinality, params, nestedColumns2);
            column.aggFuncType = aggFunc;
            fixedLength = false;
            ++estimatedLength;
        } else if (args.startsWith(KEYWORD_ARRAY, i)) {
            index = args.indexOf(40, i + KEYWORD_ARRAY.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(');
            nestedColumns = new LinkedList<ClickHouseColumn>();
            ClickHouseColumn.readColumn(args, index + 1, endIndex - 1, "", nestedColumns);
            if (nestedColumns.size() != 1) {
                throw new IllegalArgumentException("Array can have one and only one nested column, but we got: " + nestedColumns.size());
            }
            column = new ClickHouseColumn(ClickHouseDataType.Array, name, args.substring(startIndex, endIndex), nullable, lowCardinality, null, nestedColumns);
            i = endIndex;
            fixedLength = false;
            ++estimatedLength;
        } else if (args.startsWith(KEYWORD_MAP, i)) {
            char c;
            index = args.indexOf(40, i + KEYWORD_MAP.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(');
            nestedColumns = new LinkedList();
            for (i = index + 1; i < endIndex && (c = args.charAt(i)) != ')'; ++i) {
                if (c == ',' || Character.isWhitespace(c)) continue;
                i = ClickHouseColumn.readColumn(args, i, endIndex, "", nestedColumns) - 1;
            }
            if (nestedColumns.size() != 2) {
                throw new IllegalArgumentException("Map should have two nested columns(key and value), but we got: " + nestedColumns.size());
            }
            column = new ClickHouseColumn(ClickHouseDataType.Map, name, args.substring(startIndex, endIndex), nullable, lowCardinality, null, nestedColumns);
            i = endIndex;
            fixedLength = false;
            ++estimatedLength;
        } else if (args.startsWith(KEYWORD_NESTED, i)) {
            index = args.indexOf(40, i + KEYWORD_NESTED.length());
            if (index < i) {
                throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
            }
            i = ClickHouseUtils.skipBrackets(args, index, len, '(');
            String originalTypeName = args.substring(startIndex, i);
            nestedColumns = ClickHouseColumn.parse(args.substring(index + 1, i - 1));
            if (nestedColumns.isEmpty()) {
                throw new IllegalArgumentException("Nested should have at least one nested column");
            }
            column = new ClickHouseColumn(ClickHouseDataType.Nested, name, originalTypeName, nullable, lowCardinality, null, nestedColumns);
            fixedLength = false;
            ++estimatedLength;
        } else {
            matchedKeyword = KEYWORD_TUPLE;
            if (args.startsWith(matchedKeyword, i) || args.startsWith(matchedKeyword = KEYWORD_OBJECT, i)) {
                char c;
                index = args.indexOf(40, i + matchedKeyword.length());
                if (index < i) {
                    throw new IllegalArgumentException(ERROR_MISSING_NESTED_TYPE);
                }
                int endIndex = ClickHouseUtils.skipBrackets(args, index, len, '(') - 1;
                nestedColumns = new LinkedList();
                for (i = index + 1; i <= endIndex && (c = args.charAt(i)) != ')'; ++i) {
                    if (c == ',' || Character.isWhitespace(c)) continue;
                    i = ClickHouseColumn.readColumn(args, i, endIndex, "", nestedColumns);
                }
                if (nestedColumns.isEmpty()) {
                    throw new IllegalArgumentException("Tuple should have at least one nested column");
                }
                column = new ClickHouseColumn(ClickHouseDataType.valueOf(matchedKeyword), name, args.substring(startIndex, endIndex + 1), nullable, lowCardinality, null, nestedColumns);
                for (ClickHouseColumn n : nestedColumns) {
                    estimatedLength += n.estimatedByteLength;
                    if (n.fixedByteLength) continue;
                    fixedLength = false;
                }
            }
        }
        if (column == null) {
            LinkedList<String> params = new LinkedList<String>();
            for (i = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder); i < len; ++i) {
                char ch = args.charAt(i);
                if (ch == '(') {
                    i = ClickHouseUtils.readParameters(args, i, len, params) - 1;
                    continue;
                }
                if (ch == ')') {
                    if (brackets <= 0) break;
                    if (--brackets > 0) continue;
                    ++i;
                    break;
                }
                if (ch == ',') break;
                if (Character.isWhitespace(ch)) continue;
                StringBuilder sb = new StringBuilder();
                i = ClickHouseUtils.readNameOrQuotedString(args, i, len, sb);
                String modifier = sb.toString();
                String normalizedModifier = modifier.toUpperCase();
                sb.setLength(0);
                boolean startsWithNot = false;
                if ("NOT".equals(normalizedModifier)) {
                    startsWithNot = true;
                    i = ClickHouseUtils.readNameOrQuotedString(args, i, len, sb);
                    modifier = sb.toString();
                    normalizedModifier = modifier.toUpperCase();
                    sb.setLength(0);
                }
                if ("NULL".equals(normalizedModifier)) {
                    if (nullable) {
                        throw new IllegalArgumentException("Nullable and NULL cannot be used together");
                    }
                    nullable = !startsWithNot;
                    i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
                    break;
                }
                if (startsWithNot) {
                    throw new IllegalArgumentException("Expect keyword NULL after NOT");
                }
                if ("ALIAS".equals(normalizedModifier) || "CODEC".equals(normalizedModifier) || "DEFAULT".equals(normalizedModifier) || "MATERIALIZED".equals(normalizedModifier) || "TTL".equals(normalizedModifier)) {
                    i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
                    break;
                }
                if ((name == null || name.isEmpty()) && !ClickHouseDataType.mayStartWith(builder.toString(), normalizedModifier)) {
                    return ClickHouseColumn.readColumn(args, i - modifier.length(), len, builder.toString(), list);
                }
                builder.append(' ');
                builder.append(modifier);
                --i;
            }
            column = new ClickHouseColumn(ClickHouseDataType.of(builder.toString()), name, args.substring(startIndex, i), nullable, lowCardinality, params, null);
            builder.setLength(0);
        }
        if (nullable) {
            fixedLength = false;
            ++estimatedLength;
        } else if (column.dataType == ClickHouseDataType.FixedString) {
            fixedLength = true;
            estimatedLength = column.precision;
        } else if (column.dataType.getByteLength() == 0) {
            fixedLength = false;
        } else {
            estimatedLength += column.dataType.getByteLength();
        }
        column.fixedByteLength = fixedLength;
        column.estimatedByteLength = estimatedLength;
        list.add(ClickHouseColumn.update(column));
        return i;
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, int precision, int scale) {
        ClickHouseColumn column = new ClickHouseColumn(dataType, columnName, null, nullable, false, null, null);
        column.precision = precision;
        column.scale = scale;
        return column;
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, boolean lowCardinality, String ... parameters) {
        return ClickHouseColumn.update(new ClickHouseColumn(dataType, columnName, null, nullable, lowCardinality, Arrays.asList(parameters), null));
    }

    public static ClickHouseColumn of(String columnName, ClickHouseDataType dataType, boolean nullable, ClickHouseColumn ... nestedColumns) {
        return ClickHouseColumn.update(new ClickHouseColumn(dataType, columnName, null, nullable, false, null, Arrays.asList(nestedColumns)));
    }

    public static ClickHouseColumn of(String columnName, String columnType) {
        if (columnName == null || columnType == null) {
            throw new IllegalArgumentException("Non-null columnName and columnType are required");
        }
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(1);
        ClickHouseColumn.readColumn(columnType, 0, columnType.length(), columnName, list);
        if (list.size() != 1) {
            throw new IllegalArgumentException("Failed to parse given column");
        }
        return (ClickHouseColumn)list.get(0);
    }

    public static List<ClickHouseColumn> parse(String args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyList();
        }
        String name = null;
        ClickHouseColumn column = null;
        LinkedList<ClickHouseColumn> list = new LinkedList<ClickHouseColumn>();
        StringBuilder builder = new StringBuilder();
        int len = args.length();
        for (int i = 0; i < len; ++i) {
            char ch = args.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (name == null) {
                i = ClickHouseUtils.readNameOrQuotedString(args, i, len, builder) - 1;
                name = builder.toString();
                builder.setLength(0);
                continue;
            }
            if (column == null) {
                LinkedList<ClickHouseColumn> colList = new LinkedList<ClickHouseColumn>();
                i = ClickHouseColumn.readColumn(args, i, len, name, colList) - 1;
                column = colList.getFirst();
                list.add(column);
                continue;
            }
            i = ClickHouseUtils.skipContentsUntil(args, i, len, ',') - 1;
            name = null;
            column = null;
        }
        ArrayList<ClickHouseColumn> c = new ArrayList<ClickHouseColumn>(list.size());
        for (ClickHouseColumn cc : list) {
            c.add(cc);
        }
        return Collections.unmodifiableList(c);
    }

    private ClickHouseColumn(ClickHouseDataType dataType, String columnName, String originalTypeName, boolean nullable, boolean lowCardinality, List<String> parameters, List<ClickHouseColumn> nestedColumns) {
        ArrayList<Object> list;
        this.dataType = ClickHouseChecker.nonNull(dataType, "dataType");
        this.columnCount = 1;
        this.columnIndex = 0;
        this.columnName = columnName == null ? "" : columnName;
        this.originalTypeName = originalTypeName == null ? dataType.name() : originalTypeName;
        this.nullable = nullable;
        this.lowCardinality = lowCardinality;
        boolean bl = this.hasDefault = originalTypeName != null && originalTypeName.toUpperCase().contains("DEFAULT");
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = Collections.emptyList();
        } else {
            list = new ArrayList<Object>(parameters.size());
            list.addAll(parameters);
            this.parameters = Collections.unmodifiableList(list);
        }
        if (nestedColumns == null || nestedColumns.isEmpty()) {
            this.nested = Collections.emptyList();
        } else {
            list = new ArrayList(nestedColumns.size());
            list.addAll(nestedColumns);
            this.nested = Collections.unmodifiableList(list);
        }
        this.fixedByteLength = false;
        this.estimatedByteLength = 0;
    }

    protected void setColumnIndex(int index, int count) {
        int n = this.columnCount = count < 2 ? 1 : count;
        this.columnIndex = index < 1 ? 0 : (index < count ? index : count - 1);
    }

    public boolean isAggregateFunction() {
        return this.dataType == ClickHouseDataType.AggregateFunction;
    }

    public boolean isArray() {
        return this.dataType == ClickHouseDataType.Array;
    }

    public boolean isEnum() {
        return this.dataType == ClickHouseDataType.Enum8 || this.dataType == ClickHouseDataType.Enum16;
    }

    public boolean isFixedLength() {
        return this.fixedByteLength;
    }

    public boolean isMap() {
        return this.dataType == ClickHouseDataType.Map;
    }

    public boolean isNested() {
        return this.dataType == ClickHouseDataType.Nested;
    }

    public boolean isTuple() {
        return this.dataType == ClickHouseDataType.Tuple;
    }

    public boolean isNestedType() {
        return this.dataType.isNested();
    }

    public int getArrayNestedLevel() {
        return this.arrayLevel;
    }

    public ClickHouseColumn getArrayBaseColumn() {
        return this.arrayBaseColumn;
    }

    public ClickHouseDataType getDataType() {
        return this.dataType;
    }

    public Class<?> getObjectClass(ClickHouseDataConfig config) {
        if (this.timeZone != null) {
            return OffsetDateTime.class;
        }
        return config != null && config.isWidenUnsignedTypes() ? this.dataType.getWiderObjectClass() : this.dataType.getObjectClass();
    }

    public Class<?> getObjectClassForArray(ClickHouseDataConfig config) {
        Class<Object> javaClass;
        Class<?> clazz = javaClass = config.isUseObjectsInArray() || this.isNullable() ? this.getObjectClass(config) : this.getPrimitiveClass(config);
        if (config.isUseBinaryString() && javaClass == String.class) {
            javaClass = Object.class;
        }
        return javaClass;
    }

    public Class<?> getPrimitiveClass(ClickHouseDataConfig config) {
        if (this.timeZone != null) {
            return OffsetDateTime.class;
        }
        return config != null && config.isWidenUnsignedTypes() ? this.dataType.getWiderPrimitiveClass() : this.dataType.getPrimitiveClass();
    }

    public ClickHouseEnum getEnumConstants() {
        return this.enumConstants;
    }

    public int getEstimatedLength() {
        return this.estimatedByteLength;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getOriginalTypeName() {
        return this.originalTypeName;
    }

    public boolean isFirstColumn() {
        return this.columnCount == 0;
    }

    public boolean isLastColumn() {
        return this.columnCount - this.columnIndex == 1;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public boolean isLowCardinality() {
        return !this.lowCardinalityDisabled && this.lowCardinality;
    }

    public boolean isLowCardinalityDisabled() {
        return this.lowCardinalityDisabled;
    }

    public void disableLowCardinality() {
        this.lowCardinalityDisabled = true;
    }

    public boolean hasTimeZone() {
        return this.timeZone != null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public TimeZone getTimeZoneOrDefault(TimeZone defaultTz) {
        return this.timeZone != null ? this.timeZone : defaultTz;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean hasNestedColumn() {
        return !this.nested.isEmpty();
    }

    public List<ClickHouseColumn> getNestedColumns() {
        return this.nested;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public ClickHouseColumn getKeyInfo() {
        return this.dataType == ClickHouseDataType.Map && this.nested.size() == 2 ? this.nested.get(0) : null;
    }

    public ClickHouseColumn getValueInfo() {
        return this.dataType == ClickHouseDataType.Map && this.nested.size() == 2 ? this.nested.get(1) : null;
    }

    public String getFunction() {
        return this.dataType == ClickHouseDataType.AggregateFunction ? this.parameters.get(0) : null;
    }

    public ClickHouseAggregateFunction getAggregateFunction() {
        return this.aggFuncType;
    }

    public ClickHouseArraySequence newArrayValue(ClickHouseDataConfig config) {
        ClickHouseObjectValue value;
        int level = this.arrayLevel;
        if (level < 1 || this.arrayBaseColumn == null || this.arrayBaseColumn.nullable || config.isUseObjectsInArray()) {
            value = this.arrayBaseColumn == null ? ClickHouseArrayValue.ofEmpty() : ClickHouseArrayValue.ofEmpty(this.arrayBaseColumn.getObjectClass(config));
        } else {
            if (level > 255) {
                throw new IllegalArgumentException("Nested level of array should be less than or equal to 255 but we got: " + level);
            }
            if (level > 1) {
                value = ClickHouseArrayValue.of((Object[])Array.newInstance(this.arrayBaseColumn.getPrimitiveClass(config), new int[level]));
            } else {
                switch (this.arrayBaseColumn.dataType) {
                    case Bool: {
                        value = ClickHouseBoolArrayValue.ofEmpty();
                        break;
                    }
                    case Int8: {
                        value = ClickHouseByteArrayValue.ofEmpty();
                        break;
                    }
                    case UInt8: {
                        value = config.isWidenUnsignedTypes() ? ClickHouseShortArrayValue.ofEmpty() : ClickHouseByteArrayValue.ofUnsignedEmpty();
                        break;
                    }
                    case Int16: {
                        value = ClickHouseShortArrayValue.ofEmpty();
                        break;
                    }
                    case UInt16: {
                        value = config.isWidenUnsignedTypes() ? ClickHouseIntArrayValue.ofEmpty() : ClickHouseShortArrayValue.ofUnsignedEmpty();
                        break;
                    }
                    case Int32: {
                        value = ClickHouseIntArrayValue.ofEmpty();
                        break;
                    }
                    case UInt32: {
                        value = config.isWidenUnsignedTypes() ? ClickHouseLongArrayValue.ofEmpty() : ClickHouseIntArrayValue.ofUnsignedEmpty();
                        break;
                    }
                    case Int64: {
                        value = ClickHouseLongArrayValue.ofEmpty();
                        break;
                    }
                    case UInt64: {
                        value = ClickHouseLongArrayValue.ofUnsignedEmpty();
                        break;
                    }
                    case Float32: {
                        value = ClickHouseFloatArrayValue.ofEmpty();
                        break;
                    }
                    case Float64: {
                        value = ClickHouseDoubleArrayValue.ofEmpty();
                        break;
                    }
                    default: {
                        value = ClickHouseArrayValue.ofEmpty(this.arrayBaseColumn.getObjectClass(config));
                    }
                }
            }
        }
        return value;
    }

    public ClickHouseValue newValue(ClickHouseDataConfig config) {
        if (this.template != null) {
            return this.template.copy();
        }
        ClickHouseValue value = null;
        block0 : switch (this.dataType) {
            case UInt8: {
                value = config.isWidenUnsignedTypes() ? ClickHouseShortValue.ofNull() : ClickHouseByteValue.ofUnsignedNull();
                break;
            }
            case UInt16: {
                value = config.isWidenUnsignedTypes() ? ClickHouseIntegerValue.ofNull() : ClickHouseShortValue.ofUnsignedNull();
                break;
            }
            case UInt32: {
                value = config.isWidenUnsignedTypes() ? ClickHouseLongValue.ofNull() : ClickHouseIntegerValue.ofUnsignedNull();
                break;
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                value = ClickHouseDateTimeValue.ofNull(this.getScale(), config.getUseTimeZone());
                break;
            }
            case SimpleAggregateFunction: {
                value = this.nested.get(0).newValue(config);
                break;
            }
            case AggregateFunction: {
                value = ClickHouseEmptyValue.INSTANCE;
                switch (this.aggFuncType) {
                    case any: {
                        value = this.nested.get(0).newValue(config);
                        break block0;
                    }
                    case groupBitmap: {
                        value = ClickHouseBitmapValue.ofEmpty(this.nested.get(0).getDataType());
                        break block0;
                    }
                }
                break;
            }
            case Array: {
                value = this.newArrayValue(config);
                break;
            }
            case Map: {
                value = ClickHouseMapValue.ofEmpty(this.getKeyInfo().getObjectClass(config), this.getValueInfo().getObjectClass(config));
                break;
            }
        }
        if (value == null) {
            throw new IllegalArgumentException("Unsupported data type: " + this.dataType.name());
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arrayBaseColumn == null ? 0 : this.arrayBaseColumn.hashCode());
        result = 31 * result + (this.aggFuncType == null ? 0 : this.aggFuncType.hashCode());
        result = 31 * result + this.arrayLevel;
        result = 31 * result + this.columnCount;
        result = 31 * result + this.columnIndex;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.originalTypeName == null ? 0 : this.originalTypeName.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.lowCardinality ? 1231 : 1237);
        result = 31 * result + (this.nested == null ? 0 : this.nested.hashCode());
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
        result = 31 * result + (this.fixedByteLength ? 1231 : 1237);
        result = 31 * result + this.estimatedByteLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseColumn other = (ClickHouseColumn)obj;
        return Objects.equals(this.arrayBaseColumn, other.arrayBaseColumn) && this.aggFuncType == other.aggFuncType && this.arrayLevel == other.arrayLevel && this.columnCount == other.columnCount && this.columnIndex == other.columnIndex && Objects.equals(this.columnName, other.columnName) && this.dataType == other.dataType && this.lowCardinality == other.lowCardinality && Objects.equals(this.nested, other.nested) && this.nullable == other.nullable && Objects.equals(this.originalTypeName, other.originalTypeName) && Objects.equals(this.parameters, other.parameters) && this.precision == other.precision && this.scale == other.scale && Objects.equals(this.timeZone, other.timeZone) && this.fixedByteLength == other.fixedByteLength && this.estimatedByteLength == other.estimatedByteLength;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.columnName == null || this.columnName.isEmpty()) {
            builder.append("column").append(this.columnIndex);
        } else {
            builder.append(this.columnName);
        }
        return builder.append(' ').append(this.originalTypeName).toString();
    }
}

