/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseResponseSummary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ClickHouseResponse
extends AutoCloseable,
Serializable {
    public static final ClickHouseResponse EMPTY = new ClickHouseResponse(){

        @Override
        public List<ClickHouseColumn> getColumns() {
            return Collections.emptyList();
        }

        @Override
        public ClickHouseResponseSummary getSummary() {
            return ClickHouseResponseSummary.EMPTY;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public Iterable<ClickHouseRecord> records() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isClosed() {
            return false;
        }
    };

    public List<ClickHouseColumn> getColumns();

    public ClickHouseResponseSummary getSummary();

    public InputStream getInputStream();

    default public ClickHouseRecord firstRecord() {
        return this.records().iterator().next();
    }

    public Iterable<ClickHouseRecord> records();

    default public void pipe(OutputStream output, int bufferSize) throws IOException {
        ClickHouseChecker.nonNull(output, "output");
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        int counter = 0;
        while ((counter = this.getInputStream().read(buffer, 0, bufferSize)) >= 0) {
            output.write(buffer, 0, counter);
        }
    }

    default public Stream<ClickHouseRecord> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.records().iterator(), 1296), false);
    }

    @Override
    public void close();

    public boolean isClosed();
}

