/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseTupleValue
extends ClickHouseObjectValue<List<Object>> {
    public static ClickHouseTupleValue of(Object ... value) {
        return ClickHouseTupleValue.of(null, Arrays.asList(value));
    }

    public static ClickHouseTupleValue of(ClickHouseValue ref, List<Object> value) {
        return ref instanceof ClickHouseTupleValue ? (ClickHouseTupleValue)((ClickHouseTupleValue)ref).set(value) : new ClickHouseTupleValue(value);
    }

    protected ClickHouseTupleValue(List<Object> value) {
        super(value);
    }

    protected Object getSingleValue() {
        List value = (List)this.getValue();
        if (value == null || value.size() != 1) {
            throw new UnsupportedOperationException("Only singleton tuple supports type conversion");
        }
        return value.iterator().next();
    }

    @Override
    public ClickHouseTupleValue copy(boolean deep) {
        if (!deep || this.isNullOrEmpty()) {
            return new ClickHouseTupleValue((List)this.getValue());
        }
        return new ClickHouseTupleValue((List<Object>)new ArrayList<Object>((Collection)this.getValue()));
    }

    @Override
    public Object[] asArray() {
        if (this.isNullOrEmpty()) {
            return ClickHouseValues.EMPTY_OBJECT_ARRAY;
        }
        return ((List)this.getValue()).toArray(new Object[0]);
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        if (this.isNullOrEmpty()) {
            return ClickHouseValues.EMPTY_OBJECT_ARRAY;
        }
        List value = (List)this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), value.size());
        int index = 0;
        for (Object v : value) {
            array[index++] = clazz.cast(v);
        }
        return array;
    }

    @Override
    public Map<Object, Object> asMap() {
        if (this.isNullOrEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int index = 1;
        for (Object v : (List)this.getValue()) {
            map.put(index++, v);
        }
        return map;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (this.isNullOrEmpty()) {
            return Collections.emptyMap();
        }
        if (Integer.class != keyClass || valueClass == null) {
            throw new IllegalArgumentException("Key class must be Integer and value class cannot be null");
        }
        LinkedHashMap<Integer, V> map = new LinkedHashMap<Integer, V>();
        int index = 1;
        for (Object v : (List)this.getValue()) {
            map.put(index++, valueClass.cast(v));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.deepToString(this.asArray());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public List<Object> asTuple() {
        return (List)this.getValue();
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((List)this.getValue()).isEmpty();
    }

    @Override
    public ClickHouseTupleValue resetToDefault() {
        this.set(Collections.emptyList());
        return this;
    }

    @Override
    public ClickHouseTupleValue resetToNullOrEmpty() {
        return this.resetToDefault();
    }

    @Override
    public String toSqlExpression() {
        StringBuilder builder = new StringBuilder().append('(');
        for (Object v : (List)this.getValue()) {
            builder.append(ClickHouseValues.convertToSqlExpression(v)).append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    @Override
    public ClickHouseTupleValue update(boolean[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Byte> v = new ArrayList<Byte>(value.length);
        for (boolean b : value) {
            v.add(b ? (byte)1 : 0);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(char[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Integer> v = new ArrayList<Integer>(value.length);
        for (char c : value) {
            v.add(Integer.valueOf(c));
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(byte value) {
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(byte[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Byte> v = new ArrayList<Byte>(value.length);
        for (byte b : value) {
            v.add(b);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(short value) {
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(short[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Short> v = new ArrayList<Short>(value.length);
        for (short s : value) {
            v.add(s);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(int value) {
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(int[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Integer> v = new ArrayList<Integer>(value.length);
        for (int i : value) {
            v.add(i);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(long value) {
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(long[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Long> v = new ArrayList<Long>(value.length);
        for (long l : value) {
            v.add(l);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(float value) {
        this.set(Collections.singletonList(Float.valueOf(value)));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(float[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Float> v = new ArrayList<Float>(value.length);
        for (float f : value) {
            v.add(Float.valueOf(f));
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(double value) {
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(double[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList<Double> v = new ArrayList<Double>(value.length);
        for (double d : value) {
            v.add(d);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Enum<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(LocalDate value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(LocalTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(LocalDateTime value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList v = new ArrayList(size);
        for (Object o : value) {
            v.add(o);
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Enumeration<?> value) {
        if (value == null) {
            this.set(Collections.emptyList());
            return this;
        }
        LinkedList v = new LinkedList();
        while (value.hasMoreElements()) {
            v.add(value.nextElement());
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        ArrayList v = new ArrayList(size);
        for (Map.Entry<?, ?> e : value.entrySet()) {
            v.add(e.getValue());
        }
        this.set(v);
        return this;
    }

    @Override
    public ClickHouseTupleValue update(String value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        this.set(Collections.singletonList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(ClickHouseValue value) {
        if (value == null) {
            this.set(Collections.emptyList());
            return this;
        }
        this.set(value.asTuple());
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Object[] value) {
        if (value == null || value.length == 0) {
            this.set(Collections.emptyList());
            return this;
        }
        this.set(Arrays.asList(value));
        return this;
    }

    @Override
    public ClickHouseTupleValue update(Object value) {
        if (value instanceof List) {
            this.set((List)value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        List v2;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        List v1 = (List)this.getValue();
        return v1 == (v2 = (List)((ClickHouseTupleValue)obj).getValue()) || v1 != null && v1.equals(v2);
    }

    @Override
    public int hashCode() {
        List v = (List)this.getValue();
        return Arrays.deepHashCode(v == null ? null : v.toArray(new Object[v.size()]));
    }
}

