/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeManager;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseThreadFactory;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseClientBuilder {
    static final ExecutorService defaultExecutor;
    static final ScheduledExecutorService defaultScheduler;
    protected boolean agent = true;
    protected ClickHouseConfig config = null;
    protected ClickHouseCredentials credentials;
    protected Object metricRegistry = null;
    protected ClickHouseNodeSelector nodeSelector = null;
    protected final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();

    static ServiceLoader<ClickHouseClient> loadClients() {
        return ServiceLoader.load(ClickHouseClient.class, ClickHouseClientBuilder.class.getClassLoader());
    }

    protected ClickHouseClientBuilder() {
    }

    protected void resetConfig() {
        if (this.config != null) {
            this.config = null;
        }
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            this.config = new ClickHouseConfig(this.options, this.credentials, this.nodeSelector, this.metricRegistry);
        }
        return this.config;
    }

    public ClickHouseClient build() {
        ClickHouseClient client = null;
        boolean noSelector = this.nodeSelector == null || this.nodeSelector == ClickHouseNodeSelector.EMPTY;
        int counter = 0;
        ClickHouseConfig conf = this.getConfig();
        for (ClickHouseClient c : ClickHouseClientBuilder.loadClients()) {
            c.init(conf);
            ++counter;
            if (!noSelector && !this.nodeSelector.match(c)) continue;
            client = c;
            break;
        }
        if (client == null) {
            throw new IllegalStateException(ClickHouseUtils.format("No suitable ClickHouse client(out of %d) found in classpath for %s.", counter, this.nodeSelector));
        }
        return this.agent ? new Agent(client) : client;
    }

    public ClickHouseClientBuilder agent(boolean agent) {
        this.agent = agent;
        return this;
    }

    public ClickHouseClientBuilder config(ClickHouseConfig config) {
        this.config = config;
        this.credentials = config.getDefaultCredentials();
        this.metricRegistry = config.getMetricRegistry().orElse(null);
        this.nodeSelector = config.getNodeSelector();
        this.options.putAll(config.getAllOptions());
        return this;
    }

    public ClickHouseClientBuilder option(ClickHouseOption option, Serializable value) {
        if (option == null || value == null) {
            throw new IllegalArgumentException("Non-null option and value are required");
        }
        Serializable oldValue = this.options.put(option, value);
        if (oldValue == null || !value.equals(oldValue)) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder removeOption(ClickHouseOption option) {
        Serializable value = this.options.remove(ClickHouseChecker.nonNull(option, "option"));
        if (value != null) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder options(Map<ClickHouseOption, Serializable> options) {
        if (options != null && !options.isEmpty()) {
            this.options.putAll(options);
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder defaultCredentials(ClickHouseCredentials credentials) {
        if (!Objects.equals(this.credentials, credentials)) {
            this.credentials = credentials;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder nodeSelector(ClickHouseNodeSelector nodeSelector) {
        if (!ClickHouseChecker.nonNull(nodeSelector, "nodeSelector").equals(this.nodeSelector)) {
            this.nodeSelector = nodeSelector;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder metricRegistry(Object metricRegistry) {
        if (!Objects.equals(this.metricRegistry, metricRegistry)) {
            this.metricRegistry = metricRegistry;
            this.resetConfig();
        }
        return this;
    }

    static {
        int maxSchedulers = (Integer)ClickHouseDefaults.MAX_SCHEDULER_THREADS.getEffectiveDefaultValue();
        int maxThreads = (Integer)ClickHouseDefaults.MAX_THREADS.getEffectiveDefaultValue();
        int maxRequests = (Integer)ClickHouseDefaults.MAX_REQUESTS.getEffectiveDefaultValue();
        long keepAliveTimeoutMs = (Long)ClickHouseDefaults.THREAD_KEEPALIVE_TIMEOUT.getEffectiveDefaultValue();
        if (maxThreads <= 0) {
            maxThreads = Runtime.getRuntime().availableProcessors();
        }
        if (maxSchedulers <= 0) {
            maxSchedulers = Runtime.getRuntime().availableProcessors();
        } else if (maxSchedulers > maxThreads) {
            maxSchedulers = maxThreads;
        }
        if (maxRequests <= 0) {
            maxRequests = 0;
        }
        String prefix = "ClickHouseClientWorker";
        defaultExecutor = ClickHouseUtils.newThreadPool(prefix, maxThreads, maxThreads * 2, maxRequests, keepAliveTimeoutMs, false);
        prefix = "ClickHouseClientScheduler";
        defaultScheduler = maxSchedulers == 1 ? Executors.newSingleThreadScheduledExecutor(new ClickHouseThreadFactory(prefix)) : Executors.newScheduledThreadPool(maxSchedulers, new ClickHouseThreadFactory(prefix));
    }

    static final class Agent
    implements ClickHouseClient {
        private static final Logger log = LoggerFactory.getLogger(Agent.class);
        private final AtomicReference<ClickHouseClient> client;

        Agent(ClickHouseClient client) {
            this.client = new AtomicReference<ClickHouseClient>(client != null ? client : DummyClient.INSTANCE);
        }

        ClickHouseClient getClient() {
            return this.client.get();
        }

        boolean changeClient(ClickHouseClient currentClient, ClickHouseClient newClient) {
            boolean changed = this.client.compareAndSet(currentClient, newClient);
            try {
                if (changed) {
                    currentClient.close();
                } else {
                    newClient.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClickHouseResponse failover(ClickHouseRequest<?> sealedRequest, Throwable cause, int times) {
            for (int i = 1; i <= times; ++i) {
                block11: {
                    ClickHouseNode next;
                    log.debug((Object)"Failover %d of %d due to: %s", i, times, cause.getMessage());
                    ClickHouseNode current = sealedRequest.getServer();
                    ClickHouseNodeManager manager = current.manager.get();
                    if (manager == null || (next = manager.suggestNode(current, cause)) == current) break;
                    current.update(ClickHouseNode.Status.FAULTY);
                    next = sealedRequest.changeServer(current, next);
                    if (next == current) break;
                    log.info((Object)"Switching node from %s to %s due to: %s", current, next, cause.getMessage());
                    ClickHouseProtocol protocol = next.getProtocol();
                    ClickHouseClient currentClient = this.client.get();
                    if (!currentClient.accept(protocol)) {
                        boolean changed;
                        ClickHouseClient newClient = null;
                        try {
                            newClient = ClickHouseClient.builder().agent(false).config(new ClickHouseConfig(currentClient.getConfig(), next.config)).nodeSelector(ClickHouseNodeSelector.of(protocol, new ClickHouseProtocol[0])).build();
                            if (newClient == null) break block11;
                            changed = this.changeClient(currentClient, newClient);
                        }
                        catch (Exception e) {
                            boolean changed2;
                            try {
                                cause = e;
                                if (newClient == null) continue;
                                changed2 = this.changeClient(currentClient, newClient);
                            }
                            catch (Throwable throwable) {
                                if (newClient != null) {
                                    boolean changed3 = this.changeClient(currentClient, newClient);
                                    log.debug((Object)"Switching client from %s to %s: %s", currentClient, newClient, changed3);
                                    if (changed3) {
                                        sealedRequest.resetCache();
                                    }
                                }
                                throw throwable;
                            }
                            log.debug((Object)"Switching client from %s to %s: %s", currentClient, newClient, changed2);
                            if (!changed2) continue;
                            sealedRequest.resetCache();
                            continue;
                        }
                        log.debug((Object)"Switching client from %s to %s: %s", currentClient, newClient, changed);
                        if (changed) {
                            sealedRequest.resetCache();
                        }
                    }
                }
                try {
                    return this.sendOnce(sealedRequest);
                }
                catch (Exception exp) {
                    cause = exp.getCause();
                    if (cause != null) continue;
                    cause = exp;
                }
            }
            throw new CompletionException(cause);
        }

        ClickHouseResponse retry(ClickHouseRequest<?> sealedRequest, Throwable cause, int times) {
            for (int i = 1; i <= times; ++i) {
                log.debug((Object)"Retry %d of %d due to: %s", i, times, cause.getMessage());
                if (!(cause instanceof ClickHouseException) || ((ClickHouseException)cause).getErrorCode() != 210) continue;
                log.info((Object)"Retry request on %s due to connection issue", sealedRequest.getServer());
                try {
                    return this.sendOnce(sealedRequest);
                }
                catch (Exception exp) {
                    cause = exp.getCause();
                    if (cause != null) continue;
                    cause = exp;
                }
            }
            throw new CompletionException(cause);
        }

        ClickHouseResponse handle(ClickHouseRequest<?> sealedRequest, Throwable cause) {
            try {
                int times = sealedRequest.getConfig().getFailover();
                if (times > 0) {
                    return this.failover(sealedRequest, cause, times);
                }
                times = sealedRequest.getConfig().getRetry();
                if (times > 0) {
                    return this.retry(sealedRequest, cause, times);
                }
                throw new CompletionException(cause);
            }
            catch (CompletionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }

        ClickHouseResponse sendOnce(ClickHouseRequest<?> sealedRequest) {
            try {
                return this.getClient().execute(sealedRequest).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CancellationException("Execution was interrupted");
            }
            catch (ExecutionException e) {
                throw new CompletionException(e.getCause());
            }
        }

        ClickHouseResponse send(ClickHouseRequest<?> sealedRequest) {
            try {
                return this.sendOnce(sealedRequest);
            }
            catch (CompletionException e) {
                return this.handle(sealedRequest, e.getCause());
            }
        }

        @Override
        public boolean accept(ClickHouseProtocol protocol) {
            return this.client.get().accept(protocol);
        }

        @Override
        public Class<? extends ClickHouseOption> getOptionClass() {
            return this.client.get().getOptionClass();
        }

        @Override
        public void init(ClickHouseConfig config) {
            this.client.get().init(config);
        }

        @Override
        public boolean ping(ClickHouseNode server, int timeout) {
            return this.client.get().ping(server, timeout);
        }

        @Override
        public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
            ClickHouseRequest<?> sealedRequest = request.seal();
            return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause())) : CompletableFuture.completedFuture(this.send(sealedRequest));
        }

        @Override
        public ClickHouseConfig getConfig() {
            return this.client.get().getConfig();
        }

        @Override
        public void close() {
            this.client.get().close();
        }
    }

    static class DummyClient
    implements ClickHouseClient {
        static final ClickHouseConfig CONFIG = new ClickHouseConfig(new ClickHouseConfig[0]);
        static final DummyClient INSTANCE = new DummyClient();

        DummyClient() {
        }

        @Override
        public boolean accept(ClickHouseProtocol protocol) {
            return true;
        }

        @Override
        public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
            return CompletableFuture.completedFuture(ClickHouseResponse.EMPTY);
        }

        @Override
        public ClickHouseConfig getConfig() {
            return CONFIG;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean ping(ClickHouseNode server, int timeout) {
            return true;
        }
    }
}

