/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Enumeration;
import java.util.concurrent.Future;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

@State(value=Scope.Benchmark)
public class ServerState {
    private final String host = System.getProperty("dbHost", "127.0.0.1");
    private final String user = System.getProperty("dbUser", "default");
    private final String passwd = System.getProperty("dbPasswd", "");
    private final String db = System.getProperty("dbName", "system");
    private final String localIpAddress = ServerState.getLocalIpAddress();
    private GenericContainer<?> container = null;

    static String getLocalIpAddress() {
        String localIpAddress = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                if (i.isUp() && !i.isLoopback() && !i.isPointToPoint() && !i.isVirtual()) {
                    for (InterfaceAddress addr : i.getInterfaceAddresses()) {
                        InetAddress inetAddr = addr.getAddress();
                        if (!(inetAddr instanceof Inet4Address)) continue;
                        localIpAddress = inetAddr.getHostAddress();
                        break;
                    }
                }
                if (localIpAddress == null) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localIpAddress != null ? localIpAddress : "127.0.0.1";
    }

    @Setup(value=Level.Trial)
    public void doSetup() throws Exception {
        if (System.getProperty("dbHost") != null) {
            return;
        }
        String imageTag = System.getProperty("clickhouseVersion");
        imageTag = imageTag == null || (imageTag = imageTag.trim()).isEmpty() ? "" : ":" + imageTag;
        String imageNameWithTag = "clickhouse/clickhouse-server" + imageTag;
        this.container = new GenericContainer((Future)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)builder.from(imageNameWithTag)).run("echo '<clickhouse><listen_host>0.0.0.0</listen_host><http_port>8123</http_port><tcp_port>9000</tcp_port><mysql_port>9004</mysql_port><postgresql_port>9005</postgresql_port><interserver_http_port>9009</interserver_http_port><grpc_port>9100</grpc_port></clickhouse>' > /etc/clickhouse-server/config.d/custom.xml"))).withExposedPorts(new Integer[]{9100, 8123, 9004, 9000}).waitingFor(Wait.forHttp((String)"/ping").forPort(8123).forStatusCode(200).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)));
        this.container.start();
    }

    @TearDown(value=Level.Trial)
    public void doTearDown() throws Exception {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public String getHost() {
        return this.container != null ? this.localIpAddress : this.host;
    }

    public int getPort(int defaultPort) {
        return this.container != null ? this.container.getMappedPort(defaultPort) : defaultPort;
    }

    public String getUser() {
        return this.container != null ? "default" : this.user;
    }

    public String getPassword() {
        return this.container != null ? "" : this.passwd;
    }

    public String getDatabase() {
        return this.container != null ? "system" : this.db;
    }
}

