/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates.validators;

import com.clevertap.android.pushtemplates.TemplateRenderer;
import com.clevertap.android.pushtemplates.TemplateType;
import com.clevertap.android.pushtemplates.checkers.Checker;
import com.clevertap.android.pushtemplates.checkers.IntSizeChecker;
import com.clevertap.android.pushtemplates.checkers.JsonArraySizeChecker;
import com.clevertap.android.pushtemplates.checkers.ListEqualSizeChecker;
import com.clevertap.android.pushtemplates.checkers.ListSizeChecker;
import com.clevertap.android.pushtemplates.checkers.StringSizeChecker;
import com.clevertap.android.pushtemplates.validators.BackgroundValidator;
import com.clevertap.android.pushtemplates.validators.BasicTemplateValidator;
import com.clevertap.android.pushtemplates.validators.CarouselTemplateValidator;
import com.clevertap.android.pushtemplates.validators.ContentValidator;
import com.clevertap.android.pushtemplates.validators.FiveIconsTemplateValidator;
import com.clevertap.android.pushtemplates.validators.InputBoxTemplateValidator;
import com.clevertap.android.pushtemplates.validators.ProductDisplayTemplateValidator;
import com.clevertap.android.pushtemplates.validators.RatingTemplateValidator;
import com.clevertap.android.pushtemplates.validators.TimerTemplateValidator;
import com.clevertap.android.pushtemplates.validators.Validator;
import com.clevertap.android.pushtemplates.validators.ZeroBezelTemplateValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/pushtemplates/validators/ValidatorFactory;", "", "<init>", "()V", "Companion", "clevertap-pushtemplates_release"})
public final class ValidatorFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static Map<String, ? extends Checker<? extends Object>> keys;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00070\u00052\u0006\u0010\f\u001a\u00020\rH\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00070\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/clevertap/android/pushtemplates/validators/ValidatorFactory$Companion;", "", "<init>", "()V", "keys", "", "", "Lcom/clevertap/android/pushtemplates/checkers/Checker;", "getValidator", "Lcom/clevertap/android/pushtemplates/validators/Validator;", "templateType", "Lcom/clevertap/android/pushtemplates/TemplateType;", "templateRenderer", "Lcom/clevertap/android/pushtemplates/TemplateRenderer;", "createKeysMap", "clevertap-pushtemplates_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Validator getValidator(@NotNull TemplateType templateType, @NotNull TemplateRenderer templateRenderer) {
            Validator validator;
            Intrinsics.checkNotNullParameter((Object)((Object)templateType), (String)"templateType");
            Intrinsics.checkNotNullParameter((Object)templateRenderer, (String)"templateRenderer");
            keys = this.createKeysMap(templateRenderer);
            switch (WhenMappings.$EnumSwitchMapping$0[templateType.ordinal()]) {
                case 1: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new BasicTemplateValidator(new ContentValidator(map));
                    break;
                }
                case 2: 
                case 3: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new CarouselTemplateValidator(new BasicTemplateValidator(new ContentValidator(map)));
                    break;
                }
                case 4: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new RatingTemplateValidator(new BasicTemplateValidator(new ContentValidator(map)));
                    break;
                }
                case 5: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new FiveIconsTemplateValidator(new BackgroundValidator(map));
                    break;
                }
                case 6: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new ProductDisplayTemplateValidator(new BasicTemplateValidator(new ContentValidator(map)));
                    break;
                }
                case 7: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new ZeroBezelTemplateValidator(new ContentValidator(map));
                    break;
                }
                case 8: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new TimerTemplateValidator(new BasicTemplateValidator(new ContentValidator(map)));
                    break;
                }
                case 9: {
                    Map map = keys;
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"keys");
                        map = null;
                    }
                    validator = new InputBoxTemplateValidator(new ContentValidator(map));
                    break;
                }
                default: {
                    validator = null;
                }
            }
            return validator;
        }

        private final Map<String, Checker<? extends Object>> createKeysMap(TemplateRenderer templateRenderer) {
            HashMap hashMap = new HashMap();
            ((Map)hashMap).put("PT_TITLE", new StringSizeChecker(templateRenderer.getPt_title$clevertap_pushtemplates_release(), 0, "Title is missing or empty"));
            ((Map)hashMap).put("PT_MSG", new StringSizeChecker(templateRenderer.getPt_msg$clevertap_pushtemplates_release(), 0, "Message is missing or empty"));
            ((Map)hashMap).put("PT_BG", new StringSizeChecker(templateRenderer.getPt_bg$clevertap_pushtemplates_release(), 0, "Background colour is missing or empty"));
            ((Map)hashMap).put("PT_DEEPLINK_LIST", new ListSizeChecker((List<? extends Object>)templateRenderer.getDeepLinkList$clevertap_pushtemplates_release(), 1, "Deeplink is missing or empty"));
            ((Map)hashMap).put("PT_IMAGE_LIST", new ListSizeChecker((List<? extends Object>)templateRenderer.getImageList$clevertap_pushtemplates_release(), 3, "Three required images not present"));
            ((Map)hashMap).put("PT_RATING_DEFAULT_DL", new StringSizeChecker(templateRenderer.getPt_rating_default_dl$clevertap_pushtemplates_release(), 0, "Default deeplink is missing or empty"));
            ((Map)hashMap).put("PT_FIVE_DEEPLINK_LIST", new ListSizeChecker((List<? extends Object>)templateRenderer.getDeepLinkList$clevertap_pushtemplates_release(), 3, "Three required deeplinks not present"));
            ((Map)hashMap).put("PT_FIVE_IMAGE_LIST", new ListSizeChecker((List<? extends Object>)templateRenderer.getImageList$clevertap_pushtemplates_release(), 3, "Three required images not present"));
            ((Map)hashMap).put("PT_PRODUCT_THREE_IMAGE_LIST", new ListEqualSizeChecker((List<? extends Object>)templateRenderer.getImageList$clevertap_pushtemplates_release(), 3, "Only three images are required"));
            ((Map)hashMap).put("PT_THREE_DEEPLINK_LIST", new ListEqualSizeChecker((List<? extends Object>)templateRenderer.getDeepLinkList$clevertap_pushtemplates_release(), 3, "Three required deeplinks not present"));
            ((Map)hashMap).put("PT_BIG_TEXT_LIST", new ListEqualSizeChecker((List<? extends Object>)templateRenderer.getBigTextList$clevertap_pushtemplates_release(), 3, "Three required product titles not present"));
            ((Map)hashMap).put("PT_SMALL_TEXT_LIST", new ListEqualSizeChecker((List<? extends Object>)templateRenderer.getSmallTextList$clevertap_pushtemplates_release(), 3, "Three required product descriptions not present"));
            ((Map)hashMap).put("PT_PRODUCT_DISPLAY_ACTION", new StringSizeChecker(templateRenderer.getPt_product_display_action$clevertap_pushtemplates_release(), 0, "Button label is missing or empty"));
            ((Map)hashMap).put("PT_PRODUCT_DISPLAY_ACTION_CLR", new StringSizeChecker(templateRenderer.getPt_product_display_action_clr$clevertap_pushtemplates_release(), 0, "Button colour is missing or empty"));
            ((Map)hashMap).put("PT_BIG_IMG", new StringSizeChecker(templateRenderer.getPt_big_img$clevertap_pushtemplates_release(), 0, "Display Image is missing or empty"));
            ((Map)hashMap).put("PT_TIMER_THRESHOLD", new IntSizeChecker(templateRenderer.getPt_timer_threshold(), -1, "Timer threshold not defined"));
            ((Map)hashMap).put("PT_TIMER_END", new IntSizeChecker(templateRenderer.getPt_timer_end(), -1, "Not rendering notification Timer End value lesser than threshold (10 seconds) from current time"));
            ((Map)hashMap).put("PT_INPUT_FEEDBACK", new StringSizeChecker(templateRenderer.getPt_input_feedback(), 0, "Feedback Text or Actions is missing or empty"));
            ((Map)hashMap).put("PT_ACTIONS", new JsonArraySizeChecker(templateRenderer.getActions(), 0, "Feedback Text or Actions is missing or empty"));
            return hashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TemplateType.values().length];
                try {
                    nArray[TemplateType.BASIC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.AUTO_CAROUSEL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.MANUAL_CAROUSEL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.RATING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.FIVE_ICONS.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.PRODUCT_DISPLAY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.ZERO_BEZEL.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.TIMER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TemplateType.INPUT_BOX.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

