/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.pushtemplates.TemplateType;
import com.clevertap.android.pushtemplates.Utils;
import com.clevertap.android.pushtemplates.content.ContentView;
import com.clevertap.android.pushtemplates.content.FiveIconBigContentView;
import com.clevertap.android.pushtemplates.content.FiveIconSmallContentView;
import com.clevertap.android.pushtemplates.styles.AutoCarouselStyle;
import com.clevertap.android.pushtemplates.styles.BasicStyle;
import com.clevertap.android.pushtemplates.styles.FiveIconStyle;
import com.clevertap.android.pushtemplates.styles.InputBoxStyle;
import com.clevertap.android.pushtemplates.styles.ManualCarouselStyle;
import com.clevertap.android.pushtemplates.styles.ProductDisplayStyle;
import com.clevertap.android.pushtemplates.styles.RatingStyle;
import com.clevertap.android.pushtemplates.styles.TimerStyle;
import com.clevertap.android.pushtemplates.styles.ZeroBezelStyle;
import com.clevertap.android.pushtemplates.validators.Validator;
import com.clevertap.android.pushtemplates.validators.ValidatorFactory;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.interfaces.AudibleNotification;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.PushNotificationHandler;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import java.util.ArrayList;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\b\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000 \u00ad\u00012\u00020\u00012\u00020\u0002:\u0004\u00ac\u0001\u00ad\u0001B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0013\u0010\u0099\u0001\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001b\u0010\u009a\u0001\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J7\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u009d\u0001\u001a\u00030\u009c\u00012\u0006\u0010\t\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020LH\u0016J\u0012\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0011\u0010\u00a0\u0001\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0003\u0010\u00a1\u0001J4\u0010\u00a2\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0007\u0010\u0096\u0001\u001a\u00020L2\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010LH\u0003\u00a2\u0006\u0003\u0010\u00a4\u0001J\u001a\u0010\u00a5\u0001\u001a\u00030\u009f\u00012\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\t\u0010\u00a6\u0001\u001a\u00020\rH\u0016J\u0014\u0010\u00a7\u0001\u001a\u0005\u0018\u00010\u008e\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u00a8\u0001\u001a\u00030\u009c\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u009d\u0001\u001a\u00030\u009c\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u00a9\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u00aa\u0001\u001a\u00030\u009f\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J9\u0010\u00ab\u0001\u001a\u00030\u009c\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0007\u0010\u0096\u0001\u001a\u00020L2\b\u0010\u009d\u0001\u001a\u00030\u009c\u00012\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001c\u0010!\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R\u001c\u0010$\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R\u001c\u0010'\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\"\u00103\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010-\"\u0004\b5\u0010/R\"\u00106\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010-\"\u0004\b8\u0010/R\"\u00109\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010-\"\u0004\b;\u0010/R\u001c\u0010<\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0012\"\u0004\b>\u0010\u0014R\u001c\u0010?\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0012\"\u0004\bA\u0010\u0014R\u001c\u0010B\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0012\"\u0004\bD\u0010\u0014R\u001c\u0010E\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0012\"\u0004\bG\u0010\u0014R\u001c\u0010H\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0012\"\u0004\bJ\u0010\u0014R\u001a\u0010K\u001a\u00020LX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020LX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010N\"\u0004\bS\u0010PR\u001a\u0010T\u001a\u00020LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010N\"\u0004\bV\u0010PR\u001c\u0010W\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\u0012\"\u0004\bY\u0010\u0014R\u001c\u0010Z\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0012\"\u0004\b\\\u0010\u0014R\u001c\u0010]\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010\u0012\"\u0004\b_\u0010\u0014R\u001c\u0010`\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010\u0012\"\u0004\bb\u0010\u0014R\u001a\u0010c\u001a\u00020LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010N\"\u0004\be\u0010PR\u0010\u0010f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010g\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010h\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010i\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010\u0012\"\u0004\bk\u0010\u0014R\u001c\u0010l\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010\u0012\"\u0004\bn\u0010\u0014R\u001c\u0010o\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010\u0012\"\u0004\bq\u0010\u0014R\u001c\u0010r\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010\u0012\"\u0004\bt\u0010\u0014R\u001c\u0010u\u001a\u0004\u0018\u00010vX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u001c\u0010{\u001a\u0004\u0018\u00010vX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010x\"\u0004\b}\u0010zR\u0010\u0010~\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001f\u0010\u0086\u0001\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u0012\"\u0005\b\u0088\u0001\u0010\u0014R\u0011\u0010\u0089\u0001\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u008a\u0001\u001a\u00020LX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008b\u0001\u0010N\"\u0005\b\u008c\u0001\u0010PR\u0012\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u008f\u0001\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0090\u0001\u0010\u0012\"\u0005\b\u0091\u0001\u0010\u0014R \u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001\"\u0006\b\u0094\u0001\u0010\u0095\u0001R\u001d\u0010\u0096\u0001\u001a\u00020LX\u0080\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0097\u0001\u0010N\"\u0005\b\u0098\u0001\u0010P\u00a8\u0006\u00ae\u0001"}, d2={"Lcom/clevertap/android/pushtemplates/TemplateRenderer;", "Lcom/clevertap/android/sdk/pushnotification/INotificationRenderer;", "Lcom/clevertap/android/sdk/interfaces/AudibleNotification;", "context", "Landroid/content/Context;", "extras", "Landroid/os/Bundle;", "<init>", "(Landroid/content/Context;Landroid/os/Bundle;)V", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "(Landroid/content/Context;Landroid/os/Bundle;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "pt_id", "", "templateType", "Lcom/clevertap/android/pushtemplates/TemplateType;", "pt_title", "getPt_title$clevertap_pushtemplates_release", "()Ljava/lang/String;", "setPt_title$clevertap_pushtemplates_release", "(Ljava/lang/String;)V", "pt_msg", "getPt_msg$clevertap_pushtemplates_release", "setPt_msg$clevertap_pushtemplates_release", "pt_msg_summary", "getPt_msg_summary$clevertap_pushtemplates_release", "setPt_msg_summary$clevertap_pushtemplates_release", "pt_large_icon", "getPt_large_icon$clevertap_pushtemplates_release", "setPt_large_icon$clevertap_pushtemplates_release", "pt_big_img", "getPt_big_img$clevertap_pushtemplates_release", "setPt_big_img$clevertap_pushtemplates_release", "pt_title_clr", "getPt_title_clr$clevertap_pushtemplates_release", "setPt_title_clr$clevertap_pushtemplates_release", "pt_msg_clr", "getPt_msg_clr$clevertap_pushtemplates_release", "setPt_msg_clr$clevertap_pushtemplates_release", "pt_chrono_title_clr", "getPt_chrono_title_clr$clevertap_pushtemplates_release", "setPt_chrono_title_clr$clevertap_pushtemplates_release", "imageList", "Ljava/util/ArrayList;", "getImageList$clevertap_pushtemplates_release", "()Ljava/util/ArrayList;", "setImageList$clevertap_pushtemplates_release", "(Ljava/util/ArrayList;)V", "deepLinkList", "getDeepLinkList$clevertap_pushtemplates_release", "setDeepLinkList$clevertap_pushtemplates_release", "bigTextList", "getBigTextList$clevertap_pushtemplates_release", "setBigTextList$clevertap_pushtemplates_release", "smallTextList", "getSmallTextList$clevertap_pushtemplates_release", "setSmallTextList$clevertap_pushtemplates_release", "priceList", "getPriceList$clevertap_pushtemplates_release", "setPriceList$clevertap_pushtemplates_release", "pt_product_display_action", "getPt_product_display_action$clevertap_pushtemplates_release", "setPt_product_display_action$clevertap_pushtemplates_release", "pt_product_display_action_clr", "getPt_product_display_action_clr$clevertap_pushtemplates_release", "setPt_product_display_action_clr$clevertap_pushtemplates_release", "pt_bg", "getPt_bg$clevertap_pushtemplates_release", "setPt_bg$clevertap_pushtemplates_release", "pt_rating_default_dl", "getPt_rating_default_dl$clevertap_pushtemplates_release", "setPt_rating_default_dl$clevertap_pushtemplates_release", "pt_small_view", "getPt_small_view$clevertap_pushtemplates_release", "setPt_small_view$clevertap_pushtemplates_release", "smallIcon", "", "getSmallIcon$clevertap_pushtemplates_release", "()I", "setSmallIcon$clevertap_pushtemplates_release", "(I)V", "pt_dot", "getPt_dot$clevertap_pushtemplates_release", "setPt_dot$clevertap_pushtemplates_release", "pt_timer_threshold", "getPt_timer_threshold", "setPt_timer_threshold", "pt_input_label", "getPt_input_label$clevertap_pushtemplates_release", "setPt_input_label$clevertap_pushtemplates_release", "pt_input_feedback", "getPt_input_feedback", "setPt_input_feedback", "pt_input_auto_open", "getPt_input_auto_open$clevertap_pushtemplates_release", "setPt_input_auto_open$clevertap_pushtemplates_release", "pt_dismiss_on_click", "getPt_dismiss_on_click$clevertap_pushtemplates_release", "setPt_dismiss_on_click$clevertap_pushtemplates_release", "pt_timer_end", "getPt_timer_end", "setPt_timer_end", "pt_title_alt", "pt_msg_alt", "pt_big_img_alt", "pt_product_display_linear", "getPt_product_display_linear$clevertap_pushtemplates_release", "setPt_product_display_linear$clevertap_pushtemplates_release", "pt_meta_clr", "getPt_meta_clr$clevertap_pushtemplates_release", "setPt_meta_clr$clevertap_pushtemplates_release", "pt_product_display_action_text_clr", "getPt_product_display_action_text_clr$clevertap_pushtemplates_release", "setPt_product_display_action_text_clr$clevertap_pushtemplates_release", "pt_small_icon_clr", "getPt_small_icon_clr$clevertap_pushtemplates_release", "setPt_small_icon_clr$clevertap_pushtemplates_release", "pt_small_icon", "Landroid/graphics/Bitmap;", "getPt_small_icon$clevertap_pushtemplates_release", "()Landroid/graphics/Bitmap;", "setPt_small_icon$clevertap_pushtemplates_release", "(Landroid/graphics/Bitmap;)V", "pt_dot_sep", "getPt_dot_sep$clevertap_pushtemplates_release", "setPt_dot_sep$clevertap_pushtemplates_release", "pt_cancel_notif_id", "pt_cancel_notif_ids", "actions", "Lorg/json/JSONArray;", "getActions", "()Lorg/json/JSONArray;", "setActions", "(Lorg/json/JSONArray;)V", "pt_subtitle", "getPt_subtitle$clevertap_pushtemplates_release", "setPt_subtitle$clevertap_pushtemplates_release", "pID", "pt_flip_interval", "getPt_flip_interval$clevertap_pushtemplates_release", "setPt_flip_interval$clevertap_pushtemplates_release", "pt_collapse_key", "", "pt_manual_carousel_type", "getPt_manual_carousel_type$clevertap_pushtemplates_release", "setPt_manual_carousel_type$clevertap_pushtemplates_release", "getConfig$clevertap_pushtemplates_release", "()Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "setConfig$clevertap_pushtemplates_release", "(Lcom/clevertap/android/sdk/CleverTapInstanceConfig;)V", "notificationId", "getNotificationId$clevertap_pushtemplates_release", "setNotificationId$clevertap_pushtemplates_release", "getMessage", "getTitle", "renderNotification", "Landroidx/core/app/NotificationCompat$Builder;", "nb", "renderCancelNotification", "", "getTimerEnd", "()Ljava/lang/Integer;", "timerRunner", "delay", "(Landroid/content/Context;Landroid/os/Bundle;ILjava/lang/Integer;)V", "setSmallIcon", "getActionButtonIconKey", "getCollapseKey", "setSound", "setUp", "setKeysFromDashboard", "setActionButtons", "LogLevel", "Companion", "clevertap-pushtemplates_release"})
public final class TemplateRenderer
implements INotificationRenderer,
AudibleNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String pt_id;
    @Nullable
    private TemplateType templateType;
    @Nullable
    private String pt_title;
    @Nullable
    private String pt_msg;
    @Nullable
    private String pt_msg_summary;
    @Nullable
    private String pt_large_icon;
    @Nullable
    private String pt_big_img;
    @Nullable
    private String pt_title_clr;
    @Nullable
    private String pt_msg_clr;
    @Nullable
    private String pt_chrono_title_clr;
    @Nullable
    private ArrayList<String> imageList;
    @Nullable
    private ArrayList<String> deepLinkList;
    @Nullable
    private ArrayList<String> bigTextList;
    @Nullable
    private ArrayList<String> smallTextList;
    @Nullable
    private ArrayList<String> priceList;
    @Nullable
    private String pt_product_display_action;
    @Nullable
    private String pt_product_display_action_clr;
    @Nullable
    private String pt_bg;
    @Nullable
    private String pt_rating_default_dl;
    @Nullable
    private String pt_small_view;
    private int smallIcon;
    private int pt_dot;
    private int pt_timer_threshold;
    @Nullable
    private String pt_input_label;
    @Nullable
    private String pt_input_feedback;
    @Nullable
    private String pt_input_auto_open;
    @Nullable
    private String pt_dismiss_on_click;
    private int pt_timer_end;
    @Nullable
    private String pt_title_alt;
    @Nullable
    private String pt_msg_alt;
    @Nullable
    private String pt_big_img_alt;
    @Nullable
    private String pt_product_display_linear;
    @Nullable
    private String pt_meta_clr;
    @Nullable
    private String pt_product_display_action_text_clr;
    @Nullable
    private String pt_small_icon_clr;
    @Nullable
    private Bitmap pt_small_icon;
    @Nullable
    private Bitmap pt_dot_sep;
    @Nullable
    private String pt_cancel_notif_id;
    @Nullable
    private ArrayList<Integer> pt_cancel_notif_ids;
    @Nullable
    private JSONArray actions;
    @Nullable
    private String pt_subtitle;
    @Nullable
    private String pID;
    private int pt_flip_interval;
    @Nullable
    private Object pt_collapse_key;
    @Nullable
    private String pt_manual_carousel_type;
    @Nullable
    private CleverTapInstanceConfig config;
    private int notificationId;
    private static int debugLevel = LogLevel.INFO.intValue();

    @Nullable
    public final String getPt_title$clevertap_pushtemplates_release() {
        return this.pt_title;
    }

    public final void setPt_title$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_title = string;
    }

    @Nullable
    public final String getPt_msg$clevertap_pushtemplates_release() {
        return this.pt_msg;
    }

    public final void setPt_msg$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_msg = string;
    }

    @Nullable
    public final String getPt_msg_summary$clevertap_pushtemplates_release() {
        return this.pt_msg_summary;
    }

    public final void setPt_msg_summary$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_msg_summary = string;
    }

    @Nullable
    public final String getPt_large_icon$clevertap_pushtemplates_release() {
        return this.pt_large_icon;
    }

    public final void setPt_large_icon$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_large_icon = string;
    }

    @Nullable
    public final String getPt_big_img$clevertap_pushtemplates_release() {
        return this.pt_big_img;
    }

    public final void setPt_big_img$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_big_img = string;
    }

    @Nullable
    public final String getPt_title_clr$clevertap_pushtemplates_release() {
        return this.pt_title_clr;
    }

    public final void setPt_title_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_title_clr = string;
    }

    @Nullable
    public final String getPt_msg_clr$clevertap_pushtemplates_release() {
        return this.pt_msg_clr;
    }

    public final void setPt_msg_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_msg_clr = string;
    }

    @Nullable
    public final String getPt_chrono_title_clr$clevertap_pushtemplates_release() {
        return this.pt_chrono_title_clr;
    }

    public final void setPt_chrono_title_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_chrono_title_clr = string;
    }

    @Nullable
    public final ArrayList<String> getImageList$clevertap_pushtemplates_release() {
        return this.imageList;
    }

    public final void setImageList$clevertap_pushtemplates_release(@Nullable ArrayList<String> arrayList) {
        this.imageList = arrayList;
    }

    @Nullable
    public final ArrayList<String> getDeepLinkList$clevertap_pushtemplates_release() {
        return this.deepLinkList;
    }

    public final void setDeepLinkList$clevertap_pushtemplates_release(@Nullable ArrayList<String> arrayList) {
        this.deepLinkList = arrayList;
    }

    @Nullable
    public final ArrayList<String> getBigTextList$clevertap_pushtemplates_release() {
        return this.bigTextList;
    }

    public final void setBigTextList$clevertap_pushtemplates_release(@Nullable ArrayList<String> arrayList) {
        this.bigTextList = arrayList;
    }

    @Nullable
    public final ArrayList<String> getSmallTextList$clevertap_pushtemplates_release() {
        return this.smallTextList;
    }

    public final void setSmallTextList$clevertap_pushtemplates_release(@Nullable ArrayList<String> arrayList) {
        this.smallTextList = arrayList;
    }

    @Nullable
    public final ArrayList<String> getPriceList$clevertap_pushtemplates_release() {
        return this.priceList;
    }

    public final void setPriceList$clevertap_pushtemplates_release(@Nullable ArrayList<String> arrayList) {
        this.priceList = arrayList;
    }

    @Nullable
    public final String getPt_product_display_action$clevertap_pushtemplates_release() {
        return this.pt_product_display_action;
    }

    public final void setPt_product_display_action$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_product_display_action = string;
    }

    @Nullable
    public final String getPt_product_display_action_clr$clevertap_pushtemplates_release() {
        return this.pt_product_display_action_clr;
    }

    public final void setPt_product_display_action_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_product_display_action_clr = string;
    }

    @Nullable
    public final String getPt_bg$clevertap_pushtemplates_release() {
        return this.pt_bg;
    }

    public final void setPt_bg$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_bg = string;
    }

    @Nullable
    public final String getPt_rating_default_dl$clevertap_pushtemplates_release() {
        return this.pt_rating_default_dl;
    }

    public final void setPt_rating_default_dl$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_rating_default_dl = string;
    }

    @Nullable
    public final String getPt_small_view$clevertap_pushtemplates_release() {
        return this.pt_small_view;
    }

    public final void setPt_small_view$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_small_view = string;
    }

    public final int getSmallIcon$clevertap_pushtemplates_release() {
        return this.smallIcon;
    }

    public final void setSmallIcon$clevertap_pushtemplates_release(int n) {
        this.smallIcon = n;
    }

    public final int getPt_dot$clevertap_pushtemplates_release() {
        return this.pt_dot;
    }

    public final void setPt_dot$clevertap_pushtemplates_release(int n) {
        this.pt_dot = n;
    }

    public final int getPt_timer_threshold() {
        return this.pt_timer_threshold;
    }

    public final void setPt_timer_threshold(int n) {
        this.pt_timer_threshold = n;
    }

    @Nullable
    public final String getPt_input_label$clevertap_pushtemplates_release() {
        return this.pt_input_label;
    }

    public final void setPt_input_label$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_input_label = string;
    }

    @Nullable
    public final String getPt_input_feedback() {
        return this.pt_input_feedback;
    }

    public final void setPt_input_feedback(@Nullable String string) {
        this.pt_input_feedback = string;
    }

    @Nullable
    public final String getPt_input_auto_open$clevertap_pushtemplates_release() {
        return this.pt_input_auto_open;
    }

    public final void setPt_input_auto_open$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_input_auto_open = string;
    }

    @Nullable
    public final String getPt_dismiss_on_click$clevertap_pushtemplates_release() {
        return this.pt_dismiss_on_click;
    }

    public final void setPt_dismiss_on_click$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_dismiss_on_click = string;
    }

    public final int getPt_timer_end() {
        return this.pt_timer_end;
    }

    public final void setPt_timer_end(int n) {
        this.pt_timer_end = n;
    }

    @Nullable
    public final String getPt_product_display_linear$clevertap_pushtemplates_release() {
        return this.pt_product_display_linear;
    }

    public final void setPt_product_display_linear$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_product_display_linear = string;
    }

    @Nullable
    public final String getPt_meta_clr$clevertap_pushtemplates_release() {
        return this.pt_meta_clr;
    }

    public final void setPt_meta_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_meta_clr = string;
    }

    @Nullable
    public final String getPt_product_display_action_text_clr$clevertap_pushtemplates_release() {
        return this.pt_product_display_action_text_clr;
    }

    public final void setPt_product_display_action_text_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_product_display_action_text_clr = string;
    }

    @Nullable
    public final String getPt_small_icon_clr$clevertap_pushtemplates_release() {
        return this.pt_small_icon_clr;
    }

    public final void setPt_small_icon_clr$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_small_icon_clr = string;
    }

    @Nullable
    public final Bitmap getPt_small_icon$clevertap_pushtemplates_release() {
        return this.pt_small_icon;
    }

    public final void setPt_small_icon$clevertap_pushtemplates_release(@Nullable Bitmap bitmap) {
        this.pt_small_icon = bitmap;
    }

    @Nullable
    public final Bitmap getPt_dot_sep$clevertap_pushtemplates_release() {
        return this.pt_dot_sep;
    }

    public final void setPt_dot_sep$clevertap_pushtemplates_release(@Nullable Bitmap bitmap) {
        this.pt_dot_sep = bitmap;
    }

    @Nullable
    public final JSONArray getActions() {
        return this.actions;
    }

    public final void setActions(@Nullable JSONArray jSONArray) {
        this.actions = jSONArray;
    }

    @Nullable
    public final String getPt_subtitle$clevertap_pushtemplates_release() {
        return this.pt_subtitle;
    }

    public final void setPt_subtitle$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_subtitle = string;
    }

    public final int getPt_flip_interval$clevertap_pushtemplates_release() {
        return this.pt_flip_interval;
    }

    public final void setPt_flip_interval$clevertap_pushtemplates_release(int n) {
        this.pt_flip_interval = n;
    }

    @Nullable
    public final String getPt_manual_carousel_type$clevertap_pushtemplates_release() {
        return this.pt_manual_carousel_type;
    }

    public final void setPt_manual_carousel_type$clevertap_pushtemplates_release(@Nullable String string) {
        this.pt_manual_carousel_type = string;
    }

    @Nullable
    public final CleverTapInstanceConfig getConfig$clevertap_pushtemplates_release() {
        return this.config;
    }

    public final void setConfig$clevertap_pushtemplates_release(@Nullable CleverTapInstanceConfig cleverTapInstanceConfig) {
        this.config = cleverTapInstanceConfig;
    }

    public final int getNotificationId$clevertap_pushtemplates_release() {
        return this.notificationId;
    }

    public final void setNotificationId$clevertap_pushtemplates_release(int n) {
        this.notificationId = n;
    }

    public TemplateRenderer(@NotNull Context context, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        this.notificationId = -1;
        this.setUp(context, extras, null);
    }

    private TemplateRenderer(Context context, Bundle extras, CleverTapInstanceConfig config) {
        this.notificationId = -1;
        this.setUp(context, extras, config);
    }

    @Nullable
    public String getMessage(@NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        return this.pt_msg;
    }

    @Nullable
    public String getTitle(@NotNull Bundle extras, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.pt_title;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public NotificationCompat.Builder renderNotification(@NotNull Bundle extras, @NotNull Context context, @NotNull NotificationCompat.Builder nb, @NotNull CleverTapInstanceConfig config, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nb, (String)"nb");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.pt_id == null) {
            PTLog.verbose("Template ID not provided. Cannot create the notification");
            return null;
        }
        this.notificationId = notificationId;
        TemplateType templateType = this.templateType;
        switch (templateType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[templateType.ordinal()]) {
            case 1: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.BASIC, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new BasicStyle(this).builderFromStyle(context, extras, notificationId, nb);
            }
            case 2: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.AUTO_CAROUSEL, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new AutoCarouselStyle(this).builderFromStyle(context, extras, notificationId, nb);
            }
            case 3: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.MANUAL_CAROUSEL, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new ManualCarouselStyle(this, extras).builderFromStyle(context, extras, notificationId, nb);
            }
            case 4: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.RATING, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new RatingStyle(this, extras).builderFromStyle(context, extras, notificationId, nb);
            }
            case 5: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.FIVE_ICONS, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                FiveIconStyle fiveIconStyle = new FiveIconStyle(this, extras);
                NotificationCompat.Builder fiveIconNotificationBuilder = fiveIconStyle.builderFromStyle(context, extras, notificationId, nb);
                ContentView contentView = fiveIconStyle.getFiveIconSmallContentView();
                Intrinsics.checkNotNull((Object)contentView, (String)"null cannot be cast to non-null type com.clevertap.android.pushtemplates.content.FiveIconSmallContentView");
                if (((FiveIconSmallContentView)contentView).getUnloadedFiveIconsCount$clevertap_pushtemplates_release() > 2) return null;
                ContentView contentView2 = fiveIconStyle.getFiveIconBigContentView();
                Intrinsics.checkNotNull((Object)contentView2, (String)"null cannot be cast to non-null type com.clevertap.android.pushtemplates.content.FiveIconBigContentView");
                if (((FiveIconBigContentView)contentView2).getUnloadedFiveIconsCount$clevertap_pushtemplates_release() > 2) {
                    return null;
                }
                NotificationCompat.Builder builder = fiveIconNotificationBuilder;
                return builder;
            }
            case 6: {
                Validator fiveIconStyle = ValidatorFactory.Companion.getValidator(TemplateType.PRODUCT_DISPLAY, this);
                if (fiveIconStyle == null) return null;
                if (!fiveIconStyle.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new ProductDisplayStyle(this, extras).builderFromStyle(context, extras, notificationId, nb);
            }
            case 7: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.ZERO_BEZEL, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new ZeroBezelStyle(this).builderFromStyle(context, extras, notificationId, nb);
            }
            case 8: {
                if (Build.VERSION.SDK_INT >= 24) {
                    Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.TIMER, this);
                    if (validator == null) return null;
                    if (!validator.validate()) return null;
                    boolean bl = true;
                    if (!bl) return null;
                    Integer timerEnd = this.getTimerEnd();
                    if (timerEnd == null) return null;
                    this.timerRunner(context, extras, notificationId, timerEnd);
                    return new TimerStyle(this, extras).builderFromStyle(context, extras, notificationId, nb).setTimeoutAfter((long)timerEnd.intValue());
                }
                PTLog.debug("Push Templates SDK supports Timer Notifications only on or above Android Nougat, reverting to basic template");
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.BASIC, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new BasicStyle(this).builderFromStyle(context, extras, notificationId, nb);
            }
            case 9: {
                Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.INPUT_BOX, this);
                if (validator == null) return null;
                if (!validator.validate()) return null;
                boolean bl = true;
                if (!bl) return null;
                return new InputBoxStyle(this).builderFromStyle(context, extras, notificationId, nb);
            }
            case 10: {
                this.renderCancelNotification(context);
                return null;
            }
            default: {
                PTLog.verbose("operation not defined!");
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void renderCancelNotification(Context context) {
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        if (this.pt_cancel_notif_id != null) {
            String string = this.pt_cancel_notif_id;
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                String string2 = this.pt_cancel_notif_id;
                Intrinsics.checkNotNull((Object)string2);
                int notificationId = Integer.parseInt(string2);
                notificationManager.cancel(notificationId);
                return;
            }
        }
        ArrayList<Integer> arrayList = this.pt_cancel_notif_ids;
        Intrinsics.checkNotNull(arrayList);
        if (arrayList.size() <= 0) return;
        int i = 0;
        ArrayList<Integer> arrayList2 = this.pt_cancel_notif_ids;
        Intrinsics.checkNotNull(arrayList2);
        int n = arrayList2.size();
        if (i > n) return;
        while (true) {
            ArrayList<Integer> arrayList3 = this.pt_cancel_notif_ids;
            Intrinsics.checkNotNull(arrayList3);
            Integer n2 = arrayList3.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"get(...)");
            notificationManager.cancel(((Number)n2).intValue());
            if (i == n) return;
            ++i;
        }
    }

    private final Integer getTimerEnd() {
        Integer timer_end = null;
        if (this.pt_timer_threshold != -1 && this.pt_timer_threshold >= 10) {
            timer_end = this.pt_timer_threshold * 1000 + 1000;
        } else if (this.pt_timer_end >= 10) {
            timer_end = this.pt_timer_end * 1000 + 1000;
        } else {
            PTLog.debug("Not rendering notification Timer End value lesser than threshold (10 seconds) from current time: pt_timer_end");
        }
        return timer_end;
    }

    @RequiresApi(value=23)
    private final void timerRunner(Context context, Bundle extras, int notificationId, Integer delay) {
        Handler handler = new Handler(Looper.getMainLooper());
        if (delay != null) {
            handler.postDelayed(() -> TemplateRenderer.timerRunner$lambda$0(context, notificationId, this, extras), (long)(delay - 100));
        }
    }

    public void setSmallIcon(int smallIcon, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.smallIcon = smallIcon;
        try {
            this.pt_small_icon = Utils.setBitMapColour(context, smallIcon, this.pt_small_icon_clr);
        }
        catch (NullPointerException e) {
            PTLog.debug("NPE while setting small icon color");
        }
    }

    @NotNull
    public String getActionButtonIconKey() {
        return "pt_ico";
    }

    @Nullable
    public Object getCollapseKey(@NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        return this.pt_collapse_key;
    }

    @NotNull
    public NotificationCompat.Builder setSound(@NotNull Context context, @NotNull Bundle extras, @NotNull NotificationCompat.Builder nb, @NotNull CleverTapInstanceConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)nb, (String)"nb");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    Object s = o;
                    if (Intrinsics.areEqual((Object)s, (Object)"true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!(((CharSequence)s).length() == 0)) {
                        if (StringsKt.contains$default((CharSequence)((CharSequence)s), (CharSequence)".mp3", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)s), (CharSequence)".ogg", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)s), (CharSequence)".wav", (boolean)false, (int)2, null)) {
                            String string = ((String)s).substring(0, ((String)s).length() - 4);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            s = string;
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + (String)s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            config.getLogger().debug(config.getAccountId(), "Could not process sound parameter", t);
        }
        return nb;
    }

    private final void setUp(Context context, Bundle extras, CleverTapInstanceConfig config) {
        this.pt_id = extras.getString("pt_id");
        String pt_json = extras.getString("pt_json");
        if (this.pt_id != null) {
            this.templateType = TemplateType.Companion.fromString(this.pt_id);
            Bundle newExtras = null;
            try {
                if (pt_json != null && ((CharSequence)pt_json).length() > 0) {
                    newExtras = Utils.fromJson(new JSONObject(pt_json));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (newExtras != null) {
                extras.putAll(newExtras);
            }
        }
        this.pt_msg = extras.getString("pt_msg");
        this.pt_msg_summary = extras.getString("pt_msg_summary");
        this.pt_msg_clr = extras.getString("pt_msg_clr");
        this.pt_title = extras.getString("pt_title");
        this.pt_title_clr = extras.getString("pt_title_clr");
        this.pt_meta_clr = extras.getString("pt_meta_clr");
        this.pt_bg = extras.getString("pt_bg");
        this.pt_big_img = extras.getString("pt_big_img");
        this.pt_large_icon = extras.getString("pt_ico");
        this.pt_small_view = extras.getString("pt_small_view");
        this.imageList = Utils.getImageListFromExtras(extras);
        this.deepLinkList = Utils.getDeepLinkListFromExtras(extras);
        this.bigTextList = Utils.getBigTextFromExtras(extras);
        this.smallTextList = Utils.getSmallTextFromExtras(extras);
        this.priceList = Utils.getPriceFromExtras(extras);
        this.pt_rating_default_dl = extras.getString("pt_default_dl");
        this.pt_timer_threshold = Utils.getTimerThreshold(extras);
        this.pt_input_label = extras.getString("pt_input_label");
        this.pt_input_feedback = extras.getString("pt_input_feedback");
        this.pt_input_auto_open = extras.getString("pt_input_auto_open");
        this.pt_dismiss_on_click = extras.getString("pt_dismiss_on_click");
        this.pt_chrono_title_clr = extras.getString("pt_chrono_title_clr");
        this.pt_product_display_action = extras.getString("pt_product_display_action");
        this.pt_product_display_action_clr = extras.getString("pt_product_display_action_clr");
        this.pt_timer_end = Utils.getTimerEnd(extras);
        this.pt_big_img_alt = extras.getString("pt_big_img_alt");
        this.pt_msg_alt = extras.getString("pt_msg_alt");
        this.pt_title_alt = extras.getString("pt_title_alt");
        this.pt_product_display_linear = extras.getString("pt_product_display_linear");
        this.pt_product_display_action_text_clr = extras.getString("pt_product_display_action_text_clr");
        this.pt_small_icon_clr = extras.getString("pt_small_icon_clr");
        this.pt_cancel_notif_id = extras.getString("pt_cancel_notif_id");
        this.pt_cancel_notif_ids = Utils.getNotificationIds(context);
        this.actions = Utils.getActionKeys(extras);
        this.pt_subtitle = extras.getString("pt_subtitle");
        this.pt_collapse_key = extras.get("pt_ck");
        this.pt_flip_interval = Utils.getFlipInterval(extras);
        this.pID = extras.getString("wzrk_pid");
        this.pt_manual_carousel_type = extras.getString("pt_manual_carousel_type");
        if (config != null) {
            this.config = config;
        }
        this.setKeysFromDashboard(extras);
    }

    private final void setKeysFromDashboard(Bundle extras) {
        block45: {
            block44: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block34: {
                                                        block33: {
                                                            block32: {
                                                                block31: {
                                                                    block30: {
                                                                        block29: {
                                                                            block28: {
                                                                                if (this.pt_title == null) break block28;
                                                                                String string = this.pt_title;
                                                                                Intrinsics.checkNotNull((Object)string);
                                                                                if (!(((CharSequence)string).length() == 0)) break block29;
                                                                            }
                                                                            this.pt_title = extras.getString("nt");
                                                                        }
                                                                        if (this.pt_msg == null) break block30;
                                                                        String string = this.pt_msg;
                                                                        Intrinsics.checkNotNull((Object)string);
                                                                        if (!(((CharSequence)string).length() == 0)) break block31;
                                                                    }
                                                                    this.pt_msg = extras.getString("nm");
                                                                }
                                                                if (this.pt_msg_summary == null) break block32;
                                                                String string = this.pt_msg_summary;
                                                                Intrinsics.checkNotNull((Object)string);
                                                                if (!(((CharSequence)string).length() == 0)) break block33;
                                                            }
                                                            this.pt_msg_summary = extras.getString("wzrk_nms");
                                                        }
                                                        if (this.pt_big_img == null) break block34;
                                                        String string = this.pt_big_img;
                                                        Intrinsics.checkNotNull((Object)string);
                                                        if (!(((CharSequence)string).length() == 0)) break block35;
                                                    }
                                                    this.pt_big_img = extras.getString("wzrk_bp");
                                                }
                                                if (this.pt_rating_default_dl == null) break block36;
                                                String string = this.pt_rating_default_dl;
                                                Intrinsics.checkNotNull((Object)string);
                                                if (!(((CharSequence)string).length() == 0)) break block37;
                                            }
                                            this.pt_rating_default_dl = extras.getString("wzrk_dl");
                                        }
                                        if (this.pt_meta_clr == null) break block38;
                                        String string = this.pt_meta_clr;
                                        Intrinsics.checkNotNull((Object)string);
                                        if (!(((CharSequence)string).length() == 0)) break block39;
                                    }
                                    this.pt_meta_clr = extras.getString("wzrk_clr");
                                }
                                if (this.pt_small_icon_clr == null) break block40;
                                String string = this.pt_small_icon_clr;
                                Intrinsics.checkNotNull((Object)string);
                                if (!(((CharSequence)string).length() == 0)) break block41;
                            }
                            this.pt_small_icon_clr = extras.getString("wzrk_clr");
                        }
                        if (this.pt_subtitle == null) break block42;
                        String string = this.pt_subtitle;
                        Intrinsics.checkNotNull((Object)string);
                        if (!(((CharSequence)string).length() == 0)) break block43;
                    }
                    this.pt_subtitle = extras.getString("wzrk_st");
                }
                if (this.pt_small_icon_clr == null) break block44;
                String string = this.pt_small_icon_clr;
                Intrinsics.checkNotNull((Object)string);
                if (!(((CharSequence)string).length() == 0)) break block45;
            }
            this.pt_small_icon_clr = extras.getString("wzrk_clr");
        }
        if (this.pt_collapse_key == null) {
            this.pt_collapse_key = extras.get("wzrk_ck");
        }
    }

    @NotNull
    public NotificationCompat.Builder setActionButtons(@NotNull Context context, @NotNull Bundle extras, int notificationId, @NotNull NotificationCompat.Builder nb, @Nullable JSONArray actions) {
        block31: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Intrinsics.checkNotNullParameter((Object)nb, (String)"nb");
            String intentServiceName = ManifestInfo.getInstance((Context)context).getIntentServiceName();
            Class<?> clazz = null;
            if (intentServiceName != null) {
                try {
                    clazz = Class.forName(intentServiceName);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.d((String)"No Intent Service found");
                    }
                }
            } else {
                try {
                    clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
                }
                catch (ClassNotFoundException ex) {
                    Logger.d((String)"No Intent Service found");
                }
            }
            boolean isCTIntentServiceAvailable = com.clevertap.android.sdk.Utils.isServiceAvailable((Context)context, clazz);
            if (actions == null || actions.length() <= 0) break block31;
            int n = actions.length();
            for (int i = 0; i < n; ++i) {
                try {
                    PendingIntent pendingIntent;
                    boolean autoCancel;
                    String id2;
                    String ico;
                    String dl;
                    String label;
                    block33: {
                        block32: {
                            JSONObject action = actions.getJSONObject(i);
                            label = action.optString("l");
                            dl = action.optString("dl");
                            ico = action.optString(this.getActionButtonIconKey());
                            id2 = action.optString("id");
                            autoCancel = action.optBoolean("ac", true);
                            Intrinsics.checkNotNull((Object)label);
                            if (((CharSequence)label).length() == 0) break block32;
                            Intrinsics.checkNotNull((Object)id2);
                            if (!(((CharSequence)id2).length() == 0)) break block33;
                        }
                        Logger.d((String)"not adding push notification action: action label or id missing");
                        continue;
                    }
                    int icon = 0;
                    Intrinsics.checkNotNull((Object)ico);
                    if (!(((CharSequence)ico).length() == 0)) {
                        try {
                            icon = context.getResources().getIdentifier(ico, "drawable", context.getPackageName());
                        }
                        catch (Throwable t) {
                            Logger.d((String)("unable to add notification action icon: " + t.getLocalizedMessage()));
                        }
                    }
                    boolean sendToCTIntentService = Build.VERSION.SDK_INT < 31 && autoCancel && isCTIntentServiceAvailable;
                    String dismissOnClick = extras.getString("pt_dismiss_on_click");
                    if (!sendToCTIntentService && PushNotificationHandler.isForPushTemplates((Bundle)extras) && StringsKt.contains$default((CharSequence)id2, (CharSequence)"remind", (boolean)false, (int)2, null) && dismissOnClick != null && StringsKt.equals((String)dismissOnClick, (String)"true", (boolean)true) && autoCancel && isCTIntentServiceAvailable) {
                        sendToCTIntentService = true;
                    }
                    if (!sendToCTIntentService && PushNotificationHandler.isForPushTemplates((Bundle)extras) && dismissOnClick != null && StringsKt.equals((String)dismissOnClick, (String)"true", (boolean)true) && autoCancel && isCTIntentServiceAvailable) {
                        sendToCTIntentService = true;
                    }
                    Intent actionLaunchIntent = null;
                    if (sendToCTIntentService) {
                        actionLaunchIntent = new Intent("com.clevertap.PUSH_EVENT");
                        actionLaunchIntent.setPackage(context.getPackageName());
                        actionLaunchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                        Intrinsics.checkNotNull((Object)dl);
                        if (((CharSequence)dl).length() > 0) {
                            actionLaunchIntent.putExtra("dl", dl);
                        }
                    } else {
                        Intrinsics.checkNotNull((Object)dl);
                        if (((CharSequence)dl).length() > 0) {
                            actionLaunchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)dl));
                            Utils.setPackageNameFromResolveInfoList(context, actionLaunchIntent);
                        } else {
                            actionLaunchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                        }
                    }
                    if (actionLaunchIntent != null) {
                        actionLaunchIntent.putExtras(extras);
                        actionLaunchIntent.removeExtra("wzrk_acts");
                        actionLaunchIntent.putExtra("actionId", id2);
                        actionLaunchIntent.putExtra("autoCancel", autoCancel);
                        actionLaunchIntent.putExtra("wzrk_c2a", id2);
                        actionLaunchIntent.putExtra("notificationId", notificationId);
                        actionLaunchIntent.setFlags(0x24000000);
                    }
                    PendingIntent actionIntent = null;
                    int requestCode = new Random().nextInt();
                    int flagsActionLaunchPendingIntent = 0x8000000;
                    if (Build.VERSION.SDK_INT >= 23) {
                        flagsActionLaunchPendingIntent |= 0x4000000;
                    }
                    if (sendToCTIntentService) {
                        Intent intent = actionLaunchIntent;
                        Intrinsics.checkNotNull((Object)intent);
                        pendingIntent = PendingIntent.getService((Context)context, (int)requestCode, (Intent)intent, (int)flagsActionLaunchPendingIntent);
                    } else {
                        Intent intent = actionLaunchIntent;
                        Intrinsics.checkNotNull((Object)intent);
                        pendingIntent = PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)flagsActionLaunchPendingIntent, null);
                    }
                    actionIntent = pendingIntent;
                    nb.addAction(icon, (CharSequence)label, actionIntent);
                    continue;
                }
                catch (Throwable t) {
                    Logger.d((String)("error adding notification action : " + t.getLocalizedMessage()));
                }
            }
        }
        return nb;
    }

    private static final void timerRunner$lambda$0(Context $context, int $notificationId, TemplateRenderer this$0, Bundle $extras) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$extras, (String)"$extras");
            if (!Utils.isNotificationInTray($context, $notificationId)) break block12;
            Validator validator = ValidatorFactory.Companion.getValidator(TemplateType.BASIC, this$0);
            boolean bl = validator != null ? validator.validate() : false;
            if (bl) {
                CleverTapAPI cleverTapAPI;
                Context applicationContext = $context.getApplicationContext();
                Object object = $extras.clone();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Bundle");
                Bundle basicTemplateBundle = (Bundle)object;
                basicTemplateBundle.remove("wzrk_rnv");
                basicTemplateBundle.putString("wzrk_pid", null);
                basicTemplateBundle.putString("pt_id", "pt_basic");
                String ptJsonStr = basicTemplateBundle.getString("pt_json");
                JSONObject ptJsonObj = null;
                if (ptJsonStr != null) {
                    try {
                        ptJsonObj = new JSONObject(ptJsonStr);
                    }
                    catch (Exception e) {
                        Logger.v((String)"Unable to convert JSON to String");
                    }
                }
                if (this$0.pt_title_alt != null) {
                    JSONObject jSONObject;
                    String string = this$0.pt_title_alt;
                    Intrinsics.checkNotNull((Object)string);
                    if (((CharSequence)string).length() > 0 && ((jSONObject = ptJsonObj) == null || (jSONObject = jSONObject.put("pt_title", (Object)this$0.pt_title_alt)) == null)) {
                        basicTemplateBundle.putString("pt_title", this$0.pt_title_alt);
                        jSONObject = Unit.INSTANCE;
                    }
                }
                if (this$0.pt_big_img_alt != null) {
                    JSONObject jSONObject;
                    String string = this$0.pt_big_img_alt;
                    Intrinsics.checkNotNull((Object)string);
                    if (((CharSequence)string).length() > 0 && ((jSONObject = ptJsonObj) == null || (jSONObject = jSONObject.put("pt_big_img", (Object)this$0.pt_big_img_alt)) == null)) {
                        basicTemplateBundle.putString("pt_big_img", this$0.pt_big_img_alt);
                        jSONObject = Unit.INSTANCE;
                    }
                }
                if (this$0.pt_msg_alt != null) {
                    JSONObject jSONObject;
                    String string = this$0.pt_msg_alt;
                    Intrinsics.checkNotNull((Object)string);
                    if (((CharSequence)string).length() > 0 && ((jSONObject = ptJsonObj) == null || (jSONObject = jSONObject.put("pt_msg", (Object)this$0.pt_msg_alt)) == null)) {
                        basicTemplateBundle.putString("pt_msg", this$0.pt_msg_alt);
                        jSONObject = Unit.INSTANCE;
                    }
                }
                if (ptJsonObj != null) {
                    basicTemplateBundle.putString("pt_json", ptJsonObj.toString());
                }
                basicTemplateBundle.putString("pt_ck", null);
                basicTemplateBundle.putString("wzrk_ck", null);
                basicTemplateBundle.remove("notificationId");
                Intrinsics.checkNotNull((Object)applicationContext);
                INotificationRenderer templateRenderer = new TemplateRenderer(applicationContext, basicTemplateBundle);
                CleverTapAPI cleverTapAPI2 = cleverTapAPI = CleverTapAPI.getGlobalInstance((Context)applicationContext, (String)PushNotificationUtil.getAccountIdFromNotificationBundle((Bundle)basicTemplateBundle));
                if (cleverTapAPI2 != null) {
                    cleverTapAPI2.renderPushNotification(templateRenderer, applicationContext, basicTemplateBundle);
                }
            }
        }
    }

    public static final int getDebugLevel() {
        return Companion.getDebugLevel();
    }

    public static final void setDebugLevel(int n) {
        Companion.setDebugLevel(n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/clevertap/android/pushtemplates/TemplateRenderer$Companion;", "", "<init>", "()V", "debugLevel", "", "getDebugLevel$annotations", "getDebugLevel", "()I", "setDebugLevel", "(I)V", "clevertap-pushtemplates_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDebugLevel() {
            return debugLevel;
        }

        public final void setDebugLevel(int n) {
            debugLevel = n;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugLevel$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/clevertap/android/pushtemplates/TemplateRenderer$LogLevel;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "OFF", "INFO", "DEBUG", "VERBOSE", "intValue", "clevertap-pushtemplates_release"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        private final int value;
        public static final /* enum */ LogLevel OFF = new LogLevel(-1);
        public static final /* enum */ LogLevel INFO = new LogLevel(0);
        public static final /* enum */ LogLevel DEBUG = new LogLevel(2);
        public static final /* enum */ LogLevel VERBOSE = new LogLevel(3);
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LogLevel(int value) {
            this.value = value;
        }

        public final int intValue() {
            return this.value;
        }

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value) {
            return Enum.valueOf(LogLevel.class, value);
        }

        @NotNull
        public static EnumEntries<LogLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.OFF, LogLevel.INFO, LogLevel.DEBUG, LogLevel.VERBOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TemplateType.values().length];
            try {
                nArray[TemplateType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.AUTO_CAROUSEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.MANUAL_CAROUSEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.RATING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.FIVE_ICONS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.PRODUCT_DISPLAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.ZERO_BEZEL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.TIMER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.INPUT_BOX.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TemplateType.CANCEL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

