/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates;

import android.content.Context;
import android.os.Bundle;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.pushtemplates.TemplateRenderer;
import com.clevertap.android.pushtemplates.Utils;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.interfaces.ActionButtonClickHandler;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import java.util.Objects;

public class PushTemplateNotificationHandler
implements ActionButtonClickHandler {
    public boolean onActionButtonClick(Context context, Bundle extras, int notificationId) {
        String actionID = extras.getString("actionId");
        String dismissOnClick = extras.getString("pt_dismiss_on_click");
        CleverTapInstanceConfig config = (CleverTapInstanceConfig)extras.getParcelable("config");
        if (dismissOnClick != null && dismissOnClick.equalsIgnoreCase("true")) {
            if (actionID != null && actionID.contains("remind")) {
                Utils.raiseCleverTapEvent(context, config, extras);
            }
            Utils.cancelNotification(context, notificationId);
            return true;
        }
        return false;
    }

    public boolean onMessageReceived(Context applicationContext, Bundle message, String pushType) {
        try {
            PTLog.debug("Inside Push Templates");
            TemplateRenderer templateRenderer = new TemplateRenderer(applicationContext, message);
            CleverTapAPI cleverTapAPI = CleverTapAPI.getGlobalInstance((Context)applicationContext, (String)PushNotificationUtil.getAccountIdFromNotificationBundle((Bundle)message));
            Objects.requireNonNull(cleverTapAPI).renderPushNotificationOnCallerThread((INotificationRenderer)templateRenderer, applicationContext, message);
        }
        catch (Throwable throwable) {
            PTLog.verbose("Error parsing FCM payload", throwable);
        }
        return true;
    }

    public boolean onNewToken(Context applicationContext, String token, String pushType) {
        return true;
    }
}

