/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.db.DBEncryptionHandler;
import com.clevertap.android.sdk.db.DatabaseHelper;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.db.Table;
import com.clevertap.android.sdk.db.dao.EventDAO;
import com.clevertap.android.sdk.utils.Clock;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/db/dao/EventDAOImpl;", "Lcom/clevertap/android/sdk/db/dao/EventDAO;", "dbHelper", "Lcom/clevertap/android/sdk/db/DatabaseHelper;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "dbEncryptionHandler", "Lcom/clevertap/android/sdk/db/DBEncryptionHandler;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Lcom/clevertap/android/sdk/db/DatabaseHelper;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/db/DBEncryptionHandler;Lcom/clevertap/android/sdk/utils/Clock;)V", "storeEvent", "", "event", "Lorg/json/JSONObject;", "table", "Lcom/clevertap/android/sdk/db/Table;", "fetchEvents", "Lcom/clevertap/android/sdk/db/QueueData;", "limit", "", "fetchCombinedEvents", "batchSize", "cleanupEventsFromLastId", "", "lastId", "", "cleanupStaleEvents", "removeAllEvents", "updateAllEvents", "Companion", "clevertap-core_release"})
public final class EventDAOImpl
implements EventDAO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseHelper dbHelper;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final DBEncryptionHandler dbEncryptionHandler;
    @NotNull
    private final Clock clock;
    private static final long DATA_EXPIRATION = 432000000L;

    public EventDAOImpl(@NotNull DatabaseHelper dbHelper, @NotNull ILogger logger, @NotNull DBEncryptionHandler dbEncryptionHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbHelper), (String)"dbHelper");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)dbEncryptionHandler, (String)"dbEncryptionHandler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.dbHelper = dbHelper;
        this.logger = logger;
        this.dbEncryptionHandler = dbEncryptionHandler;
        this.clock = clock;
    }

    public /* synthetic */ EventDAOImpl(DatabaseHelper databaseHelper, ILogger iLogger, DBEncryptionHandler dBEncryptionHandler, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clock = Clock.SYSTEM;
        }
        this(databaseHelper, iLogger, dBEncryptionHandler, clock);
    }

    @Override
    @WorkerThread
    public long storeEvent(@NotNull JSONObject event, @NotNull Table table) {
        long l;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        if (!this.dbHelper.belowMemThreshold()) {
            this.logger.verbose("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = table.getTableName();
        ContentValues $this$storeEvent_u24lambda_u240 = contentValues = new ContentValues();
        boolean bl = false;
        String string2 = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        $this$storeEvent_u24lambda_u240.put("data", this.dbEncryptionHandler.wrapDbData(string2));
        $this$storeEvent_u24lambda_u240.put("created_at", Long.valueOf(this.clock.currentTimeMillis()));
        ContentValues cv = contentValues;
        try {
            l = this.dbHelper.getWritableDatabase().insert(tableName, null, cv);
        }
        catch (Exception e) {
            this.logger.verbose("Error adding data to table " + tableName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public synchronized QueueData fetchEvents(@NotNull Table table, int limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        QueueData queueData = new QueueData();
        String tName = table.getTableName();
        try {
            Object object = new String[]{"_id", "data", "created_at"};
            object = (Closeable)this.dbHelper.getReadableDatabase().query(tName, object, null, null, null, null, "created_at ASC", String.valueOf(limit + 1));
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                int rowCount = cursor.getCount();
                queueData.setHasMore$clevertap_core_release(rowCount > limit);
                int colId = cursor.getColumnIndexOrThrow("_id");
                int colData = cursor.getColumnIndexOrThrow("data");
                int pos = 0;
                while (cursor.moveToNext() && pos != limit) {
                    boolean bl2;
                    String id2 = cursor.getString(colId);
                    String eventData = cursor.getString(colData);
                    String decryptedData = this.dbEncryptionHandler.unwrapDbData(eventData);
                    if (decryptedData == null) {
                        this.logger.verbose("Error parsing event data for id: " + id2 + " from table: " + tName);
                        continue;
                    }
                    JSONObject jsonEvent = new JSONObject(decryptedData);
                    queueData.getData$clevertap_core_release().put((Object)jsonEvent);
                    if (table == Table.PROFILE_EVENTS) {
                        List<String> list = queueData.getProfileEventIds$clevertap_core_release();
                        Intrinsics.checkNotNull((Object)id2);
                        bl2 = list.add(id2);
                    } else {
                        List<String> list = queueData.getEventIds$clevertap_core_release();
                        Intrinsics.checkNotNull((Object)id2);
                        bl2 = list.add(id2);
                    }
                    ++pos;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.verbose("Could not fetch records from table " + tName, e);
        }
        int size = table == Table.PROFILE_EVENTS ? queueData.getProfileEventIds$clevertap_core_release().size() : queueData.getEventIds$clevertap_core_release().size();
        this.logger.verbose("Fetched " + size + " events from " + tName);
        return queueData;
    }

    @Override
    @NotNull
    public synchronized QueueData fetchCombinedEvents(int batchSize) {
        QueueData combinedQueueData = new QueueData();
        QueueData profileData = this.fetchEvents(Table.PROFILE_EVENTS, batchSize);
        int n = profileData.getData$clevertap_core_release().length();
        for (int i = 0; i < n; ++i) {
            combinedQueueData.getData$clevertap_core_release().put((Object)profileData.getData$clevertap_core_release().getJSONObject(i));
        }
        combinedQueueData.getProfileEventIds$clevertap_core_release().addAll((Collection<String>)profileData.getProfileEventIds$clevertap_core_release());
        combinedQueueData.setHasMore$clevertap_core_release(profileData.getHasMore$clevertap_core_release());
        int eventsNeeded = batchSize - combinedQueueData.getProfileEventIds$clevertap_core_release().size();
        if (eventsNeeded > 0 || !combinedQueueData.getHasMore$clevertap_core_release()) {
            QueueData eventsData = this.fetchEvents(Table.EVENTS, eventsNeeded);
            int n2 = eventsData.getData$clevertap_core_release().length();
            for (int i = 0; i < n2; ++i) {
                combinedQueueData.getData$clevertap_core_release().put((Object)eventsData.getData$clevertap_core_release().getJSONObject(i));
            }
            combinedQueueData.getEventIds$clevertap_core_release().addAll((Collection<String>)eventsData.getEventIds$clevertap_core_release());
            combinedQueueData.setHasMore$clevertap_core_release(eventsData.getHasMore$clevertap_core_release());
        }
        this.logger.verbose("Fetched combined batch: " + combinedQueueData.getProfileEventIds$clevertap_core_release().size() + " profile events, " + combinedQueueData.getEventIds$clevertap_core_release().size() + " events");
        return combinedQueueData;
    }

    @Override
    @WorkerThread
    public synchronized void cleanupEventsFromLastId(@NotNull String lastId, @NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)lastId, (String)"lastId");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            String[] stringArray = new String[]{lastId};
            this.dbHelper.getWritableDatabase().delete(tName, "_id <= ?", stringArray);
        }
        catch (SQLiteException e) {
            this.logger.verbose("Error removing sent data from table " + tName + " Recreating DB", e);
            this.dbHelper.deleteDatabase();
        }
    }

    @Override
    @WorkerThread
    public void cleanupStaleEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        long time = this.clock.currentTimeMillis() - 432000000L;
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, "created_at <= " + time, null);
        }
        catch (Exception e) {
            this.logger.verbose("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.dbHelper.deleteDatabase();
        }
    }

    @Override
    @WorkerThread
    public void removeAllEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        try {
            this.dbHelper.getWritableDatabase().delete(tName, null, null);
        }
        catch (Exception e) {
            this.logger.verbose("Error removing all events from table " + tName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public synchronized int updateAllEvents(@NotNull Table table) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        String tName = table.getTableName();
        int rowsUpdated = 0;
        try {
            Object object = new String[]{"_id", "data"};
            object = (Closeable)this.dbHelper.getReadableDatabase().query(tName, object, null, null, null, null, null);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                int colId = cursor.getColumnIndexOrThrow("_id");
                int colData = cursor.getColumnIndexOrThrow("data");
                while (cursor.moveToNext()) {
                    ContentValues contentValues;
                    String id2 = cursor.getString(colId);
                    String eventData = cursor.getString(colData);
                    if (eventData != null && this.dbEncryptionHandler.isInCorrectEncryptionFormat(eventData)) continue;
                    String decryptedData = this.dbEncryptionHandler.unwrapDbData(eventData);
                    if (decryptedData == null) {
                        this.logger.verbose("Error decrypting data for id: " + id2 + " from table: " + tName + ", skipping");
                        continue;
                    }
                    String reEncryptedData = this.dbEncryptionHandler.wrapDbData(decryptedData);
                    ContentValues $this$updateAllEvents_u24lambda_u243_u24lambda_u242 = contentValues = new ContentValues();
                    boolean bl2 = false;
                    $this$updateAllEvents_u24lambda_u243_u24lambda_u242.put("data", reEncryptedData);
                    ContentValues cv = contentValues;
                    String[] stringArray = new String[]{id2};
                    int updated = this.dbHelper.getWritableDatabase().update(tName, cv, "_id = ?", stringArray);
                    if (updated <= 0) continue;
                    ++rowsUpdated;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            this.logger.verbose("Successfully migrated " + rowsUpdated + " rows in table " + tName);
            return rowsUpdated;
        }
        catch (Exception e) {
            this.logger.verbose("Error updating all events in table " + tName + ". Recreating DB", e);
            this.dbHelper.deleteDatabase();
            return -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/db/dao/EventDAOImpl$Companion;", "", "<init>", "()V", "DATA_EXPIRATION", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

