/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppActionHandler;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.inapp.InAppNotificationInflater;
import com.clevertap.android.sdk.inapp.InAppQueue;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplateInAppData;
import com.clevertap.android.sdk.inapp.customtemplates.TemplatesManager;
import com.clevertap.android.sdk.inapp.data.InAppResponseAdapter;
import com.clevertap.android.sdk.inapp.evaluation.EvaluationManager;
import com.clevertap.android.sdk.inapp.evaluation.LimitAdapter;
import com.clevertap.android.sdk.inapp.fragment.CTInAppBaseFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.inapp.fragment.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.inapp.images.FileResourceProvider;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.task.CTExecutors;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.Clock;
import com.clevertap.android.sdk.utils.JsonUtilsKt;
import com.clevertap.android.sdk.variables.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 y2\u00020\u0001:\u0002xyB\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\u000e\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J4\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020,2\b\u0010@\u001a\u0004\u0018\u00010:2\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010B\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010C\u001a\u00020D2\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010E\u001a\u00020$2\u0006\u0010;\u001a\u00020<2\b\u0010F\u001a\u0004\u0018\u00010:H\u0016J\u001a\u0010G\u001a\u00020$2\u0006\u0010;\u001a\u00020<2\b\u0010F\u001a\u0004\u0018\u00010:H\u0016J\u0006\u0010H\u001a\u00020$J\u0006\u0010I\u001a\u00020$J\u0006\u0010J\u001a\u00020$J\u0010\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020MH\u0007J.\u0010N\u001a\u00020$2\u0006\u0010O\u001a\u00020,2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020R0Q2\b\u0010S\u001a\u0004\u0018\u00010TH\u0007J@\u0010U\u001a\u00020$2\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020R0Q2\u0018\u0010W\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020R0Q0X2\b\u0010S\u001a\u0004\u0018\u00010TH\u0007J2\u0010Y\u001a\u00020$2\u001e\u0010Z\u001a\u001a\u0012\u0004\u0012\u00020,\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020R0Q0Q2\b\u0010[\u001a\u0004\u0018\u00010TH\u0007J\u0018\u0010\\\u001a\u00020$2\u0006\u0010]\u001a\u00020M2\b\u0010S\u001a\u0004\u0018\u00010TJ\u0006\u0010^\u001a\u00020$J\b\u0010_\u001a\u00020$H\u0002J\u0010\u0010`\u001a\u00020$2\u0006\u0010a\u001a\u000204H\u0002J\u0012\u0010b\u001a\u0002072\b\u0010c\u001a\u0004\u0018\u00010dH\u0002J\b\u0010e\u001a\u000207H\u0002J\u0010\u0010f\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010g\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010h\u001a\u00020$2\u0006\u00103\u001a\u000204H\u0002J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020,012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010j\u001a\u000207H\u0002J\u0010\u0010k\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010l\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010m\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010n\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010o\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010p\u001a\u00020$2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010q\u001a\u00020M2\u0006\u0010r\u001a\u00020MH\u0002J\u0010\u0010s\u001a\u0002072\u0006\u0010a\u001a\u000204H\u0002J\u001a\u0010t\u001a\u00020$2\u0006\u0010u\u001a\u00020<2\b\u0010v\u001a\u0004\u0018\u00010wH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0018\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u0018\u0010+\u001a\n )*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020,01X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppController;", "Lcom/clevertap/android/sdk/inapp/InAppListener;", "context", "Landroid/content/Context;", "config", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "executors", "Lcom/clevertap/android/sdk/task/CTExecutors;", "controllerManager", "Lcom/clevertap/android/sdk/ControllerManager;", "callbackManager", "Lcom/clevertap/android/sdk/BaseCallbackManager;", "analyticsManager", "Lcom/clevertap/android/sdk/AnalyticsManager;", "coreMetaData", "Lcom/clevertap/android/sdk/CoreMetaData;", "manifestInfo", "Lcom/clevertap/android/sdk/ManifestInfo;", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "inAppQueue", "Lcom/clevertap/android/sdk/inapp/InAppQueue;", "evaluationManager", "Lcom/clevertap/android/sdk/inapp/evaluation/EvaluationManager;", "templatesManager", "Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;", "inAppActionHandler", "Lcom/clevertap/android/sdk/inapp/InAppActionHandler;", "inAppNotificationInflater", "Lcom/clevertap/android/sdk/inapp/InAppNotificationInflater;", "clock", "Lcom/clevertap/android/sdk/utils/Clock;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/task/CTExecutors;Lcom/clevertap/android/sdk/ControllerManager;Lcom/clevertap/android/sdk/BaseCallbackManager;Lcom/clevertap/android/sdk/AnalyticsManager;Lcom/clevertap/android/sdk/CoreMetaData;Lcom/clevertap/android/sdk/ManifestInfo;Lcom/clevertap/android/sdk/DeviceInfo;Lcom/clevertap/android/sdk/inapp/InAppQueue;Lcom/clevertap/android/sdk/inapp/evaluation/EvaluationManager;Lcom/clevertap/android/sdk/inapp/customtemplates/TemplatesManager;Lcom/clevertap/android/sdk/inapp/InAppActionHandler;Lcom/clevertap/android/sdk/inapp/InAppNotificationInflater;Lcom/clevertap/android/sdk/utils/Clock;)V", "onAppLaunchEventSent", "Lkotlin/Function0;", "", "getOnAppLaunchEventSent", "()Lkotlin/jvm/functions/Function0;", "logger", "Lcom/clevertap/android/sdk/Logger;", "kotlin.jvm.PlatformType", "Lcom/clevertap/android/sdk/Logger;", "defaultLogTag", "", "Ljava/lang/String;", "inAppState", "Lcom/clevertap/android/sdk/inapp/InAppController$InAppState;", "inAppExcludedActivityNames", "", "promptPushPrimer", "jsonObject", "Lorg/json/JSONObject;", "promptPermission", "showFallbackSettings", "", "isPushPermissionGranted", "inAppNotificationActionTriggered", "Landroid/os/Bundle;", "inAppNotification", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "action", "Lcom/clevertap/android/sdk/inapp/CTInAppAction;", "callToAction", "additionalData", "activityContext", "inAppNotificationDidClick", "button", "Lcom/clevertap/android/sdk/inapp/CTInAppNotificationButton;", "inAppNotificationDidDismiss", "formData", "inAppNotificationDidShow", "discardInApps", "resumeInApps", "suspendInApps", "addInAppNotificationsToQueue", "inappNotifs", "Lorg/json/JSONArray;", "onQueueEvent", "eventName", "eventProperties", "", "", "userLocation", "Landroid/location/Location;", "onQueueChargedEvent", "chargeDetails", "items", "", "onQueueProfileEvent", "userAttributeChangedProperties", "location", "onAppLaunchServerSideInAppsResponse", "appLaunchServerSideInApps", "showNotificationIfAvailable", "_showNotificationIfAvailable", "addInAppNotificationInFrontOfQueue", "inApp", "canShowInAppOnActivity", "activity", "Landroid/app/Activity;", "canShowInAppOnCurrentActivity", "displayNotification", "notificationReady", "prepareNotificationForDisplay", "getExcludedActivitiesSet", "checkPendingNotifications", "inAppDidDismiss", "incrementLocalInAppCountInPersistentStore", "checkLimitsBeforeShowing", "checkBeforeShowApprovalBeforeDisplay", "showInApp", "presentTemplate", "filterNonRegisteredCustomTemplates", "inAppNotifications", "isNonRegisteredCustomTemplate", "triggerCustomTemplateAction", "notification", "templateInAppData", "Lcom/clevertap/android/sdk/inapp/customtemplates/CustomTemplateInAppData;", "InAppState", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nInAppController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppController.kt\ncom/clevertap/android/sdk/inapp/InAppController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,810:1\n1#2:811\n*E\n"})
public final class InAppController
implements InAppListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig config;
    @NotNull
    private final CTExecutors executors;
    @NotNull
    private final ControllerManager controllerManager;
    @NotNull
    private final BaseCallbackManager callbackManager;
    @NotNull
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final CoreMetaData coreMetaData;
    @NotNull
    private final DeviceInfo deviceInfo;
    @NotNull
    private final InAppQueue inAppQueue;
    @NotNull
    private final EvaluationManager evaluationManager;
    @NotNull
    private final TemplatesManager templatesManager;
    @NotNull
    private final InAppActionHandler inAppActionHandler;
    @NotNull
    private final InAppNotificationInflater inAppNotificationInflater;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function0<Unit> onAppLaunchEventSent;
    private final Logger logger;
    private final String defaultLogTag;
    @NotNull
    private InAppState inAppState;
    @NotNull
    private final Set<String> inAppExcludedActivityNames;
    @NotNull
    public static final String LOCAL_INAPP_COUNT = "local_in_app_count";
    @NotNull
    public static final String IS_FIRST_TIME_PERMISSION_REQUEST = "firstTimeRequest";
    private static final List<CTInAppNotification> pendingNotifications = Collections.synchronizedList(new ArrayList());
    @Nullable
    private static volatile CTInAppNotification currentlyDisplayingInApp;

    public InAppController(@NotNull Context context, @NotNull CleverTapInstanceConfig config, @NotNull CTExecutors executors, @NotNull ControllerManager controllerManager, @NotNull BaseCallbackManager callbackManager, @NotNull AnalyticsManager analyticsManager, @NotNull CoreMetaData coreMetaData, @NotNull ManifestInfo manifestInfo, @NotNull DeviceInfo deviceInfo, @NotNull InAppQueue inAppQueue, @NotNull EvaluationManager evaluationManager, @NotNull TemplatesManager templatesManager, @NotNull InAppActionHandler inAppActionHandler, @NotNull InAppNotificationInflater inAppNotificationInflater, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)controllerManager, (String)"controllerManager");
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter((Object)analyticsManager, (String)"analyticsManager");
        Intrinsics.checkNotNullParameter((Object)coreMetaData, (String)"coreMetaData");
        Intrinsics.checkNotNullParameter((Object)manifestInfo, (String)"manifestInfo");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        Intrinsics.checkNotNullParameter((Object)inAppQueue, (String)"inAppQueue");
        Intrinsics.checkNotNullParameter((Object)evaluationManager, (String)"evaluationManager");
        Intrinsics.checkNotNullParameter((Object)templatesManager, (String)"templatesManager");
        Intrinsics.checkNotNullParameter((Object)inAppActionHandler, (String)"inAppActionHandler");
        Intrinsics.checkNotNullParameter((Object)inAppNotificationInflater, (String)"inAppNotificationInflater");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.context = context;
        this.config = config;
        this.executors = executors;
        this.controllerManager = controllerManager;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager;
        this.coreMetaData = coreMetaData;
        this.deviceInfo = deviceInfo;
        this.inAppQueue = inAppQueue;
        this.evaluationManager = evaluationManager;
        this.templatesManager = templatesManager;
        this.inAppActionHandler = inAppActionHandler;
        this.inAppNotificationInflater = inAppNotificationInflater;
        this.clock = clock;
        this.onAppLaunchEventSent = () -> InAppController.onAppLaunchEventSent$lambda$0(this);
        this.logger = this.config.getLogger();
        this.defaultLogTag = this.config.getAccountId();
        this.inAppState = InAppState.RESUMED;
        this.inAppExcludedActivityNames = this.getExcludedActivitiesSet(manifestInfo);
    }

    @NotNull
    public final Function0<Unit> getOnAppLaunchEventSent() {
        return this.onAppLaunchEventSent;
    }

    public final void promptPushPrimer(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        jsonObject.put("rfp", true);
        boolean fallbackToSettings = jsonObject.optBoolean("fallbackToNotificationSettings", false);
        this.inAppActionHandler.launchPushPermissionPrompt(fallbackToSettings, fallbackToSettings, arg_0 -> InAppController.promptPushPrimer$lambda$1(this, jsonObject, arg_0));
    }

    public final void promptPermission(boolean showFallbackSettings) {
        this.inAppActionHandler.launchPushPermissionPrompt(showFallbackSettings);
    }

    public final boolean isPushPermissionGranted() {
        return this.inAppActionHandler.arePushNotificationsEnabled();
    }

    @Override
    @NotNull
    public Bundle inAppNotificationActionTriggered(@NotNull CTInAppNotification inAppNotification, @NotNull CTInAppAction action, @NotNull String callToAction, @Nullable Bundle additionalData, @Nullable Context activityContext) {
        InAppActionType type;
        Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)callToAction, (String)"callToAction");
        Bundle data = additionalData != null ? new Bundle(additionalData) : new Bundle();
        data.putString("wzrk_id", inAppNotification.getCampaignId());
        data.putString("wzrk_c2a", callToAction);
        if (!inAppNotification.isLocalInApp()) {
            this.analyticsManager.pushInAppNotificationStateEvent(true, inAppNotification, data);
        }
        if ((type = action.getType()) == null) {
            this.logger.debug("Triggered in-app action without type");
            return data;
        }
        InAppActionType inAppActionType = type;
        switch (WhenMappings.$EnumSwitchMapping$0[inAppActionType.ordinal()]) {
            case 1: {
                this.triggerCustomTemplateAction(inAppNotification, action.getCustomTemplateInAppData());
                break;
            }
            case 2: {
                if (CTInAppType.CTInAppTypeCustomCodeTemplate != inAppNotification.getInAppType()) break;
                this.templatesManager.closeTemplate(inAppNotification);
                break;
            }
            case 3: {
                String actionUrl = action.getActionUrl();
                if (actionUrl != null) {
                    this.inAppActionHandler.openUrl(actionUrl, activityContext);
                    break;
                }
                this.logger.debug("Cannot trigger open url action without url value");
                break;
            }
            case 4: {
                HashMap<String, String> keyValues;
                HashMap<String, String> hashMap = keyValues = action.getKeyValues();
                boolean bl = hashMap != null ? !((Map)hashMap).isEmpty() : false;
                if (!bl || this.callbackManager.getInAppNotificationButtonListener() == null) break;
                this.callbackManager.getInAppNotificationButtonListener().onInAppButtonClick(keyValues);
            }
        }
        return data;
    }

    @Override
    @Nullable
    public Bundle inAppNotificationDidClick(@NotNull CTInAppNotification inAppNotification, @NotNull CTInAppNotificationButton button, @Nullable Context activityContext) {
        Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        CTInAppAction action = button.action;
        if (action == null) {
            return null;
        }
        return this.inAppNotificationActionTriggered(inAppNotification, action, button.getText(), null, activityContext);
    }

    @Override
    public void inAppNotificationDidDismiss(@NotNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
        if (this.controllerManager.getInAppFCManager() != null) {
            Object object = inAppNotification.getCustomTemplateData$clevertap_core_release();
            if (object == null || (object = ((CustomTemplateInAppData)object).getTemplateName()) == null) {
                object = "";
            }
            Object templateName = object;
            this.logger.verbose(this.defaultLogTag, "InApp Dismissed: " + inAppNotification.getCampaignId() + ' ' + (String)templateName);
        } else {
            this.logger.verbose(this.defaultLogTag, "Not calling InApp Dismissed: " + inAppNotification.getCampaignId() + " because InAppFCManager is null");
        }
        try {
            InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = inAppNotification.getCustomExtras$clevertap_core_release() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras$clevertap_core_release()) : new HashMap<String, Object>();
                Logger.v("Calling the in-app listener on behalf of " + this.coreMetaData.getSource());
                if (formData != null) {
                    listener.onDismissed((Map<String, Object>)notifKVS, (Map<String, Object>)Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed((Map<String, Object>)notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.defaultLogTag, "Failed to call the in-app notification listener", t);
        }
        Task<Unit> task = this.executors.postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InappController#inAppNotificationDidDismiss", () -> InAppController.inAppNotificationDidDismiss$lambda$2(this, inAppNotification));
    }

    @Override
    public void inAppNotificationDidShow(@NotNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        Intrinsics.checkNotNullParameter((Object)inAppNotification, (String)"inAppNotification");
        InAppFCManager inAppFCManager = this.controllerManager.getInAppFCManager();
        if (inAppFCManager != null) {
            inAppFCManager.didShow(this.context, inAppNotification);
        }
        this.analyticsManager.pushInAppNotificationStateEvent(false, inAppNotification, formData);
        try {
            InAppNotificationListener inAppNotificationListener = this.callbackManager.getInAppNotificationListener();
            if (inAppNotificationListener != null) {
                inAppNotificationListener.onShow(inAppNotification);
            }
        }
        catch (Throwable t) {
            Logger.v(this.defaultLogTag, "Failed to call the in-app notification listener", t);
        }
    }

    public final void discardInApps() {
        this.inAppState = InAppState.DISCARDED;
        this.logger.verbose(this.defaultLogTag, "InAppState is DISCARDED");
    }

    public final void resumeInApps() {
        this.inAppState = InAppState.RESUMED;
        this.logger.verbose(this.defaultLogTag, "InAppState is RESUMED");
        this.logger.verbose(this.defaultLogTag, "Resuming InApps by calling showInAppNotificationIfAny()");
        this.showNotificationIfAvailable();
    }

    public final void suspendInApps() {
        this.inAppState = InAppState.SUSPENDED;
        this.logger.verbose(this.defaultLogTag, "InAppState is SUSPENDED");
    }

    @WorkerThread
    public final void addInAppNotificationsToQueue(@NotNull JSONArray inappNotifs) {
        Intrinsics.checkNotNullParameter((Object)inappNotifs, (String)"inappNotifs");
        try {
            JSONArray filteredNotifs = this.filterNonRegisteredCustomTemplates(inappNotifs);
            this.inAppQueue.enqueueAll(filteredNotifs);
            this.showNotificationIfAvailable();
        }
        catch (Exception e) {
            this.logger.debug(this.defaultLogTag, "InAppController: : InApp notification handling error.", e);
        }
    }

    @WorkerThread
    public final void onQueueEvent(@NotNull String eventName, @NotNull Map<String, ? extends Object> eventProperties, @Nullable Location userLocation) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(eventProperties, (String)"eventProperties");
        Map appFieldsWithEventProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        appFieldsWithEventProperties.putAll(eventProperties);
        Intrinsics.checkNotNull(appFieldsWithEventProperties);
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnEvent(eventName, appFieldsWithEventProperties, userLocation);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    @WorkerThread
    public final void onQueueChargedEvent(@NotNull Map<String, ? extends Object> chargeDetails, @NotNull List<? extends Map<String, ? extends Object>> items, @Nullable Location userLocation) {
        Intrinsics.checkNotNullParameter(chargeDetails, (String)"chargeDetails");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Map appFieldsWithChargedEventProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        appFieldsWithChargedEventProperties.putAll(chargeDetails);
        Intrinsics.checkNotNull(appFieldsWithChargedEventProperties);
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnChargedEvent(appFieldsWithChargedEventProperties, items, userLocation);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    @WorkerThread
    public final void onQueueProfileEvent(@NotNull Map<String, ? extends Map<String, ? extends Object>> userAttributeChangedProperties, @Nullable Location location) {
        Intrinsics.checkNotNullParameter(userAttributeChangedProperties, (String)"userAttributeChangedProperties");
        Map appFields = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        Intrinsics.checkNotNull(appFields);
        JSONArray clientSideInAppsToDisplay = this.evaluationManager.evaluateOnUserAttributeChange(userAttributeChangedProperties, location, appFields);
        if (clientSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
    }

    public final void onAppLaunchServerSideInAppsResponse(@NotNull JSONArray appLaunchServerSideInApps, @Nullable Location userLocation) {
        Intrinsics.checkNotNullParameter((Object)appLaunchServerSideInApps, (String)"appLaunchServerSideInApps");
        Map appLaunchedProperties = JsonUtil.mapFromJson(this.deviceInfo.getAppLaunchedFields());
        List<JSONObject> appLaunchSsInAppList = Utils.toJSONObjectList(appLaunchServerSideInApps);
        Intrinsics.checkNotNull(appLaunchSsInAppList);
        Intrinsics.checkNotNull(appLaunchedProperties);
        JSONArray serverSideInAppsToDisplay = this.evaluationManager.evaluateOnAppLaunchedServerSide(appLaunchSsInAppList, appLaunchedProperties, userLocation);
        if (serverSideInAppsToDisplay.length() > 0) {
            this.addInAppNotificationsToQueue(serverSideInAppsToDisplay);
        }
    }

    public final void showNotificationIfAvailable() {
        if (!this.config.isAnalyticsOnly()) {
            Task<Unit> task = this.executors.postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InappController#showNotificationIfAvailable", () -> InAppController.showNotificationIfAvailable$lambda$3(this));
        }
    }

    private final void _showNotificationIfAvailable() {
        try {
            if (!this.canShowInAppOnCurrentActivity()) {
                Logger.v("Not showing notification on blacklisted activity");
                return;
            }
            if (this.inAppState == InAppState.SUSPENDED) {
                this.logger.debug(this.defaultLogTag, "InApp Notifications are set to be suspended, not showing the InApp Notification");
                return;
            }
            if (this.checkPendingNotifications()) {
                return;
            }
            JSONObject inapp = this.inAppQueue.dequeue();
            if (inapp == null) {
                return;
            }
            if (this.inAppState != InAppState.DISCARDED) {
                this.prepareNotificationForDisplay(inapp);
            } else {
                this.logger.debug(this.defaultLogTag, "InApp Notifications are set to be discarded, dropping the InApp Notification");
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.defaultLogTag, "InApp: Couldn't parse JSON array string from prefs", t);
        }
    }

    private final void addInAppNotificationInFrontOfQueue(JSONObject inApp) {
        if (this.isNonRegisteredCustomTemplate(inApp)) {
            return;
        }
        this.inAppQueue.insertInFront(inApp);
        this.showNotificationIfAvailable();
    }

    private final boolean canShowInAppOnActivity(Activity activity) {
        if (activity == null) {
            return true;
        }
        String string2 = activity.getLocalClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalClassName(...)");
        String activityName = string2;
        for (String blacklistedActivity : this.inAppExcludedActivityNames) {
            if (!StringsKt.contains$default((CharSequence)activityName, (CharSequence)blacklistedActivity, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean canShowInAppOnCurrentActivity() {
        return this.canShowInAppOnActivity(CoreMetaData.getCurrentActivity());
    }

    private final void displayNotification(CTInAppNotification inAppNotification) {
        if (!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            this.executors.mainTask().execute("InAppController:displayNotification", () -> InAppController.displayNotification$lambda$4(this, inAppNotification));
            return;
        }
        if (inAppNotification.isRequestForPushPermission() && this.inAppActionHandler.arePushNotificationsEnabled()) {
            this.logger.verbose(this.defaultLogTag, "Not showing push permission request, permission is already granted");
            this.inAppActionHandler.notifyPushPermissionListeners();
            this.showNotificationIfAvailable();
            return;
        }
        this.checkLimitsBeforeShowing(inAppNotification);
        this.incrementLocalInAppCountInPersistentStore(this.context, inAppNotification);
    }

    private final void notificationReady(CTInAppNotification inAppNotification) {
        CustomTemplate customTemplate;
        if (inAppNotification.getError$clevertap_core_release() != null) {
            this.logger.debug(this.defaultLogTag, "Unable to process inapp notification " + inAppNotification.getError$clevertap_core_release());
            return;
        }
        CustomTemplateInAppData templateData = inAppNotification.getCustomTemplateData$clevertap_core_release();
        Object object = templateData;
        if (object != null && (object = ((CustomTemplateInAppData)object).getTemplateName()) != null) {
            Object it = object;
            boolean bl = false;
            customTemplate = this.templatesManager.getTemplate((String)it);
        } else {
            customTemplate = null;
        }
        CustomTemplate template = customTemplate;
        this.logger.debug(this.defaultLogTag, "Notification ready: " + inAppNotification.getJsonDescription());
        if (template != null && !template.isVisual()) {
            this.presentTemplate(inAppNotification);
        } else {
            this.displayNotification(inAppNotification);
        }
    }

    private final void prepareNotificationForDisplay(JSONObject jsonObject) {
        this.logger.debug(this.defaultLogTag, "Preparing In-App for display: " + jsonObject);
        this.inAppNotificationInflater.inflate(jsonObject, "InappController#prepareNotificationForDisplay", new InAppNotificationInflater.InAppNotificationReadyListener(this){
            final /* synthetic */ InAppController $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onNotificationReady(CTInAppNotification p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                InAppController.access$notificationReady(this.$tmp0, p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, InAppController.class, "notificationReady", "notificationReady(Lcom/clevertap/android/sdk/inapp/CTInAppNotification;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof InAppNotificationInflater.InAppNotificationReadyListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    private final Set<String> getExcludedActivitiesSet(ManifestInfo manifestInfo) {
        Set inAppActivityExclude = new LinkedHashSet();
        String activitiesString = manifestInfo.getExcludedActivities();
        if (activitiesString != null) {
            String[] stringArray = new String[]{","};
            List split = StringsKt.split$default((CharSequence)activitiesString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String activityName : split) {
                String trimmed = ((Object)StringsKt.trim((CharSequence)activityName)).toString();
                if (!(!StringsKt.isBlank((CharSequence)trimmed))) continue;
                inAppActivityExclude.add(trimmed);
            }
        }
        this.logger.debug(this.defaultLogTag, "In-app notifications will not be shown on " + CollectionsKt.joinToString$default((Iterable)inAppActivityExclude, null, null, null, (int)0, null, null, (int)63, null));
        return inAppActivityExclude;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkPendingNotifications() {
        Logger.v(this.defaultLogTag, "checking Pending Notifications");
        List<CTInAppNotification> list = pendingNotifications;
        Intrinsics.checkNotNullExpressionValue(list, (String)"pendingNotifications");
        List<CTInAppNotification> list2 = list;
        synchronized (list2) {
            block4: {
                boolean bl = false;
                if (!pendingNotifications.isEmpty()) break block4;
                boolean bl2 = false;
                return bl2;
            }
            CTInAppNotification notification = pendingNotifications.remove(0);
            Intrinsics.checkNotNull((Object)notification);
            this.checkLimitsBeforeShowing(notification);
            boolean bl = true;
            return bl;
        }
    }

    private final void inAppDidDismiss(CTInAppNotification inAppNotification) {
        Logger.v(this.defaultLogTag, "Running inAppDidDismiss");
        if (currentlyDisplayingInApp != null) {
            CTInAppNotification cTInAppNotification = currentlyDisplayingInApp;
            if (Intrinsics.areEqual((Object)(cTInAppNotification != null ? cTInAppNotification.getCampaignId() : null), (Object)inAppNotification.getCampaignId())) {
                currentlyDisplayingInApp = null;
                this.checkPendingNotifications();
            }
        }
    }

    private final void incrementLocalInAppCountInPersistentStore(Context context, CTInAppNotification inAppNotification) {
        if (inAppNotification.isLocalInApp()) {
            this.deviceInfo.incrementLocalInAppCount();
            Task<Unit> task = this.executors.ioTask();
            task.execute("InAppController#incrementLocalInAppCountInPersistentStore", () -> InAppController.incrementLocalInAppCountInPersistentStore$lambda$7(context, this));
        }
    }

    private final void checkLimitsBeforeShowing(CTInAppNotification inAppNotification) {
        Task<Boolean> task = this.executors.ioTask();
        task.addOnSuccessListener(arg_0 -> InAppController.checkLimitsBeforeShowing$lambda$8(this, inAppNotification, arg_0));
        task.execute("checkLimitsBeforeShowing", () -> InAppController.checkLimitsBeforeShowing$lambda$10(this, inAppNotification));
    }

    private final boolean checkBeforeShowApprovalBeforeDisplay(CTInAppNotification inAppNotification) {
        boolean bl;
        InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs = inAppNotification.getCustomExtras$clevertap_core_release() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras$clevertap_core_release()) : new HashMap<String, Object>();
            bl = listener.beforeShow((Map<String, Object>)kvs);
        } else {
            bl = true;
        }
        return bl;
    }

    private final void showInApp(CTInAppNotification inAppNotification) {
        CTInAppType type;
        Activity activity = CoreMetaData.getCurrentActivity();
        boolean goFromListener = this.checkBeforeShowApprovalBeforeDisplay(inAppNotification);
        if (!goFromListener) {
            this.logger.verbose(this.defaultLogTag, "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            this.showNotificationIfAvailable();
            return;
        }
        Logger.v(this.defaultLogTag, "Attempting to show next In-App");
        if (!CoreMetaData.isAppForeground()) {
            pendingNotifications.add(inAppNotification);
            Logger.v(this.defaultLogTag, "Not in foreground, queueing this In App");
            return;
        }
        if (currentlyDisplayingInApp != null) {
            pendingNotifications.add(inAppNotification);
            Logger.v(this.defaultLogTag, "In App already displaying, queueing this In App");
            return;
        }
        if (!this.canShowInAppOnActivity(activity)) {
            pendingNotifications.add(inAppNotification);
            Logger.v(this.defaultLogTag, "Not showing In App on blacklisted activity, queuing this In App");
            return;
        }
        if (this.clock.currentTimeMillis() / (long)1000 > inAppNotification.getTimeToLive()) {
            Logger.d("InApp has elapsed its time to live, not showing the InApp");
            return;
        }
        boolean isHtmlType = Intrinsics.areEqual((Object)"custom-html", (Object)inAppNotification.getType$clevertap_core_release());
        if (isHtmlType && !NetworkManager.Companion.isNetworkOnline(this.context)) {
            Logger.d(this.defaultLogTag, "Not showing HTML InApp due to no internet. An active internet connection is required to display the HTML InApp");
            this.showNotificationIfAvailable();
            return;
        }
        currentlyDisplayingInApp = inAppNotification;
        CTInAppBaseFragment inAppFragment = null;
        CTInAppType cTInAppType = type = inAppNotification.getInAppType();
        switch (cTInAppType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cTInAppType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                try {
                    if (activity == null) {
                        throw new IllegalStateException("Current activity reference not found");
                    }
                    Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                    InAppNotificationActivity.launchForInAppNotification((Context)activity, inAppNotification, this.config);
                    break;
                }
                catch (Throwable t) {
                    Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
                    currentlyDisplayingInApp = null;
                    return;
                }
            }
            case 11: {
                inAppFragment = new CTInAppHtmlFooterFragment();
                break;
            }
            case 12: {
                inAppFragment = new CTInAppHtmlHeaderFragment();
                break;
            }
            case 13: {
                inAppFragment = new CTInAppNativeFooterFragment();
                break;
            }
            case 14: {
                inAppFragment = new CTInAppNativeHeaderFragment();
                break;
            }
            case 15: {
                this.presentTemplate(inAppNotification);
                return;
            }
            default: {
                Logger.d(this.defaultLogTag, "Unknown InApp Type found: " + (Object)((Object)type));
                currentlyDisplayingInApp = null;
                return;
            }
        }
        if (inAppFragment != null) {
            Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
            Intrinsics.checkNotNull((Object)activity);
            String string2 = this.defaultLogTag;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultLogTag");
            boolean showFragmentSuccess = CTInAppBaseFragment.Companion.showOnActivity(inAppFragment, activity, inAppNotification, this.config, string2);
            if (!showFragmentSuccess) {
                currentlyDisplayingInApp = null;
            }
        }
    }

    private final void presentTemplate(CTInAppNotification inAppNotification) {
        this.templatesManager.presentTemplate(inAppNotification, this, FileResourceProvider.Companion.getInstance(this.context, this.logger));
    }

    private final JSONArray filterNonRegisteredCustomTemplates(JSONArray inAppNotifications) {
        return JsonUtilsKt.filterObjects(inAppNotifications, (Function1<? super JSONObject, Boolean>)((Function1)arg_0 -> InAppController.filterNonRegisteredCustomTemplates$lambda$11(this, arg_0)));
    }

    private final boolean isNonRegisteredCustomTemplate(JSONObject inApp) {
        boolean isNonRegistered;
        CustomTemplateInAppData customTemplateInAppData = CustomTemplateInAppData.CREATOR.createFromJson(inApp);
        String templateName = customTemplateInAppData != null ? customTemplateInAppData.getTemplateName() : null;
        boolean bl = isNonRegistered = templateName != null && !this.templatesManager.isTemplateRegistered(templateName);
        if (isNonRegistered) {
            this.logger.info("CustomTemplates", "Template with name \"" + templateName + "\" is not registered and cannot be presented");
        }
        return isNonRegistered;
    }

    private final void triggerCustomTemplateAction(CTInAppNotification notification, CustomTemplateInAppData templateInAppData) {
        String templateName;
        CustomTemplateInAppData customTemplateInAppData = templateInAppData;
        String string2 = templateName = customTemplateInAppData != null ? customTemplateInAppData.getTemplateName() : null;
        if (templateName != null) {
            CustomTemplate template = this.templatesManager.getTemplate(templateName);
            if (template != null) {
                CustomTemplateInAppData actionTemplateData = templateInAppData.copy$clevertap_core_release();
                actionTemplateData.setAction$clevertap_core_release(true);
                CTInAppNotification notificationFromAction = notification.createNotificationForAction$clevertap_core_release(actionTemplateData);
                if (notificationFromAction == null) {
                    this.logger.debug("Failed to present custom template with name: " + templateName);
                    return;
                }
                if (template.isVisual()) {
                    this.addInAppNotificationInFrontOfQueue(notificationFromAction.getJsonDescription());
                } else {
                    this.prepareNotificationForDisplay(notificationFromAction.getJsonDescription());
                }
            } else {
                this.logger.debug("Cannot present non-registered template with name: " + templateName);
            }
        } else {
            this.logger.debug("Cannot present template without name.");
        }
    }

    private static final Unit onAppLaunchEventSent$lambda$0(InAppController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map appLaunchedProperties = JsonUtil.mapFromJson(this$0.deviceInfo.getAppLaunchedFields());
        EvaluationManager evaluationManager = this$0.evaluationManager;
        Intrinsics.checkNotNull(appLaunchedProperties);
        JSONArray clientSideInAppsToDisplay = evaluationManager.evaluateOnAppLaunchedClientSide(appLaunchedProperties, this$0.coreMetaData.getLocationFromUser());
        if (clientSideInAppsToDisplay.length() > 0) {
            this$0.addInAppNotificationsToQueue(clientSideInAppsToDisplay);
        }
        return Unit.INSTANCE;
    }

    private static final void promptPushPrimer$lambda$1(InAppController this$0, JSONObject $jsonObject, Activity activity) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jsonObject, (String)"$jsonObject");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this$0.prepareNotificationForDisplay($jsonObject);
    }

    private static final Unit inAppNotificationDidDismiss$lambda$2(InAppController this$0, CTInAppNotification $inAppNotification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inAppNotification, (String)"$inAppNotification");
        this$0.inAppDidDismiss($inAppNotification);
        this$0._showNotificationIfAvailable();
        return Unit.INSTANCE;
    }

    private static final Unit showNotificationIfAvailable$lambda$3(InAppController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0._showNotificationIfAvailable();
        return Unit.INSTANCE;
    }

    private static final Unit displayNotification$lambda$4(InAppController this$0, CTInAppNotification $inAppNotification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inAppNotification, (String)"$inAppNotification");
        this$0.displayNotification($inAppNotification);
        return Unit.INSTANCE;
    }

    private static final Unit incrementLocalInAppCountInPersistentStore$lambda$7(Context $context, InAppController this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StorageHelper.putIntImmediate($context, LOCAL_INAPP_COUNT, this$0.deviceInfo.getLocalInAppCount());
        return Unit.INSTANCE;
    }

    private static final void checkLimitsBeforeShowing$lambda$8(InAppController this$0, CTInAppNotification $inAppNotification, Boolean canShow) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inAppNotification, (String)"$inAppNotification");
        if (canShow.booleanValue()) {
            this$0.showInApp($inAppNotification);
        } else {
            this$0.showNotificationIfAvailable();
        }
    }

    private static final boolean checkLimitsBeforeShowing$lambda$10$lambda$9(InAppController this$0, JSONObject inAppJSON, String inAppId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)inAppJSON, (String)"inAppJSON");
        Intrinsics.checkNotNullParameter((Object)inAppId, (String)"inAppId");
        List<LimitAdapter> listOfWhenLimits = InAppResponseAdapter.Companion.getListOfWhenLimits(inAppJSON);
        return !this$0.evaluationManager.matchWhenLimitsBeforeDisplay(listOfWhenLimits, inAppId);
    }

    private static final Boolean checkLimitsBeforeShowing$lambda$10(InAppController this$0, CTInAppNotification $inAppNotification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inAppNotification, (String)"$inAppNotification");
        InAppFCManager inAppFCManager = this$0.controllerManager.getInAppFCManager();
        if (inAppFCManager != null) {
            Function2 hasInAppFrequencyLimitsMaxedOut = (arg_0, arg_1) -> InAppController.checkLimitsBeforeShowing$lambda$10$lambda$9(this$0, arg_0, arg_1);
            if (!inAppFCManager.canShow($inAppNotification, (Function2<JSONObject, String, Boolean>)hasInAppFrequencyLimitsMaxedOut)) {
                this$0.logger.verbose(this$0.defaultLogTag, "InApp has been rejected by FC, not showing " + $inAppNotification.getCampaignId());
                return false;
            }
        } else {
            this$0.logger.verbose(this$0.defaultLogTag, "InAppFCManager() is null, not showing " + $inAppNotification.getCampaignId());
            return false;
        }
        return true;
    }

    private static final boolean filterNonRegisteredCustomTemplates$lambda$11(InAppController this$0, JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        return !this$0.isNonRegisteredCustomTemplate(jsonObject);
    }

    public static final /* synthetic */ void access$notificationReady(InAppController $this, CTInAppNotification inAppNotification) {
        $this.notificationReady(inAppNotification);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR*\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\t8\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppController$Companion;", "", "<init>", "()V", "LOCAL_INAPP_COUNT", "", "IS_FIRST_TIME_PERMISSION_REQUEST", "pendingNotifications", "", "Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "value", "currentlyDisplayingInApp", "getCurrentlyDisplayingInApp$clevertap_core_release$annotations", "getCurrentlyDisplayingInApp$clevertap_core_release", "()Lcom/clevertap/android/sdk/inapp/CTInAppNotification;", "clearCurrentlyDisplayingInApp", "", "clearCurrentlyDisplayingInApp$clevertap_core_release", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CTInAppNotification getCurrentlyDisplayingInApp$clevertap_core_release() {
            return currentlyDisplayingInApp;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCurrentlyDisplayingInApp$clevertap_core_release$annotations() {
        }

        @VisibleForTesting
        public final void clearCurrentlyDisplayingInApp$clevertap_core_release() {
            currentlyDisplayingInApp = null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppController$InAppState;", "", "<init>", "(Ljava/lang/String;I)V", "DISCARDED", "SUSPENDED", "RESUMED", "clevertap-core_release"})
    private static final class InAppState
    extends Enum<InAppState> {
        public static final /* enum */ InAppState DISCARDED = new InAppState();
        public static final /* enum */ InAppState SUSPENDED = new InAppState();
        public static final /* enum */ InAppState RESUMED = new InAppState();
        private static final /* synthetic */ InAppState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InAppState[] values() {
            return (InAppState[])$VALUES.clone();
        }

        public static InAppState valueOf(String value) {
            return Enum.valueOf(InAppState.class, value);
        }

        @NotNull
        public static EnumEntries<InAppState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inAppStateArray = new InAppState[]{InAppState.DISCARDED, InAppState.SUSPENDED, InAppState.RESUMED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InAppActionType.values().length];
            try {
                nArray[InAppActionType.CUSTOM_CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppActionType.CLOSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppActionType.OPEN_URL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InAppActionType.KEY_VALUES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CTInAppType.values().length];
            try {
                nArray[CTInAppType.CTInAppTypeCoverHTML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeInterstitialHTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeHalfInterstitialHTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeCover.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeHalfInterstitial.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeInterstitial.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeAlert.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeInterstitialImageOnly.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeHalfInterstitialImageOnly.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeCoverImageOnly.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeFooterHTML.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeHeaderHTML.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeFooter.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeHeader.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CTInAppType.CTInAppTypeCustomCodeTemplate.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

