/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.events;

import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ProfileValueHandler;
import com.clevertap.android.sdk.network.NetworkRepo;
import com.clevertap.android.sdk.validation.Validator;
import com.clevertap.android.sdk.variables.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventMediator {
    private final CoreMetaData cleverTapMetaData;
    private final CleverTapInstanceConfig config;
    private final LocalDataStore localDataStore;
    private final NetworkRepo networkRepo;
    private final ProfileValueHandler profileValueHandler;

    public EventMediator(CleverTapInstanceConfig config, CoreMetaData coreMetaData, LocalDataStore localDataStore, ProfileValueHandler profileValueHandler, NetworkRepo networkRepo) {
        this.config = config;
        this.localDataStore = localDataStore;
        this.networkRepo = networkRepo;
        this.profileValueHandler = profileValueHandler;
        this.cleverTapMetaData = coreMetaData;
    }

    public boolean shouldDeferProcessingEvent(JSONObject event, int eventType) {
        if (eventType == 8) {
            return false;
        }
        if (this.config.isCreatedPostAppLaunch()) {
            return false;
        }
        if (event.has("evtName")) {
            try {
                if (Arrays.asList(Constants.SYSTEM_EVENTS).contains(event.getString("evtName"))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return eventType == 4 && !this.cleverTapMetaData.isAppLaunchPushed();
    }

    public boolean shouldDropEvent(JSONObject event, int eventType) {
        boolean dropEvent;
        if (eventType == 7 || eventType == 8) {
            return false;
        }
        if (this.networkRepo.isMuted()) {
            this.config.getLogger().verbose(this.config.getAccountId(), "CleverTap is muted, dropping event - " + event.toString());
            return true;
        }
        if (!this.cleverTapMetaData.isCurrentUserOptedOut()) {
            return false;
        }
        if (!this.cleverTapMetaData.getEnabledSystemEvents()) {
            this.config.getLogger().debug(this.config.getAccountId(), "Current user is opted out dropping event: " + event);
            return true;
        }
        if (eventType != 4 && eventType != 6) {
            this.config.getLogger().debug(this.config.getAccountId(), "This is not RAISED_EVENT or NV_EVENT, not dropping event: " + event);
            return false;
        }
        String eName = event != null ? this.getEventName(event) : null;
        boolean isSystemEvent = Arrays.asList(Validator.restrictedNames).contains(eName);
        boolean bl = dropEvent = !isSystemEvent;
        if (dropEvent) {
            this.config.getLogger().debug(this.config.getAccountId(), "Current user is opted out dropping event: " + event);
        } else {
            this.config.getLogger().debug(this.config.getAccountId(), "This is a system event, not dropping event: " + event);
        }
        return dropEvent;
    }

    public boolean isAppLaunchedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("App Launched");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean isEvent(JSONObject event) {
        return event.has("evtName");
    }

    public String getEventName(JSONObject event) {
        try {
            return event.getString("evtName");
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Map<String, Object> getEventProperties(JSONObject event) {
        if (event.has("evtName") && event.has("evtData")) {
            try {
                return JsonUtil.mapFromJson(event.getJSONObject("evtData"));
            }
            catch (JSONException e) {
                Logger.v("Could not convert JSONObject to Map - " + e.getMessage());
            }
        }
        return new HashMap<String, Object>();
    }

    public boolean isChargedEvent(JSONObject event) {
        try {
            return event.has("evtName") && event.getString("evtName").equals("Charged");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public List<Map<String, Object>> getChargedEventItemDetails(JSONObject event) {
        try {
            return JsonUtil.listFromJson(event.getJSONObject("evtData").getJSONArray("Items"));
        }
        catch (JSONException e) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    public Map<String, Object> getChargedEventDetails(JSONObject event) {
        try {
            Object items = event.getJSONObject("evtData").remove("Items");
            Map<String, Object> chargedDetails = JsonUtil.mapFromJson(event.getJSONObject("evtData"));
            event.getJSONObject("evtData").put("Items", items);
            return chargedDetails;
        }
        catch (JSONException e) {
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Map<String, Object>> computeUserAttributeChangeProperties(JSONObject event) {
        HashMap<String, Map<String, Object>> userAttributesChangeProperties = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> fieldsToPersistLocally = new HashMap<String, Object>();
        JSONObject profile = event.optJSONObject("profile");
        if (profile == null) {
            return userAttributesChangeProperties;
        }
        Iterator keys = profile.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                if (Constants.keysToSkipForUserAttributesEvaluation.contains(key)) continue;
                Object oldValue = this.localDataStore.getProfileProperty(key);
                Object newValue = profile.get(key);
                if (newValue instanceof JSONObject) {
                    String commandIdentifier;
                    JSONObject obj = (JSONObject)newValue;
                    switch (commandIdentifier = (String)obj.keys().next()) {
                        case "$incr": 
                        case "$decr": {
                            newValue = this.profileValueHandler.handleIncrementDecrementValues((Number)obj.get(commandIdentifier), commandIdentifier, (Number)oldValue);
                            break;
                        }
                        case "$delete": {
                            newValue = null;
                            break;
                        }
                        case "$set": 
                        case "$add": 
                        case "$remove": {
                            newValue = this.profileValueHandler.handleMultiValues(key, (JSONArray)obj.get(commandIdentifier), commandIdentifier, oldValue);
                        }
                    }
                } else if (newValue instanceof String && ((String)newValue).startsWith("$D_")) {
                    newValue = Long.parseLong(((String)newValue).substring("$D_".length()));
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                if (oldValue != null && !(oldValue instanceof JSONArray)) {
                    properties.put("oldValue", oldValue);
                }
                if (newValue != null && !(newValue instanceof JSONArray)) {
                    properties.put("newValue", newValue);
                }
                if (!properties.isEmpty()) {
                    userAttributesChangeProperties.put(key, properties);
                }
                fieldsToPersistLocally.put(key, newValue);
            }
            catch (JSONException e) {
                this.config.getLogger().debug(this.config.getAccountId(), "Error getting user attribute changes for key: " + key + (Object)((Object)e));
            }
        }
        this.localDataStore.updateProfileFields(fieldsToPersistLocally);
        return userAttributesChangeProperties;
    }
}

