/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushPermissionHandler;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.utils.PlayStoreReviewHandler;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001(B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0015\u001a\u00020\u0011JN\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u001928\u0010\u001a\u001a4\u0012*\u0012(\u0018\u00010 j\u0013\u0018\u0001`\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00170\u001bJ\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011J \u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\b\b\u0002\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppActionHandler;", "", "context", "Landroid/content/Context;", "ctConfig", "Lcom/clevertap/android/sdk/CleverTapInstanceConfig;", "pushPermissionHandler", "Lcom/clevertap/android/sdk/PushPermissionHandler;", "playStoreReviewHandler", "Lcom/clevertap/android/sdk/utils/PlayStoreReviewHandler;", "<init>", "(Landroid/content/Context;Lcom/clevertap/android/sdk/CleverTapInstanceConfig;Lcom/clevertap/android/sdk/PushPermissionHandler;Lcom/clevertap/android/sdk/utils/PlayStoreReviewHandler;)V", "logger", "Lcom/clevertap/android/sdk/Logger;", "kotlin.jvm.PlatformType", "Lcom/clevertap/android/sdk/Logger;", "openUrl", "", "url", "", "launchContext", "isPlayStoreReviewLibraryAvailable", "launchPlayStoreReviewFlow", "", "onCompleted", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lkotlin/Exception;", "Lkotlin/ParameterName;", "name", "e", "Ljava/lang/Exception;", "arePushNotificationsEnabled", "notifyPushPermissionListeners", "launchPushPermissionPrompt", "fallbackToSettings", "alwaysRequestIfNotGranted", "presenter", "Lcom/clevertap/android/sdk/inapp/InAppActionHandler$PushPermissionPromptPresenter;", "PushPermissionPromptPresenter", "clevertap-core_release"})
public final class InAppActionHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final CleverTapInstanceConfig ctConfig;
    @NotNull
    private final PushPermissionHandler pushPermissionHandler;
    @NotNull
    private final PlayStoreReviewHandler playStoreReviewHandler;
    private final Logger logger;

    public InAppActionHandler(@NotNull Context context, @NotNull CleverTapInstanceConfig ctConfig, @NotNull PushPermissionHandler pushPermissionHandler, @NotNull PlayStoreReviewHandler playStoreReviewHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ctConfig, (String)"ctConfig");
        Intrinsics.checkNotNullParameter((Object)pushPermissionHandler, (String)"pushPermissionHandler");
        Intrinsics.checkNotNullParameter((Object)playStoreReviewHandler, (String)"playStoreReviewHandler");
        this.context = context;
        this.ctConfig = ctConfig;
        this.pushPermissionHandler = pushPermissionHandler;
        this.playStoreReviewHandler = playStoreReviewHandler;
        this.logger = this.ctConfig.getLogger();
    }

    public /* synthetic */ InAppActionHandler(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, PushPermissionHandler pushPermissionHandler, PlayStoreReviewHandler playStoreReviewHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            playStoreReviewHandler = new PlayStoreReviewHandler();
        }
        this(context, cleverTapInstanceConfig, pushPermissionHandler, playStoreReviewHandler);
    }

    public final boolean openUrl(@NotNull String url, @Nullable Context launchContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Context context;
            Uri uri = Uri.parse((String)StringsKt.replace$default((String)StringsKt.replace$default((String)url, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null));
            Set queryParamSet = uri.getQueryParameterNames();
            Bundle queryBundle = new Bundle();
            Collection collection = queryParamSet;
            if (!(collection == null || collection.isEmpty())) {
                for (String queryName : queryParamSet) {
                    queryBundle.putString(queryName, uri.getQueryParameter(queryName));
                }
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!queryBundle.isEmpty()) {
                intent.putExtras(queryBundle);
            }
            if (launchContext != null) {
                context = launchContext;
            } else {
                intent.setFlags(0x10000000);
                context = this.context;
            }
            Context context2 = context;
            Utils.setPackageNameFromResolveInfoList(context2, intent);
            context2.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            if (StringsKt.startsWith$default((String)url, (String)"wzrk://", (boolean)false, (int)2, null)) {
                return true;
            }
            this.logger.debug("No activity found to open url: " + url);
            return false;
        }
    }

    public static /* synthetic */ boolean openUrl$default(InAppActionHandler inAppActionHandler, String string2, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return inAppActionHandler.openUrl(string2, context);
    }

    public final boolean isPlayStoreReviewLibraryAvailable() {
        return this.playStoreReviewHandler.isPlayStoreReviewLibraryAvailable();
    }

    public final void launchPlayStoreReviewFlow(@NotNull Function0<Unit> onCompleted, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.playStoreReviewHandler.launchReview(this.context, logger, onCompleted, onError);
    }

    public final boolean arePushNotificationsEnabled() {
        return this.pushPermissionHandler.isPushPermissionGranted(this.context);
    }

    public final void notifyPushPermissionListeners() {
        this.pushPermissionHandler.notifyPushPermissionListeners(this.context);
    }

    public final boolean launchPushPermissionPrompt(boolean fallbackToSettings) {
        return InAppActionHandler.launchPushPermissionPrompt$default(this, fallbackToSettings, false, arg_0 -> InAppActionHandler.launchPushPermissionPrompt$lambda$0(fallbackToSettings, this, arg_0), 2, null);
    }

    public final boolean launchPushPermissionPrompt(boolean fallbackToSettings, boolean alwaysRequestIfNotGranted, @NotNull PushPermissionPromptPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        Activity currentActivity = CoreMetaData.getCurrentActivity();
        if (currentActivity == null) {
            this.logger.debug("CurrentActivity reference is null. SDK can't prompt the user with Notification Permission! Ensure the following things:\n1. Calling ActivityLifecycleCallback.register(this) in your custom application class before super.onCreate().\n   Alternatively, register CleverTap SDK's Application class in the manifest using com.clevertap.android.sdk.Application.\n2. Ensure that the promptPushPrimer() API is called from the onResume() lifecycle method, not onCreate().");
            return false;
        }
        return this.pushPermissionHandler.requestPermission(currentActivity, fallbackToSettings, new PushPermissionHandler.PushPermissionRequestCallback(presenter, currentActivity){
            final /* synthetic */ PushPermissionPromptPresenter $presenter;
            final /* synthetic */ Activity $currentActivity;
            {
                this.$presenter = $presenter;
                this.$currentActivity = $currentActivity;
            }

            public void onRequestPermission() {
                this.$presenter.showPrompt(this.$currentActivity);
            }
        }, alwaysRequestIfNotGranted);
    }

    public static /* synthetic */ boolean launchPushPermissionPrompt$default(InAppActionHandler inAppActionHandler, boolean bl, boolean bl2, PushPermissionPromptPresenter pushPermissionPromptPresenter, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return inAppActionHandler.launchPushPermissionPrompt(bl, bl2, pushPermissionPromptPresenter);
    }

    private static final void launchPushPermissionPrompt$lambda$0(boolean $fallbackToSettings, InAppActionHandler this$0, Activity activity) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activity instanceof InAppNotificationActivity) {
            ((InAppNotificationActivity)activity).showPushPermissionPrompt($fallbackToSettings);
        } else {
            InAppNotificationActivity.launchForPushPermissionPrompt(activity, this$0.ctConfig, $fallbackToSettings);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/inapp/InAppActionHandler$PushPermissionPromptPresenter;", "", "showPrompt", "", "activity", "Landroid/app/Activity;", "clevertap-core_release"})
    public static interface PushPermissionPromptPresenter {
        public void showPrompt(@NotNull Activity var1);
    }
}

