/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import android.content.Context;
import com.clevertap.android.sdk.cryption.AESCrypt;
import com.clevertap.android.sdk.cryption.AESGCMCrypt;
import com.clevertap.android.sdk.cryption.Crypt;
import com.clevertap.android.sdk.cryption.CryptHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptFactory;", "", "context", "Landroid/content/Context;", "accountId", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;)V", "cryptInstances", "", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "Lcom/clevertap/android/sdk/cryption/Crypt;", "getCryptInstance", "algorithm", "Companion", "clevertap-core_release"})
@SourceDebugExtension(value={"SMAP\nCryptFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptFactory.kt\ncom/clevertap/android/sdk/cryption/CryptFactory\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,36:1\n381#2,7:37\n*S KotlinDebug\n*F\n+ 1 CryptFactory.kt\ncom/clevertap/android/sdk/cryption/CryptFactory\n*L\n34#1:37,7\n*E\n"})
public final class CryptFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String accountId;
    @NotNull
    private final Map<CryptHandler.EncryptionAlgorithm, Crypt> cryptInstances;

    public CryptFactory(@NotNull Context context, @NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        this.context = context;
        this.accountId = accountId;
        this.cryptInstances = new LinkedHashMap();
    }

    @NotNull
    public final Crypt getCryptInstance(@NotNull CryptHandler.EncryptionAlgorithm algorithm) {
        Crypt crypt;
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Map<CryptHandler.EncryptionAlgorithm, Crypt> $this$getOrPut$iv = this.cryptInstances;
        boolean $i$f$getOrPut = false;
        Crypt value$iv = $this$getOrPut$iv.get((Object)algorithm);
        if (value$iv == null) {
            boolean bl = false;
            Crypt answer$iv = Companion.getCrypt(algorithm, this.accountId, this.context);
            $this$getOrPut$iv.put(algorithm, answer$iv);
            crypt = answer$iv;
        } else {
            crypt = value$iv;
        }
        return crypt;
    }

    @JvmStatic
    @NotNull
    public static final Crypt getCrypt(@NotNull CryptHandler.EncryptionAlgorithm type, @NotNull String accountID, @NotNull Context context) {
        return Companion.getCrypt(type, accountID, context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptFactory$Companion;", "", "<init>", "()V", "getCrypt", "Lcom/clevertap/android/sdk/cryption/Crypt;", "type", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "accountID", "", "context", "Landroid/content/Context;", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Crypt getCrypt(@NotNull CryptHandler.EncryptionAlgorithm type, @NotNull String accountID, @NotNull Context context) {
            Crypt crypt;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)accountID, (String)"accountID");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    crypt = new AESCrypt(accountID);
                    break;
                }
                case 2: {
                    crypt = new AESGCMCrypt(context);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return crypt;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CryptHandler.EncryptionAlgorithm.values().length];
                try {
                    nArray[CryptHandler.EncryptionAlgorithm.AES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CryptHandler.EncryptionAlgorithm.AES_GCM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

