/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.ImpressionManager;
import com.clevertap.android.sdk.inapp.SharedPreferencesMigration;
import com.clevertap.android.sdk.inapp.store.preference.InAppStore;
import com.clevertap.android.sdk.inapp.store.preference.LegacyInAppStore;
import com.clevertap.android.sdk.inapp.store.preference.StoreRegistry;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class InAppFCManager {
    private final SimpleDateFormat ddMMyyyy = new SimpleDateFormat("ddMMyyyy", Locale.US);
    private final CleverTapInstanceConfig config;
    private final Context context;
    private String deviceId;
    private ImpressionManager impressionManager;
    private final StoreRegistry storeRegistry;

    InAppFCManager(Context context, CleverTapInstanceConfig config, String deviceId, StoreRegistry storeRegistry, ImpressionManager impressionManager) {
        this.config = config;
        this.context = context;
        this.deviceId = deviceId;
        this.storeRegistry = storeRegistry;
        this.impressionManager = impressionManager;
        Task<Void> task = CTExecutorFactory.executors(config).postAsyncSafelyTask();
        task.execute("initInAppFCManager", new Callable<Void>(){

            @Override
            public Void call() {
                InAppFCManager.this.init(InAppFCManager.this.deviceId);
                return null;
            }
        });
    }

    public boolean canShow(CTInAppNotification inapp, Function2<JSONObject, String, Boolean> hasInAppFrequencyLimitsMaxedOut) {
        try {
            if (inapp == null) {
                return false;
            }
            String id2 = this.getInAppID(inapp);
            if (id2 == null) {
                return true;
            }
            if (((Boolean)hasInAppFrequencyLimitsMaxedOut.invoke((Object)inapp.getJsonDescription(), (Object)id2)).booleanValue()) {
                return false;
            }
            if (inapp.isExcludeFromCaps()) {
                return true;
            }
            if (this.hasSessionCapacityMaxedOut(inapp)) break block8;
            if (this.hasLifetimeCapacityMaxedOut(inapp)) break block9;
            if (!this.hasDailyCapacityMaxedOut(inapp)) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block8: {
                block9: {
                }
            }
        }
    }

    public void changeUser(String deviceId) {
        this.impressionManager.clearSessionData();
        this.deviceId = deviceId;
        this.init(deviceId);
    }

    public void didShow(Context context, CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return;
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).ioTask();
        task.execute("recordInAppImpressionsAndCounts", () -> {
            this.impressionManager.recordImpression(id2);
            this.incrementInAppCountsInPersistentStore(id2);
            int shownToday = this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0);
            StorageHelper.putInt(context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", this.deviceId)), ++shownToday);
            return null;
        });
    }

    public int getShownTodayCount() {
        return this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0);
    }

    public JSONArray getInAppsCount(Context context) {
        try {
            JSONArray arr = new JSONArray();
            SharedPreferences prefs = StorageHelper.getPreferences(context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", this.deviceId)));
            Map all = prefs.getAll();
            for (Map.Entry inApp : all.entrySet()) {
                String[] parts;
                if (!(inApp.getValue() instanceof String) || (parts = ((String)inApp.getValue()).split(",")).length != 2) continue;
                JSONArray a = new JSONArray();
                a.put(0, inApp.getKey());
                a.put(1, Integer.parseInt(parts[0]));
                a.put(2, Integer.parseInt(parts[1]));
                arr.put((Object)a);
            }
            return arr;
        }
        catch (Throwable t) {
            Logger.v("Failed to get in apps count", t);
            return null;
        }
    }

    public void processResponse(Context context, JSONObject response) {
        try {
            if (!response.has("inapp_stale")) {
                return;
            }
            JSONArray arr = response.getJSONArray("inapp_stale");
            SharedPreferences prefs = StorageHelper.getPreferences(context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", this.deviceId)));
            SharedPreferences.Editor editor = prefs.edit();
            for (int i = 0; i < arr.length(); ++i) {
                Object o = arr.get(i);
                if (o instanceof Integer) {
                    editor.remove("" + o);
                    Logger.d("Purged stale in-app - " + o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                editor.remove((String)o);
                Logger.d("Purged stale in-app - " + o);
            }
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.v("Failed to purge out stale targets", t);
        }
    }

    public synchronized void updateLimits(Context context, int perDay, int perSession) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istmcd_inapp", this.deviceId)), perDay);
        StorageHelper.putInt(context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("imc", this.deviceId)), perSession);
    }

    private String getConfigAccountId() {
        return this.config.getAccountId();
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private int[] getInAppCountsFromPersistentStore(String inappID) {
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", this.deviceId)));
        String str = prefs.getString(inappID, null);
        if (str == null) {
            return new int[]{0, 0};
        }
        try {
            String[] parts = str.split(",");
            if (parts.length != 2) {
                return new int[]{0, 0};
            }
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
        catch (Throwable t) {
            return new int[]{0, 0};
        }
    }

    public String getInAppID(CTInAppNotification inapp) {
        if (inapp.getId() == null) {
            return null;
        }
        if (!inapp.getId().isEmpty()) {
            try {
                return inapp.getId();
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        return null;
    }

    private int getIntFromPrefs(String rawKey, int defaultValue) {
        if (this.config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private String getKeyWithDeviceId(String key, String deviceId) {
        return key + ":" + deviceId;
    }

    private String getStringFromPrefs(String rawKey, String defaultValue) {
        if (this.config.isDefaultInstance()) {
            String _new = StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private boolean hasDailyCapacityMaxedOut(CTInAppNotification inapp) {
        int maxPerDayCount;
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        int shownTodayCount = this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0);
        if (shownTodayCount >= (maxPerDayCount = this.getIntFromPrefs(this.getKeyWithDeviceId("istmcd_inapp", this.deviceId), 1))) {
            return true;
        }
        try {
            int maxPerDay = inapp.getTotalDailyCount();
            if (maxPerDay == -1) {
                return false;
            }
            int[] counts = this.getInAppCountsFromPersistentStore(id2);
            if (counts[0] >= maxPerDay) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    private boolean hasLifetimeCapacityMaxedOut(CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        if (inapp.getTotalLifetimeCount() == -1) {
            return false;
        }
        try {
            int[] counts = this.getInAppCountsFromPersistentStore(id2);
            if (counts[1] >= inapp.getTotalLifetimeCount()) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private boolean hasSessionCapacityMaxedOut(CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        try {
            int maxPerSession = inapp.getMaxPerSession() >= 0 ? inapp.getMaxPerSession() : 1000;
            int c = this.impressionManager.perSession(id2);
            if (c >= maxPerSession) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        int c = this.getIntFromPrefs(this.getKeyWithDeviceId("imc", this.deviceId), 1);
        int sessionTotal = this.impressionManager.perSessionTotal();
        return sessionTotal >= c;
    }

    private void incrementInAppCountsInPersistentStore(String inappID) {
        int[] current = this.getInAppCountsFromPersistentStore(inappID);
        current[0] = current[0] + 1;
        current[1] = current[1] + 1;
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", this.deviceId)));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(inappID, current[0] + "," + current[1]);
        StorageHelper.persist(editor);
    }

    private void init(String deviceId) {
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "InAppFCManager init() called");
        try {
            this.migrateToNewPrefsKey(deviceId);
            String today = this.ddMMyyyy.format(new Date());
            String lastUpdated = this.getStringFromPrefs(this.getKeyWithDeviceId("ict_date", deviceId), "20140428");
            if (!today.equals(lastUpdated)) {
                StorageHelper.putString(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("ict_date", deviceId)), today);
                StorageHelper.putInt(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", deviceId)), 0);
                SharedPreferences prefs = StorageHelper.getPreferences(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", deviceId)));
                SharedPreferences.Editor editor = prefs.edit();
                Map all = prefs.getAll();
                for (String inapp : all.keySet()) {
                    Object ov = all.get(inapp);
                    if (!(ov instanceof String)) {
                        editor.remove(inapp);
                        continue;
                    }
                    String[] oldValues = ((String)ov).split(",");
                    if (oldValues.length != 2) {
                        editor.remove(inapp);
                        continue;
                    }
                    try {
                        editor.putString(inapp, "0," + oldValues[1]);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to reset todayCount for inapp " + inapp, t);
                    }
                }
                StorageHelper.persist(editor);
            }
        }
        catch (Exception e) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to init inapp manager " + e.getLocalizedMessage());
        }
    }

    private void migrateToNewPrefsKey(String deviceId) {
        JSONArray accountBasedInApps;
        SharedPreferences spCountsPerInAppV1 = StorageHelper.getPreferences(this.context, "counts_per_inapp");
        SharedPreferences spCountsPerInAppV2 = StorageHelper.getPreferences(this.context, this.getKeyWithDeviceId("counts_per_inapp", deviceId));
        SharedPreferences spCountsPerInAppV3 = StorageHelper.getPreferences(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("counts_per_inapp", deviceId)));
        Function1 countsPerInAppMigrationCondition = it -> it.split(",").length == 2;
        if (CTXtensions.hasData(spCountsPerInAppV2)) {
            Logger.d("migrating shared preference countsPerInApp from V2 to V3...");
            SharedPreferencesMigration<String> countsPerInAppMigrationV2ToV3 = new SharedPreferencesMigration<String>(spCountsPerInAppV2, spCountsPerInAppV3, String.class, countsPerInAppMigrationCondition);
            countsPerInAppMigrationV2ToV3.migrate();
            Logger.d("Finished migrating shared preference countsPerInApp from V2 to V3.");
        } else if (CTXtensions.hasData(spCountsPerInAppV1)) {
            Logger.d("migrating shared preference countsPerInApp from V1 to V3...");
            SharedPreferencesMigration<String> countsPerInAppMigrationV1ToV3 = new SharedPreferencesMigration<String>(spCountsPerInAppV1, spCountsPerInAppV3, String.class, countsPerInAppMigrationCondition);
            countsPerInAppMigrationV1ToV3.migrate();
            Logger.d("Finished migrating shared preference countsPerInApp from V1 to V3.");
        }
        InAppStore inAppStore = this.storeRegistry.getInAppStore();
        LegacyInAppStore legacyInAppStore = this.storeRegistry.getLegacyInAppStore();
        if (inAppStore != null && legacyInAppStore != null && (accountBasedInApps = legacyInAppStore.readInApps()).length() > 0) {
            Logger.d("migrating in-apps from account id to device id based preference.");
            inAppStore.storeServerSideInApps(accountBasedInApps);
            legacyInAppStore.removeInApps();
            Logger.d("Finished migrating in-apps from account id to device id based preference.");
        }
        if (this.getStringFromPrefs(this.getKeyWithDeviceId("ict_date", deviceId), null) != null || this.getStringFromPrefs("ict_date", null) == null) {
            return;
        }
        Logger.v("Migrating InAppFC Prefs");
        String ict_date = this.getStringFromPrefs("ict_date", "20140428");
        StorageHelper.putString(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("ict_date", deviceId)), ict_date);
        int keyCountsShownToday = this.getIntFromPrefs(this.storageKeyWithSuffix("istc_inapp"), 0);
        StorageHelper.putInt(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", deviceId)), keyCountsShownToday);
    }

    private String storageKeyWithSuffix(String key) {
        return key + ":" + this.getConfigAccountId();
    }
}

