/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.content.SharedPreferences;
import com.clevertap.android.sdk.StorageHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/clevertap/android/sdk/inapp/SharedPreferencesMigration;", "T", "", "oldSharedPreferences", "Landroid/content/SharedPreferences;", "newSharedPreferences", "valueType", "Ljava/lang/Class;", "condition", "Lkotlin/Function1;", "", "<init>", "(Landroid/content/SharedPreferences;Landroid/content/SharedPreferences;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "migrate", "", "clevertap-core_release"})
public final class SharedPreferencesMigration<T> {
    @NotNull
    private final SharedPreferences oldSharedPreferences;
    @NotNull
    private final SharedPreferences newSharedPreferences;
    @NotNull
    private final Class<T> valueType;
    @NotNull
    private final Function1<T, Boolean> condition;

    public SharedPreferencesMigration(@NotNull SharedPreferences oldSharedPreferences, @NotNull SharedPreferences newSharedPreferences, @NotNull Class<T> valueType, @NotNull Function1<? super T, Boolean> condition) {
        Intrinsics.checkNotNullParameter((Object)oldSharedPreferences, (String)"oldSharedPreferences");
        Intrinsics.checkNotNullParameter((Object)newSharedPreferences, (String)"newSharedPreferences");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.oldSharedPreferences = oldSharedPreferences;
        this.newSharedPreferences = newSharedPreferences;
        this.valueType = valueType;
        this.condition = condition;
    }

    public /* synthetic */ SharedPreferencesMigration(SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2, Class clazz, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = SharedPreferencesMigration::_init_$lambda$0;
        }
        this(sharedPreferences, sharedPreferences2, clazz, function1);
    }

    public final void migrate() {
        Map oldData = this.oldSharedPreferences.getAll();
        SharedPreferences.Editor editor = this.newSharedPreferences.edit();
        Intrinsics.checkNotNull((Object)oldData);
        for (Map.Entry entry : oldData.entrySet()) {
            SharedPreferences.Editor editor2;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.valueType.isInstance(value) || !((Boolean)this.condition.invoke(value)).booleanValue()) continue;
            Class<T> clazz = this.valueType;
            if (Intrinsics.areEqual(clazz, Boolean.class)) {
                Object v = value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Boolean");
                editor2 = editor.putBoolean(key, ((Boolean)v).booleanValue());
                continue;
            }
            if (Intrinsics.areEqual(clazz, Integer.class)) {
                Object v = value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Int");
                editor2 = editor.putInt(key, ((Integer)v).intValue());
                continue;
            }
            if (Intrinsics.areEqual(clazz, Long.class)) {
                Object v = value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
                editor2 = editor.putLong(key, ((Long)v).longValue());
                continue;
            }
            if (Intrinsics.areEqual(clazz, Float.class)) {
                Object v = value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Float");
                editor2 = editor.putFloat(key, ((Float)v).floatValue());
                continue;
            }
            if (Intrinsics.areEqual(clazz, String.class)) {
                Object v = value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                editor2 = editor.putString(key, (String)v);
                continue;
            }
            Object v = value;
            if (v instanceof Boolean) {
                editor.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (v instanceof Integer) {
                editor.putInt(key, ((Number)value).intValue());
            } else if (v instanceof Long) {
                editor.putLong(key, ((Number)value).longValue());
            } else if (v instanceof Float) {
                editor.putFloat(key, ((Number)value).floatValue());
            } else if (v instanceof String) {
                editor.putString(key, (String)value);
            }
            editor2 = Unit.INSTANCE;
        }
        StorageHelper.persist(editor);
        this.oldSharedPreferences.edit().clear().apply();
    }

    private static final boolean _init_$lambda$0(Object it) {
        return true;
    }
}

