/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network.http;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.http.CtHttpClient;
import com.clevertap.android.sdk.network.http.Request;
import com.clevertap.android.sdk.network.http.Response;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/clevertap/android/sdk/network/http/UrlConnectionHttpClient;", "Lcom/clevertap/android/sdk/network/http/CtHttpClient;", "isSslPinningEnabled", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "logTag", "", "<init>", "(ZLcom/clevertap/android/sdk/Logger;Ljava/lang/String;)V", "()Z", "setSslPinningEnabled", "(Z)V", "socketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "socketFactory$delegate", "Lkotlin/Lazy;", "sslContext", "Ljavax/net/ssl/SSLContext;", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "sslContext$delegate", "execute", "Lcom/clevertap/android/sdk/network/http/Response;", "request", "Lcom/clevertap/android/sdk/network/http/Request;", "openHttpsURLConnection", "Ljavax/net/ssl/HttpsURLConnection;", "createSslContext", "Companion", "clevertap-core_release"})
public final class UrlConnectionHttpClient
implements CtHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isSslPinningEnabled;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logTag;
    @NotNull
    private final Lazy socketFactory$delegate;
    @NotNull
    private final Lazy sslContext$delegate;
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 10000;

    public UrlConnectionHttpClient(boolean isSslPinningEnabled, @NotNull Logger logger, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.isSslPinningEnabled = isSslPinningEnabled;
        this.logger = logger;
        this.logTag = logTag;
        this.socketFactory$delegate = LazyKt.lazy(() -> UrlConnectionHttpClient.socketFactory_delegate$lambda$0(this));
        this.sslContext$delegate = LazyKt.lazy(() -> UrlConnectionHttpClient.sslContext_delegate$lambda$1(this));
    }

    public final boolean isSslPinningEnabled() {
        return this.isSslPinningEnabled;
    }

    public final void setSslPinningEnabled(boolean bl) {
        this.isSslPinningEnabled = bl;
    }

    private final SSLSocketFactory getSocketFactory() {
        Lazy lazy = this.socketFactory$delegate;
        return (SSLSocketFactory)lazy.getValue();
    }

    private final SSLContext getSslContext() {
        Lazy lazy = this.sslContext$delegate;
        return (SSLContext)lazy.getValue();
    }

    @Override
    @NotNull
    public Response execute(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Ref.ObjectRef connection = new Ref.ObjectRef();
        try {
            Response response;
            connection.element = this.openHttpsURLConnection(request);
            this.logger.debug(this.logTag, "Sending request to: " + request.getUrl());
            int responseCode = ((HttpsURLConnection)connection.element).getResponseCode();
            Map<String, List<String>> headers = ((HttpsURLConnection)connection.element).getHeaderFields();
            Function0 disconnectConnection = () -> UrlConnectionHttpClient.execute$lambda$2(connection);
            if (responseCode == 200) {
                Intrinsics.checkNotNull(headers);
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getInputStream(), (Function0<Unit>)disconnectConnection);
            } else {
                Intrinsics.checkNotNull(headers);
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getErrorStream(), (Function0<Unit>)disconnectConnection);
            }
            return response;
        }
        catch (Exception e) {
            block4: {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection.element;
                if (httpsURLConnection == null) break block4;
                httpsURLConnection.disconnect();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpsURLConnection openHttpsURLConnection(Request request) {
        HttpsURLConnection httpsURLConnection;
        URL url = new URL(request.getUrl().toString());
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection $this$openHttpsURLConnection_u24lambda_u244 = httpsURLConnection = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$openHttpsURLConnection_u24lambda_u244.setConnectTimeout(10000);
        $this$openHttpsURLConnection_u24lambda_u244.setReadTimeout(10000);
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            $this$openHttpsURLConnection_u24lambda_u244.setRequestProperty(header.getKey(), header.getValue());
        }
        $this$openHttpsURLConnection_u24lambda_u244.setInstanceFollowRedirects(false);
        if (this.isSslPinningEnabled && this.getSslContext() != null) {
            $this$openHttpsURLConnection_u24lambda_u244.setSSLSocketFactory(this.getSocketFactory());
        }
        if (request.getBody() != null) {
            $this$openHttpsURLConnection_u24lambda_u244.setDoOutput(true);
            Closeable closeable = $this$openHttpsURLConnection_u24lambda_u244.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = false;
                byte[] byArray = request.getBody().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        HttpsURLConnection connection = httpsURLConnection;
        return connection;
    }

    private final SSLContext createSslContext() {
        try {
            KeyStore keyStore;
            TrustManagerFactory trustManagerFactory;
            SSLContext sSLContext;
            SSLContext $this$createSslContext_u24lambda_u247 = sSLContext = SSLContext.getInstance("TLS");
            boolean bl = false;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            TrustManagerFactory $this$createSslContext_u24lambda_u247_u24lambda_u246 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            boolean bl2 = false;
            KeyStore $this$createSslContext_u24lambda_u247_u24lambda_u246_u24lambda_u245 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            boolean bl3 = false;
            $this$createSslContext_u24lambda_u247_u24lambda_u246_u24lambda_u245.load(null, null);
            ClassLoader classLoader = $this$createSslContext_u24lambda_u247_u24lambda_u246_u24lambda_u245.getClass().getClassLoader();
            InputStream inputStream = new BufferedInputStream(classLoader != null ? classLoader.getResourceAsStream("com/clevertap/android/sdk/certificates/AmazonRootCA1.cer") : null);
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate x509Certificate3 = (X509Certificate)certificate;
            $this$createSslContext_u24lambda_u247_u24lambda_u246_u24lambda_u245.setCertificateEntry("AmazonRootCA1", x509Certificate3);
            KeyStore keyStore2 = keyStore;
            $this$createSslContext_u24lambda_u247_u24lambda_u246.init(keyStore2);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            $this$createSslContext_u24lambda_u247.init(null, trustManagerFactory2.getTrustManagers(), null);
            SSLContext sslContext = sSLContext;
            Logger.d("SSL Context built");
            return sslContext;
        }
        catch (Exception e) {
            Logger.i("Error building SSL Context", e);
            return null;
        }
    }

    private static final SSLSocketFactory socketFactory_delegate$lambda$0(UrlConnectionHttpClient this$0) {
        SSLSocketFactory sSLSocketFactory;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
            SSLContext sSLContext = this$0.getSslContext();
            sSLSocketFactory = sSLContext != null ? sSLContext.getSocketFactory() : null;
        }
        catch (Exception e) {
            Logger.d("Issue in pinning SSL,", e);
            sSLSocketFactory = null;
        }
        return sSLSocketFactory;
    }

    private static final SSLContext sslContext_delegate$lambda$1(UrlConnectionHttpClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.createSslContext();
    }

    private static final Unit execute$lambda$2(Ref.ObjectRef $connection) {
        Intrinsics.checkNotNullParameter((Object)$connection, (String)"$connection");
        ((HttpsURLConnection)$connection.element).disconnect();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/network/http/UrlConnectionHttpClient$Companion;", "", "<init>", "()V", "READ_TIMEOUT", "", "CONNECT_TIMEOUT", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

