/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.QueueData;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.inapp.customtemplates.CustomTemplate;
import com.clevertap.android.sdk.inapp.evaluation.EventType;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.network.EndpointId;
import com.clevertap.android.sdk.network.NetworkHeadersListener;
import com.clevertap.android.sdk.network.api.CtApiWrapper;
import com.clevertap.android.sdk.network.api.DefineTemplatesRequestBody;
import com.clevertap.android.sdk.network.api.SendQueueRequestBody;
import com.clevertap.android.sdk.network.http.Response;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.ConsoleResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.FeatureFlagResponse;
import com.clevertap.android.sdk.response.FetchVariablesResponse;
import com.clevertap.android.sdk.response.GeofenceResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.response.MetadataResponse;
import com.clevertap.android.sdk.response.ProductConfigResponse;
import com.clevertap.android.sdk.response.PushAmpResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkManager {
    private final BaseCallbackManager callbackManager;
    private final List<CleverTapResponse> cleverTapResponses = new ArrayList<CleverTapResponse>();
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final CtApiWrapper ctApiWrapper;
    private final BaseDatabaseManager databaseManager;
    private final DeviceInfo deviceInfo;
    private final Logger logger;
    private int responseFailureCount = 0;
    private int networkRetryCount = 0;
    private final ValidationResultStack validationResultStack;
    private final Validator validator;
    private int minDelayFrequency = 0;
    private final List<NetworkHeadersListener> mNetworkHeadersListeners = new ArrayList<NetworkHeadersListener>();

    public void addNetworkHeadersListener(NetworkHeadersListener listener) {
        this.mNetworkHeadersListeners.add(listener);
    }

    public void removeNetworkHeadersListener(NetworkHeadersListener listener) {
        this.mNetworkHeadersListeners.remove(listener);
    }

    public static boolean isNetworkOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return true;
            }
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Exception ignore) {
            return true;
        }
    }

    public NetworkManager(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, CoreMetaData coreMetaData, ValidationResultStack validationResultStack, ControllerManager controllerManager, BaseDatabaseManager baseDatabaseManager, BaseCallbackManager callbackManager, CTLockManager ctLockManager, Validator validator, InAppResponse inAppResponse, CtApiWrapper ctApiWrapper) {
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
        this.callbackManager = callbackManager;
        this.validator = validator;
        this.logger = this.config.getLogger();
        this.coreMetaData = coreMetaData;
        this.validationResultStack = validationResultStack;
        this.controllerManager = controllerManager;
        this.databaseManager = baseDatabaseManager;
        this.ctApiWrapper = ctApiWrapper;
        this.cleverTapResponses.add(inAppResponse);
        this.cleverTapResponses.add(new MetadataResponse(config, deviceInfo, this));
        this.cleverTapResponses.add(new ARPResponse(config, this, validator, controllerManager));
        this.cleverTapResponses.add(new ConsoleResponse(config));
        this.cleverTapResponses.add(new InboxResponse(config, ctLockManager, callbackManager, controllerManager));
        this.cleverTapResponses.add(new PushAmpResponse(context, config, baseDatabaseManager, callbackManager, controllerManager));
        this.cleverTapResponses.add(new FetchVariablesResponse(config, controllerManager, callbackManager));
        this.cleverTapResponses.add(new DisplayUnitResponse(config, callbackManager, controllerManager));
        this.cleverTapResponses.add(new FeatureFlagResponse(config, controllerManager));
        this.cleverTapResponses.add(new ProductConfigResponse(config, coreMetaData, controllerManager));
        this.cleverTapResponses.add(new GeofenceResponse(config, callbackManager));
    }

    public void flushDBQueue(Context context, EventGroup eventGroup, @Nullable String caller) {
        this.config.getLogger().verbose(this.config.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueData previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueData cursor = this.databaseManager.getQueuedEvents(context, 50, previousCursor, eventGroup);
            if (cursor == null || cursor.isEmpty()) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                if (eventGroup != EventGroup.PUSH_NOTIFICATION_VIEWED || previousCursor == null || previousCursor.getData() == null) break;
                try {
                    this.notifyListenersForPushImpressionSentToServer(previousCursor.getData());
                }
                catch (Exception e) {
                    this.config.getLogger().verbose(this.config.getAccountId(), "met with exception while notifying listeners for PushImpressionSentToServer event");
                }
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                break;
            }
            loadMore = this.sendQueue(context, eventGroup, queue, caller);
            if (!loadMore) {
                this.controllerManager.invokeCallbacksForNetworkError();
                this.controllerManager.invokeBatchListener(queue, false);
                continue;
            }
            this.controllerManager.invokeBatchListener(queue, true);
        }
    }

    public int getDelayFrequency() {
        this.logger.debug(this.config.getAccountId(), "Network retry #" + this.networkRetryCount);
        if (this.networkRetryCount < 10) {
            this.logger.debug(this.config.getAccountId(), "Failure count is " + this.networkRetryCount + ". Setting delay frequency to 1s");
            this.minDelayFrequency = 1000;
            return this.minDelayFrequency;
        }
        if (this.config.getAccountRegion() == null) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to 1s");
            return 1000;
        }
        SecureRandom randomGen = new SecureRandom();
        int randomDelay = (randomGen.nextInt(10) + 1) * 1000;
        this.minDelayFrequency += randomDelay;
        if (this.minDelayFrequency < 600000) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
            return this.minDelayFrequency;
        }
        this.minDelayFrequency = 1000;
        this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
        return this.minDelayFrequency;
    }

    public String getNewNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "New ARP Key = ARP:" + accountId + ":" + this.deviceInfo.getDeviceID());
        return "ARP:" + accountId + ":" + this.deviceInfo.getDeviceID();
    }

    @WorkerThread
    public void initHandshake(EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        this.responseFailureCount = 0;
        this.performHandshakeForDomain(this.context, eventGroup, handshakeSuccessCallback);
    }

    @WorkerThread
    public boolean needsHandshakeForDomain(EventGroup eventGroup) {
        boolean needHandshakeDueToFailure;
        boolean needsHandshake = this.ctApiWrapper.needsHandshake(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);
        boolean bl = needHandshakeDueToFailure = this.responseFailureCount > 5;
        if (needHandshakeDueToFailure) {
            this.setDomain(this.context, null);
        }
        return needsHandshake || needHandshakeDueToFailure;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_i"), i);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_j"), j);
        StorageHelper.persist(editor);
    }

    @WorkerThread
    int getCurrentRequestTimestamp() {
        return this.ctApiWrapper.getCtApi().getCurrentRequestTimestampSeconds();
    }

    @WorkerThread
    public String getDomain(EventGroup eventGroup) {
        return this.ctApiWrapper.getCtApi().getActualDomain(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);
    }

    int getFirstRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_first_ts", 0);
    }

    int getLastRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_last_ts", 0);
    }

    void setLastRequestTimestamp(int ts) {
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), ts);
    }

    boolean hasDomainChanged(String newDomain) {
        String oldDomain = StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
        return !newDomain.equals(oldDomain);
    }

    private JSONObject getQueueHeader(Context context, @Nullable String caller) {
        try {
            long j;
            String deviceId;
            JSONObject header = new JSONObject();
            if (caller != null) {
                header.put("d_src", (Object)caller);
            }
            if ((deviceId = this.deviceInfo.getDeviceID()) != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                this.logger.verbose(this.config.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = this.deviceInfo.getAppLaunchedFields();
            if (this.coreMetaData.isWebInterfaceInitializedExternally()) {
                appFields.put("wv_init", true);
            }
            header.put("af", (Object)appFields);
            long i = this.getI();
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = this.getJ()) > 0L) {
                header.put("_j", j);
            }
            String accountId = this.config.getAccountId();
            String token = this.config.getAccountToken();
            if (accountId == null || token == null) {
                this.logger.debug(this.config.getAccountId(), "Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", this.getLastRequestTimestamp());
            header.put("f_ts", this.getFirstRequestTimestamp());
            header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this.context, this.config, this.validationResultStack).getIdentitySet().toString());
            header.put("ddnd", !CTXtensions.areAppNotificationsEnabled(this.context) || this.controllerManager.getPushProviders() != null && !this.controllerManager.getPushProviders().isNotificationSupported());
            if (this.coreMetaData.isBgPing()) {
                header.put("bk", 1);
                this.coreMetaData.setBgPing(false);
            }
            header.put("rtl", (Object)CTJsonConverter.getRenderedTargetList(this.databaseManager.loadDBAdapter(this.context)));
            if (!this.coreMetaData.isInstallReferrerDataSent()) {
                header.put("rct", this.coreMetaData.getReferrerClickTime());
                header.put("ait", this.coreMetaData.getAppInstallTime());
            }
            header.put("frs", this.coreMetaData.isFirstRequestInSession());
            if (CleverTapAPI.getDebugLevel() == 3) {
                header.put("debug", true);
            }
            this.coreMetaData.setFirstRequestInSession(false);
            try {
                JSONObject arp = this.getARP();
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (JSONException e) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ARP", e);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = this.coreMetaData.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = this.coreMetaData.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = this.coreMetaData.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (JSONException e) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ref", e);
            }
            JSONObject wzrkParams = this.coreMetaData.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            if (this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Attaching InAppFC to Header");
                header.put("imp", this.controllerManager.getInAppFCManager().getShownTodayCount());
                header.put("tlc", (Object)this.controllerManager.getInAppFCManager().getInAppsCount(context));
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Attaching InAppFC to Header");
            }
            return header;
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "CommsManager: Failed to attach header", e);
            return null;
        }
    }

    @WorkerThread
    private void performHandshakeForDomain(Context context, EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        try (Response response = this.ctApiWrapper.getCtApi().performHandshakeForDomain(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED);){
            if (response.isSuccess()) {
                this.logger.verbose(this.config.getAccountId(), "Received success from handshake :)");
                if (this.processIncomingHeaders(context, response)) {
                    this.logger.verbose(this.config.getAccountId(), "We are not muted");
                    handshakeSuccessCallback.run();
                }
            } else {
                this.logger.verbose(this.config.getAccountId(), "Invalid HTTP status code received for handshake - " + response.getCode());
            }
        }
        catch (Exception e) {
            this.logger.verbose(this.config.getAccountId(), "Failed to perform handshake!", e);
        }
    }

    @WorkerThread
    private boolean processIncomingHeaders(Context context, Response response) {
        String muteCommand = response.getHeaderValue("X-WZRK-MUTE");
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                this.setMuted(context, true);
                return false;
            }
            this.setMuted(context, false);
        }
        String domainName = response.getHeaderValue("X-WZRK-RD");
        Logger.v("Getting domain from header - " + domainName);
        if (domainName == null || domainName.trim().length() == 0) {
            return true;
        }
        String spikyDomainName = response.getHeaderValue("X-WZRK-SPIKY-RD");
        Logger.v("Getting spiky domain from header - " + spikyDomainName);
        this.setMuted(context, false);
        this.setDomain(context, domainName);
        Logger.v("Setting spiky domain from header as -" + spikyDomainName);
        if (spikyDomainName == null) {
            this.setSpikyDomain(context, domainName);
        } else {
            this.setSpikyDomain(context, spikyDomainName);
        }
        return true;
    }

    public boolean sendQueue(Context context, EventGroup eventGroup, JSONArray queue, @Nullable String caller) {
        if (queue == null || queue.length() <= 0) {
            return false;
        }
        if (this.deviceInfo.getDeviceID() == null) {
            this.logger.debug(this.config.getAccountId(), "CleverTap Id not finalized, unable to send queue");
            return false;
        }
        EndpointId endpointId = EndpointId.fromEventGroup(eventGroup);
        JSONObject queueHeader = this.getQueueHeader(context, caller);
        this.applyQueueHeaderListeners(queueHeader, endpointId, queue.optJSONObject(0).has("profile"));
        SendQueueRequestBody body = new SendQueueRequestBody(queueHeader, queue);
        this.logger.debug(this.config.getAccountId(), "Send queue contains " + queue.length() + " items: " + body);
        Response response = this.callApiForEventGroup(eventGroup, body);
        try {
            this.networkRetryCount = 0;
            boolean isProcessed = eventGroup == EventGroup.VARIABLES ? this.handleVariablesResponse(response) : this.handleSendQueueResponse(response, body, endpointId);
            this.responseFailureCount = isProcessed ? 0 : ++this.responseFailureCount;
            boolean bl = isProcessed;
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                ++this.networkRetryCount;
                ++this.responseFailureCount;
                this.logger.debug(this.config.getAccountId(), "An exception occurred while sending the queue, will retry: ", e);
                if (this.callbackManager.getFailureFlushListener() != null) {
                    this.callbackManager.getFailureFlushListener().failureFlush(context);
                }
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public boolean defineTemplates(Context context, Collection<CustomTemplate> templates) {
        JSONObject header = this.getQueueHeader(context, null);
        if (header == null) {
            return false;
        }
        DefineTemplatesRequestBody body = new DefineTemplatesRequestBody(header, templates);
        this.logger.debug(this.config.getAccountId(), "Will define templates: " + body);
        try (Response response = this.ctApiWrapper.getCtApi().defineTemplates(body);){
            if (response.isSuccess()) {
                this.handleTemplateResponseSuccess(response);
                boolean bl = true;
                return bl;
            }
            this.handleVarsOrTemplatesResponseError(response, "CustomTemplates");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.logger.debug(this.config.getAccountId(), "An exception occurred while defining templates.", e);
            return false;
        }
    }

    private void applyQueueHeaderListeners(JSONObject queueHeader, EndpointId endpointId, boolean isProfile) {
        if (queueHeader != null) {
            for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                JSONObject headersToAttach = listener.onAttachHeaders(endpointId, EventType.Companion.fromBoolean(isProfile));
                if (headersToAttach == null) continue;
                CTXtensions.copyFrom(queueHeader, headersToAttach);
            }
        }
    }

    @WorkerThread
    private Response callApiForEventGroup(EventGroup eventGroup, SendQueueRequestBody body) {
        if (eventGroup == EventGroup.VARIABLES) {
            return this.ctApiWrapper.getCtApi().defineVars(body);
        }
        return this.ctApiWrapper.getCtApi().sendQueue(eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED, body);
    }

    private boolean handleVariablesResponse(@NonNull Response response) {
        if (response.isSuccess()) {
            String bodyString = response.readBody();
            JSONObject bodyJson = CTXtensions.toJsonOrNull(bodyString);
            this.logger.verbose(this.config.getAccountId(), "Processing variables response : " + bodyJson);
            new ARPResponse(this.config, this, this.validator, this.controllerManager).processResponse(bodyJson, bodyString, this.context);
            return true;
        }
        this.handleVarsOrTemplatesResponseError(response, "Variables");
        return false;
    }

    private void handleVarsOrTemplatesResponseError(Response response, String logTag) {
        switch (response.getCode()) {
            case 400: {
                JSONObject errorStreamJson = CTXtensions.toJsonOrNull(response.readBody());
                if (errorStreamJson != null && !TextUtils.isEmpty((CharSequence)errorStreamJson.optString("error"))) {
                    String errorMessage = errorStreamJson.optString("error");
                    this.logger.info(logTag, "Error while syncing: " + errorMessage);
                } else {
                    this.logger.info(logTag, "Error while syncing.");
                }
                return;
            }
            case 401: {
                this.logger.info(logTag, "Unauthorized access from a non-test profile. Please mark this profile as a test profile from the CleverTap dashboard.");
                return;
            }
        }
        this.logger.info(logTag, "Response code " + response.getCode() + " while syncing.");
    }

    private void handleTemplateResponseSuccess(Response response) {
        String warnings;
        this.logger.info(this.config.getAccountId(), "Custom templates defined successfully.");
        JSONObject body = CTXtensions.toJsonOrNull(response.readBody());
        if (body != null && !TextUtils.isEmpty((CharSequence)(warnings = body.optString("error")))) {
            this.logger.info(this.config.getAccountId(), "Custom templates warnings: " + warnings);
        }
    }

    @WorkerThread
    private boolean handleSendQueueResponse(@NonNull Response response, SendQueueRequestBody body, EndpointId endpointId) {
        if (!response.isSuccess()) {
            this.handleSendQueueResponseError(response);
            return false;
        }
        String newDomain = response.getHeaderValue("X-WZRK-RD");
        if (newDomain != null && !newDomain.trim().isEmpty() && this.hasDomainChanged(newDomain)) {
            this.setDomain(this.context, newDomain);
            this.logger.debug(this.config.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
            return false;
        }
        if (body.getQueueHeader() != null) {
            for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                boolean isProfile = body.getQueue().optJSONObject(0).has("profile");
                listener.onSentHeaders(body.getQueueHeader(), endpointId, EventType.Companion.fromBoolean(isProfile));
            }
        }
        if (!this.processIncomingHeaders(this.context, response)) {
            return false;
        }
        this.logger.debug(this.config.getAccountId(), "Queue sent successfully");
        this.setLastRequestTimestamp(this.getCurrentRequestTimestamp());
        this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
        String bodyString = response.readBody();
        JSONObject bodyJson = CTXtensions.toJsonOrNull(bodyString);
        this.logger.verbose(this.config.getAccountId(), "Processing response : " + bodyJson);
        boolean isFullResponse = this.doesBodyContainAppLaunchedOrFetchEvents(body);
        for (CleverTapResponse processor : this.cleverTapResponses) {
            processor.isFullResponse = isFullResponse;
            processor.processResponse(bodyJson, bodyString, this.context);
        }
        return true;
    }

    private void handleSendQueueResponseError(@NonNull Response response) {
        this.logger.info("Received error response code: " + response.getCode());
    }

    private boolean doesBodyContainAppLaunchedOrFetchEvents(SendQueueRequestBody body) {
        for (int index = 0; index < body.getQueue().length(); ++index) {
            try {
                String evtName;
                JSONObject event = body.getQueue().getJSONObject(index);
                String eventType = event.getString("type");
                if (!"event".equals(eventType) || !"App Launched".equals(evtName = event.getString("evtName")) && !"wzrk_fetch".equals(evtName)) continue;
                return true;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return false;
    }

    private void notifyListenersForPushImpressionSentToServer(JSONArray queue) throws JSONException {
        for (int i = 0; i < queue.length(); ++i) {
            try {
                JSONObject notif = queue.getJSONObject(i).optJSONObject("evtData");
                if (notif == null) continue;
                String pushId = notif.optString("wzrk_pid");
                String pushAccountId = notif.optString("wzrk_acct_id");
                this.notifyListenerForPushImpressionSentToServer(PushNotificationUtil.buildPushNotificationRenderedListenerKey(pushAccountId, pushId));
                continue;
            }
            catch (JSONException e) {
                this.logger.verbose(this.config.getAccountId(), "Encountered an exception while parsing the push notification viewed event queue");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.verbose(this.config.getAccountId(), "push notification viewed event sent successfully");
    }

    private void notifyListenerForPushImpressionSentToServer(@NonNull String listenerKey) {
        NotificationRenderedListener notificationRenderedListener = CleverTapAPI.getNotificationRenderedListener(listenerKey);
        if (notificationRenderedListener != null) {
            this.logger.verbose(this.config.getAccountId(), "notifying listener " + listenerKey + ", that push impression sent successfully");
            notificationRenderedListener.onNotificationRendered(true);
        }
    }

    @WorkerThread
    private void setDomain(Context context, String domainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting domain to " + domainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn"), domainName);
        this.ctApiWrapper.getCtApi().setCachedDomain(domainName);
        if (this.callbackManager.getSCDomainListener() != null) {
            if (domainName != null) {
                this.callbackManager.getSCDomainListener().onSCDomainAvailable(Utils.getSCDomain(domainName));
            } else {
                this.callbackManager.getSCDomainListener().onSCDomainUnavailable();
            }
        }
    }

    private void setFirstRequestTimestampIfNeeded(int ts) {
        if (this.getFirstRequestTimestamp() > 0) {
            return;
        }
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), ts);
    }

    @WorkerThread
    private void setSpikyDomain(Context context, String spikyDomainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting spiky domain to " + spikyDomainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn_spiky"), spikyDomainName);
        this.ctApiWrapper.getCtApi().setCachedSpikyDomain(spikyDomainName);
    }

    private JSONObject getARP() {
        try {
            String nameSpaceKey = this.getNewNamespaceARPKey();
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = !StorageHelper.getPreferences(this.context, nameSpaceKey).getAll().isEmpty() ? StorageHelper.getPreferences(this.context, nameSpaceKey) : this.migrateARPToNewNameSpace(nameSpaceKey, this.getNamespaceARPKey());
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.logger.verbose(this.config.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all);
            return ret;
        }
        catch (Exception e) {
            this.logger.verbose(this.config.getAccountId(), "Failed to construct ARP object", e);
            return null;
        }
    }

    private long getI() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_i", 0, "IJ");
    }

    private long getJ() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_j", 0, "IJ");
    }

    private String getNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "Old ARP Key = ARP:" + accountId);
        return "ARP:" + accountId;
    }

    private SharedPreferences migrateARPToNewNameSpace(String newKey, String oldKey) {
        SharedPreferences oldPrefs = StorageHelper.getPreferences(this.context, oldKey);
        SharedPreferences newPrefs = StorageHelper.getPreferences(this.context, newKey);
        SharedPreferences.Editor editor = newPrefs.edit();
        Map all = oldPrefs.getAll();
        for (Map.Entry kv : all.entrySet()) {
            Object o = kv.getValue();
            if (o instanceof Number) {
                int update = ((Number)o).intValue();
                editor.putInt((String)kv.getKey(), update);
                continue;
            }
            if (o instanceof String) {
                if (((String)o).length() < 100) {
                    editor.putString((String)kv.getKey(), (String)o);
                    continue;
                }
                this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (string value too long)");
                continue;
            }
            if (o instanceof Boolean) {
                editor.putBoolean((String)kv.getKey(), ((Boolean)o).booleanValue());
                continue;
            }
            this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (invalid data type)");
        }
        this.logger.verbose(this.config.getAccountId(), "Completed ARP update for namespace key: " + newKey);
        StorageHelper.persist(editor);
        oldPrefs.edit().clear().apply();
        return newPrefs;
    }

    @WorkerThread
    private void setMuted(Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), now);
            this.setDomain(context, null);
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("CommsManager#setMuted", () -> {
                this.databaseManager.clearQueues(context);
                return null;
            });
        } else {
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), 0);
        }
    }
}

