/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network.http;

import com.clevertap.android.sdk.network.http.Request;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/clevertap/android/sdk/network/http/Response;", "Ljava/io/Closeable;", "request", "Lcom/clevertap/android/sdk/network/http/Request;", "code", "", "headers", "", "", "", "bodyStream", "Ljava/io/InputStream;", "closeDelegate", "Lkotlin/Function0;", "", "(Lcom/clevertap/android/sdk/network/http/Request;ILjava/util/Map;Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;)V", "bodyReader", "Ljava/io/Reader;", "getCode", "()I", "getHeaders", "()Ljava/util/Map;", "getRequest", "()Lcom/clevertap/android/sdk/network/http/Request;", "close", "getHeaderValue", "header", "isSuccess", "", "readBody", "clevertap-core_release"})
public final class Response
implements Closeable {
    @NotNull
    private final Request request;
    private final int code;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final Function0<Unit> closeDelegate;
    @Nullable
    private final Reader bodyReader;

    public Response(@NotNull Request request, int code, @NotNull Map<String, ? extends List<String>> headers, @Nullable InputStream bodyStream, @NotNull Function0<Unit> closeDelegate) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(closeDelegate, (String)"closeDelegate");
        this.request = request;
        this.code = code;
        this.headers = headers;
        this.closeDelegate = closeDelegate;
        if (bodyStream != null) {
            Reader reader = new InputStreamReader(bodyStream, Charsets.UTF_8);
            int n = 8192;
            bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        } else {
            bufferedReader = null;
        }
        this.bodyReader = bufferedReader;
    }

    @NotNull
    public final Request getRequest() {
        return this.request;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final boolean isSuccess() {
        return this.code == 200;
    }

    @Nullable
    public final String getHeaderValue(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        List<String> list = this.headers.get(header);
        return list != null ? (String)CollectionsKt.lastOrNull(list) : null;
    }

    @Nullable
    public final String readBody() {
        Reader reader = this.bodyReader;
        return reader != null ? TextStreamsKt.readText((Reader)reader) : null;
    }

    @Override
    public void close() {
        Reader reader = this.bodyReader;
        if (reader != null) {
            reader.close();
        }
        this.closeDelegate.invoke();
    }
}

