/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

public class RegisterSet {
    public static final int LOG2_BITS_PER_WORD = 6;
    public static final int REGISTER_SIZE = 5;
    public final int count;
    public final int size;
    private final int[] M;

    public RegisterSet(int count) {
        this(count, null);
    }

    public RegisterSet(int count, int[] initialValues) {
        this.count = count;
        int bits = RegisterSet.getBits(count);
        this.M = initialValues == null ? (bits == 0 ? new int[1] : (bits % 32 == 0 ? new int[bits] : new int[bits + 1])) : initialValues;
        this.size = this.M.length;
    }

    public static int getBits(int count) {
        return (int)Math.floor(count / 6);
    }

    public void set(int position, int value) {
        int bucketPos = (int)Math.floor(position / 6);
        int shift = 5 * (position - bucketPos * 6);
        this.M[bucketPos] = this.M[bucketPos] & ~(31 << shift) | value << shift;
    }

    public int get(int position) {
        int bucketPos = (int)Math.floor(position / 6);
        int shift = 5 * (position - bucketPos * 6);
        return (this.M[bucketPos] & 31 << shift) >>> shift;
    }

    public int[] bits() {
        int[] copy = new int[this.size];
        System.arraycopy(this.M, 0, copy, 0, this.M.length);
        return copy;
    }
}

