/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream;

import com.clearspring.analytics.stream.ISampleSet;
import com.clearspring.analytics.stream.ITopK;
import com.clearspring.analytics.stream.SampleSet;
import java.util.List;
import java.util.Random;

public class StochasticTopper<T>
implements ITopK<T> {
    private int sampleSize;
    private ISampleSet<T> sample;
    private Random random;
    private long count;

    public StochasticTopper(int sampleSize) {
        this(sampleSize, null);
    }

    public StochasticTopper(int sampleSize, Long seed) {
        this.sample = new SampleSet(sampleSize);
        this.sampleSize = sampleSize;
        this.random = seed != null ? new Random(seed) : new Random();
    }

    @Override
    public boolean offer(T item) {
        ++this.count;
        boolean taken = false;
        if (this.sample.count() < (long)this.sampleSize) {
            this.sample.put(item);
            taken = true;
        } else if (this.random.nextDouble() < (double)this.sampleSize / (double)this.count) {
            this.sample.removeRandom();
            this.sample.put(item);
            taken = true;
        }
        return taken;
    }

    @Override
    public List<T> peek(int k) {
        return this.sample.peek(k);
    }
}

