/*
 * Decompiled with CFR 0.152.
 */
package com.classic.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.classic.common.R;

public class MultipleStatusView
extends RelativeLayout {
    public static final int STATUS_CONTENT = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_EMPTY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_NO_NETWORK = 4;
    private static final int NULL_RESOURCE_ID = -1;
    private View mEmptyView;
    private View mErrorView;
    private View mLoadingView;
    private View mNoNetworkView;
    private View mContentView;
    private View mEmptyRetryView;
    private View mErrorRetryView;
    private View mNoNetworkRetryView;
    private int mEmptyViewResId;
    private int mErrorViewResId;
    private int mLoadingViewResId;
    private int mNoNetworkViewResId;
    private int mContentViewResId;
    private int mViewStatus;
    private LayoutInflater mInflater;
    private View.OnClickListener mOnRetryClickListener;
    private final ViewGroup.LayoutParams mLayoutParams = new ViewGroup.LayoutParams(-1, -1);

    public MultipleStatusView(Context context) {
        this(context, null);
    }

    public MultipleStatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultipleStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultipleStatusView, defStyleAttr, 0);
        this.mEmptyViewResId = a.getResourceId(R.styleable.MultipleStatusView_emptyView, R.layout.empty_view);
        this.mErrorViewResId = a.getResourceId(R.styleable.MultipleStatusView_errorView, R.layout.error_view);
        this.mLoadingViewResId = a.getResourceId(R.styleable.MultipleStatusView_loadingView, R.layout.loading_view);
        this.mNoNetworkViewResId = a.getResourceId(R.styleable.MultipleStatusView_noNetworkView, R.layout.no_network_view);
        this.mContentViewResId = a.getResourceId(R.styleable.MultipleStatusView_contentView, -1);
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mInflater = LayoutInflater.from((Context)this.getContext());
        this.showContent();
    }

    public int getViewStatus() {
        return this.mViewStatus;
    }

    public void setOnRetryClickListener(View.OnClickListener onRetryClickListener) {
        this.mOnRetryClickListener = onRetryClickListener;
    }

    public final void showEmpty() {
        this.mViewStatus = 2;
        if (null == this.mEmptyView) {
            this.mEmptyView = this.mInflater.inflate(this.mEmptyViewResId, null);
            this.mEmptyRetryView = this.mEmptyView.findViewById(R.id.empty_retry_view);
            if (null != this.mOnRetryClickListener && null != this.mEmptyRetryView) {
                this.mEmptyRetryView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mEmptyView, 0, this.mLayoutParams);
        }
        this.showViewByStatus(this.mViewStatus);
    }

    public final void showError() {
        this.mViewStatus = 3;
        if (null == this.mErrorView) {
            this.mErrorView = this.mInflater.inflate(this.mErrorViewResId, null);
            this.mErrorRetryView = this.mErrorView.findViewById(R.id.error_retry_view);
            if (null != this.mOnRetryClickListener && null != this.mErrorRetryView) {
                this.mErrorRetryView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mErrorView, 0, this.mLayoutParams);
        }
        this.showViewByStatus(this.mViewStatus);
    }

    public final void showLoading() {
        this.mViewStatus = 1;
        if (null == this.mLoadingView) {
            this.mLoadingView = this.mInflater.inflate(this.mLoadingViewResId, null);
            this.addView(this.mLoadingView, 0, this.mLayoutParams);
        }
        this.showViewByStatus(this.mViewStatus);
    }

    public final void showNoNetwork() {
        this.mViewStatus = 4;
        if (null == this.mNoNetworkView) {
            this.mNoNetworkView = this.mInflater.inflate(this.mNoNetworkViewResId, null);
            this.mNoNetworkRetryView = this.mNoNetworkView.findViewById(R.id.no_network_retry_view);
            if (null != this.mOnRetryClickListener && null != this.mNoNetworkRetryView) {
                this.mNoNetworkRetryView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.addView(this.mNoNetworkView, 0, this.mLayoutParams);
        }
        this.showViewByStatus(this.mViewStatus);
    }

    public final void showContent() {
        this.mViewStatus = 0;
        if (null == this.mContentView) {
            if (this.mContentViewResId != -1) {
                this.mContentView = this.mInflater.inflate(this.mContentViewResId, null);
                this.addView(this.mContentView, 0, this.mLayoutParams);
            } else {
                this.mContentView = this.findViewById(R.id.content_view);
            }
        }
        this.showViewByStatus(this.mViewStatus);
    }

    private void showViewByStatus(int viewStatus) {
        if (null != this.mLoadingView) {
            this.mLoadingView.setVisibility(viewStatus == 1 ? 0 : 8);
        }
        if (null != this.mEmptyView) {
            this.mEmptyView.setVisibility(viewStatus == 2 ? 0 : 8);
        }
        if (null != this.mErrorView) {
            this.mErrorView.setVisibility(viewStatus == 3 ? 0 : 8);
        }
        if (null != this.mNoNetworkView) {
            this.mNoNetworkView.setVisibility(viewStatus == 4 ? 0 : 8);
        }
        if (null != this.mContentView) {
            this.mContentView.setVisibility(viewStatus == 0 ? 0 : 8);
        }
    }
}

