/*
 * Decompiled with CFR 0.152.
 */
package com.cjj;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cjj.CircleProgressBar;
import com.cjj.MaterialHeadListener;
import com.cjj.MaterialRefreshLayout;
import com.cjj.MaterialWaveView;
import com.cjj.Util;

public class MaterialHeadView
extends FrameLayout
implements MaterialHeadListener {
    private MaterialWaveView materialWaveView;
    private CircleProgressBar circleProgressBar;
    private int waveColor;
    private int progressTextColor;
    private int[] progress_colors;
    private int progressStokeWidth;
    private boolean isShowArrow;
    private boolean isShowProgressBg;
    private int progressValue;
    private int progressValueMax;
    private int textType;
    private int progressBg;
    private int progressSize;
    private MaterialHeadListener listener;

    public MaterialHeadView(Context context) {
        this(context, null);
    }

    public MaterialHeadView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialHeadView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    protected void init(AttributeSet attrs, int defStyle) {
        if (this.isInEditMode()) {
            return;
        }
        this.setClipToPadding(false);
        this.setWillNotDraw(false);
    }

    public int getWaveColor() {
        return this.waveColor;
    }

    public void setWaveColor(int waveColor) {
        this.waveColor = waveColor;
        if (null != this.materialWaveView) {
            this.materialWaveView.setColor(this.waveColor);
        }
    }

    public void setProgressSize(int progressSize) {
        this.progressSize = progressSize;
    }

    public void setProgressBg(int progressBg) {
        this.progressBg = progressBg;
    }

    public void setIsProgressBg(boolean isShowProgressBg) {
        this.isShowProgressBg = isShowProgressBg;
    }

    public void setProgressTextColor(int textColor) {
        this.progressTextColor = textColor;
    }

    public void setProgressColors(int[] colors) {
        this.progress_colors = colors;
    }

    public void setTextType(int textType) {
        this.textType = textType;
    }

    public void setProgressValue(int value) {
        this.progressValue = value;
        this.post(new Runnable(){

            @Override
            public void run() {
                MaterialHeadView.this.circleProgressBar.setProgress(MaterialHeadView.this.progressValue);
            }
        });
    }

    public void setProgressValueMax(int value) {
        this.progressValueMax = value;
    }

    public void setProgressStokeWidth(int w) {
        this.progressStokeWidth = w;
    }

    public void showProgressArrow(boolean isShowArrow) {
        this.isShowArrow = isShowArrow;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.materialWaveView = new MaterialWaveView(this.getContext());
        this.materialWaveView.setColor(this.waveColor);
        this.addView(this.materialWaveView);
        this.circleProgressBar = new CircleProgressBar(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(Util.dip2px(this.getContext(), this.progressSize), Util.dip2px(this.getContext(), this.progressSize));
        layoutParams.gravity = 17;
        this.circleProgressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.circleProgressBar.setColorSchemeColors(this.progress_colors);
        this.circleProgressBar.setProgressStokeWidth(this.progressStokeWidth);
        this.circleProgressBar.setShowArrow(this.isShowArrow);
        this.circleProgressBar.setShowProgressText(this.textType == 0);
        this.circleProgressBar.setTextColor(this.progressTextColor);
        this.circleProgressBar.setProgress(this.progressValue);
        this.circleProgressBar.setMax(this.progressValueMax);
        this.circleProgressBar.setCircleBackgroundEnabled(this.isShowProgressBg);
        this.circleProgressBar.setProgressBackGroundColor(this.progressBg);
        this.addView((View)this.circleProgressBar);
    }

    @Override
    public void onComlete(MaterialRefreshLayout materialRefreshLayout) {
        if (this.materialWaveView != null) {
            this.materialWaveView.onComlete(materialRefreshLayout);
        }
        if (this.circleProgressBar != null) {
            this.circleProgressBar.onComlete(materialRefreshLayout);
            ViewCompat.setTranslationY((View)this.circleProgressBar, (float)0.0f);
            ViewCompat.setScaleX((View)this.circleProgressBar, (float)0.0f);
            ViewCompat.setScaleY((View)this.circleProgressBar, (float)0.0f);
        }
    }

    @Override
    public void onBegin(MaterialRefreshLayout materialRefreshLayout) {
        if (this.materialWaveView != null) {
            this.materialWaveView.onBegin(materialRefreshLayout);
        }
        if (this.circleProgressBar != null) {
            this.circleProgressBar.onBegin(materialRefreshLayout);
        }
    }

    @Override
    public void onPull(MaterialRefreshLayout materialRefreshLayout, float fraction) {
        if (this.materialWaveView != null) {
            this.materialWaveView.onPull(materialRefreshLayout, fraction);
        }
        if (this.circleProgressBar != null) {
            this.circleProgressBar.onPull(materialRefreshLayout, fraction);
            float a = Util.limitValue(1.0f, fraction);
            ViewCompat.setScaleX((View)this.circleProgressBar, (float)1.0f);
            ViewCompat.setScaleY((View)this.circleProgressBar, (float)1.0f);
            ViewCompat.setAlpha((View)this.circleProgressBar, (float)a);
        }
    }

    @Override
    public void onRelease(MaterialRefreshLayout materialRefreshLayout, float fraction) {
    }

    @Override
    public void onRefreshing(MaterialRefreshLayout materialRefreshLayout) {
        if (this.materialWaveView != null) {
            this.materialWaveView.onRefreshing(materialRefreshLayout);
        }
        if (this.circleProgressBar != null) {
            this.circleProgressBar.onRefreshing(materialRefreshLayout);
        }
    }
}

