/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.dsl.dependencies;

import com.citi.gradle.plugins.helm.dsl.HelmChart;
import com.citi.gradle.plugins.helm.dsl.dependencies.ChartDependencyHandler;
import com.citi.gradle.plugins.helm.rules.ChartDependenciesConfigurationRuleKt;
import com.citi.gradle.plugins.helm.rules.ChartPackagedArtifactRuleKt;
import com.citi.gradle.plugins.helm.rules.PackageTaskRuleKt;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/citi/gradle/plugins/helm/dsl/dependencies/DefaultChartDependencyHandler;", "Lcom/citi/gradle/plugins/helm/dsl/dependencies/ChartDependencyHandler;", "chart", "Lcom/citi/gradle/plugins/helm/dsl/HelmChart;", "project", "Lorg/gradle/api/Project;", "(Lcom/citi/gradle/plugins/helm/dsl/HelmChart;Lorg/gradle/api/Project;)V", "add", "", "", "helm-plugin"})
@SourceDebugExtension(value={"SMAP\nChartDependencyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartDependencyHandler.kt\ncom/citi/gradle/plugins/helm/dsl/dependencies/DefaultChartDependencyHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
class DefaultChartDependencyHandler
implements ChartDependencyHandler {
    @NotNull
    private final HelmChart chart;
    @NotNull
    private final Project project;

    @Inject
    public DefaultChartDependencyHandler(@NotNull HelmChart chart, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.chart = chart;
        this.project = project;
    }

    @Override
    public void add(@NotNull String chart, @Nullable String project) {
        ConfigurableFileCollection configurableFileCollection;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        if (!(!Intrinsics.areEqual((Object)chart, (Object)this.chart.getName()) || project != null)) {
            boolean bl = false;
            String string = "A chart cannot have a dependency on itself.";
            throw new IllegalArgumentException(string.toString());
        }
        if (project != null) {
            objectArray = new Pair[]{TuplesKt.to((Object)"path", (Object)project), TuplesKt.to((Object)"configuration", (Object)ChartPackagedArtifactRuleKt.chartPackagedArtifactConfigurationName(chart))};
            configurableFileCollection = this.project.getDependencies().project(MapsKt.mapOf((Pair[])objectArray));
        } else {
            objectArray = new Object[]{this.project.getTasks().named(PackageTaskRuleKt.chartPackageTaskName(chart))};
            configurableFileCollection = this.project.files(objectArray);
        }
        ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection;
        Intrinsics.checkNotNull((Object)configurableFileCollection2);
        ConfigurableFileCollection dependencyNotation = configurableFileCollection2;
        this.project.getDependencies().add(ChartDependenciesConfigurationRuleKt.getDependenciesConfigurationName(this.chart), (Object)dependencyNotation);
    }

    @Override
    public void add(@NotNull HelmChart chart) {
        ChartDependencyHandler.DefaultImpls.add((ChartDependencyHandler)this, chart);
    }

    @Override
    public void add(@NotNull Map<?, ?> notation) {
        ChartDependencyHandler.DefaultImpls.add((ChartDependencyHandler)this, notation);
    }
}

