/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.crush.Bucket;
import com.ceph.fs.CephFileExtent;
import com.ceph.fs.CephNativeLoader;
import com.ceph.fs.CephNotDirectoryException;
import com.ceph.fs.CephPoolException;
import com.ceph.fs.CephStat;
import com.ceph.fs.CephStatVFS;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CephMount {
    private long instance_ptr;
    public static final int O_RDONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_APPEND = 4;
    public static final int O_CREAT = 8;
    public static final int O_TRUNC = 16;
    public static final int O_EXCL = 32;
    public static final int O_WRONLY = 64;
    public static final int SEEK_SET = 1;
    public static final int SEEK_CUR = 2;
    public static final int SEEK_END = 3;
    public static final int SETATTR_MODE = 1;
    public static final int SETATTR_UID = 2;
    public static final int SETATTR_GID = 4;
    public static final int SETATTR_MTIME = 8;
    public static final int SETATTR_ATIME = 16;
    public static final int XATTR_CREATE = 1;
    public static final int XATTR_REPLACE = 2;
    public static final int XATTR_NONE = 3;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock rlock = this.rwlock.readLock();
    private final Lock wlock = this.rwlock.writeLock();
    private boolean initialized = false;

    static native void native_initialize();

    protected void finalize() throws Throwable {
        if (this.initialized) {
            try {
                this.unmount();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                CephMount.native_ceph_release(this.instance_ptr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public CephMount(String id) {
        CephMount.native_ceph_create(this, id);
        this.initialized = true;
    }

    private static native int native_ceph_create(CephMount var0, String var1);

    public CephMount() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(String root) {
        this.wlock.lock();
        try {
            CephMount.native_ceph_mount(this.instance_ptr, root);
        }
        finally {
            this.wlock.unlock();
        }
    }

    private static native int native_ceph_mount(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmount() {
        this.wlock.lock();
        try {
            CephMount.native_ceph_unmount(this.instance_ptr);
        }
        finally {
            this.wlock.unlock();
        }
    }

    private static native int native_ceph_unmount(long var0);

    private static native int native_ceph_release(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conf_read_file(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_conf_read_file(this.instance_ptr, path);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_conf_read_file(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conf_set(String option, String value) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_conf_set(this.instance_ptr, option, value);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_conf_set(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String conf_get(String option) {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_conf_get(this.instance_ptr, option);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_conf_get(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statfs(String path, CephStatVFS statvfs) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_statfs(this.instance_ptr, path, statvfs);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_statfs(long var0, String var2, CephStatVFS var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getcwd() {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_getcwd(this.instance_ptr);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_getcwd(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chdir(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_chdir(this.instance_ptr, path);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_chdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listdir(String dir) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_listdir(this.instance_ptr, dir);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_listdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(String oldpath, String newpath) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_link(this.instance_ptr, oldpath, newpath);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_link(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_unlink(this.instance_ptr, path);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_unlink(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String from, String to) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_rename(this.instance_ptr, from, to);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_rename(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(String path, int mode) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_mkdir(this.instance_ptr, path, mode);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_mkdir(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdirs(String path, int mode) throws IOException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_mkdirs(this.instance_ptr, path, mode);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_mkdirs(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmdir(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_rmdir(this.instance_ptr, path);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_rmdir(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readlink(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_readlink(this.instance_ptr, path);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_readlink(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void symlink(String oldpath, String newpath) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_symlink(this.instance_ptr, oldpath, newpath);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_symlink(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stat(String path, CephStat stat) throws FileNotFoundException, CephNotDirectoryException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_stat(this.instance_ptr, path, stat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_stat(long var0, String var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lstat(String path, CephStat stat) throws FileNotFoundException, CephNotDirectoryException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lstat(this.instance_ptr, path, stat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lstat(long var0, String var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setattr(String path, CephStat stat, int mask) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_setattr(this.instance_ptr, path, stat, mask);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_setattr(long var0, String var2, CephStat var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String path, int mode) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_chmod(this.instance_ptr, path, mode);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_chmod(long var0, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fchmod(int fd, int mode) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fchmod(this.instance_ptr, fd, mode);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fchmod(long var0, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(String path, long size) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_truncate(this.instance_ptr, path, size);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_truncate(long var0, String var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(String path, int flags, int mode) throws FileNotFoundException {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_open(this.instance_ptr, path, flags, mode);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_open(long var0, String var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(String path, int flags, int mode, int stripe_unit, int stripe_count, int object_size, String data_pool) throws FileNotFoundException {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_open_layout(this.instance_ptr, path, flags, mode, stripe_unit, stripe_count, object_size, data_pool);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_open_layout(long var0, String var2, int var3, int var4, int var5, int var6, int var7, String var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int fd) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_close(this.instance_ptr, fd);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_close(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lseek(int fd, long offset, int whence) {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_lseek(this.instance_ptr, fd, offset, whence);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_lseek(long var0, int var2, long var3, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(int fd, byte[] buf, long size, long offset) {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_read(this.instance_ptr, fd, buf, size, offset);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_read(long var0, int var2, byte[] var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(int fd, byte[] buf, long size, long offset) {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_write(this.instance_ptr, fd, buf, size, offset);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_write(long var0, int var2, byte[] var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftruncate(int fd, long size) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_ftruncate(this.instance_ptr, fd, size);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_ftruncate(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsync(int fd, boolean dataonly) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fsync(this.instance_ptr, fd, dataonly);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fsync(long var0, int var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fstat(int fd, CephStat stat) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_fstat(this.instance_ptr, fd, stat);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_fstat(long var0, int var2, CephStat var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync_fs() {
        this.rlock.lock();
        try {
            CephMount.native_ceph_sync_fs(this.instance_ptr);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_sync_fs(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getxattr(String path, String name, byte[] buf) throws FileNotFoundException {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_getxattr(this.instance_ptr, path, name, buf);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_getxattr(long var0, String var2, String var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lgetxattr(String path, String name, byte[] buf) throws FileNotFoundException {
        this.rlock.lock();
        try {
            long l = CephMount.native_ceph_lgetxattr(this.instance_ptr, path, name, buf);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native long native_ceph_lgetxattr(long var0, String var2, String var3, byte[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listxattr(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_listxattr(this.instance_ptr, path);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_listxattr(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] llistxattr(String path) throws FileNotFoundException {
        this.rlock.lock();
        try {
            String[] stringArray = CephMount.native_ceph_llistxattr(this.instance_ptr, path);
            return stringArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_llistxattr(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removexattr(String path, String name) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_removexattr(this.instance_ptr, path, name);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_removexattr(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lremovexattr(String path, String name) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lremovexattr(this.instance_ptr, path, name);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lremovexattr(long var0, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setxattr(String path, String name, byte[] buf, long size, int flags) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_setxattr(this.instance_ptr, path, name, buf, size, flags);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_setxattr(long var0, String var2, String var3, byte[] var4, long var5, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lsetxattr(String path, String name, byte[] buf, long size, int flags) throws FileNotFoundException {
        this.rlock.lock();
        try {
            CephMount.native_ceph_lsetxattr(this.instance_ptr, path, name, buf, size, flags);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_lsetxattr(long var0, String var2, String var3, byte[] var4, long var5, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_file_stripe_unit(int fd) {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_file_stripe_unit(this.instance_ptr, fd);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_file_stripe_unit(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_file_pool_name(int fd) {
        this.rlock.lock();
        try {
            String string = CephMount.native_ceph_get_file_pool_name(this.instance_ptr, fd);
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String native_ceph_get_file_pool_name(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_file_replication(int fd) {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_file_replication(this.instance_ptr, fd);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_file_replication(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localize_reads(boolean state) {
        this.rlock.lock();
        try {
            CephMount.native_ceph_localize_reads(this.instance_ptr, state);
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_localize_reads(long var0, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_stripe_unit_granularity() {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_stripe_unit_granularity(this.instance_ptr);
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_stripe_unit_granularity(long var0);

    public int get_pool_id(String name) throws CephPoolException {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_pool_id(this.instance_ptr, name);
            return n;
        }
        catch (FileNotFoundException e) {
            throw new CephPoolException("pool name " + name + " not found");
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_pool_id(long var0, String var2) throws FileNotFoundException;

    public int get_pool_replication(int pool_id) throws CephPoolException {
        this.rlock.lock();
        try {
            int n = CephMount.native_ceph_get_pool_replication(this.instance_ptr, pool_id);
            return n;
        }
        catch (FileNotFoundException e) {
            throw new CephPoolException("pool id " + pool_id + " not found");
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native int native_ceph_get_pool_replication(long var0, int var2) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CephFileExtent get_file_extent(int fd, long offset) {
        this.rlock.lock();
        try {
            CephFileExtent cephFileExtent = CephMount.native_ceph_get_file_extent_osds(this.instance_ptr, fd, offset);
            return cephFileExtent;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native CephFileExtent native_ceph_get_file_extent_osds(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket[] get_osd_crush_location(int osd) {
        this.rlock.lock();
        try {
            String[] parts = CephMount.native_ceph_get_osd_crush_location(this.instance_ptr, osd);
            Bucket[] path = new Bucket[parts.length / 2];
            for (int i = 0; i < path.length; ++i) {
                path[i] = new Bucket(parts[i * 2], parts[i * 2 + 1]);
            }
            Bucket[] bucketArray = path;
            return bucketArray;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native String[] native_ceph_get_osd_crush_location(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress get_osd_address(int osd) {
        this.rlock.lock();
        try {
            InetAddress inetAddress = CephMount.native_ceph_get_osd_addr(this.instance_ptr, osd);
            return inetAddress;
        }
        finally {
            this.rlock.unlock();
        }
    }

    private static native InetAddress native_ceph_get_osd_addr(long var0, int var2);

    static {
        CephNativeLoader.checkLoaded();
    }
}

