/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.writers;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.util.CompactMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

public class CompactMapWriter
implements JsonWriter.JsonClassWriter {
    public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
        String orderCode;
        CompactMap map = (CompactMap)obj;
        Map config = map.getConfig();
        boolean caseSensitive = (Boolean)config.get("caseSensitive");
        int compactSize = (Integer)config.get("compactSize");
        String ordering = (String)config.get("ordering");
        String singleKey = (String)config.get("singleKey");
        Class mapImplClass = (Class)config.get("mapType");
        String mapImplClassName = mapImplClass.getName();
        StringBuilder configStr = new StringBuilder();
        configStr.append(mapImplClassName).append('/');
        configStr.append(caseSensitive ? "CS" : "CI").append('/');
        configStr.append('S').append(compactSize).append('/');
        configStr.append(singleKey == null ? "-" : singleKey).append('/');
        switch (ordering) {
            case "sorted": {
                orderCode = "Sort";
                break;
            }
            case "reverse": {
                orderCode = "Rev";
                break;
            }
            case "insertion": {
                orderCode = "Ins";
                break;
            }
            default: {
                orderCode = "Unord";
            }
        }
        configStr.append(orderCode);
        output.write("\"config\":\"" + configStr + "\",");
        output.write("\"data\":{");
        boolean allStringKeys = true;
        if (!context.getWriteOptions().isForceMapOutputAsTwoArrays()) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String) continue;
                allStringKeys = false;
                break;
            }
        } else {
            allStringKeys = false;
        }
        if (allStringKeys) {
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    output.write(44);
                }
                String key = (String)entry.getKey();
                JsonWriter.writeJsonUtf8String(output, key);
                output.write(58);
                context.writeImpl(entry.getValue(), showType);
            }
        } else {
            Set entries = map.entrySet();
            int size = entries.size();
            Object[] keys = new Object[size];
            Object[] values = new Object[size];
            int i = 0;
            for (Map.Entry entry : entries) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            output.write("\"@keys\":");
            context.writeImpl(keys, showType);
            output.write(",\"@items\":");
            context.writeImpl(values, showType);
        }
        output.write("}");
    }

    @Override
    public String getTypeName(Object o) {
        return CompactMap.class.getName();
    }
}

