/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public class ArrayFactory<T>
implements JsonReader.ClassFactory {
    private final Class<T> type;

    public ArrayFactory(Class<T> c) {
        this.type = c;
    }

    public T newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object[] items = jObj.getItems();
        Converter converter = resolver.getConverter();
        if (items == null) {
            return (T)jObj.setTarget(null);
        }
        int len = items.length;
        Class<?> arrayType = this.getType();
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, len);
        boolean hasJsonObjects = false;
        for (Object item : items) {
            if (!(item instanceof JsonObject)) continue;
            hasJsonObjects = true;
            break;
        }
        if (componentType.isPrimitive()) {
            if (hasJsonObjects) {
                for (int i = 0; i < len; ++i) {
                    Object val = items[i];
                    if (val == null) continue;
                    val = val instanceof JsonObject ? this.unwrapJsonObject((JsonObject)val, componentType, converter) : converter.convert(val, componentType);
                    ArrayUtilities.setPrimitiveElement((Object)array, (int)i, (Object)val);
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    Object val = items[i];
                    if (val == null) continue;
                    val = converter.convert(val, componentType);
                    ArrayUtilities.setPrimitiveElement((Object)array, (int)i, (Object)val);
                }
            }
        } else {
            int i;
            Object[] typedArray = (Object[])array;
            if (hasJsonObjects) {
                for (i = 0; i < len; ++i) {
                    Object val = items[i];
                    if (val == null) continue;
                    val = val instanceof JsonObject ? this.unwrapJsonObject((JsonObject)val, componentType, converter) : converter.convert(val, componentType);
                    typedArray[i] = val;
                }
            } else {
                for (i = 0; i < len; ++i) {
                    Object val = items[i];
                    if (val == null) continue;
                    typedArray[i] = val = converter.convert(val, componentType);
                }
            }
        }
        return (T)jObj.setTarget(array);
    }

    private Object unwrapJsonObject(JsonObject jsonObject, Class<?> componentType, Converter converter) {
        JsonObject current;
        Object val = jsonObject;
        Type type = null;
        do {
            current = val;
            type = current.getType();
        } while (current.hasValue() && (val = current.getValue()) instanceof JsonObject);
        Class targetType = type == null ? componentType : TypeUtilities.getRawClass((Type)type);
        return converter.convert(val, targetType);
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

