/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;

public class MetaUtils {
    private MetaUtils() {
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (Object arg : args) {
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
        }
        String result = sb.toString().trim();
        return result + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        if (argCharLen < 0) {
            throw new JsonIoException("argCharLen cannot be negative: " + argCharLen);
        }
        ReadOptions defaultOptions = new ReadOptionsBuilder().build();
        int maxAllowedLength = Math.min(argCharLen, defaultOptions.getMaxAllowedLength());
        try {
            WriteOptions options = new WriteOptionsBuilder().shortMetaKeys(true).showTypeInfoNever().build();
            String arg = JsonIo.toJson(obj, options);
            if (arg.length() > maxAllowedLength) {
                arg = arg.substring(0, maxAllowedLength) + "...";
            }
            return arg;
        }
        catch (Exception e) {
            return "Error serializing object: " + e.getClass().getSimpleName();
        }
    }

    public static <K, V> V getValueWithDefaultForNull(Map map, K key, V defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        try {
            Object value = map.get(key);
            return value == null ? defaultValue : value;
        }
        catch (ClassCastException e) {
            throw new JsonIoException("Type mismatch when retrieving value for key: " + key + ". Expected type: " + (defaultValue != null ? defaultValue.getClass().getName() : "null") + ", Actual type: " + (map.get(key) != null ? map.get(key).getClass().getName() : "null"), e);
        }
    }

    public static <K, V> V getValueWithDefaultForMissing(Map map, K key, V defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        try {
            return map.get(key);
        }
        catch (ClassCastException e) {
            throw new JsonIoException("Type mismatch when retrieving value for key: " + key + ". Expected type: " + (defaultValue != null ? defaultValue.getClass().getName() : "null") + ", Actual type: " + (map.get(key) != null ? map.get(key).getClass().getName() : "null"), e);
        }
    }

    @Deprecated
    public static boolean isLogicalPrimitive(Class<?> c) {
        return ClassUtilities.isPrimitive(c) || c.equals(String.class) || Number.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    public static Map<String, String> loadMapDefinition(String resName, ReadOptions readOptions) {
        if (resName == null || resName.trim().isEmpty()) {
            throw new JsonIoException("Resource name cannot be null or empty");
        }
        if (resName.contains("..") || resName.contains("\\") || resName.startsWith("/")) {
            throw new JsonIoException("Invalid resource name: " + resName + ". Resource names cannot contain '..' or path separators.");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try (Scanner scanner = null;){
            String contents = ClassUtilities.loadResourceAsString((String)resName);
            int maxFileContentSize = readOptions.getMaxFileContentSize();
            if (contents.length() > maxFileContentSize) {
                throw new JsonIoException("Resource file too large: " + resName + " (" + contents.length() + " bytes). Maximum allowed: " + maxFileContentSize + " bytes");
            }
            scanner = new Scanner(contents);
            int lineCount = 0;
            int maxLineCount = readOptions.getMaxLineCount();
            int maxLineLength = readOptions.getMaxLineLength();
            while (scanner.hasNextLine()) {
                if (++lineCount > maxLineCount) {
                    throw new JsonIoException("Resource file has too many lines: " + resName + " (" + lineCount + " lines). Maximum allowed: " + maxLineCount);
                }
                String line = scanner.nextLine();
                if (line.length() > maxLineLength) {
                    throw new JsonIoException("Line too long in resource file: " + resName + " (line " + lineCount + ", " + line.length() + " chars). Maximum allowed: " + maxLineLength + " chars per line");
                }
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) continue;
                String[] parts = line.split("=", 2);
                if (parts.length != 2) {
                    throw new JsonIoException("Invalid format in resource file: " + resName + " at line " + lineCount + ". Expected format: key=value");
                }
                String key = parts[0].trim();
                String value = parts[1].trim();
                if (key.isEmpty()) {
                    throw new JsonIoException("Empty key found in resource file: " + resName + " at line " + lineCount);
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static Map<String, String> loadMapDefinition(String resName) {
        ReadOptions defaultOptions = new ReadOptionsBuilder().build();
        return MetaUtils.loadMapDefinition(resName, defaultOptions);
    }

    public static Set<String> loadSetDefinition(String resName, ReadOptions readOptions) {
        if (resName == null || resName.trim().isEmpty()) {
            throw new JsonIoException("Resource name cannot be null or empty");
        }
        if (resName.contains("..") || resName.contains("\\") || resName.startsWith("/")) {
            throw new JsonIoException("Invalid resource name: " + resName + ". Resource names cannot contain '..' or path separators.");
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try (Scanner scanner = null;){
            String contents = ClassUtilities.loadResourceAsString((String)resName);
            int maxFileContentSize = readOptions.getMaxFileContentSize();
            if (contents.length() > maxFileContentSize) {
                throw new JsonIoException("Resource file too large: " + resName + " (" + contents.length() + " bytes). Maximum allowed: " + maxFileContentSize + " bytes");
            }
            scanner = new Scanner(contents);
            int lineCount = 0;
            int maxLineCount = readOptions.getMaxLineCount();
            int maxLineLength = readOptions.getMaxLineLength();
            while (scanner.hasNextLine()) {
                if (++lineCount > maxLineCount) {
                    throw new JsonIoException("Resource file has too many lines: " + resName + " (" + lineCount + " lines). Maximum allowed: " + maxLineCount);
                }
                String line = scanner.nextLine();
                if (line.length() > maxLineLength) {
                    throw new JsonIoException("Line too long in resource file: " + resName + " (line " + lineCount + ", " + line.length() + " chars). Maximum allowed: " + maxLineLength + " chars per line");
                }
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#") || trimmedLine.isEmpty()) continue;
                set.add(trimmedLine);
            }
        }
        return set;
    }

    public static Set<String> loadSetDefinition(String resName) {
        ReadOptions defaultOptions = new ReadOptionsBuilder().build();
        return MetaUtils.loadSetDefinition(resName, defaultOptions);
    }

    @Deprecated
    public static String loadResourceAsString(String resourceName) {
        return ClassUtilities.loadResourceAsString((String)resourceName);
    }

    @Deprecated
    public static byte[] loadResourceAsBytes(String resourceName) {
        return ClassUtilities.loadResourceAsBytes((String)resourceName);
    }

    @Deprecated
    public static String removeLeadingAndTrailingQuotes(String input) {
        return StringUtilities.removeLeadingAndTrailingQuotes((String)input);
    }

    @Deprecated
    public static <T> T findClosest(Class<?> clazz, Map<Class<?>, T> workerClasses, T defaultClass) {
        return (T)ClassUtilities.findClosest(clazz, workerClasses, defaultClass);
    }

    @Deprecated
    public static void setUseUnsafe(boolean state) {
        ClassUtilities.setUseUnsafe((boolean)state);
    }

    @Deprecated
    public static Object newInstance(Converter converter, Class<?> c, Collection<?> argumentValues) {
        return ClassUtilities.newInstance((Converter)converter, c, argumentValues);
    }

    @Deprecated
    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        return (T)ExceptionUtilities.safelyIgnoreException(callable, defaultValue);
    }

    @Deprecated
    public static void safelyIgnoreException(Runnable runnable) {
        ExceptionUtilities.safelyIgnoreException((Runnable)runnable);
    }

    @Deprecated
    public static int length(String s) {
        return StringUtilities.length((String)s);
    }

    @Deprecated
    public static int trimLength(String s) {
        return StringUtilities.trimLength((String)s);
    }

    @Deprecated
    public static Class<?> getClassIfEnum(Class<?> c) {
        return ClassUtilities.getClassIfEnum(c);
    }

    @Deprecated
    public static boolean isPrimitive(Class<?> c) {
        return ClassUtilities.isPrimitive(c);
    }

    @Deprecated
    public static void trySetAccessible(AccessibleObject object) {
        ExceptionUtilities.safelyIgnoreException(() -> object.setAccessible(true));
    }

    public static final class Dumpty
    extends Enum<Dumpty> {
        private static final /* synthetic */ Dumpty[] $VALUES;

        public static Dumpty[] values() {
            return (Dumpty[])$VALUES.clone();
        }

        public static Dumpty valueOf(String name) {
            return Enum.valueOf(Dumpty.class, name);
        }

        private static /* synthetic */ Dumpty[] $values() {
            return new Dumpty[0];
        }

        static {
            $VALUES = Dumpty.$values();
        }
    }
}

