/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.ExceptionUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Accessor {
    private final String uniqueFieldName;
    private final Field field;
    private final boolean isMethod;
    private final String fieldOrMethodName;
    private final MethodHandle methodHandle;
    private final boolean isPublic;

    private Accessor(Field field, MethodHandle methodHandle, String uniqueFieldName, String fieldOrMethodName, boolean isPublic, boolean isMethod) {
        this.field = field;
        this.methodHandle = methodHandle;
        this.uniqueFieldName = uniqueFieldName;
        this.fieldOrMethodName = fieldOrMethodName;
        this.isPublic = isPublic;
        this.isMethod = isMethod;
    }

    public static Accessor createFieldAccessor(Field field, String uniqueFieldName) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            ExceptionUtilities.safelyIgnoreException(() -> field.setAccessible(true));
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            return new Accessor(field, handle, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
        catch (IllegalAccessException ex) {
            return new Accessor(field, null, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
    }

    public static Accessor createMethodAccessor(Field field, String methodName, String uniqueFieldName) {
        try {
            MethodType type = MethodType.methodType(field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), methodName, type);
            return new Accessor(field, handle, uniqueFieldName, methodName, true, true);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Object retrieve(Object o) {
        if (o == null) {
            throw new JsonIoException("Cannot retrieve field value from null object for field: " + this.getActualFieldName());
        }
        Class<?> declaringClass = this.field.getDeclaringClass();
        if (!declaringClass.isInstance(o)) {
            throw new JsonIoException("Object is not an instance of the field's declaring class. Expected: " + declaringClass.getName() + ", Actual: " + o.getClass().getName() + " for field: " + this.getActualFieldName());
        }
        try {
            if (this.methodHandle != null) {
                try {
                    return this.methodHandle.invoke(o);
                }
                catch (Throwable t) {
                    return this.field.get(o);
                }
            }
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            if (Accessor.isJdkInternalClass(declaringClass)) {
                return Accessor.handleInaccessibleJdkField(declaringClass, this.getActualFieldName());
            }
            throw new JsonIoException("Failed to retrieve field value: " + this.getActualFieldName() + " in class: " + declaringClass.getName(), e);
        }
        catch (Throwable t) {
            throw new JsonIoException("Failed to retrieve field value: " + this.getActualFieldName() + " in class: " + declaringClass.getName(), t);
        }
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getActualFieldName() {
        return this.field.getName();
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    public String getFieldOrMethodName() {
        return this.fieldOrMethodName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    private static boolean isJdkInternalClass(Class<?> clazz) {
        String className = clazz.getName();
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.contains(".internal.");
    }

    private static Object handleInaccessibleJdkField(Class<?> declaringClass, String fieldName) {
        String className = declaringClass.getName();
        if ("java.util.regex.Pattern".equals(className) && "pattern".equals(fieldName)) {
            return null;
        }
        if ("java.lang.ProcessImpl".equals(className) && "pid".equals(fieldName)) {
            return null;
        }
        if (className.contains("ClassLoader") && "parent".equals(fieldName)) {
            return null;
        }
        return null;
    }
}

