/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonValue;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.factory.ArrayFactory;
import com.cedarsoftware.io.factory.EnumClassFactory;
import com.cedarsoftware.io.factory.RecordFactory;
import com.cedarsoftware.io.factory.ThrowableFactory;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.io.reflect.InjectorFactory;
import com.cedarsoftware.io.reflect.factories.MethodInjectorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.ClassValueSet;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ReadOptionsBuilder {
    private static final Logger LOG = Logger.getLogger(ReadOptionsBuilder.class.getName());
    private static final Map<Class<?>, JsonReader.JsonClassReader> BASE_READERS;
    private static final Map<Class<?>, JsonReader.ClassFactory> BASE_CLASS_FACTORIES;
    private static final Map<String, String> BASE_ALIAS_MAPPINGS;
    private static final Map<Class<?>, Class<?>> BASE_COERCED_TYPES;
    private static final Set<Class<?>> BASE_NON_REFS;
    private static final Set<Class<?>> BASE_NOT_CUSTOM_READ;
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_SETTERS;
    private static final Map<Class<?>, Set<String>> BASE_NOT_IMPORTED_FIELDS;
    private static volatile int BASE_MAX_UNRESOLVED_REFERENCES;
    private static volatile int BASE_MAX_STACK_DEPTH;
    private static volatile int BASE_MAX_MAPS_TO_REHASH;
    private static volatile int BASE_MAX_MISSING_FIELDS;
    private static volatile int BASE_MAX_OBJECT_REFERENCES;
    private static volatile int BASE_MAX_REFERENCE_CHAIN_DEPTH;
    private static volatile int BASE_MAX_ENUM_NAME_LENGTH;
    private static volatile long BASE_MAX_ID_VALUE;
    private static volatile int BASE_STRING_BUFFER_SIZE;
    private static volatile int BASE_THREAD_LOCAL_BUFFER_SIZE;
    private static volatile int BASE_LARGE_THREAD_LOCAL_BUFFER_SIZE;
    private static volatile int BASE_MAX_ALLOWED_LENGTH;
    private static volatile int BASE_MAX_FILE_CONTENT_SIZE;
    private static volatile int BASE_MAX_LINE_COUNT;
    private static volatile int BASE_MAX_LINE_LENGTH;
    private static volatile int BASE_MAX_TYPE_RESOLUTION_CACHE_SIZE;
    private static volatile int BASE_DEFAULT_COLLECTION_CAPACITY;
    private static volatile float BASE_COLLECTION_LOAD_FACTOR;
    private static volatile int BASE_MIN_COLLECTION_CAPACITY;
    private static volatile int BASE_LINEAR_SEARCH_THRESHOLD;
    private static volatile int BASE_MAX_DEPTH;
    private static volatile int BASE_LRU_SIZE;
    private static volatile boolean BASE_ALLOW_NAN_AND_INFINITY;
    private static volatile boolean BASE_FAIL_ON_UNKNOWN_TYPE;
    private static volatile boolean BASE_CLOSE_STREAM;
    private static final Map<Class<?>, Map<String, Field>> classMetaCache;
    private static final Map<Class<?>, Map<String, Injector>> injectorsCache;
    private static final ReadOptions defReadOptions;
    private final DefaultReadOptions options = new DefaultReadOptions();

    public static ReadOptions getDefaultReadOptions() {
        return defReadOptions;
    }

    public ReadOptionsBuilder() {
        BASE_ALIAS_MAPPINGS.forEach((srcType, alias) -> this.options.aliasTypeNames.put(alias, srcType));
        this.addInjectorFactory(new MethodInjectorFactory());
        this.addFieldFilter(new StaticFieldFilter());
        this.addFieldFilter(new EnumFieldFilter());
        this.options.coercedTypes.putAll(BASE_COERCED_TYPES);
        this.options.customReaderClasses.putAll(BASE_READERS);
        this.options.classFactoryMap.putAll(BASE_CLASS_FACTORIES);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.notCustomReadClasses.addAll(BASE_NOT_CUSTOM_READ);
        this.options.excludedFieldNames.putAll(WriteOptionsBuilder.BASE_EXCLUDED_FIELD_NAMES);
        this.options.fieldsNotImported.putAll(BASE_NOT_IMPORTED_FIELDS);
        this.options.maxUnresolvedReferences = ReadOptionsBuilder.BASE_MAX_UNRESOLVED_REFERENCES;
        this.options.maxStackDepth = ReadOptionsBuilder.BASE_MAX_STACK_DEPTH;
        this.options.maxMapsToRehash = ReadOptionsBuilder.BASE_MAX_MAPS_TO_REHASH;
        this.options.maxMissingFields = ReadOptionsBuilder.BASE_MAX_MISSING_FIELDS;
        this.options.maxObjectReferences = ReadOptionsBuilder.BASE_MAX_OBJECT_REFERENCES;
        this.options.maxReferenceChainDepth = ReadOptionsBuilder.BASE_MAX_REFERENCE_CHAIN_DEPTH;
        this.options.maxEnumNameLength = ReadOptionsBuilder.BASE_MAX_ENUM_NAME_LENGTH;
        this.options.maxIdValue = ReadOptionsBuilder.BASE_MAX_ID_VALUE;
        this.options.stringBufferSize = ReadOptionsBuilder.BASE_STRING_BUFFER_SIZE;
        this.options.threadLocalBufferSize = ReadOptionsBuilder.BASE_THREAD_LOCAL_BUFFER_SIZE;
        this.options.largeThreadLocalBufferSize = ReadOptionsBuilder.BASE_LARGE_THREAD_LOCAL_BUFFER_SIZE;
        this.options.maxAllowedLength = ReadOptionsBuilder.BASE_MAX_ALLOWED_LENGTH;
        this.options.maxFileContentSize = ReadOptionsBuilder.BASE_MAX_FILE_CONTENT_SIZE;
        this.options.maxLineCount = ReadOptionsBuilder.BASE_MAX_LINE_COUNT;
        this.options.maxLineLength = ReadOptionsBuilder.BASE_MAX_LINE_LENGTH;
        this.options.maxTypeResolutionCacheSize = ReadOptionsBuilder.BASE_MAX_TYPE_RESOLUTION_CACHE_SIZE;
        this.options.defaultCollectionCapacity = ReadOptionsBuilder.BASE_DEFAULT_COLLECTION_CAPACITY;
        this.options.collectionLoadFactor = ReadOptionsBuilder.BASE_COLLECTION_LOAD_FACTOR;
        this.options.minCollectionCapacity = ReadOptionsBuilder.BASE_MIN_COLLECTION_CAPACITY;
        this.options.linearSearchThreshold = ReadOptionsBuilder.BASE_LINEAR_SEARCH_THRESHOLD;
        this.options.maxDepth = ReadOptionsBuilder.BASE_MAX_DEPTH;
        this.options.lruSize = ReadOptionsBuilder.BASE_LRU_SIZE;
        this.options.allowNanAndInfinity = ReadOptionsBuilder.BASE_ALLOW_NAN_AND_INFINITY;
        this.options.failOnUnknownType = ReadOptionsBuilder.BASE_FAIL_ON_UNKNOWN_TYPE;
        this.options.closeStream = ReadOptionsBuilder.BASE_CLOSE_STREAM;
    }

    public ReadOptionsBuilder(ReadOptions copy) {
        this();
        if (copy != null) {
            DefaultReadOptions other = (DefaultReadOptions)copy;
            this.options.converterOptions = other.converterOptions;
            this.options.allowNanAndInfinity = other.allowNanAndInfinity;
            this.options.closeStream = other.closeStream;
            this.options.failOnUnknownType = other.failOnUnknownType;
            this.options.maxDepth = other.maxDepth;
            this.options.lruSize = other.lruSize;
            this.options.returnType = other.returnType;
            this.options.unknownTypeClass = other.unknownTypeClass;
            this.options.missingFieldHandler = other.missingFieldHandler;
            this.options.decimalType = other.decimalType;
            this.options.integerType = other.integerType;
            this.options.useUnsafe = other.useUnsafe;
            this.options.maxUnresolvedReferences = other.maxUnresolvedReferences;
            this.options.maxStackDepth = other.maxStackDepth;
            this.options.maxMapsToRehash = other.maxMapsToRehash;
            this.options.maxMissingFields = other.maxMissingFields;
            this.options.maxObjectReferences = other.maxObjectReferences;
            this.options.maxReferenceChainDepth = other.maxReferenceChainDepth;
            this.options.maxEnumNameLength = other.maxEnumNameLength;
            this.options.maxIdValue = other.maxIdValue;
            this.options.stringBufferSize = other.stringBufferSize;
            this.options.threadLocalBufferSize = other.threadLocalBufferSize;
            this.options.largeThreadLocalBufferSize = other.largeThreadLocalBufferSize;
            this.options.maxAllowedLength = other.maxAllowedLength;
            this.options.maxFileContentSize = other.maxFileContentSize;
            this.options.maxLineCount = other.maxLineCount;
            this.options.maxLineLength = other.maxLineLength;
            this.options.maxTypeResolutionCacheSize = other.maxTypeResolutionCacheSize;
            this.options.defaultCollectionCapacity = other.defaultCollectionCapacity;
            this.options.collectionLoadFactor = other.collectionLoadFactor;
            this.options.minCollectionCapacity = other.minCollectionCapacity;
            this.options.linearSearchThreshold = other.linearSearchThreshold;
            this.options.aliasTypeNames.clear();
            this.options.aliasTypeNames.putAll(other.aliasTypeNames);
            this.options.injectorFactories.clear();
            this.options.injectorFactories.addAll(other.injectorFactories);
            this.options.fieldFilters.clear();
            this.options.fieldFilters.addAll(other.fieldFilters);
            this.options.excludedFieldNames.clear();
            this.options.excludedFieldNames.putAll(other.excludedFieldNames);
            this.options.fieldsNotImported.clear();
            this.options.fieldsNotImported.putAll(other.fieldsNotImported);
            this.options.coercedTypes.clear();
            this.options.coercedTypes.putAll(other.coercedTypes);
            this.options.customReaderClasses.clear();
            this.options.customReaderClasses.putAll(other.customReaderClasses);
            this.options.notCustomReadClasses.clear();
            this.options.notCustomReadClasses.addAll(other.notCustomReadClasses);
            this.options.classFactoryMap.clear();
            this.options.classFactoryMap.putAll(other.classFactoryMap);
            this.options.nonRefClasses.clear();
            this.options.nonRefClasses.addAll(other.nonRefClasses);
        }
    }

    public static void addPermanentClassFactory(Class<?> sourceClass, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(sourceClass, factory);
    }

    @Deprecated
    public static void assignInstantiator(Class<?> classToCreate, JsonReader.ClassFactory factory) {
        BASE_CLASS_FACTORIES.put(classToCreate, factory);
    }

    public static void addPermanentCoercedType(Class<?> sourceClass, Class<?> destinationClass) {
        BASE_COERCED_TYPES.put(sourceClass, destinationClass);
    }

    public static void addPermanentAlias(Class<?> sourceClass, String alias) {
        BASE_ALIAS_MAPPINGS.put(sourceClass.getName(), alias);
    }

    public static void removePermanentAliasTypeNamesMatching(String classNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)classNamePattern);
        Pattern pattern = Pattern.compile(regex);
        BASE_ALIAS_MAPPINGS.values().removeIf(value -> pattern.matcher((CharSequence)value).matches());
    }

    public static void addPermanentReader(Class<?> c, JsonReader.JsonClassReader reader) {
        BASE_READERS.put(c, reader);
    }

    public static void addPermanentNonReferenceableClass(Class<?> clazz) {
        BASE_NON_REFS.add(clazz);
    }

    public static void addPermanentNotCustomReadClass(Class<?> clazz) {
        BASE_NOT_CUSTOM_READ.add(clazz);
    }

    public static void addPermanentNotImportedField(Class<?> clazz, String fieldName) {
        BASE_NOT_IMPORTED_FIELDS.computeIfAbsent(clazz, k -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    public static void addPermanentNonStandardSetter(Class<?> clazz, String fieldName, String alias) {
        BASE_NONSTANDARD_SETTERS.computeIfAbsent(clazz, k -> new ConcurrentHashMap()).put(fieldName, alias);
    }

    public static void addPermanentMaxUnresolvedReferences(int maxUnresolvedReferences) {
        BASE_MAX_UNRESOLVED_REFERENCES = maxUnresolvedReferences;
    }

    public static void addPermanentMaxStackDepth(int maxStackDepth) {
        BASE_MAX_STACK_DEPTH = maxStackDepth;
    }

    public static void addPermanentMaxMapsToRehash(int maxMapsToRehash) {
        BASE_MAX_MAPS_TO_REHASH = maxMapsToRehash;
    }

    public static void addPermanentMaxMissingFields(int maxMissingFields) {
        BASE_MAX_MISSING_FIELDS = maxMissingFields;
    }

    public static void addPermanentMaxObjectReferences(int maxObjectReferences) {
        BASE_MAX_OBJECT_REFERENCES = maxObjectReferences;
    }

    public static void addPermanentMaxReferenceChainDepth(int maxReferenceChainDepth) {
        BASE_MAX_REFERENCE_CHAIN_DEPTH = maxReferenceChainDepth;
    }

    public static void addPermanentMaxEnumNameLength(int maxEnumNameLength) {
        BASE_MAX_ENUM_NAME_LENGTH = maxEnumNameLength;
    }

    public static void addPermanentMaxIdValue(long maxIdValue) {
        BASE_MAX_ID_VALUE = maxIdValue;
    }

    public static void addPermanentStringBufferSize(int stringBufferSize) {
        BASE_STRING_BUFFER_SIZE = stringBufferSize;
    }

    public static void addPermanentThreadLocalBufferSize(int threadLocalBufferSize) {
        if (threadLocalBufferSize < 1) {
            throw new JsonIoException("threadLocalBufferSize must be at least 1, value: " + threadLocalBufferSize);
        }
        BASE_THREAD_LOCAL_BUFFER_SIZE = threadLocalBufferSize;
    }

    public static void addPermanentLargeThreadLocalBufferSize(int largeThreadLocalBufferSize) {
        if (largeThreadLocalBufferSize < 1) {
            throw new JsonIoException("largeThreadLocalBufferSize must be at least 1, value: " + largeThreadLocalBufferSize);
        }
        BASE_LARGE_THREAD_LOCAL_BUFFER_SIZE = largeThreadLocalBufferSize;
    }

    public static void addPermanentMaxAllowedLength(int maxAllowedLength) {
        BASE_MAX_ALLOWED_LENGTH = maxAllowedLength;
    }

    public static void addPermanentMaxFileContentSize(int maxFileContentSize) {
        BASE_MAX_FILE_CONTENT_SIZE = maxFileContentSize;
    }

    public static void addPermanentMaxLineCount(int maxLineCount) {
        BASE_MAX_LINE_COUNT = maxLineCount;
    }

    public static void addPermanentMaxLineLength(int maxLineLength) {
        BASE_MAX_LINE_LENGTH = maxLineLength;
    }

    public static void addPermanentMaxTypeResolutionCacheSize(int maxTypeResolutionCacheSize) {
        if (maxTypeResolutionCacheSize < 1) {
            throw new JsonIoException("maxTypeResolutionCacheSize must be at least 1, value: " + maxTypeResolutionCacheSize);
        }
        BASE_MAX_TYPE_RESOLUTION_CACHE_SIZE = maxTypeResolutionCacheSize;
        JsonValue.setMaxTypeResolutionCacheSize(maxTypeResolutionCacheSize);
    }

    public static void addPermanentDefaultCollectionCapacity(int defaultCollectionCapacity) {
        if (defaultCollectionCapacity < 1) {
            throw new JsonIoException("defaultCollectionCapacity must be at least 1, value: " + defaultCollectionCapacity);
        }
        BASE_DEFAULT_COLLECTION_CAPACITY = defaultCollectionCapacity;
    }

    public static void addPermanentCollectionLoadFactor(float collectionLoadFactor) {
        if (collectionLoadFactor <= 0.0f || collectionLoadFactor >= 1.0f) {
            throw new JsonIoException("collectionLoadFactor must be between 0.0 and 1.0 (exclusive), value: " + collectionLoadFactor);
        }
        BASE_COLLECTION_LOAD_FACTOR = collectionLoadFactor;
    }

    public static void addPermanentMinCollectionCapacity(int minCollectionCapacity) {
        if (minCollectionCapacity < 1) {
            throw new JsonIoException("minCollectionCapacity must be at least 1, value: " + minCollectionCapacity);
        }
        BASE_MIN_COLLECTION_CAPACITY = minCollectionCapacity;
    }

    public static void addPermanentLinearSearchThreshold(int linearSearchThreshold) {
        if (linearSearchThreshold < 1) {
            throw new JsonIoException("linearSearchThreshold must be at least 1, value: " + linearSearchThreshold);
        }
        BASE_LINEAR_SEARCH_THRESHOLD = linearSearchThreshold;
        JsonObject.setLinearSearchThreshold(linearSearchThreshold);
    }

    public static void addPermanentMaxDepth(int maxDepth) {
        if (maxDepth < 1) {
            throw new JsonIoException("maxDepth must be at least 1, value: " + maxDepth);
        }
        BASE_MAX_DEPTH = maxDepth;
    }

    public static void addPermanentLruSize(int lruSize) {
        if (lruSize < 1) {
            throw new JsonIoException("lruSize must be at least 1, value: " + lruSize);
        }
        BASE_LRU_SIZE = lruSize;
    }

    public static void addPermanentAllowNanAndInfinity(boolean allowNanAndInfinity) {
        BASE_ALLOW_NAN_AND_INFINITY = allowNanAndInfinity;
    }

    public static void addPermanentFailOnUnknownType(boolean failOnUnknownType) {
        BASE_FAIL_ON_UNKNOWN_TYPE = failOnUnknownType;
    }

    public static void addPermanentCloseStream(boolean closeStream) {
        BASE_CLOSE_STREAM = closeStream;
    }

    public ReadOptions build() {
        this.options.clearCaches();
        JsonValue.setMaxTypeResolutionCacheSize(this.options.maxTypeResolutionCacheSize);
        JsonObject.setLinearSearchThreshold(this.options.linearSearchThreshold);
        this.options.aliasTypeNames = Collections.unmodifiableMap(this.options.aliasTypeNames);
        this.options.coercedTypes = ((ClassValueMap)this.options.coercedTypes).unmodifiableView();
        this.options.notCustomReadClasses = ((ClassValueSet)this.options.notCustomReadClasses).unmodifiableView();
        this.options.customReaderClasses = ((ClassValueMap)this.options.customReaderClasses).unmodifiableView();
        this.options.classFactoryMap = ((ClassValueMap)this.options.classFactoryMap).unmodifiableView();
        this.options.nonRefClasses = ((ClassValueSet)this.options.nonRefClasses).unmodifiableView();
        this.options.converterOptions.converterOverrides = Collections.unmodifiableMap(this.options.converterOptions.converterOverrides);
        this.options.converterOptions.customOptions = Collections.unmodifiableMap(this.options.converterOptions.customOptions);
        this.options.excludedFieldNames = ((ClassValueMap)this.options.excludedFieldNames).unmodifiableView();
        this.options.fieldsNotImported = ((ClassValueMap)this.options.fieldsNotImported).unmodifiableView();
        this.options.fieldFilters = Collections.unmodifiableList(this.options.fieldFilters);
        this.options.injectorFactories = Collections.unmodifiableList(this.options.injectorFactories);
        this.options.customOptions = Collections.unmodifiableMap(this.options.customOptions);
        return this.options;
    }

    public ReadOptionsBuilder addInjectorFactory(InjectorFactory factory) {
        this.options.injectorFactories.add(factory);
        return this;
    }

    public ReadOptionsBuilder addFieldFilter(FieldFilter filter) {
        this.options.fieldFilters.add(filter);
        return this;
    }

    public ReadOptionsBuilder addNotCustomReaderClass(Class<?> notCustomClass) {
        this.options.notCustomReadClasses.add(notCustomClass);
        return this;
    }

    public ReadOptionsBuilder replaceNotCustomReaderClasses(Collection<? extends Class<?>> notCustomClasses) {
        this.options.notCustomReadClasses.clear();
        this.options.notCustomReadClasses.addAll(notCustomClasses);
        return this;
    }

    public ReadOptionsBuilder addConverterOverride(Class<?> source, Class<?> target, Convert<?> conversionFunction) {
        source = ClassUtilities.toPrimitiveWrapperClass(source);
        target = ClassUtilities.toPrimitiveWrapperClass(target);
        this.options.converterOptions.converterOverrides.put(Converter.pair((Class)source, (Class)target), conversionFunction);
        return this;
    }

    public ReadOptionsBuilder replaceCustomReaderClasses(Map<? extends Class<?>, ? extends JsonReader.JsonClassReader> customReaderClasses) {
        this.options.customReaderClasses.clear();
        this.options.customReaderClasses.putAll(customReaderClasses);
        return this;
    }

    public <T> ReadOptionsBuilder addCustomReaderClass(Class<T> clazz, JsonReader.JsonClassReader<? super T> customReader) {
        this.options.customReaderClasses.put(clazz, customReader);
        return this;
    }

    public ReadOptionsBuilder replaceClassFactories(Map<? extends Class<?>, ? extends JsonReader.ClassFactory> factories) {
        this.options.classFactoryMap.clear();
        this.options.classFactoryMap.putAll(factories);
        return this;
    }

    public ReadOptionsBuilder addClassFactory(Class<?> clazz, JsonReader.ClassFactory factory) {
        this.options.classFactoryMap.put(clazz, factory);
        return this;
    }

    @Deprecated
    public ReadOptionsBuilder returnAsNativeJsonObjects() {
        this.options.returnType = ReadOptions.ReturnType.JSON_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder returnAsJsonObjects() {
        this.options.returnType = ReadOptions.ReturnType.JSON_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder returnAsJavaObjects() {
        this.options.returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        return this;
    }

    public ReadOptionsBuilder floatPointDouble() {
        this.options.decimalType = ReadOptions.Decimals.DOUBLE;
        return this;
    }

    public ReadOptionsBuilder floatPointBigDecimal() {
        this.options.decimalType = ReadOptions.Decimals.BIG_DECIMAL;
        return this;
    }

    public ReadOptionsBuilder floatPointBoth() {
        this.options.decimalType = ReadOptions.Decimals.BOTH;
        return this;
    }

    public ReadOptionsBuilder integerTypeLong() {
        this.options.integerType = ReadOptions.Integers.LONG;
        return this;
    }

    public ReadOptionsBuilder integerTypeBigInteger() {
        this.options.integerType = ReadOptions.Integers.BOTH;
        return this;
    }

    public ReadOptionsBuilder integerTypeBoth() {
        this.options.integerType = ReadOptions.Integers.BOTH;
        return this;
    }

    public ReadOptionsBuilder classLoader(ClassLoader classLoader) {
        Convention.throwIfNull((Object)classLoader, (String)"classloader cannot be null");
        this.options.converterOptions.classloader = classLoader;
        return this;
    }

    public ReadOptionsBuilder failOnUnknownType(boolean fail) {
        this.options.failOnUnknownType = fail;
        return this;
    }

    public ReadOptionsBuilder unknownTypeClass(Class<?> c) {
        this.options.unknownTypeClass = c;
        return this;
    }

    public ReadOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public ReadOptionsBuilder maxDepth(int maxDepth) {
        this.options.maxDepth = maxDepth;
        return this;
    }

    public ReadOptionsBuilder maxUnresolvedReferences(int maxUnresolvedReferences) {
        this.options.maxUnresolvedReferences = maxUnresolvedReferences;
        return this;
    }

    public ReadOptionsBuilder maxStackDepth(int maxStackDepth) {
        this.options.maxStackDepth = maxStackDepth;
        return this;
    }

    public ReadOptionsBuilder maxMapsToRehash(int maxMapsToRehash) {
        this.options.maxMapsToRehash = maxMapsToRehash;
        return this;
    }

    public ReadOptionsBuilder maxMissingFields(int maxMissingFields) {
        this.options.maxMissingFields = maxMissingFields;
        return this;
    }

    public ReadOptionsBuilder maxObjectReferences(int maxObjectReferences) {
        this.options.maxObjectReferences = maxObjectReferences;
        return this;
    }

    public ReadOptionsBuilder maxReferenceChainDepth(int maxReferenceChainDepth) {
        this.options.maxReferenceChainDepth = maxReferenceChainDepth;
        return this;
    }

    public ReadOptionsBuilder maxEnumNameLength(int maxEnumNameLength) {
        this.options.maxEnumNameLength = maxEnumNameLength;
        return this;
    }

    public ReadOptionsBuilder maxIdValue(long maxIdValue) {
        this.options.maxIdValue = maxIdValue;
        return this;
    }

    public ReadOptionsBuilder stringBufferSize(int stringBufferSize) {
        this.options.stringBufferSize = stringBufferSize;
        return this;
    }

    public ReadOptionsBuilder threadLocalBufferSize(int threadLocalBufferSize) {
        if (threadLocalBufferSize < 1) {
            throw new JsonIoException("threadLocalBufferSize must be at least 1, value: " + threadLocalBufferSize);
        }
        this.options.threadLocalBufferSize = threadLocalBufferSize;
        return this;
    }

    public ReadOptionsBuilder largeThreadLocalBufferSize(int largeThreadLocalBufferSize) {
        if (largeThreadLocalBufferSize < 1) {
            throw new JsonIoException("largeThreadLocalBufferSize must be at least 1, value: " + largeThreadLocalBufferSize);
        }
        this.options.largeThreadLocalBufferSize = largeThreadLocalBufferSize;
        return this;
    }

    public ReadOptionsBuilder maxAllowedLength(int maxAllowedLength) {
        this.options.maxAllowedLength = maxAllowedLength;
        return this;
    }

    public ReadOptionsBuilder maxFileContentSize(int maxFileContentSize) {
        this.options.maxFileContentSize = maxFileContentSize;
        return this;
    }

    public ReadOptionsBuilder maxLineCount(int maxLineCount) {
        this.options.maxLineCount = maxLineCount;
        return this;
    }

    public ReadOptionsBuilder maxLineLength(int maxLineLength) {
        this.options.maxLineLength = maxLineLength;
        return this;
    }

    public ReadOptionsBuilder maxTypeResolutionCacheSize(int maxTypeResolutionCacheSize) {
        if (maxTypeResolutionCacheSize < 1) {
            throw new JsonIoException("maxTypeResolutionCacheSize must be at least 1, value: " + maxTypeResolutionCacheSize);
        }
        this.options.maxTypeResolutionCacheSize = maxTypeResolutionCacheSize;
        return this;
    }

    public ReadOptionsBuilder defaultCollectionCapacity(int defaultCollectionCapacity) {
        if (defaultCollectionCapacity < 1) {
            throw new JsonIoException("defaultCollectionCapacity must be at least 1, value: " + defaultCollectionCapacity);
        }
        this.options.defaultCollectionCapacity = defaultCollectionCapacity;
        return this;
    }

    public ReadOptionsBuilder collectionLoadFactor(float collectionLoadFactor) {
        if (collectionLoadFactor <= 0.0f || collectionLoadFactor >= 1.0f) {
            throw new JsonIoException("collectionLoadFactor must be between 0.0 and 1.0 (exclusive), value: " + collectionLoadFactor);
        }
        this.options.collectionLoadFactor = collectionLoadFactor;
        return this;
    }

    public ReadOptionsBuilder minCollectionCapacity(int minCollectionCapacity) {
        if (minCollectionCapacity < 1) {
            throw new JsonIoException("minCollectionCapacity must be at least 1, value: " + minCollectionCapacity);
        }
        this.options.minCollectionCapacity = minCollectionCapacity;
        return this;
    }

    public ReadOptionsBuilder linearSearchThreshold(int linearSearchThreshold) {
        if (linearSearchThreshold < 1) {
            throw new JsonIoException("linearSearchThreshold must be at least 1, value: " + linearSearchThreshold);
        }
        this.options.linearSearchThreshold = linearSearchThreshold;
        return this;
    }

    public ReadOptionsBuilder lruSize(int lruSize) {
        this.options.lruSize = lruSize;
        return this;
    }

    public ReadOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public ReadOptionsBuilder aliasTypeNames(Map<String, String> aliasTypeNames) {
        aliasTypeNames.forEach(this::addUniqueAlias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.addUniqueAlias(type.getName(), alias);
        return this;
    }

    public ReadOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    public ReadOptionsBuilder removeAliasTypeNameMatching(String typeNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)typeNamePattern);
        Pattern pattern = Pattern.compile(regex);
        this.options.aliasTypeNames.values().removeIf(key -> pattern.matcher((CharSequence)key).matches());
        return this;
    }

    public ReadOptionsBuilder setLocale(Locale locale) {
        this.options.converterOptions.locale = locale;
        return this;
    }

    public ReadOptionsBuilder setCharset(Charset charset) {
        this.options.converterOptions.charset = charset;
        return this;
    }

    public ReadOptionsBuilder setZoneId(ZoneId zoneId) {
        this.options.converterOptions.zoneId = zoneId;
        return this;
    }

    public ReadOptionsBuilder setTrueCharacter(Character ch) {
        this.options.converterOptions.trueChar = ch;
        return this;
    }

    public ReadOptionsBuilder setFalseCharacter(Character ch) {
        this.options.converterOptions.falseChar = ch;
        return this;
    }

    public ReadOptionsBuilder addCustomOption(String key, Object value) {
        if (key == null) {
            throw new JsonIoException("Custom option key must not be null.");
        }
        if (value == null) {
            this.options.customOptions.remove(key);
        } else {
            this.options.customOptions.put(key, value);
        }
        return this;
    }

    private void addUniqueAlias(String type, String alias) {
        String existType;
        Class clazz = ClassUtilities.forName((String)type, (ClassLoader)this.options.getClassLoader());
        if (clazz == null) {
            LOG.warning("Unknown class: " + type + " cannot be added to the ReadOptions alias map.");
        }
        if ((existType = (String)this.options.aliasTypeNames.get(alias)) != null) {
            LOG.warning("Non-unique ReadOptions alias: " + alias + " attempted assign to: " + type + ", but is already assigned to: " + existType);
        }
        this.options.aliasTypeNames.put(alias, type);
    }

    public ReadOptionsBuilder coerceClass(String sourceClassName, Class<?> destClass) {
        Class clazz = ClassUtilities.forName((String)sourceClassName, (ClassLoader)this.options.getClassLoader());
        if (clazz != null) {
            this.options.coercedTypes.put(clazz, destClass);
        }
        return this;
    }

    public ReadOptionsBuilder missingFieldHandler(JsonReader.MissingFieldHandler missingFieldHandler) {
        this.options.missingFieldHandler = missingFieldHandler;
        return this;
    }

    public ReadOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    public ReadOptionsBuilder useUnsafe(boolean useUnsafe) {
        this.options.useUnsafe = useUnsafe;
        return this;
    }

    private static void loadBaseClassFactory() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/classFactory.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String factoryClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.fine("Skipping class: " + className + " not defined in JVM, but listed in resources/classFactories.txt");
                continue;
            }
            if (factoryClassName.equalsIgnoreCase("ArrayFactory")) {
                ReadOptionsBuilder.addPermanentClassFactory(clazz, new ArrayFactory(clazz));
                continue;
            }
            try {
                Class factoryClass = ClassUtilities.forName((String)factoryClassName, (ClassLoader)classLoader);
                if (factoryClass == null) {
                    LOG.fine("Skipping class: " + factoryClassName + " not defined in JVM, but listed in resources/classFactories.txt, as factory for: " + className);
                    continue;
                }
                Constructor ctor = ReflectionUtils.getConstructor((Class)factoryClass, (Class[])new Class[0]);
                ReadOptionsBuilder.addPermanentClassFactory(clazz, (JsonReader.ClassFactory)ctor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Unable to create JsonReader.ClassFactory class: " + factoryClassName + ", a factory class for: " + className + ", listed in resources/classFactories.txt", e);
            }
        }
    }

    private static void loadBaseReaders() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/customReaders.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String readerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz != null) {
                Class customReaderClass = ClassUtilities.forName((String)readerClassName, (ClassLoader)classLoader);
                try {
                    Constructor ctor = ReflectionUtils.getConstructor((Class)customReaderClass, (Class[])new Class[0]);
                    ReadOptionsBuilder.addPermanentReader(clazz, (JsonReader.JsonClassReader)ctor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "Note: could not instantiate (custom JsonClassReader class): " + readerClassName + " from resources/customReaders.txt", e);
                }
                continue;
            }
            LOG.fine("Class: " + className + " not defined in JVM, but listed in resources/customReaders.txt");
        }
    }

    private static void loadBaseCoercedTypes() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/coercedTypes.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String srcClassName = entry.getKey();
            String destClassName = entry.getValue();
            Class srcType = ClassUtilities.forName((String)srcClassName, (ClassLoader)classLoader);
            if (srcType == null) {
                LOG.fine("Skipping class coercion for source class: " + srcClassName + " (not found) to: " + destClassName + ", listed in resources/coercedTypes.txt");
                continue;
            }
            Class destType = ClassUtilities.forName((String)destClassName, (ClassLoader)classLoader);
            if (destType == null) {
                LOG.fine("Skipping class coercion for source class: " + srcClassName + " cannot be mapped to: " + destClassName + " (not found), listed in resources/coercedTypes.txt");
                continue;
            }
            ReadOptionsBuilder.addPermanentCoercedType(srcType, destType);
        }
    }

    static Map<Class<?>, Set<String>> loadClassToSetOfStrings(String fileName) {
        Map<String, String> map = MetaUtils.loadMapDefinition(fileName);
        LinkedHashMap builtMap = new LinkedHashMap();
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) continue;
            ConcurrentHashMap.KeySetView resultSet = ConcurrentHashMap.newKeySet();
            resultSet.addAll(StringUtilities.commaSeparatedStringToSet((String)entry.getValue()));
            builtMap.put(clazz, resultSet);
        }
        return builtMap;
    }

    static Map<Class<?>, Map<String, String>> loadClassToFieldAliasNameMapping(String fileName) {
        Map<String, String> map = MetaUtils.loadMapDefinition(fileName);
        ConcurrentHashMap nonStandardMapping = new ConcurrentHashMap();
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String mappings = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.fine("Class: " + className + " not defined in the JVM");
                continue;
            }
            Map mapping = nonStandardMapping.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
            Set pairs = StringUtilities.commaSeparatedStringToSet((String)mappings);
            for (String pair : pairs) {
                String[] fieldAlias = pair.split(":");
                mapping.put(fieldAlias[0], fieldAlias[1]);
            }
        }
        return nonStandardMapping;
    }

    private static void loadBaseNonRefs() {
        Set<String> set = MetaUtils.loadSetDefinition("config/nonRefs.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (String className : set) {
            Class loadedClass = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (loadedClass == null) {
                LOG.warning("Class: " + className + " undefined.  Cannot be used as non-referenceable class, listed in config/nonRefs.txt");
                continue;
            }
            ReadOptionsBuilder.addPermanentNonReferenceableClass(loadedClass);
        }
    }

    private static void loadBaseNotCustomReadClasses() {
        Set<String> set = MetaUtils.loadSetDefinition("config/notCustomRead.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (String className : set) {
            Class loadedClass = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (loadedClass == null) {
                LOG.warning("Class: " + className + " undefined.  Cannot be used as to turn off custom reading for this class, listed in config/notCustomRead.txt");
                continue;
            }
            ReadOptionsBuilder.addPermanentNotCustomReadClass(loadedClass);
        }
    }

    static void loadBaseAliasMappings(AliasApplier aliasApplier) {
        Map<String, String> aliasMappings = MetaUtils.loadMapDefinition("config/aliases.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        for (Map.Entry<String, String> entry : aliasMappings.entrySet()) {
            String className = entry.getKey();
            String alias = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.fine("Could not find class: " + className + " which has associated alias value: " + alias + " config/aliases.txt");
                continue;
            }
            Class<?> clazz1 = Array.newInstance(clazz, 0).getClass();
            Class<?> clazz2 = Array.newInstance(clazz1, 0).getClass();
            Class<?> clazz3 = Array.newInstance(clazz2, 0).getClass();
            aliasApplier.apply(clazz, alias);
            aliasApplier.apply(clazz1, alias + "[]");
            aliasApplier.apply(clazz2, alias + "[][]");
            aliasApplier.apply(clazz3, alias + "[][][]");
        }
    }

    private static void loadBaseFieldsNotImported() {
        Map<Class<?>, Set<String>> allFieldsNotImported = ReadOptionsBuilder.loadClassToSetOfStrings("config/fieldsNotImported.txt");
        for (Map.Entry<Class<?>, Set<String>> entry : allFieldsNotImported.entrySet()) {
            Class<?> clazz = entry.getKey();
            Set<String> notImportedFields = entry.getValue();
            for (String notImportedField : notImportedFields) {
                ReadOptionsBuilder.addPermanentNotImportedField(clazz, notImportedField);
            }
        }
    }

    private static void loadBaseNonStandardSetters() {
        Map<Class<?>, Map<String, String>> allNonStandardSetters = ReadOptionsBuilder.loadClassToFieldAliasNameMapping("config/nonStandardSetters.txt");
        for (Map.Entry<Class<?>, Map<String, String>> entry : allNonStandardSetters.entrySet()) {
            Class<?> clazz = entry.getKey();
            Map<String, String> nonStandardSetters = entry.getValue();
            for (Map.Entry<String, String> stringEntry : nonStandardSetters.entrySet()) {
                ReadOptionsBuilder.addPermanentNonStandardSetter(clazz, stringEntry.getKey(), stringEntry.getValue());
            }
        }
    }

    static {
        LoggingConfig.init();
        BASE_READERS = new ConcurrentHashMap();
        BASE_CLASS_FACTORIES = new ConcurrentHashMap();
        BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
        BASE_COERCED_TYPES = new ConcurrentHashMap();
        BASE_NON_REFS = new ConcurrentSet();
        BASE_NOT_CUSTOM_READ = new ConcurrentSet();
        BASE_NONSTANDARD_SETTERS = new ConcurrentHashMap();
        BASE_NOT_IMPORTED_FIELDS = new ConcurrentHashMap();
        BASE_MAX_UNRESOLVED_REFERENCES = Integer.MAX_VALUE;
        BASE_MAX_STACK_DEPTH = Integer.MAX_VALUE;
        BASE_MAX_MAPS_TO_REHASH = Integer.MAX_VALUE;
        BASE_MAX_MISSING_FIELDS = Integer.MAX_VALUE;
        BASE_MAX_OBJECT_REFERENCES = 10000000;
        BASE_MAX_REFERENCE_CHAIN_DEPTH = 10000;
        BASE_MAX_ENUM_NAME_LENGTH = 256;
        BASE_MAX_ID_VALUE = 1000000000L;
        BASE_STRING_BUFFER_SIZE = 256;
        BASE_THREAD_LOCAL_BUFFER_SIZE = 1024;
        BASE_LARGE_THREAD_LOCAL_BUFFER_SIZE = 8192;
        BASE_MAX_ALLOWED_LENGTH = 65536;
        BASE_MAX_FILE_CONTENT_SIZE = 0x100000;
        BASE_MAX_LINE_COUNT = 10000;
        BASE_MAX_LINE_LENGTH = 8192;
        BASE_MAX_TYPE_RESOLUTION_CACHE_SIZE = 1000;
        BASE_DEFAULT_COLLECTION_CAPACITY = 16;
        BASE_COLLECTION_LOAD_FACTOR = 0.75f;
        BASE_MIN_COLLECTION_CAPACITY = 16;
        BASE_LINEAR_SEARCH_THRESHOLD = 8;
        BASE_MAX_DEPTH = 1000;
        BASE_LRU_SIZE = 1000;
        BASE_ALLOW_NAN_AND_INFINITY = false;
        BASE_FAIL_ON_UNKNOWN_TYPE = true;
        BASE_CLOSE_STREAM = true;
        classMetaCache = new ClassValueMap();
        injectorsCache = new ClassValueMap();
        ReadOptionsBuilder.loadBaseClassFactory();
        ReadOptionsBuilder.loadBaseReaders();
        ReadOptionsBuilder.loadBaseAliasMappings(ReadOptionsBuilder::addPermanentAlias);
        ReadOptionsBuilder.loadBaseCoercedTypes();
        ReadOptionsBuilder.loadBaseNonRefs();
        ReadOptionsBuilder.loadBaseNotCustomReadClasses();
        ReadOptionsBuilder.loadBaseFieldsNotImported();
        ReadOptionsBuilder.loadBaseNonStandardSetters();
        defReadOptions = new ReadOptionsBuilder().build();
    }

    static class DefaultReadOptions
    implements ReadOptions {
        private Class<?> unknownTypeClass = null;
        private boolean failOnUnknownType = true;
        private boolean closeStream = true;
        private int maxDepth = 1000;
        private int lruSize = 1000;
        private JsonReader.MissingFieldHandler missingFieldHandler = null;
        private DefaultConverterOptions converterOptions = new DefaultConverterOptions();
        private ReadOptions.ReturnType returnType = ReadOptions.ReturnType.JAVA_OBJECTS;
        private ReadOptions.Decimals decimalType = ReadOptions.Decimals.DOUBLE;
        private ReadOptions.Integers integerType = ReadOptions.Integers.LONG;
        private boolean allowNanAndInfinity = false;
        private boolean useUnsafe = false;
        private int maxUnresolvedReferences = Integer.MAX_VALUE;
        private int maxStackDepth = Integer.MAX_VALUE;
        private int maxMapsToRehash = Integer.MAX_VALUE;
        private int maxMissingFields = Integer.MAX_VALUE;
        private int maxObjectReferences = 10000000;
        private int maxReferenceChainDepth = 10000;
        private int maxEnumNameLength = 256;
        private long maxIdValue = 1000000000L;
        private int stringBufferSize = 256;
        private int threadLocalBufferSize = 1024;
        private int largeThreadLocalBufferSize = 8192;
        private int maxAllowedLength = 65536;
        private int maxFileContentSize = 0x100000;
        private int maxLineCount = 10000;
        private int maxLineLength = 8192;
        private int maxTypeResolutionCacheSize = 1000;
        private int defaultCollectionCapacity = 16;
        private float collectionLoadFactor = 0.75f;
        private int minCollectionCapacity = 16;
        private int linearSearchThreshold = 8;
        private Map<String, String> aliasTypeNames = new LinkedHashMap<String, String>();
        private Map<Class<?>, Class<?>> coercedTypes = new ClassValueMap();
        private Set<Class<?>> notCustomReadClasses = new ClassValueSet();
        private Map<Class<?>, JsonReader.JsonClassReader> customReaderClasses = new ClassValueMap();
        private Map<Class<?>, JsonReader.ClassFactory> classFactoryMap = new ClassValueMap();
        private Set<Class<?>> nonRefClasses = new ClassValueSet();
        private Map<Class<?>, Set<String>> excludedFieldNames = new ClassValueMap();
        private Map<Class<?>, Set<String>> fieldsNotImported = new ClassValueMap();
        private List<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
        private List<InjectorFactory> injectorFactories = new ArrayList<InjectorFactory>();
        private Map<String, Object> customOptions = new LinkedHashMap<String, Object>();
        private final Map<Class<?>, JsonReader.JsonClassReader> readerCache = new ClassValueMap();
        private final JsonReader.ClassFactory throwableFactory = new ThrowableFactory();
        private final JsonReader.ClassFactory enumFactory = new EnumClassFactory();
        private static final JsonReader.ClassFactory recordFactory = new RecordFactory();
        private static final Method isRecordMethod;
        private static final NullClass nullReader;

        private DefaultReadOptions() {
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.converterOptions.getClassLoader();
        }

        @Override
        public boolean isFailOnUnknownType() {
            return this.failOnUnknownType;
        }

        @Override
        public Class<?> getUnknownTypeClass() {
            return this.unknownTypeClass;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Override
        public int getMaxUnresolvedReferences() {
            return this.maxUnresolvedReferences;
        }

        @Override
        public int getMaxStackDepth() {
            return this.maxStackDepth;
        }

        @Override
        public int getMaxMapsToRehash() {
            return this.maxMapsToRehash;
        }

        @Override
        public int getMaxMissingFields() {
            return this.maxMissingFields;
        }

        @Override
        public int getMaxObjectReferences() {
            return this.maxObjectReferences;
        }

        @Override
        public int getMaxReferenceChainDepth() {
            return this.maxReferenceChainDepth;
        }

        @Override
        public int getMaxEnumNameLength() {
            return this.maxEnumNameLength;
        }

        @Override
        public long getMaxIdValue() {
            return this.maxIdValue;
        }

        @Override
        public int getStringBufferSize() {
            return this.stringBufferSize;
        }

        @Override
        public int getThreadLocalBufferSize() {
            return this.threadLocalBufferSize;
        }

        @Override
        public int getLargeThreadLocalBufferSize() {
            return this.largeThreadLocalBufferSize;
        }

        @Override
        public int getMaxAllowedLength() {
            return this.maxAllowedLength;
        }

        @Override
        public int getMaxFileContentSize() {
            return this.maxFileContentSize;
        }

        @Override
        public int getMaxLineCount() {
            return this.maxLineCount;
        }

        @Override
        public int getMaxLineLength() {
            return this.maxLineLength;
        }

        @Override
        public int getMaxTypeResolutionCacheSize() {
            return this.maxTypeResolutionCacheSize;
        }

        @Override
        public int getDefaultCollectionCapacity() {
            return this.defaultCollectionCapacity;
        }

        @Override
        public float getCollectionLoadFactor() {
            return this.collectionLoadFactor;
        }

        @Override
        public int getMinCollectionCapacity() {
            return this.minCollectionCapacity;
        }

        @Override
        public int getLinearSearchThreshold() {
            return this.linearSearchThreshold;
        }

        @Override
        public boolean isUseUnsafe() {
            return this.useUnsafe;
        }

        @Override
        public int getLruSize() {
            return this.lruSize;
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public boolean isClassCoerced(Class<?> clazz) {
            return this.coercedTypes.containsKey(clazz);
        }

        @Override
        public Class<?> getCoercedClass(Class<?> c) {
            return this.coercedTypes.get(c);
        }

        @Override
        public JsonReader.MissingFieldHandler getMissingFieldHandler() {
            return this.missingFieldHandler;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public boolean isNotCustomReaderClass(Class<?> clazz) {
            return this.notCustomReadClasses.contains(clazz);
        }

        @Override
        public boolean isCustomReaderClass(Class<?> clazz) {
            return this.customReaderClasses.containsKey(clazz);
        }

        @Override
        public JsonReader.ClassFactory getClassFactory(Class<?> c) {
            if (c == null) {
                return null;
            }
            JsonReader.ClassFactory factory = this.classFactoryMap.get(c);
            if (factory != null) {
                return factory;
            }
            if (Throwable.class.isAssignableFrom(c)) {
                return this.throwableFactory;
            }
            Class enumClass = ClassUtilities.getClassIfEnum(c);
            if (enumClass != null) {
                return this.enumFactory;
            }
            if (DefaultReadOptions.isRecord(c)) {
                return recordFactory;
            }
            return null;
        }

        private static boolean isRecord(Class<?> c) {
            if (isRecordMethod == null || c == null) {
                return false;
            }
            try {
                return (Boolean)isRecordMethod.invoke(c, new Object[0]);
            }
            catch (Exception ignore) {
                return false;
            }
        }

        @Override
        public JsonReader.JsonClassReader getCustomReader(Class<?> c) {
            JsonReader.JsonClassReader reader = this.readerCache.computeIfAbsent(c, cls -> (JsonReader.JsonClassReader)ClassUtilities.findClosest((Class)c, this.customReaderClasses, (Object)nullReader));
            return reader == nullReader ? null : reader;
        }

        @Override
        public boolean isReturningJsonObjects() {
            return this.returnType == ReadOptions.ReturnType.JSON_OBJECTS;
        }

        @Override
        public boolean isReturningJavaObjects() {
            return this.returnType == ReadOptions.ReturnType.JAVA_OBJECTS;
        }

        @Override
        public boolean isFloatingPointDouble() {
            return this.decimalType == ReadOptions.Decimals.DOUBLE;
        }

        @Override
        public boolean isFloatingPointBigDecimal() {
            return this.decimalType == ReadOptions.Decimals.BIG_DECIMAL;
        }

        @Override
        public boolean isFloatingPointBoth() {
            return this.decimalType == ReadOptions.Decimals.BOTH;
        }

        @Override
        public boolean isIntegerTypeLong() {
            return this.integerType == ReadOptions.Integers.LONG;
        }

        @Override
        public boolean isIntegerTypeBigInteger() {
            return this.integerType == ReadOptions.Integers.BIG_INTEGER;
        }

        @Override
        public boolean isIntegerTypeBoth() {
            return this.integerType == ReadOptions.Integers.BOTH;
        }

        @Override
        public Map<String, Injector> getDeepInjectorMap(Class<?> classToTraverse) {
            if (classToTraverse == null) {
                return Collections.emptyMap();
            }
            return injectorsCache.computeIfAbsent(classToTraverse, this::buildInjectors);
        }

        @Override
        public void clearCaches() {
            injectorsCache.clear();
        }

        private Map<String, Injector> buildInjectors(Class<?> c) {
            Map<String, Field> fields = this.getDeepDeclaredFields(c);
            LinkedHashMap<String, Injector> injectors = new LinkedHashMap<String, Injector>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String fieldName;
                Field field = entry.getValue();
                Injector injector = this.findInjector(field, fieldName = entry.getKey());
                if (injector == null) {
                    injector = Injector.create(field, fieldName);
                }
                if (injector == null) continue;
                injectors.put(fieldName, injector);
            }
            return injectors;
        }

        private Injector findInjector(Field field, String key) {
            for (InjectorFactory factory : this.injectorFactories) {
                try {
                    Injector injector = factory.createInjector(field, BASE_NONSTANDARD_SETTERS, key);
                    if (injector == null) continue;
                    return injector;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        @Override
        public ConverterOptions getConverterOptions() {
            return this.converterOptions;
        }

        @Override
        public Object getCustomOption(String key) {
            return this.customOptions.get(key);
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            return classMetaCache.computeIfAbsent(c, this::buildDeepFieldMap);
        }

        public Map<String, Field> buildDeepFieldMap(Class<?> clazz) {
            Convention.throwIfNull(clazz, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> excludedFields = new HashSet<String>();
            for (Class<?> curr = clazz; curr != null; curr = curr.getSuperclass()) {
                Set<String> notImported;
                List fields = ReflectionUtils.getDeclaredFields(curr);
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    excludedFields.addAll(excludedForClass);
                }
                if ((notImported = this.fieldsNotImported.get(curr)) != null) {
                    excludedFields.addAll(notImported);
                }
                for (Field field : fields) {
                    String name;
                    if (excludedFields.contains(field.getName()) || this.fieldIsFiltered(field) || map.putIfAbsent(name = field.getName(), field) == null) continue;
                    map.put(field.getDeclaringClass().getSimpleName() + '.' + name, field);
                    map.put(field.getDeclaringClass().getName() + '.' + name, field);
                }
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean fieldIsFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        static {
            Method m = null;
            try {
                m = ReflectionUtils.getMethod(Class.class, (String)"isRecord", (Class[])new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            isRecordMethod = m;
            nullReader = new NullClass();
        }

        private static final class NullClass
        implements JsonReader.JsonClassReader {
            private NullClass() {
            }
        }
    }

    public static class DefaultConverterOptions
    implements ConverterOptions {
        private ZoneId zoneId = ZoneId.systemDefault();
        private Locale locale = Locale.getDefault();
        private Charset charset = StandardCharsets.UTF_8;
        private ClassLoader classloader = ClassUtilities.getClassLoader(ReadOptionsBuilder.class);
        private Character trueChar = CommonValues.CHARACTER_ONE;
        private Character falseChar = CommonValues.CHARACTER_ZERO;
        private Map<String, Object> customOptions = new ConcurrentHashMap<String, Object>();
        private Map<Converter.ConversionPair, Convert<?>> converterOverrides = new ConcurrentHashMap(100, 0.8f);

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ClassLoader getClassLoader() {
            return this.classloader;
        }

        public Character trueChar() {
            return this.trueChar;
        }

        public Character falseChar() {
            return this.falseChar;
        }

        public Map<Converter.ConversionPair, Convert<?>> getConverterOverrides() {
            return this.converterOverrides;
        }

        public <T> T getCustomOption(String name) {
            return (T)this.customOptions.get(name);
        }
    }

    @FunctionalInterface
    public static interface AliasApplier {
        public void apply(Class<?> var1, String var2);
    }
}

