/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.Writers;
import com.cedarsoftware.io.reflect.Accessor;
import com.cedarsoftware.io.reflect.AccessorFactory;
import com.cedarsoftware.io.reflect.factories.GetMethodAccessorFactory;
import com.cedarsoftware.io.reflect.factories.IsMethodAccessorFactory;
import com.cedarsoftware.io.reflect.filters.FieldFilter;
import com.cedarsoftware.io.reflect.filters.MethodFilter;
import com.cedarsoftware.io.reflect.filters.field.EnumFieldFilter;
import com.cedarsoftware.io.reflect.filters.field.StaticFieldFilter;
import com.cedarsoftware.io.reflect.filters.method.DefaultMethodFilter;
import com.cedarsoftware.io.reflect.filters.method.NamedMethodFilter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.ClassValueSet;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WriteOptionsBuilder {
    private static final Logger LOG = Logger.getLogger(WriteOptionsBuilder.class.getName());
    private static final Map<String, String> BASE_ALIAS_MAPPINGS;
    private static final Map<Class<?>, JsonWriter.JsonClassWriter> BASE_WRITERS;
    private static final Set<Class<?>> BASE_NON_REFS;
    private static final Set<Class<?>> BASE_NOT_CUSTOM_WRITTEN;
    static final Map<Class<?>, Set<String>> BASE_EXCLUDED_FIELD_NAMES;
    private static final Map<Class<?>, Map<String, String>> BASE_NONSTANDARD_GETTERS;
    private static final Map<String, FieldFilter> BASE_FIELD_FILTERS;
    private static final Map<String, MethodFilter> BASE_METHOD_FILTERS;
    private static final Map<String, AccessorFactory> BASE_ACCESSOR_FACTORIES;
    private static volatile int permanentMaxIndentationDepth;
    private static volatile int permanentMaxObjectGraphDepth;
    private static volatile int permanentMaxObjectCount;
    private static volatile int permanentMaxStringLength;
    private static volatile int permanentIndentationSize;
    private static volatile double permanentBufferSizeMultiplier;
    private static volatile int permanentIndentationThreshold;
    private static volatile boolean BASE_SHORT_META_KEYS;
    private static volatile WriteOptions.ShowType BASE_SHOW_TYPE_INFO;
    private static volatile boolean BASE_PRETTY_PRINT;
    private static volatile int BASE_LRU_SIZE;
    private static volatile boolean BASE_WRITE_LONGS_AS_STRINGS;
    private static volatile boolean BASE_SKIP_NULL_FIELDS;
    private static volatile boolean BASE_FORCE_MAP_OUTPUT_AS_TWO_ARRAYS;
    private static volatile boolean BASE_ALLOW_NAN_AND_INFINITY;
    private static volatile boolean BASE_ENUM_PUBLIC_FIELDS_ONLY;
    private static volatile boolean BASE_ENUM_SET_WRITTEN_OLD_WAY;
    private static volatile boolean BASE_CLOSE_STREAM;
    private static volatile ClassLoader BASE_CLASS_LOADER;
    private static final WriteOptions defWriteOptions;
    private final DefaultWriteOptions options = new DefaultWriteOptions();

    public static WriteOptions getDefaultWriteOptions() {
        return defWriteOptions;
    }

    public WriteOptionsBuilder() {
        this.options.nonStandardGetters.putAll(BASE_NONSTANDARD_GETTERS);
        this.options.aliasTypeNames.putAll(BASE_ALIAS_MAPPINGS);
        this.options.customWrittenClasses.putAll(BASE_WRITERS);
        this.options.nonRefClasses.addAll(BASE_NON_REFS);
        this.options.notCustomWrittenClasses.addAll(BASE_NOT_CUSTOM_WRITTEN);
        this.options.excludedFieldNames.putAll(BASE_EXCLUDED_FIELD_NAMES);
        this.options.fieldFilters.putAll(BASE_FIELD_FILTERS);
        this.options.methodFilters.putAll(BASE_METHOD_FILTERS);
        this.options.accessorFactories.putAll(BASE_ACCESSOR_FACTORIES);
        this.options.maxIndentationDepth = WriteOptionsBuilder.permanentMaxIndentationDepth;
        this.options.maxObjectGraphDepth = WriteOptionsBuilder.permanentMaxObjectGraphDepth;
        this.options.maxObjectCount = WriteOptionsBuilder.permanentMaxObjectCount;
        this.options.maxStringLength = WriteOptionsBuilder.permanentMaxStringLength;
        this.options.indentationSize = WriteOptionsBuilder.permanentIndentationSize;
        this.options.bufferSizeMultiplier = WriteOptionsBuilder.permanentBufferSizeMultiplier;
        this.options.indentationThreshold = WriteOptionsBuilder.permanentIndentationThreshold;
        this.options.shortMetaKeys = WriteOptionsBuilder.BASE_SHORT_META_KEYS;
        this.options.showTypeInfo = WriteOptionsBuilder.BASE_SHOW_TYPE_INFO;
        this.options.prettyPrint = WriteOptionsBuilder.BASE_PRETTY_PRINT;
        this.options.lruSize = WriteOptionsBuilder.BASE_LRU_SIZE;
        this.options.writeLongsAsStrings = WriteOptionsBuilder.BASE_WRITE_LONGS_AS_STRINGS;
        this.options.skipNullFields = WriteOptionsBuilder.BASE_SKIP_NULL_FIELDS;
        this.options.forceMapOutputAsTwoArrays = WriteOptionsBuilder.BASE_FORCE_MAP_OUTPUT_AS_TWO_ARRAYS;
        this.options.allowNanAndInfinity = WriteOptionsBuilder.BASE_ALLOW_NAN_AND_INFINITY;
        this.options.enumPublicFieldsOnly = WriteOptionsBuilder.BASE_ENUM_PUBLIC_FIELDS_ONLY;
        this.options.enumSetWrittenOldWay = WriteOptionsBuilder.BASE_ENUM_SET_WRITTEN_OLD_WAY;
        this.options.closeStream = WriteOptionsBuilder.BASE_CLOSE_STREAM;
        this.options.classLoader = WriteOptionsBuilder.BASE_CLASS_LOADER;
        this.options.accessorsCache = (Map)new LRUCache(WriteOptionsBuilder.BASE_LRU_SIZE);
        this.options.classMetaCache = (Map)new LRUCache(WriteOptionsBuilder.BASE_LRU_SIZE);
    }

    public WriteOptionsBuilder(WriteOptions copy) {
        this();
        if (copy != null) {
            DefaultWriteOptions other = (DefaultWriteOptions)copy;
            this.options.converterOptions = other.converterOptions;
            this.options.allowNanAndInfinity = other.allowNanAndInfinity;
            this.options.closeStream = other.closeStream;
            this.options.classLoader = other.classLoader;
            this.options.enumPublicFieldsOnly = other.enumPublicFieldsOnly;
            this.options.enumSetWrittenOldWay = other.enumSetWrittenOldWay;
            this.options.forceMapOutputAsTwoArrays = other.forceMapOutputAsTwoArrays;
            this.options.prettyPrint = other.prettyPrint;
            this.options.lruSize = other.lruSize;
            this.options.shortMetaKeys = other.shortMetaKeys;
            this.options.showTypeInfo = other.showTypeInfo;
            this.options.skipNullFields = other.skipNullFields;
            this.options.writeLongsAsStrings = other.writeLongsAsStrings;
            this.options.maxIndentationDepth = other.maxIndentationDepth;
            this.options.maxObjectGraphDepth = other.maxObjectGraphDepth;
            this.options.maxObjectCount = other.maxObjectCount;
            this.options.maxStringLength = other.maxStringLength;
            this.options.indentationSize = other.indentationSize;
            this.options.bufferSizeMultiplier = other.bufferSizeMultiplier;
            this.options.indentationThreshold = other.indentationThreshold;
            this.options.includedFieldNames.clear();
            this.options.includedFieldNames.putAll(other.includedFieldNames);
            this.options.nonStandardGetters.clear();
            this.options.nonStandardGetters.putAll(other.nonStandardGetters);
            this.options.aliasTypeNames.clear();
            this.options.aliasTypeNames.putAll(other.aliasTypeNames);
            this.options.excludedFieldNames.clear();
            this.options.excludedFieldNames.putAll(other.excludedFieldNames);
            this.options.customWrittenClasses.clear();
            this.options.customWrittenClasses.putAll(other.customWrittenClasses);
            this.options.notCustomWrittenClasses.clear();
            this.options.notCustomWrittenClasses.addAll(other.notCustomWrittenClasses);
            this.options.nonRefClasses.clear();
            this.options.nonRefClasses.addAll(other.nonRefClasses);
            this.options.fieldFilters.clear();
            this.options.fieldFilters.putAll(other.fieldFilters);
            this.options.methodFilters.clear();
            this.options.methodFilters.putAll(other.methodFilters);
            this.options.accessorFactories.clear();
            this.options.accessorFactories.putAll(other.accessorFactories);
            this.options.accessorsCache = (Map)new LRUCache(other.lruSize);
            this.options.accessorsCache.putAll(other.accessorsCache);
            this.options.classMetaCache = (Map)new LRUCache(other.lruSize);
            this.options.classMetaCache.putAll(other.classMetaCache);
        }
    }

    public static void addPermanentAlias(Class<?> clazz, String alias) {
        BASE_ALIAS_MAPPINGS.put(clazz.getName(), alias);
    }

    public static void removePermanentAliasTypeNamesMatching(String classNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)classNamePattern);
        Pattern pattern = Pattern.compile(regex);
        BASE_ALIAS_MAPPINGS.keySet().removeIf(key -> pattern.matcher((CharSequence)key).matches());
    }

    public static void addPermanentExcludedField(Class<?> clazz, String fieldName) {
        BASE_EXCLUDED_FIELD_NAMES.computeIfAbsent(clazz, cls -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    public static void addPermanentNonRef(Class<?> clazz) {
        BASE_NON_REFS.add(clazz);
    }

    public static void addPermanentNotCustomWrittenClass(Class<?> clazz) {
        BASE_NOT_CUSTOM_WRITTEN.add(clazz);
    }

    public static void addPermanentWriter(Class<?> clazz, JsonWriter.JsonClassWriter writer) {
        BASE_WRITERS.put(clazz, writer);
    }

    public static void addPermanentNonStandardGetter(Class<?> clazz, String field, String methodName) {
        BASE_NONSTANDARD_GETTERS.computeIfAbsent(clazz, cls -> new ConcurrentHashMap()).put(field, methodName);
    }

    public static void addPermanentFieldFilter(String name, FieldFilter fieldFilter) {
        BASE_FIELD_FILTERS.put(name, fieldFilter);
    }

    public static void addPermanentMethodFilter(String name, MethodFilter methodFilter) {
        BASE_METHOD_FILTERS.put(name, methodFilter);
    }

    public static void removePermanentMethodFilter(String name) {
        BASE_METHOD_FILTERS.remove(name);
    }

    public static void addPermanentNamedMethodFilter(String name, Class<?> clazz, String methodName) {
        BASE_METHOD_FILTERS.put(name, new NamedMethodFilter(clazz, methodName));
    }

    public static void addPermanentAccessorFactory(String name, AccessorFactory factory) {
        BASE_ACCESSOR_FACTORIES.put(name, factory);
    }

    public static void removePermanentAccessorFactory(String name) {
        BASE_ACCESSOR_FACTORIES.remove(name);
    }

    public static void addPermanentMaxIndentationDepth(int maxIndentationDepth) {
        if (maxIndentationDepth < 1) {
            throw new JsonIoException("maxIndentationDepth must be at least 1, value: " + maxIndentationDepth);
        }
        permanentMaxIndentationDepth = maxIndentationDepth;
    }

    public static void addPermanentMaxObjectGraphDepth(int maxObjectGraphDepth) {
        if (maxObjectGraphDepth < 1) {
            throw new JsonIoException("maxObjectGraphDepth must be at least 1, value: " + maxObjectGraphDepth);
        }
        permanentMaxObjectGraphDepth = maxObjectGraphDepth;
    }

    public static void addPermanentMaxObjectCount(int maxObjectCount) {
        if (maxObjectCount < 1) {
            throw new JsonIoException("maxObjectCount must be at least 1, value: " + maxObjectCount);
        }
        permanentMaxObjectCount = maxObjectCount;
    }

    public static void addPermanentMaxStringLength(int maxStringLength) {
        if (maxStringLength < 1) {
            throw new JsonIoException("maxStringLength must be at least 1, value: " + maxStringLength);
        }
        permanentMaxStringLength = maxStringLength;
    }

    public static void addPermanentIndentationSize(int indentationSize) {
        if (indentationSize < 1) {
            throw new JsonIoException("indentationSize must be at least 1, value: " + indentationSize);
        }
        permanentIndentationSize = indentationSize;
    }

    public static void addPermanentBufferSizeMultiplier(double bufferSizeMultiplier) {
        if (bufferSizeMultiplier < 1.0) {
            throw new JsonIoException("bufferSizeMultiplier must be at least 1.0, value: " + bufferSizeMultiplier);
        }
        permanentBufferSizeMultiplier = bufferSizeMultiplier;
    }

    public static void addPermanentIndentationThreshold(int indentationThreshold) {
        if (indentationThreshold < 1) {
            throw new JsonIoException("indentationThreshold must be at least 1, value: " + indentationThreshold);
        }
        permanentIndentationThreshold = indentationThreshold;
    }

    public static void addPermanentClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new JsonIoException("classLoader cannot be null");
        }
        BASE_CLASS_LOADER = classLoader;
    }

    public static void addPermanentShortMetaKeys(boolean shortMetaKeys) {
        BASE_SHORT_META_KEYS = shortMetaKeys;
    }

    public static void addPermanentShowTypeInfoAlways() {
        BASE_SHOW_TYPE_INFO = WriteOptions.ShowType.ALWAYS;
    }

    public static void addPermanentShowTypeInfoNever() {
        BASE_SHOW_TYPE_INFO = WriteOptions.ShowType.NEVER;
    }

    public static void addPermanentShowTypeInfoMinimal() {
        BASE_SHOW_TYPE_INFO = WriteOptions.ShowType.MINIMAL;
    }

    public static void addPermanentPrettyPrint(boolean prettyPrint) {
        BASE_PRETTY_PRINT = prettyPrint;
    }

    public static void addPermanentLruSize(int lruSize) {
        if (lruSize < 1) {
            throw new JsonIoException("lruSize must be at least 1, value: " + lruSize);
        }
        BASE_LRU_SIZE = lruSize;
    }

    public static void addPermanentWriteLongsAsStrings(boolean writeLongsAsStrings) {
        BASE_WRITE_LONGS_AS_STRINGS = writeLongsAsStrings;
    }

    public static void addPermanentSkipNullFields(boolean skipNullFields) {
        BASE_SKIP_NULL_FIELDS = skipNullFields;
    }

    public static void addPermanentForceMapOutputAsTwoArrays(boolean forceMapOutputAsTwoArrays) {
        BASE_FORCE_MAP_OUTPUT_AS_TWO_ARRAYS = forceMapOutputAsTwoArrays;
    }

    public static void addPermanentAllowNanAndInfinity(boolean allowNanAndInfinity) {
        BASE_ALLOW_NAN_AND_INFINITY = allowNanAndInfinity;
    }

    public static void addPermanentEnumPublicFieldsOnly(boolean enumPublicFieldsOnly) {
        BASE_ENUM_PUBLIC_FIELDS_ONLY = enumPublicFieldsOnly;
    }

    public static void addPermanentEnumSetWrittenOldWay(boolean enumSetWrittenOldWay) {
        BASE_ENUM_SET_WRITTEN_OLD_WAY = enumSetWrittenOldWay;
    }

    public static void addPermanentCloseStream(boolean closeStream) {
        BASE_CLOSE_STREAM = closeStream;
    }

    public WriteOptionsBuilder classLoader(ClassLoader loader) {
        this.options.classLoader = loader;
        return this;
    }

    public WriteOptionsBuilder shortMetaKeys(boolean shortMetaKeys) {
        this.options.shortMetaKeys = shortMetaKeys;
        return this;
    }

    public WriteOptionsBuilder aliasTypeNames(Map<? extends String, ? extends String> aliases) {
        aliases.forEach(this::addUniqueAlias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(Class<?> type, String alias) {
        this.options.aliasTypeNames.put(type.getName(), alias);
        return this;
    }

    public WriteOptionsBuilder aliasTypeName(String typeName, String alias) {
        this.addUniqueAlias(typeName, alias);
        return this;
    }

    private void addUniqueAlias(String typeName, String alias) {
        Convention.throwIfClassNotFound((String)typeName, (ClassLoader)this.options.classLoader);
        Convention.throwIfKeyExists((Map)this.options.aliasTypeNames, (Object)typeName, (String)("Tried to create @type alias '" + alias + "' for '" + typeName + "', but it is already aliased to: " + (String)this.options.aliasTypeNames.get(typeName)));
        this.options.aliasTypeNames.put(typeName, alias);
    }

    public WriteOptionsBuilder removeAliasTypeNamesMatching(String typeNamePattern) {
        String regex = StringUtilities.wildcardToRegexString((String)typeNamePattern);
        Pattern pattern = Pattern.compile(regex);
        this.options.aliasTypeNames.keySet().removeIf(key -> pattern.matcher((CharSequence)key).matches());
        return this;
    }

    public WriteOptionsBuilder showTypeInfoAlways() {
        this.options.showTypeInfo = WriteOptions.ShowType.ALWAYS;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoNever() {
        this.options.showTypeInfo = WriteOptions.ShowType.NEVER;
        return this;
    }

    public WriteOptionsBuilder showTypeInfoMinimal() {
        this.options.showTypeInfo = WriteOptions.ShowType.MINIMAL;
        return this;
    }

    public WriteOptionsBuilder prettyPrint(boolean prettyPrint) {
        this.options.prettyPrint = prettyPrint;
        return this;
    }

    public WriteOptionsBuilder lruSize(int size) {
        this.options.lruSize = size;
        Map accessorCacheCopy = this.options.accessorsCache;
        this.options.accessorsCache = (Map)new LRUCache(this.options.getLruSize());
        this.options.accessorsCache.putAll(accessorCacheCopy);
        Map classMetaCacheCopy = this.options.classMetaCache;
        this.options.classMetaCache = (Map)new LRUCache(this.options.getLruSize());
        this.options.classMetaCache.putAll(classMetaCacheCopy);
        return this;
    }

    public WriteOptionsBuilder writeLongsAsStrings(boolean writeLongsAsStrings) {
        this.options.writeLongsAsStrings = writeLongsAsStrings;
        return this;
    }

    public WriteOptionsBuilder skipNullFields(boolean skipNullFields) {
        this.options.skipNullFields = skipNullFields;
        return this;
    }

    public WriteOptionsBuilder forceMapOutputAsTwoArrays(boolean forceMapOutputAsTwoArrays) {
        this.options.forceMapOutputAsTwoArrays = forceMapOutputAsTwoArrays;
        return this;
    }

    public WriteOptionsBuilder allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.options.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public WriteOptionsBuilder writeEnumsAsString() {
        this.options.enumWriter = new Writers.EnumsAsStringWriter();
        return this;
    }

    public WriteOptionsBuilder writeEnumAsJsonObject(boolean writePublicFieldsOnly) {
        this.options.enumWriter = DefaultWriteOptions.nullWriter;
        this.options.enumPublicFieldsOnly = writePublicFieldsOnly;
        return this;
    }

    public WriteOptionsBuilder writeEnumSetOldWay(boolean writeOldWay) {
        this.options.enumSetWrittenOldWay = writeOldWay;
        return this;
    }

    public WriteOptionsBuilder closeStream(boolean closeStream) {
        this.options.closeStream = closeStream;
        return this;
    }

    public WriteOptionsBuilder setCustomWrittenClasses(Map<? extends Class<?>, ? extends JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.clear();
        this.addCustomWrittenClasses(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClasses(Map<? extends Class<?>, ? extends JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.options.customWrittenClasses.putAll(customWrittenClasses);
        return this;
    }

    public WriteOptionsBuilder addCustomWrittenClass(Class<?> clazz, JsonWriter.JsonClassWriter customWriter) {
        this.options.customWrittenClasses.put(clazz, customWriter);
        return this;
    }

    public WriteOptionsBuilder addNotCustomWrittenClass(Class<?> notCustomClass) {
        this.options.notCustomWrittenClasses.add(notCustomClass);
        return this;
    }

    public WriteOptionsBuilder setNotCustomWrittenClasses(Collection<? extends Class<?>> notCustomClasses) {
        this.options.notCustomWrittenClasses.clear();
        this.options.notCustomWrittenClasses.addAll(notCustomClasses);
        return this;
    }

    public WriteOptionsBuilder addIncludedField(Class<?> clazz, String includedFieldName) {
        Convention.throwIfNull((Object)includedFieldName, (String)"includedFieldName cannot be null");
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(includedFieldName);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Class<?> clazz, Collection<? extends String> includedFieldNames) {
        this.options.includedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(includedFieldNames);
        return this;
    }

    public WriteOptionsBuilder addIncludedFields(Map<? extends Class<?>, ? extends Collection<? extends String>> includedFieldNames) {
        includedFieldNames.forEach(this::addIncludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedField(Class<?> clazz, String excludedFieldName) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).add(excludedFieldName);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Class<?> clazz, Collection<? extends String> excludedFields) {
        this.options.excludedFieldNames.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(excludedFields);
        return this;
    }

    public WriteOptionsBuilder addExcludedFields(Map<? extends Class<?>, ? extends Collection<? extends String>> excludedFieldNames) {
        excludedFieldNames.forEach(this::addExcludedFields);
        return this;
    }

    public WriteOptionsBuilder isoDateFormat() {
        this.addCustomWrittenClass(Date.class, new Writers.DateWriter());
        return this;
    }

    public WriteOptionsBuilder longDateFormat() {
        this.addCustomWrittenClass(Date.class, new Writers.DateAsLongWriter());
        return this;
    }

    public WriteOptionsBuilder addNonStandardGetter(Class<?> c, String fieldName, String methodName) {
        Convention.throwIfNull(c, (String)"class cannot be null");
        Convention.throwIfNull((Object)fieldName, (String)"fieldName cannot be null");
        Convention.throwIfNull((Object)methodName, (String)"methodName cannot be null");
        this.options.nonStandardGetters.computeIfAbsent(c, cls -> new LinkedHashMap()).put(fieldName, methodName);
        return this;
    }

    public WriteOptionsBuilder addNonReferenceableClass(Class<?> clazz) {
        Convention.throwIfNull(clazz, (String)"clazz cannot be null");
        this.options.nonRefClasses.add(clazz);
        return this;
    }

    public WriteOptionsBuilder addCustomOption(String key, Object value) {
        if (key == null) {
            throw new JsonIoException("Custom option key must not be null.");
        }
        if (value == null) {
            this.options.customOptions.remove(key);
        } else {
            this.options.customOptions.put(key, value);
        }
        return this;
    }

    public WriteOptionsBuilder addFieldFilter(String filterName, FieldFilter filter) {
        this.options.fieldFilters.put(filterName, filter);
        return this;
    }

    public WriteOptionsBuilder removeFieldFilter(String filterName) {
        this.options.fieldFilters.remove(filterName);
        return this;
    }

    public WriteOptionsBuilder addMethodFilter(String filterName, MethodFilter methodFilter) {
        this.options.methodFilters.put(filterName, methodFilter);
        return this;
    }

    public WriteOptionsBuilder addNamedMethodFilter(String filterName, Class<?> clazz, String methodName) {
        this.options.methodFilters.put(filterName, new NamedMethodFilter(clazz, methodName));
        return this;
    }

    public WriteOptionsBuilder removeMethodFilter(String filterName) {
        this.options.methodFilters.remove(filterName);
        return this;
    }

    public WriteOptionsBuilder addAccessorFactory(String factoryName, AccessorFactory accessorFactory) {
        LinkedHashMap<String, AccessorFactory> map = new LinkedHashMap<String, AccessorFactory>();
        map.put(factoryName, accessorFactory);
        map.putAll(this.options.accessorFactories);
        this.options.accessorFactories.clear();
        this.options.accessorFactories.putAll(map);
        return this;
    }

    public WriteOptionsBuilder removeAccessorFactory(String factoryName) {
        this.options.accessorFactories.remove(factoryName);
        return this;
    }

    public WriteOptionsBuilder maxIndentationDepth(int maxIndentationDepth) {
        if (maxIndentationDepth < 1) {
            throw new JsonIoException("maxIndentationDepth must be at least 1, value: " + maxIndentationDepth);
        }
        this.options.maxIndentationDepth = maxIndentationDepth;
        return this;
    }

    public WriteOptionsBuilder maxObjectGraphDepth(int maxObjectGraphDepth) {
        if (maxObjectGraphDepth < 1) {
            throw new JsonIoException("maxObjectGraphDepth must be at least 1, value: " + maxObjectGraphDepth);
        }
        this.options.maxObjectGraphDepth = maxObjectGraphDepth;
        return this;
    }

    public WriteOptionsBuilder maxObjectCount(int maxObjectCount) {
        if (maxObjectCount < 1) {
            throw new JsonIoException("maxObjectCount must be at least 1, value: " + maxObjectCount);
        }
        this.options.maxObjectCount = maxObjectCount;
        return this;
    }

    public WriteOptionsBuilder maxStringLength(int maxStringLength) {
        if (maxStringLength < 1) {
            throw new JsonIoException("maxStringLength must be at least 1, value: " + maxStringLength);
        }
        this.options.maxStringLength = maxStringLength;
        return this;
    }

    public WriteOptionsBuilder indentationSize(int indentationSize) {
        if (indentationSize < 1) {
            throw new JsonIoException("indentationSize must be at least 1, value: " + indentationSize);
        }
        this.options.indentationSize = indentationSize;
        return this;
    }

    public WriteOptionsBuilder bufferSizeMultiplier(double bufferSizeMultiplier) {
        if (bufferSizeMultiplier < 1.0) {
            throw new JsonIoException("bufferSizeMultiplier must be at least 1.0, value: " + bufferSizeMultiplier);
        }
        this.options.bufferSizeMultiplier = bufferSizeMultiplier;
        return this;
    }

    public WriteOptionsBuilder indentationThreshold(int indentationThreshold) {
        if (indentationThreshold < 1) {
            throw new JsonIoException("indentationThreshold must be at least 1, value: " + indentationThreshold);
        }
        this.options.indentationThreshold = indentationThreshold;
        return this;
    }

    public WriteOptions build() {
        this.options.clearCaches();
        this.options.includedFieldNames = ((ClassValueMap)this.options.includedFieldNames).unmodifiableView();
        this.options.nonStandardGetters = ((ClassValueMap)this.options.nonStandardGetters).unmodifiableView();
        this.options.aliasTypeNames = Collections.unmodifiableMap(this.options.aliasTypeNames);
        this.options.notCustomWrittenClasses = ((ClassValueSet)this.options.notCustomWrittenClasses).unmodifiableView();
        this.options.nonRefClasses = ((ClassValueSet)this.options.nonRefClasses).unmodifiableView();
        this.options.excludedFieldNames = ((ClassValueMap)this.options.excludedFieldNames).unmodifiableView();
        this.options.fieldFilters = Collections.unmodifiableMap(this.options.fieldFilters);
        this.options.methodFilters = Collections.unmodifiableMap(this.options.methodFilters);
        this.options.accessorFactories = Collections.unmodifiableMap(this.options.accessorFactories);
        this.options.customWrittenClasses = ((ClassValueMap)this.options.customWrittenClasses).unmodifiableView();
        this.options.customOptions = Collections.unmodifiableMap(this.options.customOptions);
        return this.options;
    }

    private static void loadBaseWriters() {
        Map<String, String> map = MetaUtils.loadMapDefinition("config/customWriters.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(WriteOptionsBuilder.class);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String writerClassName = entry.getValue();
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.warning("Class: " + className + " not defined in the JVM, so custom writer: " + writerClassName + ", will not be used.");
                continue;
            }
            Class customWriter = ClassUtilities.forName((String)writerClassName, (ClassLoader)classLoader);
            if (customWriter == null) {
                LOG.warning("Note: class not found (custom JsonClassWriter class): " + writerClassName + ", listed in config/customWriters.txt as a custom writer for: " + className);
                continue;
            }
            try {
                JsonWriter.JsonClassWriter writer = (JsonWriter.JsonClassWriter)customWriter.newInstance();
                WriteOptionsBuilder.addPermanentWriter(clazz, writer);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Note: class failed to instantiate (a custom JsonClassWriter class): " + writerClassName + ", listed in config/customWriters.txt as a custom writer for: " + className, e);
            }
        }
    }

    private static void loadBaseNonRefs() {
        Set<String> set = MetaUtils.loadSetDefinition("config/nonRefs.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(WriteOptionsBuilder.class);
        for (String className : set) {
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.warning("Class: " + className + " undefined.  Cannot be used as non-referenceable class, listed in config/nonRefs.txt");
                continue;
            }
            WriteOptionsBuilder.addPermanentNonRef(clazz);
        }
    }

    private static void loadBaseNotCustomWrittenClasses() {
        Set<String> set = MetaUtils.loadSetDefinition("config/notCustomWritten.txt");
        ClassLoader classLoader = ClassUtilities.getClassLoader(WriteOptionsBuilder.class);
        for (String className : set) {
            Class clazz = ClassUtilities.forName((String)className, (ClassLoader)classLoader);
            if (clazz == null) {
                LOG.warning("Class: " + className + " undefined.  Cannot be used as to turn off custom writing for this class, listed in config/notCustomWritten.txt");
                continue;
            }
            WriteOptionsBuilder.addPermanentNotCustomWrittenClass(clazz);
        }
    }

    private static void loadBaseExcludedFields() {
        Map<Class<?>, Set<String>> allExcludedFields = ReadOptionsBuilder.loadClassToSetOfStrings("config/fieldsNotExported.txt");
        for (Map.Entry<Class<?>, Set<String>> entry : allExcludedFields.entrySet()) {
            Class<?> clazz = entry.getKey();
            Set<String> excludedFields = entry.getValue();
            for (String fieldName : excludedFields) {
                WriteOptionsBuilder.addPermanentExcludedField(clazz, fieldName);
            }
        }
    }

    private static void loadBaseNonStandardGetters() {
        Map<Class<?>, Map<String, String>> nonStandardGetterMap = ReadOptionsBuilder.loadClassToFieldAliasNameMapping("config/nonStandardGetters.txt");
        for (Map.Entry<Class<?>, Map<String, String>> entry : nonStandardGetterMap.entrySet()) {
            Class<?> clazz = entry.getKey();
            Map<String, String> pairingsMap = entry.getValue();
            for (Map.Entry<String, String> fieldToAltName : pairingsMap.entrySet()) {
                WriteOptionsBuilder.addPermanentNonStandardGetter(clazz, fieldToAltName.getKey(), fieldToAltName.getValue());
            }
        }
    }

    static {
        LoggingConfig.init();
        BASE_ALIAS_MAPPINGS = new ConcurrentHashMap<String, String>();
        BASE_WRITERS = new ConcurrentHashMap();
        BASE_NON_REFS = new ConcurrentSet();
        BASE_NOT_CUSTOM_WRITTEN = new ConcurrentSet();
        BASE_EXCLUDED_FIELD_NAMES = new ConcurrentHashMap();
        BASE_NONSTANDARD_GETTERS = new ConcurrentHashMap();
        BASE_FIELD_FILTERS = new ConcurrentHashMap<String, FieldFilter>();
        BASE_METHOD_FILTERS = new ConcurrentHashMap<String, MethodFilter>();
        BASE_ACCESSOR_FACTORIES = new ConcurrentHashMap<String, AccessorFactory>();
        permanentMaxIndentationDepth = 100;
        permanentMaxObjectGraphDepth = 10000;
        permanentMaxObjectCount = 100000;
        permanentMaxStringLength = 1000000;
        permanentIndentationSize = 2;
        permanentBufferSizeMultiplier = 1.3;
        permanentIndentationThreshold = 10;
        BASE_SHORT_META_KEYS = false;
        BASE_SHOW_TYPE_INFO = WriteOptions.ShowType.MINIMAL;
        BASE_PRETTY_PRINT = false;
        BASE_LRU_SIZE = 1000;
        BASE_WRITE_LONGS_AS_STRINGS = false;
        BASE_SKIP_NULL_FIELDS = false;
        BASE_FORCE_MAP_OUTPUT_AS_TWO_ARRAYS = false;
        BASE_ALLOW_NAN_AND_INFINITY = false;
        BASE_ENUM_PUBLIC_FIELDS_ONLY = false;
        BASE_ENUM_SET_WRITTEN_OLD_WAY = true;
        BASE_CLOSE_STREAM = true;
        BASE_CLASS_LOADER = ClassUtilities.getClassLoader(WriteOptionsBuilder.class);
        ReadOptionsBuilder.loadBaseAliasMappings(WriteOptionsBuilder::addPermanentAlias);
        WriteOptionsBuilder.loadBaseWriters();
        WriteOptionsBuilder.loadBaseNonRefs();
        WriteOptionsBuilder.loadBaseNotCustomWrittenClasses();
        WriteOptionsBuilder.loadBaseExcludedFields();
        WriteOptionsBuilder.loadBaseNonStandardGetters();
        WriteOptionsBuilder.addPermanentFieldFilter("static", new StaticFieldFilter());
        WriteOptionsBuilder.addPermanentFieldFilter("enum", new EnumFieldFilter());
        WriteOptionsBuilder.addPermanentMethodFilter("default", new DefaultMethodFilter());
        WriteOptionsBuilder.addPermanentAccessorFactory("get", new GetMethodAccessorFactory());
        WriteOptionsBuilder.addPermanentAccessorFactory("is", new IsMethodAccessorFactory());
        defWriteOptions = new WriteOptionsBuilder().build();
        ClassUtilities.addPermanentClassAlias(BigInteger.class, (String)"bigint");
        ClassUtilities.addPermanentClassAlias(BigInteger.class, (String)"BigInt");
        ClassUtilities.addPermanentClassAlias(BigDecimal.class, (String)"bigdec");
        ClassUtilities.addPermanentClassAlias(BigDecimal.class, (String)"BigDec");
    }

    static class DefaultWriteOptions
    implements WriteOptions {
        private boolean shortMetaKeys = false;
        private WriteOptions.ShowType showTypeInfo = WriteOptions.ShowType.MINIMAL;
        private boolean prettyPrint = false;
        private int lruSize = 1000;
        private boolean writeLongsAsStrings = false;
        private boolean skipNullFields = false;
        private boolean forceMapOutputAsTwoArrays = false;
        private boolean allowNanAndInfinity = false;
        private boolean enumPublicFieldsOnly = false;
        private boolean enumSetWrittenOldWay = true;
        private boolean closeStream = true;
        private JsonWriter.JsonClassWriter enumWriter = new Writers.EnumsAsStringWriter();
        private ClassLoader classLoader = ClassUtilities.getClassLoader(DefaultWriteOptions.class);
        private Map<Class<?>, Set<String>> includedFieldNames = new ClassValueMap();
        private Map<Class<?>, Map<String, String>> nonStandardGetters = new ClassValueMap();
        private Map<String, String> aliasTypeNames = new LinkedHashMap<String, String>();
        private Set<Class<?>> notCustomWrittenClasses = new ClassValueSet();
        private Set<Class<?>> nonRefClasses = new ClassValueSet();
        private Map<Class<?>, Set<String>> excludedFieldNames = new ClassValueMap();
        private Map<String, FieldFilter> fieldFilters = new LinkedHashMap<String, FieldFilter>();
        private Map<String, MethodFilter> methodFilters = new LinkedHashMap<String, MethodFilter>();
        private Map<String, AccessorFactory> accessorFactories = new LinkedHashMap<String, AccessorFactory>();
        private Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses = new ClassValueMap();
        private Map<String, Object> customOptions = new LinkedHashMap<String, Object>();
        private DefaultConverterOptions converterOptions = new DefaultConverterOptions();
        private int maxIndentationDepth = 100;
        private int maxObjectGraphDepth = 10000;
        private int maxObjectCount = 100000;
        private int maxStringLength = 1000000;
        private int indentationSize = 2;
        private double bufferSizeMultiplier = 1.3;
        private int indentationThreshold = 10;
        private final Map<Class<?>, JsonWriter.JsonClassWriter> writerCache = new ClassValueMap();
        private Map<Class<?>, List<Accessor>> accessorsCache = new ClassValueMap();
        private Map<Class<?>, Map<String, Field>> classMetaCache = new ClassValueMap();
        static final NullClass nullWriter = new NullClass();

        private DefaultWriteOptions() {
        }

        @Override
        public String getTypeNameAlias(String typeName) {
            String alias = this.aliasTypeNames.get(typeName);
            return alias == null ? typeName : alias;
        }

        @Override
        public Map<String, String> aliases() {
            return Collections.unmodifiableMap(this.aliasTypeNames);
        }

        @Override
        public boolean isAlwaysShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.ALWAYS;
        }

        @Override
        public boolean isNeverShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.NEVER;
        }

        @Override
        public boolean isMinimalShowingType() {
            return this.showTypeInfo == WriteOptions.ShowType.MINIMAL;
        }

        @Override
        public boolean isCustomWrittenClass(Class<?> clazz) {
            return this.customWrittenClasses.containsKey(clazz);
        }

        @Override
        public boolean isNotCustomWrittenClass(Class<?> clazz) {
            return this.notCustomWrittenClasses.contains(clazz);
        }

        @Override
        public List<Accessor> getAccessorsForClass(Class<?> c) {
            return this.accessorsCache.computeIfAbsent(c, this::buildDeepAccessors);
        }

        @Override
        public boolean isLongDateFormat() {
            JsonWriter.JsonClassWriter a = this.customWrittenClasses.get(Date.class);
            return a instanceof Writers.DateAsLongWriter;
        }

        @Override
        public boolean isNonReferenceableClass(Class<?> clazz) {
            return this.nonRefClasses.contains(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || clazz.isEnum();
        }

        @Override
        public boolean isShortMetaKeys() {
            return this.shortMetaKeys;
        }

        @Override
        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        @Override
        public int getLruSize() {
            return this.lruSize;
        }

        @Override
        public boolean isWriteLongsAsStrings() {
            return this.writeLongsAsStrings;
        }

        @Override
        public boolean isSkipNullFields() {
            return this.skipNullFields;
        }

        @Override
        public boolean isForceMapOutputAsTwoArrays() {
            return this.forceMapOutputAsTwoArrays;
        }

        @Override
        public boolean isAllowNanAndInfinity() {
            return this.allowNanAndInfinity;
        }

        @Override
        public boolean isEnumPublicFieldsOnly() {
            return this.enumPublicFieldsOnly;
        }

        @Override
        public boolean isEnumSetWrittenOldWay() {
            return this.enumSetWrittenOldWay;
        }

        @Override
        public boolean isCloseStream() {
            return this.closeStream;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public JsonWriter.JsonClassWriter getCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = this.writerCache.computeIfAbsent(c, this::findCustomWriter);
            return writer == nullWriter ? null : writer;
        }

        JsonWriter.JsonClassWriter findCustomWriter(Class<?> c) {
            JsonWriter.JsonClassWriter writer = (JsonWriter.JsonClassWriter)ClassUtilities.findClosest(c, this.customWrittenClasses, (Object)nullWriter);
            if (writer != nullWriter) {
                return writer;
            }
            Class enumClass = ClassUtilities.getClassIfEnum(c);
            return enumClass != null ? this.enumWriter : nullWriter;
        }

        @Override
        public Object getCustomOption(String key) {
            return this.customOptions.get(key);
        }

        @Override
        public ConverterOptions getConverterOptions() {
            return this.converterOptions;
        }

        @Override
        public Set<String> getIncludedFields(Class<?> c) {
            return Collections.unmodifiableSet(this.includedFieldNames.get(c));
        }

        @Override
        public Set<String> getExcludedFields(Class<?> c) {
            return Collections.unmodifiableSet(this.excludedFieldNames.get(c));
        }

        @Override
        public int getMaxIndentationDepth() {
            return this.maxIndentationDepth;
        }

        @Override
        public int getMaxObjectGraphDepth() {
            return this.maxObjectGraphDepth;
        }

        @Override
        public int getMaxObjectCount() {
            return this.maxObjectCount;
        }

        @Override
        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        @Override
        public int getIndentationSize() {
            return this.indentationSize;
        }

        @Override
        public double getBufferSizeMultiplier() {
            return this.bufferSizeMultiplier;
        }

        @Override
        public int getIndentationThreshold() {
            return this.indentationThreshold;
        }

        @Override
        public void clearCaches() {
            this.classMetaCache.clear();
            this.accessorsCache.clear();
        }

        private List<Accessor> buildDeepAccessors(Class<?> clazz) {
            Map<String, Field> fields = this.getDeepDeclaredFields(clazz);
            ArrayList<Accessor> accessors = new ArrayList<Accessor>(fields.size());
            for (Map.Entry<String, Field> entry : fields.entrySet()) {
                String uniqueFieldName;
                Field field = entry.getValue();
                Accessor accessor = this.findMethodAccessor(field, uniqueFieldName = entry.getKey());
                if (accessor != null && this.isMethodFiltered(clazz, accessor.getFieldOrMethodName())) {
                    accessor = null;
                }
                if (accessor == null) {
                    accessor = Accessor.createFieldAccessor(field, uniqueFieldName);
                }
                accessors.add(accessor);
            }
            return Collections.unmodifiableList(accessors);
        }

        private boolean isMethodFiltered(Class<?> clazz, String methodName) {
            for (MethodFilter filter : this.methodFilters.values()) {
                if (!filter.filter(clazz, methodName)) continue;
                return true;
            }
            return false;
        }

        private Accessor findMethodAccessor(Field field, String uniqueFieldName) {
            for (AccessorFactory factory : this.accessorFactories.values()) {
                try {
                    Accessor accessor = factory.buildAccessor(field, this.nonStandardGetters, uniqueFieldName);
                    if (accessor == null) continue;
                    return accessor;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        @Override
        public Map<String, Field> getDeepDeclaredFields(Class<?> c) {
            return this.classMetaCache.computeIfAbsent(c, this::buildWithIncludedMinusExcluded);
        }

        private Map<String, Field> buildWithIncludedMinusExcluded(Class<?> c) {
            Convention.throwIfNull(c, (String)"class cannot be null");
            LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
            HashSet<String> excluded = new HashSet<String>();
            HashSet includedFields = this.includedFieldNames.get(c);
            HashSet included = includedFields == null ? new HashSet() : includedFields;
            Class<?> curr = c;
            while (curr != null) {
                List fields;
                try {
                    fields = ReflectionUtils.getDeclaredFields(curr);
                }
                catch (SecurityException e) {
                    curr = curr.getSuperclass();
                    continue;
                }
                Set<String> excludedForClass = this.excludedFieldNames.get(curr);
                if (excludedForClass != null) {
                    excluded.addAll(excludedForClass);
                }
                for (Field field : fields) {
                    String fieldName = field.getName();
                    if (map.containsKey(fieldName)) {
                        fieldName = field.getDeclaringClass().getSimpleName() + '.' + fieldName;
                    }
                    if (this.isFieldFiltered(field) || excluded.contains(fieldName)) continue;
                    boolean isTransient = Modifier.isTransient(field.getModifiers());
                    boolean includedExplicitly = included.contains(fieldName);
                    if (isTransient && !includedExplicitly || !included.isEmpty() && !includedExplicitly) continue;
                    map.put(fieldName, field);
                }
                curr = curr.getSuperclass();
            }
            return Collections.unmodifiableMap(map);
        }

        private boolean isFieldFiltered(Field field) {
            for (FieldFilter filter : this.fieldFilters.values()) {
                if (!filter.filter(field)) continue;
                return true;
            }
            return false;
        }

        private static final class NullClass
        implements JsonWriter.JsonClassWriter {
            private NullClass() {
            }
        }
    }

    public static class DefaultConverterOptions
    implements ConverterOptions {
        private ZoneId zoneId = ZoneId.systemDefault();
        private Locale locale = Locale.getDefault();
        private Charset charset = StandardCharsets.UTF_8;
        private ClassLoader classloader = ClassUtilities.getClassLoader(WriteOptionsBuilder.class);
        private Character trueChar = CommonValues.CHARACTER_ONE;
        private Character falseChar = CommonValues.CHARACTER_ZERO;
        private Map<String, Object> customOptions = new ConcurrentHashMap<String, Object>();
        private Map<Converter.ConversionPair, Convert<?>> converterOverrides = new ConcurrentHashMap(100, 0.8f);

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ClassLoader getClassLoader() {
            return this.classloader;
        }

        public Character trueChar() {
            return this.trueChar;
        }

        public Character falseChar() {
            return this.falseChar;
        }

        public Map<Converter.ConversionPair, Convert<?>> getConverterOverrides() {
            return this.converterOverrides;
        }

        public <T> T getCustomOption(String name) {
            return (T)this.customOptions.get(name);
        }
    }
}

