/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.SealedSupplier;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ClassValueMap;
import com.cedarsoftware.util.CompactCIHashMap;
import com.cedarsoftware.util.CompactCIHashSet;
import com.cedarsoftware.util.CompactCILinkedMap;
import com.cedarsoftware.util.CompactCILinkedSet;
import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.CompactLinkedSet;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.CompactSet;
import com.cedarsoftware.util.ConcurrentList;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public abstract class Resolver {
    private static final String NO_FACTORY = "_\ufe3f_\u03c8_\u263c";
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();
    protected final Deque<JsonObject> stack = new ArrayDeque<JsonObject>();
    private final Collection<JsonObject> mapsToRehash = new ArrayList<JsonObject>();
    final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    private ReadOptions readOptions;
    private ReferenceTracker references;
    private final Converter converter;
    private SealedSupplier sealedSupplier = new SealedSupplier();
    private static final ClassValueMap<Function<JsonObject, Object>> DEFAULT_INSTANTIATORS = new ClassValueMap();

    protected Resolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        this.readOptions = readOptions;
        this.references = references;
        this.converter = converter;
    }

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    public ReferenceTracker getReferences() {
        return this.references;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public <T> T toJavaObjects(JsonObject rootObj, Type rootType) {
        Object instance;
        if (rootObj == null) {
            return null;
        }
        if (rootObj.isReference() && (rootObj = this.getReferences().get(rootObj.refId)) != null) {
            return (T)rootObj;
        }
        if (rootObj.isFinished) {
            return (T)rootObj.getTarget();
        }
        if (rootObj.getType() == null) {
            rootObj.setType(rootType);
        }
        Object object = instance = rootObj.getTarget() == null ? this.createInstance(rootObj) : rootObj.getTarget();
        if (rootObj.isFinished) {
            return (T)instance;
        }
        return this.traverseJsonObject(rootObj);
    }

    public <T> T traverseJsonObject(JsonObject root) {
        this.push(root);
        while (!this.stack.isEmpty()) {
            JsonObject jsonObj = this.stack.pop();
            if (jsonObj.isFinished) continue;
            this.visited.put(jsonObj, null);
            this.traverseSpecificType(jsonObj);
        }
        return (T)root.getTarget();
    }

    protected void traverseSpecificType(JsonObject jsonObj) {
        if (jsonObj.isArray()) {
            this.traverseArray(jsonObj);
        } else if (jsonObj.isCollection()) {
            this.traverseCollection(jsonObj);
        } else if (jsonObj.isMap()) {
            this.traverseMap(jsonObj);
        } else {
            this.traverseObject(jsonObj);
        }
    }

    protected void traverseObject(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        Object special = this.readWithFactoryIfExists(jsonObj, null);
        if (special != null) {
            jsonObj.setTarget(special);
        } else {
            this.traverseFields(jsonObj);
        }
    }

    public SealedSupplier getSealedSupplier() {
        return this.sealedSupplier;
    }

    public void push(JsonObject jsonObject) {
        this.stack.push(jsonObject);
    }

    public abstract void traverseFields(JsonObject var1);

    protected abstract Object readWithFactoryIfExists(Object var1, Type var2);

    protected abstract void traverseCollection(JsonObject var1);

    protected abstract void traverseArray(JsonObject var1);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this.references.clear();
        this.unresolvedRefs.clear();
        this.mapsToRehash.clear();
        this.handleMissingFields();
        this.missingFields.clear();
        this.stack.clear();
        this.visited.clear();
        this.references = null;
        this.readOptions = null;
        this.sealedSupplier.seal();
        this.sealedSupplier = null;
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        jsonObj.setFinished();
        Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
        Object[] keys = pair.getKey();
        Object[] items = pair.getValue();
        if (keys == null) {
            return;
        }
        this.buildCollection(keys);
        this.buildCollection(items);
        this.mapsToRehash.add(jsonObj);
    }

    private void buildCollection(Object[] arrayContent) {
        JsonObject collection = new JsonObject();
        collection.setItems(arrayContent);
        collection.setTarget(arrayContent);
        this.push(collection);
    }

    Object createInstance(JsonObject jsonObj) {
        Class<?> sourceType;
        Object sourceValue;
        Object instance;
        Object target = jsonObj.getTarget();
        if (target != null) {
            return target;
        }
        Class<?> targetType = this.resolveTargetType(jsonObj);
        Function instantiator = (Function)DEFAULT_INSTANTIATORS.get(targetType);
        if (instantiator != null && (instance = instantiator.apply(jsonObj)) != null) {
            return jsonObj.setTarget(instance);
        }
        if (this.converter.isSimpleTypeConversionSupported(targetType, targetType)) {
            return jsonObj.setFinishedTarget(this.converter.convert((Object)jsonObj, targetType), true);
        }
        Class<?> factoryType = this.determineFactoryType(jsonObj, targetType);
        Object mate = this.createInstanceUsingClassFactory(factoryType, jsonObj);
        if (mate != NO_FACTORY) {
            return mate;
        }
        Object object = sourceValue = jsonObj.hasValue() ? jsonObj.getValue() : null;
        Class<Object> clazz = sourceValue != null ? sourceValue.getClass() : (sourceType = !jsonObj.isEmpty() ? Map.class : null);
        if (!Throwable.class.isAssignableFrom(targetType) && sourceType != null && this.converter.isConversionSupportedFor(sourceType, targetType)) {
            try {
                Object value = this.converter.convert(sourceValue != null ? sourceValue : jsonObj, targetType);
                return jsonObj.setFinishedTarget(value, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.shouldCreateArray(jsonObj, targetType)) {
            mate = this.createArrayInstance(jsonObj, targetType);
            return jsonObj.setTarget(mate);
        }
        return this.createInstanceUsingType(jsonObj);
    }

    private Class<?> resolveTargetType(JsonObject jsonObj) {
        Class<?> coercedEnumClass;
        Class<?> targetType = this.coerceClassIfNeeded(jsonObj.getRawType());
        jsonObj.setType(targetType);
        Class enumClass = ClassUtilities.getClassIfEnum(targetType);
        if (enumClass != null && (coercedEnumClass = this.getCoercedEnumClass(enumClass)) != null) {
            targetType = coercedEnumClass;
            jsonObj.setType(coercedEnumClass);
        }
        return targetType;
    }

    private Class<?> coerceClassIfNeeded(Class<?> type) {
        Class<?> clazz = this.readOptions.getCoercedClass(type);
        return clazz == null ? type : clazz;
    }

    private Class<?> getCoercedEnumClass(Class<?> enumClass) {
        Class<?> coercedClass = this.readOptions.getCoercedClass(enumClass);
        if (coercedClass != null) {
            return ClassUtilities.getClassIfEnum(coercedClass);
        }
        return null;
    }

    private Class<?> determineFactoryType(JsonObject jsonObj, Class<?> targetType) {
        Class enumClass = ClassUtilities.getClassIfEnum(targetType);
        if (enumClass != null) {
            boolean isEnumSet = jsonObj.getItems() != null;
            return isEnumSet ? EnumSet.class : enumClass;
        }
        return targetType;
    }

    private boolean shouldCreateArray(JsonObject jsonObj, Class<?> targetType) {
        Object[] items = jsonObj.getItems();
        return targetType.isArray() || items != null && targetType == Object.class && jsonObj.getKeys() == null;
    }

    private Object createArrayInstance(JsonObject jsonObj, Class<?> targetType) {
        Object[] items = jsonObj.getItems();
        int size = items == null ? 0 : items.length;
        Class componentType = targetType.isArray() ? targetType.getComponentType() : Object.class;
        return Array.newInstance(componentType, size);
    }

    private Object createInstanceUsingType(JsonObject jsonObj) {
        Object mate;
        Class<?> c = jsonObj.getRawType();
        boolean useMaps = this.readOptions.isReturningJsonObjects();
        if (c == Object.class && !useMaps) {
            Class<?> unknownClass = this.readOptions.getUnknownTypeClass();
            if (unknownClass == null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.setType((Type)((Object)Map.class));
                mate = jsonObject;
            } else {
                mate = ClassUtilities.newInstance((Converter)this.converter, unknownClass, null);
            }
        } else {
            mate = ClassUtilities.newInstance((Converter)this.converter, c, null);
        }
        return jsonObj.setTarget(mate);
    }

    Object createInstanceUsingClassFactory(Class c, JsonObject jsonObj) {
        JsonReader.ClassFactory classFactory = this.readOptions.getClassFactory(c);
        if (classFactory == null) {
            return NO_FACTORY;
        }
        Object target = classFactory.newInstance(c, jsonObj, this);
        if (classFactory.isObjectFinal()) {
            return jsonObj.setFinishedTarget(target, true);
        }
        return jsonObj.setTarget(target);
    }

    private void patchUnresolvedReferences() {
        for (UnresolvedReference ref : this.unresolvedRefs) {
            Object objToFix = ref.referencingObj.getTarget();
            JsonObject objReferenced = this.references.getOrThrow(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List list = (List)objToFix;
                    list.set(ref.index, objReferenced.getTarget());
                    continue;
                }
                if (objToFix instanceof Collection) {
                    Collection col = (Collection)objToFix;
                    col.add(objReferenced.getTarget());
                    continue;
                }
                Array.set(objToFix, ref.index, objReferenced.getTarget());
                continue;
            }
            Field field = this.getReadOptions().getDeepDeclaredFields(objToFix.getClass()).get(ref.field);
            Map<String, Injector> injectors = this.getReadOptions().getDeepInjectorMap(objToFix.getClass());
            if (field == null || !injectors.containsKey(field.getName())) continue;
            try {
                injectors.get(field.getName()).inject(objToFix, objReferenced.getTarget());
            }
            catch (Exception e) {
                throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
            }
        }
        this.unresolvedRefs.clear();
    }

    private void rehashMaps() {
        for (JsonObject jsonObj : this.mapsToRehash) {
            jsonObj.rehashMaps();
        }
    }

    public boolean valueToTarget(JsonObject jsonObject) {
        if (jsonObject.getType() == null) {
            return false;
        }
        Class<?> javaType = jsonObject.getRawType();
        if (javaType.isArray() && this.converter.isSimpleTypeConversionSupported(javaType.getComponentType(), javaType.getComponentType())) {
            Object[] jsonItems = jsonObject.getItems();
            Class<?> componentType = javaType.getComponentType();
            if (jsonItems == null) {
                jsonObject.setFinishedTarget(null, true);
                return true;
            }
            int len = jsonItems.length;
            Object javaArray = Array.newInstance(componentType, len);
            for (int i = 0; i < len; ++i) {
                try {
                    JsonObject jObj;
                    Class<?> type = componentType;
                    Object item = jsonItems[i];
                    if (item instanceof JsonObject && (jObj = (JsonObject)item).getType() != null) {
                        type = jObj.getRawType();
                    }
                    Array.set(javaArray, i, this.converter.convert(item, type));
                    continue;
                }
                catch (Exception e) {
                    JsonIoException jioe = new JsonIoException(e.getMessage());
                    jioe.setStackTrace(e.getStackTrace());
                    throw jioe;
                }
            }
            jsonObject.setFinishedTarget(javaArray, true);
            return true;
        }
        if (!this.converter.isSimpleTypeConversionSupported(javaType, javaType)) {
            return false;
        }
        try {
            Object value = this.converter.convert((Object)jsonObject, javaType);
            jsonObject.setFinishedTarget(value, true);
            return true;
        }
        catch (Exception e) {
            JsonIoException jioe = new JsonIoException(e.getMessage());
            jioe.setStackTrace(e.getStackTrace());
            throw jioe;
        }
    }

    protected void setArrayElement(Object array, int index, Object element) {
        if (array instanceof Object[]) {
            try {
                ((Object[])array)[index] = element;
                return;
            }
            catch (ArrayStoreException arrayStoreException) {}
        } else {
            Class<?> componentType = array.getClass().getComponentType();
            try {
                if (componentType == Integer.TYPE) {
                    ((int[])array)[index] = element == null ? 0 : ((Number)element).intValue();
                    return;
                }
                if (componentType == Long.TYPE) {
                    ((long[])array)[index] = element == null ? 0L : ((Number)element).longValue();
                    return;
                }
                if (componentType == Double.TYPE) {
                    ((double[])array)[index] = element == null ? 0.0 : ((Number)element).doubleValue();
                    return;
                }
                if (componentType == Boolean.TYPE) {
                    ((boolean[])array)[index] = element != null && element instanceof Boolean && (Boolean)element != false;
                    return;
                }
                if (componentType == Byte.TYPE) {
                    ((byte[])array)[index] = element == null ? (byte)0 : ((Number)element).byteValue();
                    return;
                }
                if (componentType == Character.TYPE) {
                    ((char[])array)[index] = element == null ? (char)'\u0000' : (element instanceof Character ? ((Character)element).charValue() : (element instanceof String && ((String)element).length() > 0 ? ((String)element).charAt(0) : (char)'\u0000'));
                    return;
                }
                if (componentType == Short.TYPE) {
                    ((short[])array)[index] = element == null ? (short)0 : ((Number)element).shortValue();
                    return;
                }
                if (componentType == Float.TYPE) {
                    ((float[])array)[index] = element == null ? 0.0f : ((Number)element).floatValue();
                    return;
                }
                Array.set(array, index, element);
                return;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        String elementType = element == null ? "null" : element.getClass().getName();
        String arrayType = array.getClass().getComponentType().getName() + "[]";
        throw new IllegalArgumentException("Cannot set '" + elementType + "' (value: " + element + ") into '" + arrayType + "' at index " + index);
    }

    protected abstract Object resolveArray(Type var1, List<Object> var2);

    static {
        DEFAULT_INSTANTIATORS.put(ArrayList.class, jsonObj -> new ArrayList());
        DEFAULT_INSTANTIATORS.put(LinkedList.class, jsonObj -> new LinkedList());
        DEFAULT_INSTANTIATORS.put(CopyOnWriteArrayList.class, jsonObj -> new CopyOnWriteArrayList());
        DEFAULT_INSTANTIATORS.put(ConcurrentList.class, jsonObj -> new ConcurrentList());
        DEFAULT_INSTANTIATORS.put(CompactCIHashMap.class, jsonObj -> new CompactCIHashMap());
        DEFAULT_INSTANTIATORS.put(CompactCILinkedMap.class, jsonObj -> new CompactCILinkedMap());
        DEFAULT_INSTANTIATORS.put(CompactLinkedMap.class, jsonObj -> new CompactLinkedMap());
        DEFAULT_INSTANTIATORS.put(ConcurrentHashMap.class, jsonObj -> new ConcurrentHashMap());
        DEFAULT_INSTANTIATORS.put(ConcurrentSkipListMap.class, jsonObj -> new ConcurrentSkipListMap());
        DEFAULT_INSTANTIATORS.put(Vector.class, jsonObj -> new Vector());
        DEFAULT_INSTANTIATORS.put(HashMap.class, jsonObj -> new HashMap());
        DEFAULT_INSTANTIATORS.put(TreeMap.class, jsonObj -> new TreeMap());
        DEFAULT_INSTANTIATORS.put(CompactCIHashSet.class, jsonObj -> new CompactCIHashSet());
        DEFAULT_INSTANTIATORS.put(CompactCILinkedSet.class, jsonObj -> new CompactCILinkedSet());
        DEFAULT_INSTANTIATORS.put(CompactLinkedSet.class, jsonObj -> new CompactLinkedSet());
        DEFAULT_INSTANTIATORS.put(ConcurrentSkipListSet.class, jsonObj -> new ConcurrentSkipListSet());
        DEFAULT_INSTANTIATORS.put(ConcurrentNavigableSetNullSafe.class, jsonObj -> new ConcurrentNavigableSetNullSafe());
        DEFAULT_INSTANTIATORS.put(ConcurrentSet.class, jsonObj -> new ConcurrentSet());
        DEFAULT_INSTANTIATORS.put(HashSet.class, jsonObj -> new HashSet());
        DEFAULT_INSTANTIATORS.put(LinkedHashSet.class, jsonObj -> new LinkedHashSet());
        DEFAULT_INSTANTIATORS.put(TreeSet.class, jsonObj -> new TreeSet());
        DEFAULT_INSTANTIATORS.put(LinkedHashMap.class, jsonObj -> new LinkedHashMap());
        DEFAULT_INSTANTIATORS.put(CompactMap.class, jsonObj -> {
            if (!jsonObj.containsKey("config") || !jsonObj.containsKey("data")) {
                return new CompactMap();
            }
            Object configValue = jsonObj.get("config");
            if (!(configValue instanceof String) || ((String)configValue).split("/", -1).length < 3) {
                return new CompactMap();
            }
            return null;
        });
        DEFAULT_INSTANTIATORS.put(CompactSet.class, jsonObj -> {
            if (!jsonObj.containsKey("config") || !jsonObj.containsKey("data")) {
                return new CompactSet();
            }
            Object configValue = jsonObj.get("config");
            if (!(configValue instanceof String) || StringUtilities.count((String)((String)configValue), (char)'/') < 2) {
                return new CompactSet();
            }
            return null;
        });
    }

    protected static class Missingfields {
        private final Object target;
        private final String fieldName;
        private final Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

