/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class SingletonSet<T>
implements Set<T> {
    private static final Object UNINITIALIZED = new Object();
    private T element = UNINITIALIZED;

    public SingletonSet(T element) {
        this.element = element == null ? UNINITIALIZED : element;
    }

    public SingletonSet() {
    }

    @Override
    public int size() {
        return this.element == UNINITIALIZED ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.element == UNINITIALIZED;
    }

    @Override
    public boolean contains(Object o) {
        return this.element != UNINITIALIZED && this.element.equals(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private boolean hasNext;
            {
                this.hasNext = SingletonSet.this.element != UNINITIALIZED;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return SingletonSet.this.element;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        if (this.element == UNINITIALIZED) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.element;
        }
        return objectArray;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        if (this.element == UNINITIALIZED) {
            return a;
        }
        if (a.length > 0) {
            a[0] = this.element;
            if (a.length > 1) {
                a[1] = null;
            }
            return a;
        }
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
        newArray[0] = this.element;
        return newArray;
    }

    @Override
    public boolean add(T t) {
        if (this.element == UNINITIALIZED) {
            this.element = t;
            return true;
        }
        throw new UnsupportedOperationException("Cannot add item to singleton set");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove item from singleton set");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.size() == 1 && c.contains(this.element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Cannot add items to singleton set");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot modify singleton set");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from singleton set");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear singleton set");
    }
}

