/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.reflect;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.StringUtilities;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Injector {
    private static final boolean IS_JDK17_OR_HIGHER;
    private static final Object LOOKUP;
    private static final Method PRIVATE_LOOKUP_IN_METHOD;
    private static final Method FIND_VAR_HANDLE_METHOD;
    private static final Method VAR_HANDLE_SET_METHOD;
    private static final Class<?> VAR_HANDLE_CLASS;
    private final Field field;
    private final String displayName;
    private final String uniqueFieldName;
    private MethodHandle injector;
    private Object varHandle;
    private final boolean useFieldSet;

    public Injector(Field field, MethodHandle handle, String uniqueFieldName, String displayName) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.injector = handle;
        this.useFieldSet = false;
    }

    private Injector(Field field, String uniqueFieldName, String displayName, boolean useFieldSet) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.useFieldSet = useFieldSet;
    }

    private Injector(Field field, Object varHandle, String uniqueFieldName, String displayName) {
        this.field = field;
        this.displayName = displayName;
        this.uniqueFieldName = uniqueFieldName;
        this.varHandle = varHandle;
        this.useFieldSet = false;
    }

    public static Injector create(Field field, String uniqueFieldName) {
        boolean isFinal;
        if (!field.isAccessible()) {
            try {
                field.setAccessible(true);
            }
            catch (Exception ioe) {
                if (IS_JDK17_OR_HIGHER) {
                    return Injector.createWithVarHandle(field, uniqueFieldName);
                }
                return null;
            }
        }
        if ((isFinal = Modifier.isFinal(field.getModifiers())) && !IS_JDK17_OR_HIGHER) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception ex) {
                return new Injector(field, uniqueFieldName, field.getName(), true);
            }
            return new Injector(field, uniqueFieldName, field.getName(), true);
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectSetter(field);
            return new Injector(field, handle, uniqueFieldName, field.getName());
        }
        catch (IllegalAccessException e) {
            if (IS_JDK17_OR_HIGHER) {
                return Injector.createWithVarHandle(field, uniqueFieldName);
            }
            return new Injector(field, uniqueFieldName, field.getName(), true);
        }
    }

    private static Injector createWithVarHandle(Field field, String uniqueFieldName) {
        if (PRIVATE_LOOKUP_IN_METHOD == null || FIND_VAR_HANDLE_METHOD == null || VAR_HANDLE_SET_METHOD == null || LOOKUP == null) {
            return null;
        }
        try {
            Object privateLookup = PRIVATE_LOOKUP_IN_METHOD.invoke(null, field.getDeclaringClass(), LOOKUP);
            Object varHandle = FIND_VAR_HANDLE_METHOD.invoke(privateLookup, field.getDeclaringClass(), field.getName(), field.getType());
            return new Injector(field, varHandle, uniqueFieldName, field.getName());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Injector create(Field field, String methodName, String uniqueFieldName) {
        try {
            MethodType methodType = MethodType.methodType(Void.class, field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), methodName, methodType);
            return new Injector(field, handle, uniqueFieldName, methodName);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            return null;
        }
    }

    public void inject(Object object, Object value) {
        if (object == null) {
            throw new JsonIoException("Attempting to set field: " + this.getName() + " on null object.");
        }
        try {
            if (this.varHandle != null) {
                this.injectWithVarHandle(object, value);
            } else if (this.useFieldSet) {
                this.field.set(object, value);
            } else {
                this.injector.invoke(object, value);
            }
        }
        catch (ClassCastException e) {
            String msg = e.getMessage();
            if (StringUtilities.hasContent((String)msg) && msg.contains("LinkedHashMap")) {
                throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName() + ".", e);
            }
            try {
                Object convertedValue = Converter.convert((Object)value, this.field.getType());
                if (this.varHandle != null) {
                    this.injectWithVarHandle(object, convertedValue);
                } else if (this.useFieldSet) {
                    this.field.set(object, convertedValue);
                } else {
                    this.injector.invoke(object, convertedValue);
                }
            }
            catch (Throwable t) {
                throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName() + ". Getting a ClassCastException.", e);
            }
        }
        catch (Throwable t) {
            if (t instanceof JsonIoException) {
                throw (JsonIoException)t;
            }
            throw new JsonIoException("Unable to set field: " + this.getName() + " using " + this.getDisplayName(), t);
        }
    }

    private void injectWithVarHandle(Object object, Object value) throws Exception {
        if (this.varHandle == null || VAR_HANDLE_SET_METHOD == null) {
            throw new JsonIoException("Unable to set field: " + this.getName() + " - VarHandle not available");
        }
        VAR_HANDLE_SET_METHOD.invoke(this.varHandle, object, value);
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        int dot = version.indexOf(46);
        if (dot != -1) {
            return Integer.parseInt(version.substring(0, dot));
        }
        return Integer.parseInt(version);
    }

    static {
        int javaVersion = Injector.getJavaVersion();
        IS_JDK17_OR_HIGHER = javaVersion >= 17;
        Object lookup = null;
        Method privateLookupInMethod = null;
        Method findVarHandleMethod = null;
        Method varHandleSetMethod = null;
        Class<?> varHandleClass = null;
        if (javaVersion >= 9) {
            try {
                Class<?> methodHandlesClass = Class.forName("java.lang.invoke.MethodHandles");
                Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
                Method lookupMethod = methodHandlesClass.getMethod("lookup", new Class[0]);
                lookup = lookupMethod.invoke(null, new Object[0]);
                privateLookupInMethod = methodHandlesClass.getMethod("privateLookupIn", Class.class, lookupClass);
                varHandleClass = Class.forName("java.lang.invoke.VarHandle");
                findVarHandleMethod = lookupClass.getMethod("findVarHandle", Class.class, String.class, Class.class);
                varHandleSetMethod = varHandleClass.getMethod("set", Object.class, Object.class);
            }
            catch (Exception e) {
                lookup = null;
                privateLookupInMethod = null;
                findVarHandleMethod = null;
                varHandleSetMethod = null;
                varHandleClass = null;
            }
        }
        LOOKUP = lookup;
        PRIVATE_LOOKUP_IN_METHOD = privateLookupInMethod;
        FIND_VAR_HANDLE_METHOD = findVarHandleMethod;
        VAR_HANDLE_SET_METHOD = varHandleSetMethod;
        VAR_HANDLE_CLASS = varHandleClass;
    }
}

