/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class Resolver {
    private static final String NO_FACTORY = "_\ufe3f_\u03c8_\u263c";
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    private final IdentityHashMap<Object, Object> visited = new IdentityHashMap();
    private final Deque<JsonObject> stack = new ArrayDeque<JsonObject>();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    private final ReadOptions readOptions;
    private final ReferenceTracker references;
    private final Converter converter;

    public ReadOptions getReadOptions() {
        return this.readOptions;
    }

    public ReferenceTracker getReferences() {
        return this.references;
    }

    public Converter getConverter() {
        return this.converter;
    }

    protected Resolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        this.readOptions = readOptions;
        this.references = references;
        this.converter = converter;
    }

    public <T> T toJavaObjects(JsonObject rootObj, Class<T> root) {
        Object instance;
        if (rootObj == null) {
            return null;
        }
        if (rootObj.isReference()) {
            rootObj = this.getReferences().get(rootObj);
        }
        if (rootObj.isFinished) {
            return (T)rootObj.getTarget();
        }
        rootObj.setHintType(root);
        Object object = instance = rootObj.getTarget() == null ? this.createInstance(rootObj) : rootObj.getTarget();
        if (rootObj.isFinished) {
            return (T)instance;
        }
        return this.traverseJsonObject(rootObj);
    }

    public <T> T traverseJsonObject(JsonObject root) {
        this.push(root);
        while (!this.stack.isEmpty()) {
            JsonObject jsonObj = this.stack.pop();
            if (jsonObj.isReference() || jsonObj.isFinished) continue;
            if (this.visited.containsKey(jsonObj)) {
                jsonObj.setFinished();
                continue;
            }
            this.visited.put(jsonObj, null);
            this.traverseSpecificType(jsonObj);
        }
        return (T)root.getTarget();
    }

    public void traverseSpecificType(JsonObject jsonObj) {
        if (jsonObj.isArray()) {
            this.traverseArray(this.stack, jsonObj);
        } else if (jsonObj.isCollection()) {
            this.traverseCollection(this.stack, jsonObj);
        } else if (jsonObj.isMap()) {
            this.traverseMap(jsonObj);
        } else {
            Object special = this.readWithFactoryIfExists(jsonObj, null, this.stack);
            if (special != null) {
                jsonObj.setTarget(special);
            } else {
                this.traverseFields(this.stack, jsonObj);
            }
        }
    }

    public void push(JsonObject jsonObject) {
        this.stack.push(jsonObject);
    }

    public abstract void traverseFields(Deque<JsonObject> var1, JsonObject var2);

    protected abstract Object readWithFactoryIfExists(Object var1, Class<?> var2, Deque<JsonObject> var3);

    protected abstract void traverseCollection(Deque<JsonObject> var1, JsonObject var2);

    protected abstract void traverseArray(Deque<JsonObject> var1, JsonObject var2);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        if (this.references != null) {
            this.references.clear();
        }
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        this.handleMissingFields();
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.readOptions.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(JsonObject jsonObj) {
        Map.Entry<Object[], Object[]> pair = jsonObj.asTwoArrays();
        Object[] keys = pair.getKey();
        Object[] items = pair.getValue();
        if (keys == null || items == null) {
            if (keys != items) {
                throw new JsonIoException("Unbalanced { } in JSON, it has @keys or @items empty. They should be same null, empty, or same length.");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            throw new JsonIoException("Unbalance { } in JSON, it has @keys and @itemss entries of different sizes. They should be same length.");
        }
        this.buildCollection(keys);
        this.buildCollection(items);
        this.prettyMaps.add(new Object[]{jsonObj, keys, items});
    }

    private void buildCollection(Object[] arrayContent) {
        JsonObject collection = new JsonObject();
        collection.setJsonArray(arrayContent);
        collection.setTarget(arrayContent);
        this.push(collection);
    }

    Object createInstance(JsonObject jsonObj) {
        Object mate;
        Object target = jsonObj.getTarget();
        if (target != null) {
            return target;
        }
        Class<?> targetType = jsonObj.getJavaType();
        jsonObj.setJavaType(this.coerceClassIfNeeded(targetType));
        targetType = jsonObj.getJavaType();
        if (jsonObj.hasValue() && jsonObj.getValue() != null) {
            if (this.converter.isConversionSupportedFor(jsonObj.getValue().getClass(), targetType)) {
                Object value = this.converter.convert(jsonObj.getValue(), targetType);
                return jsonObj.setFinishedTarget(value, true);
            }
        } else if (!jsonObj.isEmpty() && this.converter.isConversionSupportedFor(Map.class, targetType)) {
            try {
                Object value = this.converter.convert((Object)jsonObj, targetType);
                return jsonObj.setFinishedTarget(value, true);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if ((mate = this.createInstanceUsingClassFactory(jsonObj.getJavaType(), jsonObj)) != NO_FACTORY) {
            return mate;
        }
        Object mayEnumSpecial = jsonObj.get("@enum");
        if (mayEnumSpecial instanceof String) {
            Class clazz = ClassUtilities.forName((String)((String)mayEnumSpecial), (ClassLoader)Resolver.class.getClassLoader());
            mate = this.extractEnumSet(clazz, jsonObj);
            jsonObj.setTarget(mate);
            jsonObj.isFinished = true;
            return mate;
        }
        Class<?> c = jsonObj.getJavaType();
        Object[] items = jsonObj.getJsonArray();
        if (c.isArray() || items != null && c == Object.class && !jsonObj.containsKey("@keys")) {
            int size = items == null ? 0 : items.length;
            mate = Array.newInstance(c.isArray() ? c.getComponentType() : Object.class, size);
            jsonObj.setTarget(mate);
            return mate;
        }
        return this.createInstanceUsingType(jsonObj);
    }

    private Object createInstanceUsingType(JsonObject jsonObj) {
        Object mate;
        Class<?> c = jsonObj.getJavaType();
        boolean useMaps = this.readOptions.isReturningJsonObjects();
        if (c == Object.class && !useMaps) {
            Class<?> unknownClass = this.readOptions.getUnknownTypeClass();
            if (unknownClass == null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.setJavaType(Map.class);
                mate = jsonObject;
            } else {
                mate = MetaUtils.newInstance(this.converter, unknownClass, null);
            }
        } else {
            mate = MetaUtils.newInstance(this.converter, c, null);
        }
        jsonObj.setTarget(mate);
        return mate;
    }

    Object createInstanceUsingClassFactory(Class c, JsonObject jsonObj) {
        JsonReader.ClassFactory classFactory = this.readOptions.getClassFactory(c);
        if (classFactory == null) {
            return NO_FACTORY;
        }
        Object target = classFactory.newInstance(c, jsonObj, this);
        if (classFactory.isObjectFinal()) {
            return jsonObj.setFinishedTarget(target, true);
        }
        jsonObj.setTarget(target);
        return target;
    }

    private Class<?> coerceClassIfNeeded(Class<?> type) {
        if (type == null) {
            return null;
        }
        Class<?> clazz = this.readOptions.getCoercedClass(type);
        return clazz == null ? type : clazz;
    }

    private EnumSet<?> extractEnumSet(Class c, JsonObject jsonObj) {
        String enumClassName = (String)jsonObj.get("@enum");
        Class enumClass = enumClassName == null ? null : ClassUtilities.forName((String)enumClassName, (ClassLoader)this.readOptions.getClassLoader());
        Object[] items = jsonObj.getJsonArray();
        if (items == null || items.length == 0) {
            if (enumClass != null) {
                return EnumSet.noneOf(enumClass);
            }
            return EnumSet.noneOf(MetaUtils.Dumpty.class);
        }
        if (enumClass == null) {
            throw new JsonIoException("Could not figure out Enum of the not empty set " + jsonObj);
        }
        EnumSet enumSet = null;
        for (Object item : items) {
            Object enumItem;
            if (item instanceof String) {
                enumItem = Enum.valueOf(enumClass, (String)item);
            } else {
                JsonObject jObj = (JsonObject)item;
                enumItem = Enum.valueOf(enumClass, (String)jObj.get("name"));
            }
            if (enumSet == null) {
                enumSet = EnumSet.of(enumItem);
                continue;
            }
            enumSet.add(enumItem);
        }
        return enumSet;
    }

    private void patchUnresolvedReferences() {
        for (UnresolvedReference ref : this.unresolvedRefs) {
            Object objToFix = ref.referencingObj.getTarget();
            JsonObject objReferenced = this.references.get(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List<Object> list = (List<Object>)objToFix;
                    list.set(ref.index, objReferenced.getTarget());
                    String containingTypeName = ref.referencingObj.getJavaTypeName();
                    if (containingTypeName == null || !containingTypeName.startsWith("java.util.Immutable") || !containingTypeName.contains("List") || !list.stream().noneMatch(c -> c == null || c instanceof JsonObject)) continue;
                    list = MetaUtils.listOf(list.toArray());
                    ref.referencingObj.setTarget(list);
                    continue;
                }
                if (objToFix instanceof Collection) {
                    String containingTypeName = ref.referencingObj.getJavaTypeName();
                    Collection col = (Collection)objToFix;
                    if (containingTypeName != null && containingTypeName.startsWith("java.util.Immutable") && containingTypeName.contains("Set")) {
                        throw new JsonIoException("Error setting set entry of ImmutableSet '" + ref.referencingObj.getJavaTypeName() + "', @ref = " + ref.refId);
                    }
                    col.add(objReferenced.getTarget());
                    continue;
                }
                Array.set(objToFix, ref.index, objReferenced.getTarget());
                continue;
            }
            Field field = this.getReadOptions().getDeepDeclaredFields(objToFix.getClass()).get(ref.field);
            if (field == null) continue;
            try {
                MetaUtils.setFieldValue(field, objToFix, objReferenced.getTarget());
            }
            catch (Exception e) {
                throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
            }
        }
        this.unresolvedRefs.clear();
    }

    private void rehashMaps() {
        boolean useMapsLocal = this.readOptions.isReturningJsonObjects();
        for (Object[] mapPieces : this.prettyMaps) {
            JsonObject jsonObj = (JsonObject)mapPieces[0];
            jsonObj.rehashMaps(useMapsLocal, (Object[])mapPieces[1], (Object[])mapPieces[2]);
        }
    }

    protected static class Missingfields {
        private final Object target;
        private final String fieldName;
        private final Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

