/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.Primitives;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.io.Writers;
import com.cedarsoftware.io.reflect.Accessor;
import com.cedarsoftware.util.FastWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonWriter
implements WriterContext,
Closeable,
Flushable {
    private static final Object[] byteStrings = new Object[256];
    private static final String NEW_LINE = System.lineSeparator();
    private static final Long ZERO = 0L;
    private final WriteOptions writeOptions;
    private final Map<Object, Long> objVisited = new IdentityHashMap<Object, Long>();
    private final Map<Object, Long> objsReferenced = new IdentityHashMap<Object, Long>();
    private final Writer out;
    private long identity = 1L;
    private int depth = 0;

    public JsonWriter(OutputStream out) {
        this(out, new WriteOptionsBuilder().build());
    }

    public JsonWriter(OutputStream out, WriteOptions writeOptions) {
        this.out = new FastWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.writeOptions = writeOptions == null ? new WriteOptionsBuilder().build() : writeOptions;
    }

    @Override
    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    protected Map<Object, Long> getObjVisited() {
        return this.objVisited;
    }

    protected Map<Object, Long> getObjsReferenced() {
        return this.objsReferenced;
    }

    public void tabIn() throws IOException {
        this.tab(this.out, 1);
    }

    public void newLine() throws IOException {
        this.tab(this.out, 0);
    }

    public void tabOut() throws IOException {
        this.tab(this.out, -1);
    }

    private void tab(Writer output, int delta) throws IOException {
        if (!this.writeOptions.isPrettyPrint()) {
            return;
        }
        output.write(NEW_LINE);
        this.depth += delta;
        for (int i = 0; i < this.depth; ++i) {
            output.write("  ");
        }
    }

    public boolean writeUsingCustomWriter(Object o, boolean showType, Writer output) {
        Class<?> c = o.getClass();
        if (this.writeOptions.isNotCustomWrittenClass(c)) {
            return false;
        }
        try {
            return this.writeCustom(c, o, !this.writeOptions.isNeverShowingType() && showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object:", e);
        }
    }

    public boolean writeArrayElementIfMatching(Class<?> arrayComponentClass, Object o, boolean showType, Writer output) {
        if (!arrayComponentClass.isAssignableFrom(o.getClass()) || this.writeOptions.isNotCustomWrittenClass(o.getClass())) {
            return false;
        }
        try {
            return this.writeCustom(arrayComponentClass, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object as array element:", e);
        }
    }

    protected boolean writeCustom(Class<?> arrayComponentClass, Object o, boolean showType, Writer output) throws IOException {
        JsonClassWriter closestWriter;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if ((closestWriter = this.writeOptions.getCustomWriter(o.getClass())) == null) {
            return false;
        }
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(o);
        if (closestWriter.hasPrimitiveForm(this) && (!referenced && !showType || closestWriter instanceof Writers.JsonStringWriter)) {
            closestWriter.writePrimitiveForm(o, output, this);
            return true;
        }
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(o));
            if (showType) {
                output.write(44);
                this.newLine();
            }
        }
        if (showType) {
            this.writeType(o.getClass().getName(), output);
        }
        if (referenced || showType) {
            output.write(44);
            this.newLine();
        }
        closestWriter.write(o, showType || referenced, output, this);
        this.tabOut();
        output.write(125);
        return true;
    }

    public void write(Object obj) {
        this.traceReferences(obj);
        this.objVisited.clear();
        try {
            this.writeImpl(obj, true);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("Error writing object to JSON:", e);
        }
        this.flush();
        this.objVisited.clear();
        this.objsReferenced.clear();
    }

    protected void traceReferences(Object root) {
        if (root == null) {
            return;
        }
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        Map<Object, Long> visited = this.objVisited;
        Map<Object, Long> referenced = this.objsReferenced;
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object obj = stack.removeFirst();
            if (!this.writeOptions.isNonReferenceableClass(obj.getClass())) {
                Long id = visited.get(obj);
                if (id != null) {
                    if (!id.equals(ZERO)) continue;
                    id = this.identity++;
                    visited.put(obj, id);
                    referenced.put(obj, id);
                    continue;
                }
                visited.put(obj, ZERO);
            }
            if ((clazz = obj.getClass()).isArray()) {
                if (this.writeOptions.isNonReferenceableClass(clazz.getComponentType())) continue;
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(obj, i);
                    if (o == null) continue;
                    stack.addFirst(o);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                try {
                    Map map = (Map)obj;
                    Iterator i = map.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry item;
                        Map.Entry entry = item = i.next();
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value != null && !this.writeOptions.isNonReferenceableClass(value.getClass())) {
                            stack.addFirst(value);
                        }
                        if (key == null || this.writeOptions.isNonReferenceableClass(key.getClass())) continue;
                        stack.addFirst(key);
                    }
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    continue;
                }
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                for (Object item : (Collection)obj) {
                    if (item == null || this.writeOptions.isNonReferenceableClass(item.getClass())) continue;
                    stack.addFirst(item);
                }
                continue;
            }
            if (this.writeOptions.isNonReferenceableClass(obj.getClass())) continue;
            this.traceFields(stack, obj);
        }
    }

    protected void traceFields(Deque<Object> stack, Object obj) {
        List<Accessor> fields = this.writeOptions.getAccessorsForClass(obj.getClass());
        for (Accessor accessor : fields) {
            MetaUtils.safelyIgnoreException(() -> {
                Object o = accessor.retrieve(obj);
                if (o != null && !this.writeOptions.isNonReferenceableClass(o.getClass())) {
                    stack.addFirst(o);
                }
            });
        }
    }

    private boolean writeOptionalReference(Object obj) throws IOException {
        if (obj == null || this.writeOptions.isNonReferenceableClass(obj.getClass())) {
            return false;
        }
        Writer output = this.out;
        if (this.objVisited.containsKey(obj)) {
            String id = this.getId(obj);
            if (id == null) {
                return false;
            }
            output.write(this.writeOptions.isShortMetaKeys() ? "{\"@r\":" : "{\"@ref\":");
            output.write(id);
            output.write(125);
            return true;
        }
        this.objVisited.put(obj, null);
        return false;
    }

    public void writeImpl(Object obj, boolean showType) throws IOException {
        if (obj == null || obj instanceof ProcessBuilder || obj instanceof Process || obj instanceof ClassLoader || obj instanceof Constructor || obj instanceof Method || obj instanceof Field) {
            this.out.write("null");
            return;
        }
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeUsingCustomWriter(obj, showType, this.out) || this.writeOptionalReference(obj)) {
            return;
        }
        if (obj.getClass().isArray()) {
            this.writeArray(obj, showType);
        } else if (obj instanceof EnumSet) {
            this.writeEnumSet((EnumSet)obj);
        } else if (obj instanceof Collection) {
            this.writeCollection((Collection)obj, showType);
        } else if (obj instanceof JsonObject) {
            JsonObject jObj = (JsonObject)obj;
            if (jObj.isArray()) {
                this.writeJsonObjectArray(jObj, showType);
            } else if (jObj.isCollection()) {
                this.writeJsonObjectCollection(jObj, showType);
            } else if (jObj.isMap()) {
                if (!this.writeJsonObjectMapWithStringKeys(jObj, showType)) {
                    this.writeJsonObjectMap(jObj, showType);
                }
            } else {
                this.writeJsonObjectObject(jObj, showType);
            }
        } else if (obj instanceof Map) {
            if (!this.writeMapWithStringKeys((Map)obj, showType)) {
                this.writeMap((Map)obj, showType);
            }
        } else {
            this.writeObject(obj, showType, false);
        }
    }

    private void writeId(String id) throws IOException {
        this.out.write(this.writeOptions.isShortMetaKeys() ? "\"@i\":" : "\"@id\":");
        this.out.write(id == null ? "0" : id);
    }

    private void writeType(String name, Writer output) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            return;
        }
        output.write(this.writeOptions.isShortMetaKeys() ? "\"@t\":\"" : "\"@type\":\"");
        String alias = this.writeOptions.getTypeNameAlias(name);
        output.write(alias);
        output.write(34);
    }

    private void writePrimitive(Object obj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (obj instanceof Long && this.getWriteOptions().isWriteLongsAsStrings()) {
            if (showType) {
                this.out.write(123);
                this.writeType("long", this.out);
                this.out.write(44);
            }
            JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Long.class);
            writer.write(obj, showType, this.out, this);
            if (showType) {
                this.out.write(125);
            }
        } else if (!this.writeOptions.isAllowNanAndInfinity() && obj instanceof Double && (Double.isNaN((Double)obj) || Double.isInfinite((Double)obj))) {
            this.out.write("null");
        } else if (!this.writeOptions.isAllowNanAndInfinity() && obj instanceof Float && (Float.isNaN(((Float)obj).floatValue()) || Float.isInfinite(((Float)obj).floatValue()))) {
            this.out.write("null");
        } else {
            this.out.write(obj.toString());
        }
    }

    private void writeArray(Object array, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Class<?> arrayType = array.getClass();
        int len = Array.getLength(array);
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(Object[].class);
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getId(array));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(arrayType.getName(), output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write(125);
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        if (byte[].class == arrayType) {
            this.writeByteArray((byte[])array, lenMinus1);
        } else if (char[].class == arrayType) {
            JsonWriter.writeJsonUtf8String(output, new String((char[])array));
        } else if (short[].class == arrayType) {
            this.writeShortArray((short[])array, lenMinus1);
        } else if (int[].class == arrayType) {
            this.writeIntArray((int[])array, lenMinus1);
        } else if (long[].class == arrayType) {
            this.writeLongArray((long[])array, lenMinus1);
        } else if (float[].class == arrayType) {
            this.writeFloatArray((float[])array, lenMinus1);
        } else if (double[].class == arrayType) {
            this.writeDoubleArray((double[])array, lenMinus1);
        } else if (boolean[].class == arrayType) {
            this.writeBooleanArray((boolean[])array, lenMinus1);
        } else {
            Class<?> componentClass = array.getClass().getComponentType();
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(array, i);
                if (value == null) {
                    output.write("null");
                } else {
                    boolean forceType = this.isForceType(value.getClass(), componentClass);
                    if (!this.writeArrayElementIfMatching(componentClass, value, forceType, output)) {
                        this.writeImpl(value, forceType);
                    }
                }
                if (i == lenMinus1) continue;
                output.write(44);
                this.newLine();
            }
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(booleans[i] ? "true," : "false,");
        }
        output.write(Boolean.toString(booleans[lenMinus1]));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) throws IOException {
        Writer output = this.out;
        JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Double.class);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(doubles[i], false, output, this);
            output.write(44);
        }
        writer.write(doubles[lenMinus1], false, output, this);
    }

    private void writeFloatArray(float[] floats, int lenMinus1) throws IOException {
        Writer output = this.out;
        JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Float.class);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(Float.valueOf(floats[i]), false, output, this);
            output.write(44);
        }
        writer.write(Float.valueOf(floats[lenMinus1]), false, output, this);
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer output = this.out;
        JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Long.TYPE);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(longs[i], false, output, this);
            output.write(44);
        }
        writer.write(longs[lenMinus1], false, output, this);
    }

    private void writeIntArray(int[] ints, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(ints[i]));
            output.write(44);
        }
        output.write(Integer.toString(ints[lenMinus1]));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(shorts[i]));
            output.write(44);
        }
        output.write(Integer.toString(shorts[lenMinus1]));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) throws IOException {
        Writer output = this.out;
        Object[] byteStrs = byteStrings;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write((char[])byteStrs[bytes[i] + 128]);
            output.write(44);
        }
        output.write((char[])byteStrs[bytes[lenMinus1] + 128]);
    }

    private void writeCollection(Collection<?> col, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            output.write(123);
            this.tabIn();
        } else if (isEmpty) {
            output.write(91);
        }
        this.writeIdAndTypeIfNeeded(col, showType, referenced);
        if (isEmpty) {
            if (referenced || showType) {
                this.tabOut();
                output.write(125);
            } else {
                output.write(93);
            }
            return;
        }
        this.beginCollection(showType, referenced);
        Iterator<?> i = col.iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write(93);
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeElements(Writer output, Iterator<?> i) throws IOException {
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
    }

    private void writeIdAndTypeIfNeeded(Object col, boolean showType, boolean referenced) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (referenced) {
            this.writeId(this.getId(col));
        }
        if (showType) {
            if (referenced) {
                this.out.write(44);
                this.newLine();
            }
            this.writeType(col.getClass().getName(), this.out);
        }
    }

    private void beginCollection(boolean showType, boolean referenced) throws IOException {
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
            this.out.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[" : "\"@items\":[");
        } else {
            this.out.write(91);
        }
        this.tabIn();
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) throws IOException {
        boolean typeWritten;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        int len = jObj.getLength();
        Class<?> jsonObjectType = jObj.getJavaType();
        Class arrayClass = jsonObjectType == null || Object[].class.equals(jsonObjectType) ? Object[].class : jsonObjectType;
        Writer output = this.out;
        boolean isObjectArray = Object[].class == arrayClass;
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this.adjustIfReferenced(jObj);
        boolean bl = typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(Long.toString(jObj.id));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(arrayClass.getName(), output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        Object[] items = (Object[])jObj.get("@items");
        int lenMinus1 = len - 1;
        for (int i = 0; i < len; ++i) {
            Object value = items[i];
            if (value == null) {
                output.write("null");
            } else {
                boolean forceType = this.isForceType(value.getClass(), componentClass);
                if (!this.writeArrayElementIfMatching(componentClass, value, forceType, output)) {
                    if (Character.class == componentClass || Character.TYPE == componentClass) {
                        JsonWriter.writeJsonUtf8String(output, (String)value);
                    } else if (value instanceof String) {
                        JsonWriter.writeJsonUtf8String(output, (String)value);
                    } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                        this.writePrimitive(value, forceType);
                    } else {
                        this.writeImpl(value, forceType);
                    }
                }
            }
            if (i == lenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Class<?> colClass = jObj.getJavaType();
        boolean referenced = this.adjustIfReferenced(jObj);
        Writer output = this.out;
        int len = jObj.getLength();
        if (referenced || showType || len == 0) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(colClass.getName(), output);
        }
        if (len == 0) {
            this.tabOut();
            output.write(125);
            return;
        }
        this.beginCollection(showType, referenced);
        Object[] items = (Object[])jObj.get("@items");
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        for (int i = 0; i < itemsLen; ++i) {
            this.writeCollectionElement(items[i]);
            if (i == itemsLenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        showType = this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(jObj, output);
    }

    private boolean writeJsonObjectMapWithStringKeys(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeOptions.isForceMapOutputAsTwoArrays() || !JsonWriter.ensureJsonPrimitiveKeys(jObj)) {
            return false;
        }
        Writer output = this.out;
        this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return true;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        return this.writeMapBody(jObj.entrySet().iterator());
    }

    private boolean emitIdAndTypeIfNeeded(JsonObject jObj, boolean showType, Writer output) throws IOException {
        boolean referenced = this.adjustIfReferenced(jObj);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            String type;
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            if ((type = jObj.getJavaTypeName()) != null) {
                this.writeType(type, output);
            } else {
                showType = false;
            }
        }
        return showType;
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.adjustIfReferenced(jObj);
        showType = showType && jObj.getJavaType() != null;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        Class<?> type = null;
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(jObj.getJavaTypeName(), output);
            type = jObj.getJavaType();
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        Iterator<Map.Entry<Object, Object>> i = jObj.entrySet().iterator();
        boolean first = true;
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (this.writeOptions.isSkipNullFields() && entry.getValue() == null) continue;
            if (!first) {
                output.write(44);
                this.newLine();
            }
            first = false;
            String fieldName = (String)entry.getKey();
            output.write(34);
            output.write(fieldName);
            output.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                output.write("null");
                continue;
            }
            if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !this.doesValueTypeMatchFieldType(type, fieldName, value));
                continue;
            }
            if (value instanceof Number || value instanceof Boolean) {
                output.write(value.toString());
                continue;
            }
            if (value instanceof String) {
                JsonWriter.writeJsonUtf8String(output, (String)value);
                continue;
            }
            if (value instanceof Character) {
                JsonWriter.writeJsonUtf8String(output, String.valueOf(value));
                continue;
            }
            this.writeImpl(value, !this.doesValueTypeMatchFieldType(type, fieldName, value));
        }
        this.tabOut();
        output.write(125);
    }

    private boolean adjustIfReferenced(JsonObject jObj) {
        Long idx = this.objsReferenced.get(jObj);
        if (!jObj.hasId() && idx != null && idx > 0L) {
            jObj.id = idx;
        }
        return this.objsReferenced.containsKey(jObj) && jObj.hasId();
    }

    private boolean doesValueTypeMatchFieldType(Class<?> type, String fieldName, Object value) {
        if (type != null) {
            Map<String, Field> fieldMap = this.writeOptions.getDeepDeclaredFields(type);
            Field field = fieldMap.get(fieldName);
            return field != null && field.getType().equals(value.getClass());
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(map);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(map));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(map.getClass().getName(), output);
        }
        if (map.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(map, output);
    }

    private void writeMapToEnd(Map map, Writer output) throws IOException {
        output.write(this.writeOptions.isShortMetaKeys() ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = map.keySet().iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.writeOptions.isShortMetaKeys() ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        i = map.values().iterator();
        this.writeElements(output, i);
        this.tabOut();
        output.write(93);
        this.tabOut();
        output.write(125);
    }

    private boolean writeMapWithStringKeys(Map map, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeOptions.isForceMapOutputAsTwoArrays() || !JsonWriter.ensureJsonPrimitiveKeys(map)) {
            return false;
        }
        boolean referenced = this.objsReferenced.containsKey(map);
        this.out.write(123);
        this.tabIn();
        this.writeIdAndTypeIfNeeded(map, showType, referenced);
        if (map.isEmpty()) {
            this.tabOut();
            this.out.write(125);
            return true;
        }
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
        }
        return this.writeMapBody(map.entrySet().iterator());
    }

    private boolean writeMapBody(Iterator i) throws IOException {
        Writer output = this.out;
        while (i.hasNext()) {
            Map.Entry att2value = (Map.Entry)i.next();
            Object value = att2value.getValue();
            if (this.writeOptions.isSkipNullFields() && value == null) continue;
            JsonWriter.writeJsonUtf8String(output, (String)att2value.getKey());
            output.write(":");
            this.writeCollectionElement(value);
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(125);
        return true;
    }

    public static boolean ensureJsonPrimitiveKeys(Map map) {
        for (Object o : map.keySet()) {
            if (o instanceof String) continue;
            return false;
        }
        return true;
    }

    private void writeCollectionElement(Object o) throws IOException {
        if (o == null) {
            this.out.write("null");
        } else if (o instanceof Boolean || o instanceof Double) {
            this.writePrimitive(o, false);
        } else if (o instanceof Long) {
            this.writePrimitive(o, this.getWriteOptions().isWriteLongsAsStrings());
        } else if (o instanceof String) {
            JsonWriter.writeJsonUtf8String(this.out, (String)o);
        } else if (this.getWriteOptions().isNeverShowingType() && MetaUtils.isPrimitive(o.getClass())) {
            this.writePrimitive(o, false);
        } else {
            this.writeImpl(o, true);
        }
    }

    private void writeEnumSet(EnumSet<?> enumSet) throws IOException {
        this.out.write(123);
        this.tabIn();
        boolean referenced = this.objsReferenced.containsKey(enumSet);
        if (referenced) {
            this.writeId(this.getId(enumSet));
            this.out.write(44);
            this.newLine();
        }
        this.out.write("\"@enum\":");
        Enum ee = null;
        if (!enumSet.isEmpty()) {
            ee = (Enum)enumSet.iterator().next();
        } else {
            EnumSet<?> complement = EnumSet.complementOf(enumSet);
            if (!complement.isEmpty()) {
                ee = (Enum)complement.iterator().next();
            }
        }
        Field elementTypeField = this.writeOptions.getDeepDeclaredFields(EnumSet.class).get("elementType");
        Class elementType = (Class<MetaUtils.Dumpty>)this.getValueByReflect(enumSet, elementTypeField);
        if (elementType == null) {
            elementType = ee == null ? MetaUtils.Dumpty.class : ee.getClass();
        }
        JsonWriter.writeBasicString(this.out, elementType.getName());
        if (!enumSet.isEmpty()) {
            List<Accessor> mapOfFields = this.writeOptions.getAccessorsForClass(elementType);
            int enumFieldsCount = mapOfFields.size();
            this.out.write(",");
            this.newLine();
            JsonWriter.writeBasicString(this.out, "@items");
            this.out.write(":[");
            if (enumFieldsCount > 2) {
                this.newLine();
            }
            boolean firstInSet = true;
            for (Enum e : enumSet) {
                if (!firstInSet) {
                    this.out.write(",");
                    if (enumFieldsCount > 2) {
                        this.newLine();
                    }
                }
                firstInSet = false;
                if (enumFieldsCount <= 2) {
                    JsonWriter.writeJsonUtf8String(this.out, e.name());
                    continue;
                }
                boolean firstInEntry = true;
                this.out.write(123);
                for (Accessor f : mapOfFields) {
                    firstInEntry = this.writeField(e, firstInEntry, f.getUniqueFieldName(), f);
                }
                this.out.write(125);
            }
            this.out.write("]");
        }
        this.tabOut();
        this.out.write(125);
    }

    @Override
    public void writeObject(Object obj, boolean showType, boolean bodyOnly) throws IOException {
        boolean first;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        boolean referenced = this.objsReferenced.containsKey(obj);
        if (!bodyOnly) {
            this.out.write(123);
            this.tabIn();
            if (referenced) {
                this.writeId(this.getId(obj));
            }
            if (referenced && showType) {
                this.out.write(44);
                this.newLine();
            }
            if (showType) {
                this.writeType(obj.getClass().getName(), this.out);
            }
        }
        boolean bl = first = !showType;
        if (referenced && !showType) {
            first = false;
        }
        List<Accessor> accessors = this.writeOptions.getAccessorsForClass(obj.getClass());
        for (Accessor accessor : accessors) {
            String fieldName = accessor.getUniqueFieldName();
            first = this.writeField(obj, first, fieldName, accessor);
        }
        if (!bodyOnly) {
            this.tabOut();
            this.out.write(125);
        }
    }

    private Object getValueByReflect(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private boolean writeField(Object obj, boolean first, String fieldName, Accessor accessor) throws IOException {
        Object o;
        Class<?> fieldDeclaringClass = accessor.getDeclaringClass();
        if (Enum.class.isAssignableFrom(fieldDeclaringClass)) {
            if (!accessor.isPublic() && this.writeOptions.isEnumPublicFieldsOnly()) {
                return first;
            }
            o = accessor.retrieve(obj);
        } else {
            o = accessor.retrieve(obj);
        }
        if (this.writeOptions.isSkipNullFields() && o == null) {
            return first;
        }
        if (!first) {
            this.out.write(44);
            this.newLine();
        }
        this.out.write("\"");
        this.out.write(fieldName);
        this.out.write("\":");
        if (o == null) {
            this.out.write("null");
            return false;
        }
        Class<?> type = accessor.getFieldType();
        this.writeImpl(o, this.isForceType(o.getClass(), type));
        return false;
    }

    private boolean isForceType(Class<?> objectClass, Class<?> declaredType) {
        boolean declaredClassIsLongWrittenAsString;
        boolean writeLongsAsStrings = this.writeOptions.isWriteLongsAsStrings();
        boolean objectClassIsLongWrittenAsString = (objectClass == Long.class || objectClass == Long.TYPE) && writeLongsAsStrings;
        boolean bl = declaredClassIsLongWrittenAsString = (declaredType == Long.class || objectClass == Long.TYPE) && writeLongsAsStrings;
        if (Primitives.isNativeJsonType(objectClass) && !objectClassIsLongWrittenAsString) {
            return false;
        }
        if (Primitives.isPrimitive(declaredType) && !declaredClassIsLongWrittenAsString) {
            return false;
        }
        if (this.writeOptions.isNeverShowingType() && Primitives.isPrimitive(objectClass) && !objectClassIsLongWrittenAsString) {
            return false;
        }
        if (this.writeOptions.isAlwaysShowingType()) {
            return true;
        }
        if (objectClass == declaredType) {
            return false;
        }
        if (declaredType.isEnum() && declaredType.isAssignableFrom(objectClass)) {
            Optional<Class<?>> optionalClass = MetaUtils.getClassIfEnum(objectClass);
            return declaredType != optionalClass.orElse(null);
        }
        return true;
    }

    @Override
    public void flush() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getId(Object o) {
        long id;
        if (o instanceof JsonObject && (id = ((JsonObject)o).id) > 0L) {
            return String.valueOf(id);
        }
        Long id2 = this.objsReferenced.get(o);
        return id2 == null ? null : Long.toString(id2);
    }

    public static void writeBasicString(Writer writer, String s) throws IOException {
        writer.write(34);
        writer.write(s);
        writer.write(34);
    }

    private static void writeChar(Writer writer, char c) throws IOException {
        if (c < ' ') {
            switch (c) {
                case '\b': {
                    writer.write("\\b");
                    break;
                }
                case '\f': {
                    writer.write("\\f");
                    break;
                }
                case '\n': {
                    writer.write("\\n");
                    break;
                }
                case '\r': {
                    writer.write("\\r");
                    break;
                }
                case '\t': {
                    writer.write("\\t");
                    break;
                }
                default: {
                    writer.write(String.format("\\u%04X", c));
                    break;
                }
            }
        } else if (c == '\\' || c == '\"') {
            writer.write(92);
            writer.write(c);
        } else {
            writer.write(c);
        }
    }

    public static void writeJsonUtf8String(Writer output, String s) throws IOException {
        output.write(34);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            JsonWriter.writeChar(output, s.charAt(i));
        }
        output.write(34);
    }

    static {
        for (int i = -128; i <= 127; i = (int)((short)(i + 1))) {
            char[] chars = Integer.toString(i).toCharArray();
            JsonWriter.byteStrings[i + 128] = chars;
        }
    }

    public static interface JsonClassWriter {
        default public void write(Object o, boolean showType, Writer output, WriterContext context) throws IOException {
        }

        default public boolean hasPrimitiveForm(WriterContext context) {
            return false;
        }

        default public void writePrimitiveForm(Object o, Writer output, WriterContext context) throws IOException {
        }
    }
}

