/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.reflect;

import com.cedarsoftware.util.io.MetaUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class Accessor {
    private final String uniqueFieldName;
    private final Field field;
    private final boolean isMethod;
    private final String displayName;
    private final MethodHandle methodHandle;
    private final boolean isPublic;

    private Accessor(Field field, MethodHandle methodHandle, String uniqueFieldName, String displayName, boolean isPublic, boolean isMethod) {
        this.field = field;
        this.methodHandle = methodHandle;
        this.uniqueFieldName = uniqueFieldName;
        this.displayName = displayName;
        this.isPublic = isPublic;
        this.isMethod = isMethod;
    }

    public static Accessor create(Field field, String uniqueFieldName) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            MetaUtils.trySetAccessible(field);
        }
        try {
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            return new Accessor(field, handle, uniqueFieldName, field.getName(), Modifier.isPublic(field.getModifiers()), false);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static Accessor create(Field field, String method, String uniqueFieldName) {
        try {
            MethodType type = MethodType.methodType(field.getType());
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(field.getDeclaringClass(), method, type);
            return new Accessor(field, handle, uniqueFieldName, method, true, true);
        }
        catch (IllegalAccessException | NoSuchMethodException ignore) {
            return null;
        }
    }

    public Object retrieve(Object o) {
        try {
            if (this.methodHandle == null) {
                return this.field.get(o);
            }
            return this.methodHandle.invoke(o);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getActualFieldName() {
        return this.field.getName();
    }

    public boolean isMethodHandlePresent() {
        return this.methodHandle != null;
    }

    public String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

