/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.ReaderContext;
import java.lang.reflect.Array;

public class ArrayFactory<T>
implements JsonReader.ClassFactory {
    private final Class<T> type;

    public ArrayFactory(Class<T> c) {
        this.type = c;
    }

    public T newInstance(Class<?> c, JsonObject jObj, ReaderContext context) {
        Object[] items = jObj.getArray();
        if (items == null) {
            jObj.setTarget(null);
        } else {
            int len = items.length;
            Class<?> arrayType = this.getType();
            Class<?> componentType = arrayType.getComponentType();
            Object array = Array.newInstance(componentType, len);
            for (int i = 0; i < len; ++i) {
                Object val = items[i];
                if (val != null) {
                    if (val instanceof JsonObject) {
                        Class<?> type;
                        JsonObject jsonObject;
                        do {
                            jsonObject = (JsonObject)val;
                            type = jsonObject.getJavaType();
                        } while (jsonObject.hasValue() && (val = jsonObject.getValue()) instanceof JsonObject);
                        if (type == null) {
                            type = componentType;
                        }
                        val = context.getConverter().convert(val, type);
                    } else {
                        val = context.getConverter().convert(val, componentType);
                    }
                }
                Array.set(array, i, val);
            }
            jObj.setTarget(array);
        }
        return (T)jObj.getTarget();
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

