/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.ReaderContext;
import java.util.Map;

public class ConvertableFactory<T>
implements JsonReader.ClassFactory {
    private final Class<? extends T> type;

    public ConvertableFactory(Class<? extends T> c) {
        this.type = c;
    }

    public T newInstance(Class<?> c, JsonObject jObj, ReaderContext context) {
        if (jObj.hasValue()) {
            Object converted = context.getConverter().convert(jObj.getValue(), this.getType());
            return (T)jObj.setFinishedTarget(converted, true);
        }
        this.resolveReferences(context, jObj);
        Class<Object> javaType = jObj.getJavaType();
        if (javaType == null) {
            javaType = this.getType();
        }
        Object converted = context.getConverter().convert((Object)jObj, javaType);
        return (T)jObj.setFinishedTarget(converted, true);
    }

    private void resolveReferences(ReaderContext context, JsonObject jObj) {
        for (Map.Entry<Object, Object> entry : jObj.entrySet()) {
            JsonObject child;
            if (!(entry.getValue() instanceof JsonObject) || !(child = (JsonObject)entry.getValue()).isReference()) continue;
            entry.setValue(context.getReferences().get(child));
        }
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

