/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.ReaderContext;
import com.cedarsoftware.util.io.factory.DateFactory;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public abstract class AbstractTemporalFactory<T extends TemporalAccessor>
implements JsonReader.ClassFactory {
    protected final DateTimeFormatter dateTimeFormatter;
    protected final ZoneId zoneId;

    protected AbstractTemporalFactory(DateTimeFormatter dateFormatter, ZoneId zoneId) {
        this.dateTimeFormatter = dateFormatter;
        this.zoneId = zoneId;
    }

    public T newInstance(Class<?> c, JsonObject jObj, ReaderContext context) {
        Object value = jObj.getValue();
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        if (value instanceof Number) {
            return this.fromNumber((Number)value);
        }
        return this.fromJsonObject(jObj, context);
    }

    protected ZonedDateTime convertToZonedDateTime(String s) {
        Date date = DateFactory.parseDate(s);
        if (date == null) {
            throw new JsonIoException("Could not parse date: " + s);
        }
        return date.toInstant().atZone(this.zoneId);
    }

    protected abstract T fromString(String var1);

    protected T fromNumber(Number l) {
        throw new IllegalArgumentException("Long Timestamps are not supported for this Temporal class");
    }

    protected abstract T fromJsonObject(JsonObject var1, ReaderContext var2);

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

