/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Writers;
import com.cedarsoftware.util.io.writers.DurationWriter;
import com.cedarsoftware.util.io.writers.InstantWriter;
import com.cedarsoftware.util.io.writers.LongWriter;
import com.cedarsoftware.util.io.writers.PeriodWriter;
import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.ClassDescriptors;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WriteOptions {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private boolean shortMetaKeys;
    private ShowType showTypeInfo = ShowType.MINIMAL;
    private Map<Class<?>, JsonWriter.JsonClassWriter> writerCache = new ConcurrentHashMap(300);
    private JsonWriter.JsonClassWriter enumWriter = new Writers.EnumsAsStringWriter();
    private boolean prettyPrint = false;
    private boolean writeLongsAsStrings = false;
    private boolean skipNullFields = false;
    private boolean forceMapOutputAsTwoArrays = false;
    private boolean allowNanAndInfinity = false;
    private boolean enumPublicFieldsOnly = false;
    private ClassLoader classLoader = WriteOptions.class.getClassLoader();
    private Map<Class<?>, Set<String>> includedFields = new ConcurrentHashMap();
    private Map<Class<?>, Set<Accessor>> includedAccessors = new ConcurrentHashMap();
    private Map<Class<?>, Set<String>> excludedFields = new ConcurrentHashMap();
    private Map<Class<?>, Set<Accessor>> excludedAccessors = new ConcurrentHashMap();
    private Map<String, String> aliasTypeNames = new ConcurrentHashMap<String, String>();
    private Set<Class<?>> notCustomWrittenClasses = Collections.synchronizedSet(new LinkedHashSet());
    private Set<Class<?>> nonReferenceableItems = Collections.synchronizedSet(new LinkedHashSet());
    private Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses = new ConcurrentHashMap();
    private static final Map<Class<?>, JsonWriter.JsonClassWriter> BASE_WRITERS = new ConcurrentHashMap();
    private boolean built = false;
    private static final NullClass nullWriter;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public WriteOptions classLoader(ClassLoader classLoader) {
        this.throwIfBuilt();
        this.classLoader = classLoader;
        return this;
    }

    public WriteOptions() {
        this.customWrittenClasses.putAll(BASE_WRITERS);
        this.nonReferenceableItems.add(Byte.TYPE);
        this.nonReferenceableItems.add(Short.TYPE);
        this.nonReferenceableItems.add(Integer.TYPE);
        this.nonReferenceableItems.add(Long.TYPE);
        this.nonReferenceableItems.add(Float.TYPE);
        this.nonReferenceableItems.add(Double.TYPE);
        this.nonReferenceableItems.add(Character.TYPE);
        this.nonReferenceableItems.add(Boolean.TYPE);
        this.nonReferenceableItems.add(Byte.class);
        this.nonReferenceableItems.add(Short.class);
        this.nonReferenceableItems.add(Integer.class);
        this.nonReferenceableItems.add(Long.class);
        this.nonReferenceableItems.add(Float.class);
        this.nonReferenceableItems.add(Double.class);
        this.nonReferenceableItems.add(Character.class);
        this.nonReferenceableItems.add(Boolean.class);
        this.nonReferenceableItems.add(String.class);
        this.nonReferenceableItems.add(java.util.Date.class);
        this.nonReferenceableItems.add(BigInteger.class);
        this.nonReferenceableItems.add(BigDecimal.class);
        this.nonReferenceableItems.add(AtomicBoolean.class);
        this.nonReferenceableItems.add(AtomicInteger.class);
        this.nonReferenceableItems.add(AtomicLong.class);
        this.aliasTypeName("java.lang.Class", "class");
        this.aliasTypeName("java.lang.String", "string");
        this.aliasTypeName("java.util.Date", "date");
        this.aliasTypeName("java.lang.Byte", "byte");
        this.aliasTypeName("java.lang.Short", "short");
        this.aliasTypeName("java.lang.Integer", "int");
        this.aliasTypeName("java.lang.Long", "long");
        this.aliasTypeName("java.lang.Float", "float");
        this.aliasTypeName("java.lang.Double", "double");
        this.aliasTypeName("java.lang.Character", "char");
        this.aliasTypeName("java.lang.Boolean", "boolean");
    }

    public WriteOptions(WriteOptions other) {
        this.shortMetaKeys = other.shortMetaKeys;
        this.showTypeInfo = other.showTypeInfo;
        this.enumWriter = other.enumWriter;
        this.prettyPrint = other.prettyPrint;
        this.writeLongsAsStrings = other.writeLongsAsStrings;
        this.skipNullFields = other.skipNullFields;
        this.allowNanAndInfinity = other.allowNanAndInfinity;
        this.forceMapOutputAsTwoArrays = other.forceMapOutputAsTwoArrays;
        this.enumPublicFieldsOnly = other.enumPublicFieldsOnly;
        this.notCustomWrittenClasses.addAll(other.notCustomWrittenClasses);
        this.aliasTypeNames.putAll(other.aliasTypeNames);
        this.customWrittenClasses.putAll(other.customWrittenClasses);
        this.classLoader = other.classLoader;
        this.nonReferenceableItems.addAll(other.nonReferenceableItems);
        this.writerCache = other.writerCache;
        this.includedFields = WriteOptions.dupe(other.includedFields, false);
        this.includedAccessors = WriteOptions.dupe(other.includedAccessors, false);
        this.excludedFields = WriteOptions.dupe(other.excludedFields, false);
        this.excludedAccessors = WriteOptions.dupe(other.excludedAccessors, false);
    }

    private void throwIfBuilt() {
        if (this.built) {
            throw new JsonIoException("These WriteOptions are sealed and cannot be modified.");
        }
    }

    public boolean isShortMetaKeys() {
        return this.shortMetaKeys;
    }

    public WriteOptions shortMetaKeys(boolean shortMetaKeys) {
        this.throwIfBuilt();
        this.shortMetaKeys = shortMetaKeys;
        return this;
    }

    public String getTypeNameAlias(String typeName) {
        String alias = this.aliasTypeNames.get(typeName);
        return alias == null ? typeName : alias;
    }

    public Map<String, String> aliasTypeNames() {
        return this.built ? this.aliasTypeNames : new LinkedHashMap<String, String>(this.aliasTypeNames);
    }

    public WriteOptions aliasTypeNames(Map<String, String> aliasTypeNames) {
        this.throwIfBuilt();
        this.aliasTypeNames.clear();
        this.aliasTypeNames.putAll(aliasTypeNames);
        return this;
    }

    public WriteOptions aliasTypeName(String typeName, String alias) {
        this.throwIfBuilt();
        this.aliasTypeNames.put(typeName, alias);
        return this;
    }

    public boolean isAlwaysShowingType() {
        return this.showTypeInfo == ShowType.ALWAYS;
    }

    public boolean isNeverShowingType() {
        return this.showTypeInfo == ShowType.NEVER;
    }

    public boolean isMinimalShowingType() {
        return this.showTypeInfo == ShowType.MINIMAL;
    }

    public WriteOptions showTypeInfoAlways() {
        this.throwIfBuilt();
        this.showTypeInfo = ShowType.ALWAYS;
        return this;
    }

    public WriteOptions showTypeInfoNever() {
        this.throwIfBuilt();
        this.showTypeInfo = ShowType.NEVER;
        return this;
    }

    public WriteOptions showTypeInfoMinimal() {
        this.throwIfBuilt();
        this.showTypeInfo = ShowType.MINIMAL;
        return this;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public WriteOptions prettyPrint(boolean prettyPrint) {
        this.throwIfBuilt();
        this.prettyPrint = prettyPrint;
        return this;
    }

    public boolean isWriteLongsAsStrings() {
        return this.writeLongsAsStrings;
    }

    public WriteOptions writeLongsAsStrings(boolean writeLongsAsStrings) {
        this.throwIfBuilt();
        this.writeLongsAsStrings = writeLongsAsStrings;
        return this;
    }

    public boolean isSkipNullFields() {
        return this.skipNullFields;
    }

    public WriteOptions skipNullFields(boolean skipNullFields) {
        this.throwIfBuilt();
        this.skipNullFields = skipNullFields;
        return this;
    }

    public boolean isForceMapOutputAsTwoArrays() {
        return this.forceMapOutputAsTwoArrays;
    }

    public WriteOptions forceMapOutputAsTwoArrays(boolean forceMapOutputAsTwoArrays) {
        this.throwIfBuilt();
        this.forceMapOutputAsTwoArrays = forceMapOutputAsTwoArrays;
        return this;
    }

    public boolean isAllowNanAndInfinity() {
        return this.allowNanAndInfinity;
    }

    public WriteOptions allowNanAndInfinity(boolean allowNanAndInfinity) {
        this.throwIfBuilt();
        this.allowNanAndInfinity = allowNanAndInfinity;
        return this;
    }

    public boolean isWriteEnumAsString() {
        return this.enumWriter instanceof Writers.EnumsAsStringWriter;
    }

    public boolean isEnumPublicFieldsOnly() {
        return this.enumPublicFieldsOnly;
    }

    public WriteOptions writeEnumsAsString() {
        this.throwIfBuilt();
        this.enumWriter = new Writers.EnumsAsStringWriter();
        return this;
    }

    public WriteOptions writeEnumAsJsonObject(boolean writePublicFieldsOnly) {
        this.throwIfBuilt();
        this.enumWriter = nullWriter;
        this.enumPublicFieldsOnly = writePublicFieldsOnly;
        return this;
    }

    public WriteOptions setCustomWrittenClasses(Map<Class<?>, JsonWriter.JsonClassWriter> customWrittenClasses) {
        this.throwIfBuilt();
        this.customWrittenClasses.clear();
        this.customWrittenClasses.putAll(customWrittenClasses);
        return this;
    }

    public WriteOptions addCustomWrittenClass(Class<?> clazz, JsonWriter.JsonClassWriter customWriter) {
        this.throwIfBuilt();
        this.customWrittenClasses.put(clazz, customWriter);
        return this;
    }

    public Map<Class<?>, JsonWriter.JsonClassWriter> getCustomWrittenClasses() {
        return this.built ? this.customWrittenClasses : new LinkedHashMap(this.customWrittenClasses);
    }

    public boolean isCustomWrittenClass(Class<?> clazz) {
        return this.customWrittenClasses.containsKey(clazz);
    }

    public boolean isNotCustomWrittenClass(Class<?> clazz) {
        return this.notCustomWrittenClasses.contains(clazz);
    }

    public Set<Class<?>> getNotCustomWrittenClasses() {
        return this.built ? this.notCustomWrittenClasses : new LinkedHashSet(this.notCustomWrittenClasses);
    }

    public WriteOptions addNotCustomWrittenClass(Class<?> notCustomClass) {
        this.throwIfBuilt();
        this.notCustomWrittenClasses.add(notCustomClass);
        return this;
    }

    public WriteOptions setNotCustomWrittenClasses(Collection<Class<?>> notCustomClasses) {
        this.throwIfBuilt();
        this.notCustomWrittenClasses.clear();
        this.notCustomWrittenClasses.addAll(notCustomClasses);
        return this;
    }

    public Set<String> getIncludedFields(Class<?> clazz) {
        return this.getItemsForClass(clazz, this.includedFields);
    }

    public Set<Accessor> getIncludedAccessors(Class<?> clazz) {
        return this.getItemsForClass(clazz, this.includedAccessors);
    }

    public Map<Class<?>, Set<String>> getIncludedFieldsPerAllClasses() {
        return this.getClassSetMapFields(this.includedFields);
    }

    public Map<Class<?>, Set<Accessor>> getIncludedAccessorsPerAllClasses() {
        if (this.built) {
            return this.includedAccessors;
        }
        LinkedHashMap copy = new LinkedHashMap();
        for (Map.Entry<Class<?>, Set<Accessor>> entry : this.includedAccessors.entrySet()) {
            copy.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
        }
        return copy;
    }

    public WriteOptions addIncludedField(Class<?> clazz, String includedField) {
        this.addIncludedFields(clazz, MetaUtils.setOf(includedField));
        return this;
    }

    public WriteOptions addIncludedFields(Class<?> clazz, Collection<String> includedFields) {
        this.throwIfBuilt();
        this.includedFields.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(includedFields);
        return this.copyFieldsToAccessors(clazz, includedFields, this.includedAccessors);
    }

    public WriteOptions addIncludedFields(Map<Class<?>, Collection<String>> includedFields) {
        this.throwIfBuilt();
        for (Map.Entry<Class<?>, Collection<String>> entry : includedFields.entrySet()) {
            this.addIncludedFields(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private Map<Class<?>, Set<String>> getClassSetMapFields(Map<Class<?>, Set<String>> fieldSet) {
        if (this.built) {
            return fieldSet;
        }
        LinkedHashMap copy = new LinkedHashMap();
        for (Map.Entry<Class<?>, Set<String>> entry : fieldSet.entrySet()) {
            copy.computeIfAbsent(entry.getKey(), k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
        }
        return copy;
    }

    public WriteOptions addExcludedField(Class<?> clazz, String excludedField) {
        this.addExcludedFields(clazz, MetaUtils.setOf(excludedField));
        return this;
    }

    public WriteOptions addExcludedFields(Class<?> clazz, Collection<String> excludedFields) {
        this.throwIfBuilt();
        this.excludedFields.computeIfAbsent(clazz, k -> new LinkedHashSet()).addAll(excludedFields);
        return this.copyFieldsToAccessors(clazz, excludedFields, this.excludedAccessors);
    }

    private WriteOptions copyFieldsToAccessors(Class<?> clazz, Collection<String> fields, Map<Class<?>, Set<Accessor>> accessors) {
        ClassDescriptors classDescriptors = ClassDescriptors.instance();
        Map<String, Accessor> accessorMap = classDescriptors.getDeepAccessorMap(clazz);
        for (Map.Entry<String, Accessor> acessorEntry : accessorMap.entrySet()) {
            if (!fields.contains(acessorEntry.getKey())) continue;
            accessors.computeIfAbsent(clazz, l -> new LinkedHashSet()).add(acessorEntry.getValue());
        }
        return this;
    }

    public WriteOptions addExcludedFields(Map<Class<?>, Collection<String>> excludedFields) {
        this.throwIfBuilt();
        for (Map.Entry<Class<?>, Collection<String>> entry : excludedFields.entrySet()) {
            this.addExcludedFields(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Set<String> getExcludedFields(Class<?> clazz) {
        return this.getItemsForClass(clazz, this.excludedFields);
    }

    public Map<Class<?>, Set<String>> getExcludedFieldsPerAllClasses() {
        return this.getClassSetMapFields(this.excludedFields);
    }

    public Set<Accessor> getExcludedAccessors(Class<?> clazz) {
        return this.getItemsForClass(clazz, this.excludedAccessors);
    }

    private Set<?> getItemsForClass(Class<?> clazz, Map<?, ? extends Set<?>> classesToSets) {
        Set<?> items = classesToSets.get(clazz);
        if (this.built) {
            return items == null ? Collections.unmodifiableSet(new LinkedHashSet()) : items;
        }
        return new LinkedHashSet(items == null ? Collections.emptySet() : items);
    }

    public Collection<Accessor> getIncludedAccessorsForClass(Class<?> c) {
        return WriteOptions.getFilteredAccessors(c, this.includedAccessors);
    }

    public Collection<Accessor> getExcludedAccessorsForClass(Class<?> c) {
        return WriteOptions.getFilteredAccessors(c, this.excludedAccessors);
    }

    private static Collection<Accessor> getFilteredAccessors(Class<?> c, Map<Class<?>, ? extends Collection<Accessor>> accessors) {
        LinkedHashSet<Accessor> accessorSets = new LinkedHashSet<Accessor>();
        for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
            Collection<Accessor> accessorSet = accessors.get(curr);
            if (accessorSet == null) continue;
            accessorSets.addAll(accessorSet);
        }
        return accessorSets;
    }

    public WriteOptions isoDateFormat() {
        return this.dateTimeFormat(ISO_DATE_FORMAT);
    }

    public WriteOptions isoDateTimeFormat() {
        return this.dateTimeFormat(ISO_DATE_TIME_FORMAT);
    }

    public WriteOptions longDateFormat() {
        this.throwIfBuilt();
        this.addCustomWrittenClass(java.util.Date.class, new Writers.DateAsLongWriter());
        return this;
    }

    public boolean isLongDateFormat() {
        JsonWriter.JsonClassWriter a = this.customWrittenClasses.get(java.util.Date.class);
        if (a == null) {
            return false;
        }
        boolean answer = Writers.DateAsLongWriter.class.equals(a.getClass());
        return answer;
    }

    public WriteOptions dateTimeFormat(String format) {
        this.throwIfBuilt();
        this.addCustomWrittenClass(java.util.Date.class, new Writers.DateWriter(format));
        return this;
    }

    public boolean isNonReferenceableClass(Class<?> clazz) {
        return this.nonReferenceableItems.contains(clazz) || Number.class.isAssignableFrom(clazz) || java.util.Date.class.isAssignableFrom(clazz) || clazz.isEnum() || clazz.equals(Class.class);
    }

    public Collection<Class<?>> getNonReferenceableClasses() {
        return this.built ? this.nonReferenceableItems : new LinkedHashSet(this.nonReferenceableItems);
    }

    public WriteOptions addNonReferenceableClass(Class<?> clazz) {
        this.throwIfBuilt();
        this.nonReferenceableItems.add(clazz);
        return this;
    }

    public WriteOptions build() {
        this.includedFields = WriteOptions.dupe(this.includedFields, true);
        this.includedAccessors = WriteOptions.dupe(this.includedAccessors, true);
        this.excludedFields = WriteOptions.dupe(this.excludedFields, true);
        this.excludedAccessors = WriteOptions.dupe(this.excludedAccessors, true);
        this.aliasTypeNames = Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.aliasTypeNames));
        this.notCustomWrittenClasses = Collections.unmodifiableSet(new LinkedHashSet(this.notCustomWrittenClasses));
        this.nonReferenceableItems = Collections.unmodifiableSet(new LinkedHashSet(this.nonReferenceableItems));
        this.customWrittenClasses = Collections.unmodifiableMap(new LinkedHashMap(this.customWrittenClasses));
        this.built = true;
        return this;
    }

    private static Map<Class<?>, ? extends Set<?>> dupe(Map<Class<?>, ? extends Set<?>> other, boolean unmodifiable) {
        LinkedHashMap<Class, Set> newItemsAssocToClass = new LinkedHashMap<Class, Set>();
        for (Map.Entry<Class<?>, Set<?>> entry : other.entrySet()) {
            LinkedHashSet itemsAssocToClass = new LinkedHashSet(entry.getValue());
            if (unmodifiable) {
                newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> Collections.unmodifiableSet(itemsAssocToClass));
                continue;
            }
            newItemsAssocToClass.computeIfAbsent(entry.getKey(), k -> itemsAssocToClass);
        }
        if (unmodifiable) {
            return Collections.unmodifiableMap(newItemsAssocToClass);
        }
        return newItemsAssocToClass;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public JsonWriter.JsonClassWriter getCustomWriter(Class<?> c) {
        JsonWriter.JsonClassWriter writer = this.writerCache.get(c);
        if (writer == null) {
            writer = this.forceGetCustomWriter(c);
            this.writerCache.put(c, writer);
        }
        if (writer != nullWriter) {
            return writer;
        }
        writer = MetaUtils.getClassIfEnum(c).isPresent() ? this.enumWriter : nullWriter;
        this.writerCache.put(c, writer);
        return writer == nullWriter ? null : writer;
    }

    private JsonWriter.JsonClassWriter forceGetCustomWriter(Class<?> c) {
        JsonWriter.JsonClassWriter closestWriter = nullWriter;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry<Class<?>, JsonWriter.JsonClassWriter> entry : this.customWrittenClasses.entrySet()) {
            Class<?> clz = entry.getKey();
            if (clz == c) {
                return entry.getValue();
            }
            int distance = MetaUtils.computeInheritanceDistance(c, clz);
            if (distance == -1 || distance >= minDistance) continue;
            minDistance = distance;
            closestWriter = entry.getValue();
        }
        return closestWriter;
    }

    static {
        LinkedHashMap temp = new LinkedHashMap();
        temp.put(String.class, new Writers.JsonStringWriter());
        temp.put(BigInteger.class, new Writers.BigIntegerWriter());
        temp.put(BigDecimal.class, new Writers.BigDecimalWriter());
        temp.put(Timestamp.class, new Writers.TimestampWriter());
        temp.put(TimeZone.class, new Writers.TimeZoneWriter());
        temp.put(Locale.class, new Writers.LocaleWriter());
        temp.put(Class.class, new Writers.ClassWriter());
        temp.put(UUID.class, new Writers.UUIDWriter());
        Writers.DateAsLongWriter defaultDateWriter = new Writers.DateAsLongWriter();
        temp.put(Date.class, defaultDateWriter);
        temp.put(java.util.Date.class, defaultDateWriter);
        temp.put(LocalDate.class, new Writers.LocalDateWriter());
        temp.put(LocalTime.class, new Writers.LocalTimeWriter());
        temp.put(LocalDateTime.class, new Writers.LocalDateTimeWriter());
        temp.put(ZonedDateTime.class, new Writers.ZonedDateTimeWriter());
        temp.put(OffsetDateTime.class, new Writers.OffsetDateTimeWriter());
        temp.put(YearMonth.class, new Writers.YearMonthWriter());
        temp.put(Year.class, new Writers.YearWriter());
        temp.put(ZoneOffset.class, new Writers.ZoneOffsetWriter());
        temp.put(Instant.class, new InstantWriter());
        temp.put(Duration.class, new DurationWriter());
        temp.put(Period.class, new PeriodWriter());
        Writers.CalendarWriter calendarWriter = new Writers.CalendarWriter();
        temp.put(Calendar.class, calendarWriter);
        temp.put(GregorianCalendar.class, calendarWriter);
        Writers.PrimitiveUtf8StringWriter stringWriter = new Writers.PrimitiveUtf8StringWriter();
        temp.put(StringBuilder.class, stringWriter);
        temp.put(StringBuffer.class, stringWriter);
        temp.put(URL.class, stringWriter);
        temp.put(ZoneOffset.class, stringWriter);
        Writers.CharacterWriter characterWriter = new Writers.CharacterWriter();
        temp.put(Character.class, characterWriter);
        temp.put(Character.TYPE, characterWriter);
        Writers.PrimitiveValueWriter primitiveValueWriter = new Writers.PrimitiveValueWriter();
        temp.put(Byte.TYPE, primitiveValueWriter);
        temp.put(Byte.class, primitiveValueWriter);
        temp.put(Short.TYPE, primitiveValueWriter);
        temp.put(Short.class, primitiveValueWriter);
        temp.put(Integer.TYPE, primitiveValueWriter);
        temp.put(Integer.class, primitiveValueWriter);
        LongWriter longWriter = new LongWriter();
        temp.put(Long.TYPE, longWriter);
        temp.put(Long.class, longWriter);
        temp.put(Boolean.TYPE, primitiveValueWriter);
        temp.put(Boolean.class, primitiveValueWriter);
        Writers.FloatWriter floatWriter = new Writers.FloatWriter();
        temp.put(Float.TYPE, floatWriter);
        temp.put(Float.class, floatWriter);
        Writers.DoubleWriter doubleWriter = new Writers.DoubleWriter();
        temp.put(Double.TYPE, doubleWriter);
        temp.put(Double.class, doubleWriter);
        temp.put(AtomicBoolean.class, primitiveValueWriter);
        temp.put(AtomicInteger.class, primitiveValueWriter);
        temp.put(AtomicLong.class, primitiveValueWriter);
        Class<?> zoneInfoClass = MetaUtils.classForName("sun.util.calendar.ZoneInfo", WriteOptions.class.getClassLoader());
        if (zoneInfoClass != null) {
            temp.put(zoneInfoClass, new Writers.TimeZoneWriter());
        }
        BASE_WRITERS.putAll(temp);
        nullWriter = new NullClass();
    }

    private static final class NullClass
    implements JsonWriter.JsonClassWriter {
        private NullClass() {
        }
    }

    public static enum ShowType {
        ALWAYS,
        NEVER,
        MINIMAL;

    }
}

