/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.ReadOptions;
import com.cedarsoftware.util.io.ReadOptionsBuilder;
import com.cedarsoftware.util.io.WriteOptions;
import java.io.IOException;
import java.io.Writer;

public class JsonIo {
    public static String formatJson(String json, ReadOptions readOptions, WriteOptions writeOptions) {
        if (writeOptions.isBuilt()) {
            writeOptions = new WriteOptions(writeOptions).prettyPrint(true);
        }
        Object object = JsonReader.toObjects(json, readOptions.ensureUsingMaps(), null);
        return JsonWriter.toJson(object, writeOptions.prettyPrint(true));
    }

    public static String formatJson(String json) {
        return JsonIo.formatJson(json, new ReadOptionsBuilder().returnAsMaps().build(), new WriteOptions().prettyPrint(true));
    }

    public static <T> T deepCopy(Object o) {
        return JsonIo.deepCopy(o, new ReadOptionsBuilder().build(), new WriteOptions());
    }

    public static <T> T deepCopy(Object o, ReadOptions readOptions, WriteOptions writeOptions) {
        String json = JsonWriter.toJson(o, writeOptions);
        return JsonReader.toObjects(json, readOptions, null);
    }

    public static void writeBasicString(Writer writer, String s) throws IOException {
        writer.write(34);
        writer.write(s);
        writer.write(34);
    }

    public static void writeJsonUtf8Char(Writer writer, char c) throws IOException {
        writer.write(34);
        JsonIo.writeChar(writer, c);
        writer.write(34);
    }

    private static void writeChar(Writer writer, char c) throws IOException {
        if (c < ' ') {
            switch (c) {
                case '\b': {
                    writer.write("\\b");
                    break;
                }
                case '\f': {
                    writer.write("\\f");
                    break;
                }
                case '\n': {
                    writer.write("\\n");
                    break;
                }
                case '\r': {
                    writer.write("\\r");
                    break;
                }
                case '\t': {
                    writer.write("\\t");
                    break;
                }
                default: {
                    writer.write(String.format("\\u%04X", c));
                    break;
                }
            }
        } else if (c == '\\' || c == '\"') {
            writer.write(92);
            writer.write(c);
        } else {
            writer.write(c);
        }
    }

    public static void writeJsonUtf8String(Writer output, String s) throws IOException {
        output.write(34);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            JsonIo.writeChar(output, s.charAt(i));
        }
        output.write(34);
    }
}

