/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.Readers;
import com.cedarsoftware.util.io.Unsafe;
import com.cedarsoftware.util.io.WriteOptionsBuilder;
import com.cedarsoftware.util.io.factory.DateFactory;
import com.cedarsoftware.util.reflect.Accessor;
import com.cedarsoftware.util.reflect.ClassDescriptor;
import com.cedarsoftware.util.reflect.ClassDescriptors;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaUtils {
    private static final Map<Class<?>, Map<String, Field>> classMetaCache = new ConcurrentHashMap();
    private static final Set<Class<?>> prims = new HashSet();
    private static final Map<String, Class<?>> nameToClass = new HashMap();
    private static final Byte[] byteCache = new Byte[256];
    private static final Pattern extraQuotes = Pattern.compile("^\"*(.*?)\"*$");
    private static final ConcurrentMap<String, CachedConstructor> constructors = new ConcurrentHashMap<String, CachedConstructor>();
    private static final Collection<?> unmodifiableCollection = Collections.unmodifiableCollection(new ArrayList());
    private static final Set<?> unmodifiableSet = Collections.unmodifiableSet(new HashSet());
    private static final SortedSet<?> unmodifiableSortedSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map<?, ?> unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private static final SortedMap<?, ?> unmodifiableSortedMap = Collections.unmodifiableSortedMap(new TreeMap());
    static final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;
    private static final Map<Class<?>, Supplier<Object>> DIRECT_CLASS_MAPPING;
    private static final Map<Class<?>, Supplier<Object>> ASSIGNABLE_CLASS_MAPPING;
    private static final Map<Class<?>, Object> FROM_NULL;

    private MetaUtils() {
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (InvocationTargetException e) {
                useUnsafe = false;
            }
        }
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return Collections.unmodifiableList(new ArrayList());
        }
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return Collections.unmodifiableList(list);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        if (items == null || items.length == 0) {
            return unmodifiableSet;
        }
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, items);
        return set;
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.unmodifiableMap(new LinkedHashMap());
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k, v);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static Field getField(Class<?> c, String field) {
        return MetaUtils.getDeepDeclaredFields(c).get(field);
    }

    public static Map<String, Field> getDeepDeclaredFields(Class<?> c) {
        Map<String, Field> classFields = classMetaCache.get(c);
        if (classFields != null) {
            return classFields;
        }
        classFields = new LinkedHashMap<String, Field>();
        for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
            Field[] local;
            for (Field field : local = curr.getDeclaredFields()) {
                String fieldName;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || "metaClass".equals(fieldName = field.getName()) && "groovy.lang.MetaClass".equals(field.getType().getName()) || field.getDeclaringClass().isAssignableFrom(Enum.class) && ("hash".equals(fieldName) || "ordinal".equals(fieldName) || "internal".equals(fieldName))) continue;
                if (classFields.containsKey(fieldName)) {
                    classFields.put(curr.getSimpleName() + '.' + fieldName, field);
                } else {
                    classFields.put(fieldName, field);
                }
                if (Modifier.isPublic(modifiers) && Modifier.isPublic(field.getDeclaringClass().getModifiers())) continue;
                MetaUtils.trySetAccessible(field);
            }
        }
        classMetaCache.put(c, classFields);
        return new LinkedHashMap<String, Field>(classFields);
    }

    public static int comparePrimitiveToWrapper(Class<?> source, Class<?> destination) {
        try {
            return source.getField("TYPE").get(null).equals(destination) ? 0 : -1;
        }
        catch (Exception e) {
            throw new JsonIoException("Error while attempting comparison of primitive types: " + source.getName() + " vs " + destination.getName(), e);
        }
    }

    public static int computeInheritanceDistance(Class<?> source, Class<?> destination) {
        if (source == null || destination == null) {
            return -1;
        }
        if (source.equals(destination)) {
            return 0;
        }
        if (source.isPrimitive()) {
            if (destination.isPrimitive()) {
                return -1;
            }
            if (!MetaUtils.isPrimitive(destination)) {
                return -1;
            }
            return MetaUtils.comparePrimitiveToWrapper(destination, source);
        }
        if (destination.isPrimitive()) {
            if (!MetaUtils.isPrimitive(source)) {
                return -1;
            }
            return MetaUtils.comparePrimitiveToWrapper(source, destination);
        }
        LinkedList queue = new LinkedList();
        HashSet visited = new HashSet();
        queue.add(source);
        visited.add(source);
        int distance = 0;
        while (!queue.isEmpty()) {
            int levelSize = queue.size();
            ++distance;
            for (int i = 0; i < levelSize; ++i) {
                Class current = (Class)queue.poll();
                if (current.getSuperclass() != null) {
                    if (current.getSuperclass().equals(destination)) {
                        return distance;
                    }
                    if (!visited.contains(current.getSuperclass())) {
                        queue.add(current.getSuperclass());
                        visited.add(current.getSuperclass());
                    }
                }
                for (Class<?> interfaceClass : current.getInterfaces()) {
                    if (interfaceClass.equals(destination)) {
                        return distance;
                    }
                    if (visited.contains(interfaceClass)) continue;
                    queue.add(interfaceClass);
                    visited.add(interfaceClass);
                }
            }
        }
        return -1;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c);
    }

    public static boolean isLogicalPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || java.util.Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    public static Optional<Class> getClassIfEnum(Class<?> c) {
        if (c.isEnum()) {
            return Optional.of(c);
        }
        if (!Enum.class.isAssignableFrom(c)) {
            return Optional.empty();
        }
        Class<?> enclosingClass = c.getEnclosingClass();
        return enclosingClass != null && enclosingClass.isEnum() ? Optional.of(enclosingClass) : Optional.empty();
    }

    public static Class<?> classForName(String name, ClassLoader classLoader) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            Class<?> c = nameToClass.get(name);
            if (c != null) {
                return c;
            }
            c = MetaUtils.loadClass(name, classLoader);
            nameToClass.put(name, c);
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<Object> currentClass = null;
        if (null == primitiveArray) {
            try {
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        if (arrayType) {
            Class clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    static String removeLeadingAndTrailingQuotes(String input) {
        Matcher m = extraQuotes.matcher(input);
        if (m.find()) {
            input = m.group(1);
        }
        return input;
    }

    static void throwIfSecurityConcern(Class<?> securityConcern, Class<?> c) {
        if (securityConcern.isAssignableFrom(c)) {
            throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: " + securityConcern.getName());
        }
    }

    static Object getArgForType(Class<?> argType) {
        if (argType.isPrimitive() || prims.contains(argType)) {
            return MetaUtils.convert(argType, null);
        }
        Supplier<Object> directClassMapping = DIRECT_CLASS_MAPPING.get(argType);
        if (directClassMapping != null) {
            return directClassMapping.get();
        }
        for (Map.Entry<Class<?>, Supplier<Object>> entry : ASSIGNABLE_CLASS_MAPPING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(argType)) continue;
            return entry.getValue().get();
        }
        if (argType.isArray()) {
            return Array.newInstance(argType.getComponentType(), 0);
        }
        return null;
    }

    public static List<Object> matchArgumentsToParameters(Collection<Object> values, Parameter[] parameterTypes, boolean useNull) {
        ArrayList<Object> answer = new ArrayList<Object>();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return answer;
        }
        ArrayList<Object> copyValues = new ArrayList<Object>(values);
        for (Parameter parameter : parameterTypes) {
            Class<?> paramType = parameter.getType();
            Object value = MetaUtils.pickBestValue(paramType, copyValues);
            if (value == null) {
                value = useNull ? (paramType.isPrimitive() ? MetaUtils.convert(paramType, null) : null) : MetaUtils.getArgForType(paramType);
            }
            answer.add(value);
        }
        return answer;
    }

    private static Object pickBestValue(Class<?> param, List<Object> values) {
        int[] distances = new int[values.size()];
        int i = 0;
        for (Object value : values) {
            distances[i++] = value == null ? -1 : MetaUtils.computeInheritanceDistance(value.getClass(), param);
        }
        int index = MetaUtils.indexOfBestValue(distances);
        if (index >= 0) {
            Object valueBestMatching = values.get(index);
            values.remove(index);
            return valueBestMatching;
        }
        return null;
    }

    public static int indexOfBestValue(int[] array) {
        if (array == null || array.length == 0) {
            return -1;
        }
        int minValue = Integer.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < minValue & array[i] > -1)) continue;
            minValue = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static String createCacheKey(Class<?> c, Collection<?> args) {
        StringBuilder s = new StringBuilder(c.getName());
        for (Object o : args) {
            if (o == null) {
                s.append(":null");
                continue;
            }
            s.append(':');
            s.append(o.getClass().getSimpleName());
        }
        return s.toString();
    }

    public static Object newInstance(Class<?> c, Collection<?> argumentValues) {
        block20: {
            String cacheKey;
            CachedConstructor cachedConstructor;
            MetaUtils.throwIfSecurityConcern(ProcessBuilder.class, c);
            MetaUtils.throwIfSecurityConcern(Process.class, c);
            MetaUtils.throwIfSecurityConcern(ClassLoader.class, c);
            MetaUtils.throwIfSecurityConcern(Constructor.class, c);
            MetaUtils.throwIfSecurityConcern(Method.class, c);
            MetaUtils.throwIfSecurityConcern(Field.class, c);
            if (c.getName().equals("java.lang.ProcessImpl")) {
                throw new IllegalArgumentException("For security reasons, json-io does not allow instantiation of: java.lang.ProcessImpl");
            }
            if (argumentValues == null) {
                argumentValues = new ArrayList();
            }
            if ((cachedConstructor = (CachedConstructor)constructors.get(cacheKey = MetaUtils.createCacheKey(c, argumentValues))) == null) {
                if (unmodifiableSortedMap.getClass().isAssignableFrom(c)) {
                    return new TreeMap();
                }
                if (unmodifiableMap.getClass().isAssignableFrom(c)) {
                    return new LinkedHashMap();
                }
                if (unmodifiableSortedSet.getClass().isAssignableFrom(c)) {
                    return new TreeSet();
                }
                if (unmodifiableSet.getClass().isAssignableFrom(c)) {
                    return new LinkedHashSet();
                }
                if (unmodifiableCollection.getClass().isAssignableFrom(c)) {
                    return new ArrayList();
                }
                if (Collections.EMPTY_LIST.getClass().equals(c)) {
                    return Collections.emptyList();
                }
                if (c.isInterface()) {
                    throw new JsonIoException("Cannot instantiate unknown interface: " + c.getName());
                }
                Constructor<?>[] declaredConstructors = c.getDeclaredConstructors();
                TreeSet<ConstructorWithValues> constructorOrder = new TreeSet<ConstructorWithValues>();
                ArrayList<Object> argValues = new ArrayList<Object>(argumentValues);
                for (Constructor<?> constructor : declaredConstructors) {
                    Parameter[] parameters = constructor.getParameters();
                    List<Object> argumentsNull = MetaUtils.matchArgumentsToParameters(argValues, parameters, true);
                    List<Object> argumentsNonNull = MetaUtils.matchArgumentsToParameters(argValues, parameters, false);
                    constructorOrder.add(new ConstructorWithValues(constructor, argumentsNull.toArray(), argumentsNonNull.toArray()));
                }
                for (ConstructorWithValues constructorWithValues : constructorOrder) {
                    Constructor<?> constructor = constructorWithValues.constructor;
                    try {
                        MetaUtils.trySetAccessible(constructor);
                        Object o = constructor.newInstance(constructorWithValues.argsNull);
                        constructors.put(cacheKey, new CachedConstructor(constructor, true));
                        return o;
                    }
                    catch (Exception ignore) {
                        try {
                            if (constructor.getParameterCount() <= 0) continue;
                            Object o = constructor.newInstance(constructorWithValues.argsNonNull);
                            constructors.put(cacheKey, new CachedConstructor(constructor, false));
                            return o;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                Object o = MetaUtils.tryUnsafeInstantiation(c);
                if (o != null) {
                    return o;
                }
            } else {
                ArrayList<Object> argValues = new ArrayList<Object>(argumentValues);
                Parameter[] parameters = cachedConstructor.constructor.getParameters();
                List<Object> arguments = MetaUtils.matchArgumentsToParameters(argValues, parameters, cachedConstructor.useNullSetting);
                try {
                    Object o = cachedConstructor.constructor.newInstance(arguments.toArray());
                    return o;
                }
                catch (Exception o) {
                    Object o2 = MetaUtils.tryUnsafeInstantiation(c);
                    if (o2 == null) break block20;
                    return o2;
                }
            }
        }
        throw new JsonIoException("Unable to instantiate: " + c.getName());
    }

    private static Object tryUnsafeInstantiation(Class<?> c) {
        if (useUnsafe) {
            try {
                Object o = unsafe.allocateInstance(c);
                return o;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static Object convert(Class<?> c, Object rhs) {
        try {
            if (rhs == null) {
                return FROM_NULL.get(c);
            }
            if (c == Boolean.TYPE || c == Boolean.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "false";
                    }
                    return Boolean.parseBoolean((String)rhs);
                }
                return rhs;
            }
            if (c == Byte.TYPE || c == Byte.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Byte.parseByte((String)rhs);
                }
                return byteCache[((Number)rhs).byteValue() + 128];
            }
            if (c == Character.TYPE || c == Character.class) {
                if (rhs instanceof String) {
                    if (rhs.equals("\"")) {
                        return Character.valueOf('\"');
                    }
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "\u0000";
                    }
                    return Character.valueOf(((CharSequence)rhs).charAt(0));
                }
                if (rhs instanceof Character) {
                    return rhs;
                }
            } else {
                if (c == Double.TYPE || c == Double.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0";
                        }
                        return Double.parseDouble((String)rhs);
                    }
                    return ((Number)rhs).doubleValue();
                }
                if (c == Float.TYPE || c == Float.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0f";
                        }
                        return Float.valueOf(Float.parseFloat((String)rhs));
                    }
                    return Float.valueOf(((Number)rhs).floatValue());
                }
                if (c == Integer.TYPE || c == Integer.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Integer.parseInt((String)rhs);
                    }
                    return ((Number)rhs).intValue();
                }
                if (c == Long.TYPE || c == Long.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Long.parseLong((String)rhs);
                    }
                    return ((Number)rhs).longValue();
                }
                if (c == Short.TYPE || c == Short.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Short.parseShort((String)rhs);
                    }
                    return ((Number)rhs).shortValue();
                }
                if (c == java.util.Date.class) {
                    if (rhs instanceof String) {
                        return DateFactory.parseDate((String)rhs);
                    }
                    if (rhs instanceof Long) {
                        return new java.util.Date((Long)rhs);
                    }
                    return new java.util.Date();
                }
                if (c == BigInteger.class) {
                    return Readers.bigIntegerFrom(rhs);
                }
                if (c == BigDecimal.class) {
                    return Readers.bigDecimalFrom(rhs);
                }
            }
        }
        catch (Exception e) {
            String className = c == null ? "null" : c.getName();
            throw new JsonIoException("Error creating primitive wrapper instance for Class: " + className, e);
        }
        throw new JsonIoException("Class '" + c.getName() + "' does not have primitive wrapper.");
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        for (Object arg : args) {
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
        }
        String result = sb.toString().trim();
        return result + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        String arg = JsonWriter.toJson(obj, new WriteOptionsBuilder().withShortMetaKeys().neverShowTypeInfo().build());
        if (arg.length() > argCharLen) {
            arg = arg.substring(0, argCharLen) + "...";
        }
        return arg;
    }

    public static Map<Class<?>, Collection<Accessor>> convertStringFieldNamesToAccessors(Map<Class<?>, Collection<String>> map) {
        HashMap copy = new HashMap();
        if (map == null) {
            return copy;
        }
        for (Map.Entry<Class<?>, Collection<String>> entry : map.entrySet()) {
            Class<?> c = entry.getKey();
            Collection<String> fields = entry.getValue();
            for (Class<?> current = c; current != null; current = current.getSuperclass()) {
                ClassDescriptor descriptor = ClassDescriptors.instance().getClassDescriptor(current);
                Map<String, Accessor> accessorMap = descriptor.getAccessors();
                for (Map.Entry<String, Accessor> acessorEntry : accessorMap.entrySet()) {
                    if (!fields.contains(acessorEntry.getKey())) continue;
                    Collection list = copy.computeIfAbsent(c, l -> new LinkedHashSet());
                    list.add(acessorEntry.getValue());
                }
            }
        }
        return copy;
    }

    public static <K, V> V getValue(Map map, K key) {
        return map.get(key);
    }

    public static <K, V> V getValueWithDefaultForNull(Map map, K key, V defaultValue) {
        Object value = map.get(key);
        return value == null ? defaultValue : value;
    }

    public static <K, V> V getValueWithDefaultForMissing(Map map, K key, V defaultValue) {
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            if (instance == null) {
                throw new JsonIoException("Attempting to set field: " + field.getName() + " on null object.");
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new JsonIoException("Cannot set field: " + field.getName() + " on class: " + instance.getClass().getName() + " as field is not accessible.  Add a ClassFactory implementation to create the needed class, and use JsonReader.assignInstantiator() to associate your ClassFactory to the class: " + instance.getClass().getName(), e);
        }
    }

    public static void trySetAccessible(AccessibleObject object) {
        if (object.isAccessible()) {
            return;
        }
        MetaUtils.safelyIgnoreException(() -> object.setAccessible(true));
    }

    public static <T> T safelyIgnoreException(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static void safelyIgnoreException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        DIRECT_CLASS_MAPPING = new HashMap();
        ASSIGNABLE_CLASS_MAPPING = new LinkedHashMap();
        FROM_NULL = new LinkedHashMap();
        DIRECT_CLASS_MAPPING.put(java.util.Date.class, java.util.Date::new);
        DIRECT_CLASS_MAPPING.put(StringBuilder.class, StringBuilder::new);
        DIRECT_CLASS_MAPPING.put(StringBuffer.class, StringBuffer::new);
        DIRECT_CLASS_MAPPING.put(Locale.class, Locale::getDefault);
        DIRECT_CLASS_MAPPING.put(TimeZone.class, TimeZone::getDefault);
        DIRECT_CLASS_MAPPING.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(Date.class, () -> new Date(System.currentTimeMillis()));
        DIRECT_CLASS_MAPPING.put(LocalDate.class, LocalDate::now);
        DIRECT_CLASS_MAPPING.put(LocalDateTime.class, LocalDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZonedDateTime.class, ZonedDateTime::now);
        DIRECT_CLASS_MAPPING.put(ZoneId.class, ZoneId::systemDefault);
        DIRECT_CLASS_MAPPING.put(AtomicBoolean.class, AtomicBoolean::new);
        DIRECT_CLASS_MAPPING.put(AtomicInteger.class, AtomicInteger::new);
        DIRECT_CLASS_MAPPING.put(AtomicLong.class, AtomicLong::new);
        DIRECT_CLASS_MAPPING.put(URL.class, () -> MetaUtils.safelyIgnoreException(() -> new URL("http://localhost"), null));
        DIRECT_CLASS_MAPPING.put(Object.class, Object::new);
        DIRECT_CLASS_MAPPING.put(String.class, () -> "");
        DIRECT_CLASS_MAPPING.put(BigInteger.class, () -> BigInteger.ZERO);
        DIRECT_CLASS_MAPPING.put(BigDecimal.class, () -> BigDecimal.ZERO);
        DIRECT_CLASS_MAPPING.put(Class.class, () -> String.class);
        DIRECT_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        DIRECT_CLASS_MAPPING.put(Instant.class, Instant::now);
        ASSIGNABLE_CLASS_MAPPING.put(EnumSet.class, () -> null);
        ASSIGNABLE_CLASS_MAPPING.put(List.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedSet.class, TreeSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(Set.class, LinkedHashSet::new);
        ASSIGNABLE_CLASS_MAPPING.put(SortedMap.class, TreeMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Map.class, LinkedHashMap::new);
        ASSIGNABLE_CLASS_MAPPING.put(Collection.class, ArrayList::new);
        ASSIGNABLE_CLASS_MAPPING.put(Calendar.class, Calendar::getInstance);
        ASSIGNABLE_CLASS_MAPPING.put(LinkedHashSet.class, LinkedHashSet::new);
        FROM_NULL.put(Boolean.class, false);
        FROM_NULL.put(Boolean.TYPE, false);
        FROM_NULL.put(Byte.TYPE, (byte)0);
        FROM_NULL.put(Byte.class, (byte)0);
        FROM_NULL.put(Short.TYPE, (short)0);
        FROM_NULL.put(Short.class, Short.TYPE);
        FROM_NULL.put(Integer.TYPE, 0);
        FROM_NULL.put(Integer.class, 0);
        FROM_NULL.put(Long.TYPE, 0L);
        FROM_NULL.put(Long.class, 0L);
        FROM_NULL.put(Double.TYPE, 0.0);
        FROM_NULL.put(Double.class, 0.0);
        FROM_NULL.put(Float.TYPE, Float.valueOf(0.0f));
        FROM_NULL.put(Float.class, Float.valueOf(0.0f));
        FROM_NULL.put(Character.TYPE, Character.valueOf('\u0000'));
        FROM_NULL.put(Character.class, Character.valueOf('\u0000'));
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("string", String.class);
        nameToClass.put("date", java.util.Date.class);
        nameToClass.put("class", Class.class);
        for (int i = 0; i < byteCache.length; ++i) {
            MetaUtils.byteCache[i] = (byte)(i - 128);
        }
    }

    private static class CachedConstructor {
        private final Constructor<?> constructor;
        private final boolean useNullSetting;

        CachedConstructor(Constructor<?> constructor, boolean useNullSetting) {
            this.constructor = constructor;
            this.useNullSetting = useNullSetting;
        }
    }

    private static class ConstructorWithValues
    implements Comparable<ConstructorWithValues> {
        final Constructor<?> constructor;
        final Object[] argsNull;
        final Object[] argsNonNull;

        ConstructorWithValues(Constructor<?> constructor, Object[] argsNull, Object[] argsNonNull) {
            this.constructor = constructor;
            this.argsNull = argsNull;
            this.argsNonNull = argsNonNull;
        }

        @Override
        public int compareTo(ConstructorWithValues other) {
            long score2;
            int mods = this.constructor.getModifiers();
            int otherMods = other.constructor.getModifiers();
            if (!Modifier.isPublic(mods) && Modifier.isPublic(otherMods)) {
                return 1;
            }
            if (Modifier.isPublic(mods) && !Modifier.isPublic(otherMods)) {
                return -1;
            }
            if (!Modifier.isProtected(mods) && Modifier.isProtected(otherMods)) {
                return 1;
            }
            if (Modifier.isProtected(mods) && !Modifier.isProtected(otherMods)) {
                return -1;
            }
            long score1 = this.scoreArgumentValues(this.argsNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            score1 = this.scoreArgumentValues(this.argsNonNull);
            if (score1 < (score2 = this.scoreArgumentValues(other.argsNonNull))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            String params1 = this.buildParameterTypeString(this.constructor);
            String params2 = this.buildParameterTypeString(other.constructor);
            return params1.compareTo(params2);
        }

        private long scoreArgumentValues(Object[] args) {
            if (args.length == 0) {
                return 0L;
            }
            int nonNull = 0;
            for (Object arg : args) {
                if (arg == null) continue;
                ++nonNull;
            }
            return (long)nonNull * 100L + (long)args.length * 50L;
        }

        private String buildParameterTypeString(Constructor<?> constructor) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            StringBuilder s = new StringBuilder();
            for (Class<?> paramType : paramTypes) {
                s.append(paramType.getName()).append(".");
            }
            return s.toString();
        }
    }

    static enum Dumpty {

    }
}

