/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io.factory;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public abstract class AbstractTemporalFactory<T extends TemporalAccessor>
implements JsonReader.ClassFactory {
    protected final DateTimeFormatter dateTimeFormatter;

    protected AbstractTemporalFactory(DateTimeFormatter dateFormatter) {
        this.dateTimeFormatter = dateFormatter;
    }

    public T newInstance(Class<?> c, JsonObject jObj) {
        Object value = jObj.getValue();
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        if (value instanceof Number) {
            return this.fromNumber((Number)value);
        }
        return this.fromJsonObject(jObj);
    }

    protected abstract T fromString(String var1);

    protected T fromNumber(Number l) {
        throw new IllegalArgumentException("Long Timestamps are not supported for this Temporal class");
    }

    protected abstract T fromJsonObject(JsonObject var1);

    @Override
    public boolean isObjectFinal() {
        return true;
    }
}

