/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Resolver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ObjectResolver
extends Resolver {
    protected ObjectResolver(JsonReader reader) {
        super(reader);
    }

    @Override
    protected void traverseFields(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Object special = this.readIfMatching(jsonObj, null, stack);
        if (special != null) {
            jsonObj.target = special;
            return;
        }
        Object javaMate = jsonObj.target;
        Iterator i = jsonObj.entrySet().iterator();
        Class<?> cls = javaMate.getClass();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            Field field = MetaUtils.getField(cls, key);
            Object rhs = e.getValue();
            if (field == null) continue;
            this.assignField(stack, jsonObj, field, rhs);
        }
        jsonObj.clear();
    }

    protected void assignField(Deque<JsonObject<String, Object>> stack, JsonObject jsonObj, Field field, Object rhs) {
        Object target = jsonObj.target;
        try {
            JsonObject jObj;
            Class<?> fieldType = field.getType();
            if (rhs == null) {
                if (fieldType.isPrimitive()) {
                    field.set(target, MetaUtils.newPrimitiveWrapper(fieldType, "0"));
                } else {
                    field.set(target, null);
                }
                return;
            }
            if (rhs instanceof JsonObject) {
                if (field.getGenericType() instanceof ParameterizedType) {
                    ObjectResolver.markUntypedObjects(field.getGenericType(), rhs, MetaUtils.getDeepDeclaredFields(fieldType));
                }
                JsonObject job = (JsonObject)rhs;
                String type = job.type;
                if (type == null || type.isEmpty()) {
                    job.setType(fieldType.getName());
                }
            }
            if (rhs == "~!o~") {
                jObj = new JsonObject();
                jObj.type = fieldType.getName();
                Object value = this.createJavaObjectInstance(fieldType, jObj);
                field.set(target, value);
            } else {
                Object special = this.readIfMatching(rhs, fieldType, stack);
                if (special != null) {
                    field.set(target, special);
                } else if (rhs.getClass().isArray()) {
                    Object[] elements = (Object[])rhs;
                    JsonObject<String, Object[]> jsonArray = new JsonObject<String, Object[]>();
                    if (char[].class == fieldType) {
                        if (elements.length == 0) {
                            field.set(target, new char[0]);
                        } else {
                            field.set(target, ((String)elements[0]).toCharArray());
                        }
                    } else {
                        jsonArray.put("@items", elements);
                        this.createJavaObjectInstance(fieldType, jsonArray);
                        field.set(target, jsonArray.target);
                        stack.addFirst(jsonArray);
                    }
                } else if (rhs instanceof JsonObject) {
                    jObj = (JsonObject)rhs;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            field.set(target, refObject.target);
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, field.getName(), (long)ref));
                        }
                    } else {
                        field.set(target, this.createJavaObjectInstance(fieldType, jObj));
                        if (!MetaUtils.isLogicalPrimitive(jObj.getTargetClass())) {
                            stack.addFirst((JsonObject)rhs);
                        }
                    }
                } else if (MetaUtils.isPrimitive(fieldType)) {
                    field.set(target, MetaUtils.newPrimitiveWrapper(fieldType, rhs));
                } else if (rhs instanceof String && "".equals(((String)rhs).trim()) && fieldType != String.class) {
                    field.set(target, null);
                } else {
                    field.set(target, rhs);
                }
            }
        }
        catch (Exception e) {
            throw new JsonIoException(String.valueOf(e.getClass().getSimpleName()) + " setting field '" + field.getName() + "' on target: " + ObjectResolver.safeToString(target) + " with value: " + rhs, e);
        }
    }

    private static String safeToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception exception) {
            return o.getClass().toString();
        }
    }

    @Override
    protected void traverseCollection(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        Collection col = (Collection)jsonObj.target;
        boolean isList = col instanceof List;
        int idx = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == null) {
                col.add(null);
            } else if (element == "~!o~") {
                col.add(new JsonObject());
            } else {
                JsonObject<String, Object> jObj;
                Object special = this.readIfMatching(element, null, stack);
                if (special != null) {
                    col.add(special);
                } else if (element instanceof String || element instanceof Boolean || element instanceof Double || element instanceof Long) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    jObj = new JsonObject<String, Object>();
                    jObj.put("@items", element);
                    this.createJavaObjectInstance(Object.class, jObj);
                    col.add(jObj.target);
                    this.convertMapsToObjects(jObj);
                } else {
                    jObj = (JsonObject<String, Object>)element;
                    Long ref = (Long)jObj.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            col.add(refObject.target);
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, idx, (long)ref));
                            if (isList) {
                                col.add(null);
                            }
                        }
                    } else {
                        this.createJavaObjectInstance(Object.class, jObj);
                        if (!MetaUtils.isLogicalPrimitive(jObj.getTargetClass())) {
                            this.convertMapsToObjects(jObj);
                        }
                        col.add(jObj.target);
                    }
                }
            }
            ++idx;
            ++n2;
        }
        jsonObj.remove("@items");
    }

    @Override
    protected void traverseArray(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        int len = jsonObj.getLength();
        if (len == 0) {
            return;
        }
        Class compType = jsonObj.getComponentType();
        if (Character.TYPE == compType) {
            return;
        }
        if (Byte.TYPE == compType) {
            jsonObj.moveBytesToMate();
            jsonObj.clearArray();
            return;
        }
        boolean isPrimitive = MetaUtils.isPrimitive(compType);
        Object array = jsonObj.target;
        Object[] items = jsonObj.getArray();
        int i = 0;
        while (i < len) {
            Object element = items[i];
            if (element == null) {
                Array.set(array, i, null);
            } else if (element == "~!o~") {
                Object arrayElement = this.createJavaObjectInstance(compType, new JsonObject());
                Array.set(array, i, arrayElement);
            } else {
                JsonObject<String, Object> jsonObject;
                Object special = this.readIfMatching(element, compType, stack);
                if (special != null) {
                    Array.set(array, i, special);
                } else if (isPrimitive) {
                    Array.set(array, i, MetaUtils.newPrimitiveWrapper(compType, element));
                } else if (element.getClass().isArray()) {
                    if (char[].class == compType) {
                        Object[] jsonArray = (Object[])element;
                        if (jsonArray.length == 0) {
                            Array.set(array, i, new char[0]);
                        } else {
                            String value = (String)jsonArray[0];
                            int numChars = value.length();
                            char[] chars = new char[numChars];
                            int j = 0;
                            while (j < numChars) {
                                chars[j] = value.charAt(j);
                                ++j;
                            }
                            Array.set(array, i, chars);
                        }
                    } else {
                        jsonObject = new JsonObject<String, Object>();
                        jsonObject.put("@items", element);
                        Array.set(array, i, this.createJavaObjectInstance(compType, jsonObject));
                        stack.addFirst(jsonObject);
                    }
                } else if (element instanceof JsonObject) {
                    jsonObject = (JsonObject<String, Object>)element;
                    Long ref = (Long)jsonObject.get("@ref");
                    if (ref != null) {
                        JsonObject refObject = this.getReferencedObj(ref);
                        if (refObject.target != null) {
                            Array.set(array, i, refObject.target);
                        } else {
                            this.unresolvedRefs.add(new Resolver.UnresolvedReference(jsonObj, i, (long)ref));
                        }
                    } else {
                        Object arrayElement = this.createJavaObjectInstance(compType, jsonObject);
                        Array.set(array, i, arrayElement);
                        if (!MetaUtils.isLogicalPrimitive(arrayElement.getClass())) {
                            stack.addFirst(jsonObject);
                        }
                    }
                } else if (element instanceof String && "".equals(((String)element).trim()) && compType != String.class && compType != Object.class) {
                    Array.set(array, i, null);
                } else {
                    Array.set(array, i, element);
                }
            }
            ++i;
        }
        jsonObj.clearArray();
    }

    protected Object readIfMatching(Object o, Class compType, Deque<JsonObject<String, Object>> stack) {
        Class c;
        boolean needsType;
        boolean isJsonObject;
        block15: {
            if (o == null) {
                throw new JsonIoException("Bug in json-io, null must be checked before calling this method.");
            }
            if (compType != null && this.notCustom(compType)) {
                return null;
            }
            isJsonObject = o instanceof JsonObject;
            if (!isJsonObject && compType == null) {
                return null;
            }
            needsType = false;
            if (isJsonObject) {
                JsonObject jObj = (JsonObject)o;
                if (jObj.isReference()) {
                    return null;
                }
                if (jObj.target == null) {
                    String typeStr = null;
                    try {
                        String type = jObj.type;
                        if (type != null) {
                            typeStr = type;
                            c = MetaUtils.classForName(type);
                            break block15;
                        }
                        if (compType != null) {
                            c = compType;
                            needsType = true;
                            break block15;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new JsonIoException("Class listed in @type [" + typeStr + "] is not found", e);
                    }
                }
                c = jObj.target.getClass();
            } else {
                c = compType;
            }
        }
        if (this.notCustom(c)) {
            return null;
        }
        JsonReader.JsonClassReaderBase closestReader = this.getCustomReader(c);
        if (closestReader == null) {
            return null;
        }
        if (needsType && isJsonObject) {
            ((JsonObject)o).setType(c.getName());
        }
        Object read = closestReader instanceof JsonReader.JsonClassReaderEx ? ((JsonReader.JsonClassReaderEx)closestReader).read(o, stack, this.getReader().getArgs()) : ((JsonReader.JsonClassReader)closestReader).read(o, stack);
        if (isJsonObject) {
            ((JsonObject)o).setTarget(read);
        }
        return read;
    }

    private static void markUntypedObjects(Type type, Object rhs, Map<String, Field> classFields) {
        ArrayDeque<Object[]> stack = new ArrayDeque<Object[]>();
        stack.addFirst(new Object[]{type, rhs});
        while (!stack.isEmpty()) {
            Object[] item = (Object[])stack.removeFirst();
            Type t = (Type)item[0];
            Object instance = item[1];
            if (t instanceof ParameterizedType) {
                JsonObject jObj;
                Class clazz = ObjectResolver.getRawType(t);
                ParameterizedType pType = (ParameterizedType)t;
                Type[] typeArgs = pType.getActualTypeArguments();
                if (typeArgs == null || typeArgs.length < 1 || clazz == null) continue;
                ObjectResolver.stampTypeOnJsonObject(instance, t);
                if (Map.class.isAssignableFrom(clazz)) {
                    Map map = (Map)instance;
                    if (!map.containsKey("@keys") && !map.containsKey("@items") && map instanceof JsonObject) {
                        ObjectResolver.convertMapToKeysItems((JsonObject)map);
                    }
                    Object[] keys = (Object[])map.get("@keys");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, keys, typeArgs[0]);
                    Object[] items = (Object[])map.get("@items");
                    ObjectResolver.getTemplateTraverseWorkItem(stack, items, typeArgs[1]);
                    continue;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    Object[] array;
                    if (instance instanceof Object[]) {
                        Object[] array2 = (Object[])instance;
                        int i = 0;
                        while (i < array2.length) {
                            Object vals = array2[i];
                            stack.addFirst(new Object[]{t, vals});
                            if (vals instanceof JsonObject) {
                                stack.addFirst(new Object[]{t, vals});
                            } else if (vals instanceof Object[]) {
                                JsonObject<String, Object[]> coll = new JsonObject<String, Object[]>();
                                coll.type = clazz.getName();
                                List<Object> items = Arrays.asList((Object[])vals);
                                coll.put("@items", items.toArray());
                                stack.addFirst(new Object[]{t, items});
                                array2[i] = coll;
                            } else {
                                stack.addFirst(new Object[]{t, vals});
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (instance instanceof Collection) {
                        Collection col = (Collection)instance;
                        for (Object o : col) {
                            stack.addFirst(new Object[]{typeArgs[0], o});
                        }
                        continue;
                    }
                    if (!(instance instanceof JsonObject) || (array = (jObj = (JsonObject)instance).getArray()) == null) continue;
                    Object[] objectArray = array;
                    int items = array.length;
                    int coll = 0;
                    while (coll < items) {
                        Object o = objectArray[coll];
                        stack.addFirst(new Object[]{typeArgs[0], o});
                        ++coll;
                    }
                    continue;
                }
                if (!(instance instanceof JsonObject)) continue;
                jObj = (JsonObject)instance;
                for (Map.Entry entry : jObj.entrySet()) {
                    Field field;
                    String fieldName = (String)entry.getKey();
                    if (fieldName.startsWith("this$") || (field = classFields.get(fieldName)) == null || field.getType().getTypeParameters().length <= 0 && !(field.getGenericType() instanceof TypeVariable)) continue;
                    stack.addFirst(new Object[]{typeArgs[0], entry.getValue()});
                }
                continue;
            }
            ObjectResolver.stampTypeOnJsonObject(instance, t);
        }
    }

    private static void getTemplateTraverseWorkItem(Deque<Object[]> stack, Object[] items, Type type) {
        if (items == null || items.length < 1) {
            return;
        }
        Class rawType = ObjectResolver.getRawType(type);
        if (rawType != null && Collection.class.isAssignableFrom(rawType)) {
            stack.add(new Object[]{type, items});
        } else {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                stack.add(new Object[]{type, o});
                ++n2;
            }
        }
    }

    private static void stampTypeOnJsonObject(Object o, Type t) {
        Class clazz;
        Class clazz2 = clazz = t instanceof Class ? (Class)t : ObjectResolver.getRawType(t);
        if (o instanceof JsonObject && clazz != null) {
            JsonObject jObj = (JsonObject)o;
            if ((jObj.type == null || jObj.type.isEmpty()) && jObj.target == null) {
                jObj.type = clazz.getName();
            }
        }
    }

    public static Class getRawType(Type t) {
        ParameterizedType pType;
        if (t instanceof ParameterizedType && (pType = (ParameterizedType)t).getRawType() instanceof Class) {
            return (Class)pType.getRawType();
        }
        return null;
    }
}

